#ifdef TeX
#  if defined(KANJI)
#    ifndef PTeX
#      define PTeX
#    endif
#    define TeXInitialize        PTeXInitialize
#    define TeXUninitialize      PTeXUninitialize
#    define TeXGetLibraryFileName PTeXGetLibraryFileName
#    define TeXGetWindow         PTeXGetWindow
#    define TeXGetJobName        PTeXGetJobName
#    define TeXGetLogFileName    PTeXGetLogFileName
#    define TeXGetOutputFileName PTeXGetOutputFileName
#    define TeXGetOutputBaseName PTeXGetOutputBaseName
#    define TeXGetError          PTeXGetError
#    define TeXGetChecksum       PTeXGetChecksum
#    define TeXMain              PTeXMain
#    define TeXVaMain            PTeXVaMain
#    define TeXGetProcedures     PTeXGetProcedures
#  endif
#elif defined(MF)
#  define TeXInitialize        MFInitialize
#  define TeXUninitialize      MFUninitialize
#  define TeXGetLibraryFileName MFGetLibraryFileName
#  define TeXGetWindow         MFGetWindow
#  define TeXGetJobName        MFGetJobName
#  define TeXGetLogFileName    MFGetLogFileName
#  define TeXGetOutputFileName MFGetOutputFileName
#  define TeXGetOutputBaseName MFGetOutputBaseName
#  define TeXGetChecksum       MFGetChecksum
#  define TeXGetError          MFGetError
#  define TeXMain              MFMain
#  define TeXVaMain            MFVaMain
#  define TeXGetProcedures     MFGetProcedures
#elif defined(MP)
#  define TeXInitialize        MPInitialize
#  define TeXUninitialize      MPUninitialize
#  define TeXGetLibraryFileName MPGetLibraryFileName
#  define TeXGetWindow         MPGetWindow
#  define TeXGetJobName        MPGetJobName
#  define TeXGetLogFileName    MPGetLogFileName
#  define TeXGetOutputFileName MPGetOutputFileName
#  define TeXGetOutputBaseName MPGetOutputBaseName
#  define TeXGetError          MPGetError
#  define TeXGetChecksum       MPGetChecksum
#  define TeXMain              MPMain
#  define TeXVaMain            MPVaMain
#  define TeXGetProcedures     MPGetProcedures
#else
#  error!!! cannot happen
#endif

#ifndef INTERRUPT_NEEDED
#  define INTERRUPT_NEEDED
#endif

static DWORD wm_texdll = 0;
static char msgWndClass[100];
static BOOL msgWndClassRegistered = FALSE;

static char *strpool_copy(integer index);

static LRESULT CALLBACK msg_wnd_proc(HWND hWnd,
				     UINT msg,
				     WPARAM wParam,
				     LPARAM lParam);
static DWORD WINAPI background_thread(LPVOID *ptr);
static void terminate_background_thread(LPTeXContext pContext);

extern BOOL kill_tex_f;
extern DWORD poolfilechecksum;

static LPTSTR expandpath(LPCTSTR path)
{
  LPTSTR s = win32_strdup(path);
  win32_unix2dos(s);

  if (s) {
    LPTSTR p = win32_make_fullpath(s);
    free(s);
    return p;
  }
  else return NULL;
}

static LPTSTR strpool_path_copy(integer index)
{
  LPTSTR s = strpool_copy(index);
  LPTSTR p = NULL;
  if (s) {
    p = expandpath(s);
    free(s);
  }
  return p;
}

#define TeXDLL_MESSAGE_TERMINATE 0xfedcba98

static DWORD WINAPI background_thread(LPVOID *ptr)
{
  LPTeXContext pContext = (LPTeXContext)ptr;
  
  pContext->hMsgWnd = CreateWindow(msgWndClass, "Unknown",
				   WS_POPUP,
				   CW_USEDEFAULT, 0,
				   CW_USEDEFAULT, 0,
				   NULL,
				   NULL,
				   pContext->hInstance,
				   pContext);
  SetEvent(pContext->hBgDoneEvent);
  if (pContext->hMsgWnd) {
    MSG msg;
    while (GetMessage(&msg, NULL, 0, 0)) {
      if (msg.message ==  wm_texdll &&
	  msg.wParam == TeXDLL_MESSAGE_TERMINATE &&
	  msg.lParam == TeXDLL_MESSAGE_TERMINATE)
	break;
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
    DestroyWindow(pContext->hMsgWnd);
    pContext->hMsgWnd = NULL;
  }

  _endthreadex(0);
  return 0;
}

static LRESULT CALLBACK msg_wnd_proc(HWND hWnd,
				     UINT msg,
				     WPARAM wParam,
				     LPARAM lParam)
{
  LPTeXContext pContext = (LPTeXContext)GetWindowLong(hWnd, 0);

  if (msg == wm_texdll) {
    switch (wParam) {
    case TeXDLL_MESSAGE_INTERRUPT:
      interrupt = 1;
      break;
    case TeXDLL_MESSAGE_KILL:
      interrupt = 1;
      kill_tex_f = 1;
      break;
    }
  }
  else {
    switch (msg) {
    case WM_CREATE:
      SetWindowLong(hWnd, 0, (LONG)((LPCREATESTRUCT)lParam)->lpCreateParams);
      break;
    }
    return DefWindowProc(hWnd, msg, wParam, lParam);
  }
  return 0;
}

static BOOL beforejob(LPTeXContext pContext)
{
#ifdef TeX
#  ifdef KANJI
#    include "ptexzero.c"
#  else
#    include "texzero.c"
#  endif
#endif
#ifdef MF
#  include "mfzero.c"
#endif
#ifdef MP
#  include "mpzero.c"
#endif
  
  user_progname = 0;
  dump_name = 0;
  
  return TRUE;
}

static void terminate_background_thread(LPTeXContext pContext)
{
  if (pContext->hBgThread) {
    PostThreadMessage(pContext->idBgThread,
		      wm_texdll,
		      TeXDLL_MESSAGE_TERMINATE,
		      TeXDLL_MESSAGE_TERMINATE);
    WaitForSingleObject(pContext->hBgThread, INFINITE);
    CloseHandle(pContext->hBgThread);
    pContext->hBgThread = NULL;
  }
}

static void afterjob(LPTeXContext pContext, int exit_code)
{
  if (exit_code) {
    pContext->error_line = 0;
    pContext->error_filename = NULL;
  }
  pContext->jobname = strpool_path_copy(jobname);
#ifndef MP
  pContext->output_filename = strpool_path_copy(outputfilename);
#endif
  if (pContext->jobname) {
    pContext->output_basename =
      win32_concat_filename(pContext->pWin32Context->lpszWorkDir,
			    win32_basename(pContext->jobname));
  }
#ifdef MF
  mf_mswin_termscreen();
  pContext->tfm_filename = strpool_path_copy(metricfilename);
#endif
  pContext->log_filename = strpool_path_copy(texmflogname);
}

TeXDLL_EXPORT
LPCTSTR WINAPI TeXGetJobName(HTeX hTeX)
{
  LPTeXContext pContext = hTeX;
  return pContext->jobname;
}

TeXDLL_EXPORT
LPCTSTR WINAPI TeXGetLogFileName(HTeX hTeX)
{
  LPTeXContext pContext = hTeX;
  return pContext->log_filename;
}

TeXDLL_EXPORT
LPCTSTR WINAPI TeXGetOutputBaseName(HTeX hTeX)
{
  LPTeXContext pContext = hTeX;
  return pContext->output_basename;
}

TeXDLL_EXPORT
LPCTSTR WINAPI TeXGetOutputFileName(HTeX hTeX)
{
  LPTeXContext pContext = hTeX;
  return pContext->output_filename;
}

#ifdef MF
TeXDLL_EXPORT
LPCTSTR WINAPI MFGetTFMFileName(HTeX hTeX)
{
  LPTeXContext pContext = hTeX;
  return pContext->tfm_filename;
}
#endif

TeXDLL_EXPORT
DWORD WINAPI TeXGetChecksum(void)
{
  return poolfilechecksum;
}

TeXDLL_EXPORT
HWND WINAPI TeXGetWindow(HTeX hTeX)
{
  LPTeXContext pContext = hTeX;
  return pContext->hMsgWnd;
}

static TeXProcedures tex_procedures =
{
  TeXGetLibraryFileName,
  TeXInitialize,
  TeXUninitialize,
  TeXMain,
  TeXVaMain,
  TeXGetWindow,
  TeXGetChecksum,
  TeXGetJobName,
  TeXGetOutputBaseName,
  TeXGetOutputFileName,
#ifdef MF
  MFGetTFMFileName,
#else
  NULL,
#endif
  TeXGetLogFileName,
};

TeXDLL_EXPORT
LPCTeXProcedures WINAPI TeXGetProcedures(VOID)
{
  return &tex_procedures;
}

/* POOL */
extern unsigned char poolfilecontents[];
unsigned char *poolfilecontentsptr;

boolean openpoolfilecontents()
{
  poolfilecontentsptr = poolfilecontents;
  return 1;
}

integer readpoolfilecontents()
{
  return *poolfilecontentsptr ? *poolfilecontentsptr++ : EOF;
}

void readlnpoolfilecontents()
{
  while (*poolfilecontentsptr) {
    poolfilecontentsptr++;
    if (*(poolfilecontentsptr-1) == '\n')
      break;
  }
}

boolean poolfilecontentseof()
{
  return (*poolfilecontentsptr == 0);
}

boolean poolfilecontentseoln()
{
  return (*poolfilecontentsptr == '\n') || poolfilecontentseof();
}
