#include <stdio.h>
#include <win32dll/win32lib.h>
#include <win32dll/dllmain.h>
#include <string.h>
#include <mbstring.h>

HANDLE hMFtoPKModule;
HANDLE hMF = NULL;
HANDLE hGFtoPK = NULL;
LPTeXProcedures MFProcs;
LPTeXProcedures GFtoPKProcs;


TeXDLL_EXPORT
LPCSTR WINAPI MFtoPKGetLibraryFileName(void)
{
  return win32_module_filename();
}

HTeX WINAPI MFtoPKInitialize(LPFTeXCallbackProc callback,
			     LPVOID callback_data, LPCSTR workdir)
{
  HTeX hTeX;
  if (!win32_init_main(callback, callback_data, workdir))
    return NULL;
  hTeX = MFProcs->Initialize(callback, callback_data, workdir);
  if (!hTeX)
    win32_uninit_main();
  return hTeX;
}

VOID WINAPI MFtoPKUninitialize(HTeX hTeX)
{
  LPTeXContext pContext = hTeX;
  pContext->output_filename = NULL;
  MFProcs->Uninitialize(hTeX);
  
  win32_uninit_main();
}

TeXDLL_EXPORT
HWND WINAPI MFtoPKGetWindow(HTeX hTeX)
{
  LPTeXContext pContext = hTeX;
  return pContext->hMsgWnd;
}

LONG main_internal(HTeX hTeX, LONG argc, LPSTR argv[])
{
  LONG code;
  char *gf;
  LPTeXContext pContext = hTeX;
  
  code = MFProcs->Main(hTeX, argc, argv);
  gf = pContext->output_filename;
  
  if (gf) {
    char* pk;
    HTeX hGF;
    win32_dos2unix(gf);
    pk = gf;
    gf = win32_strdup(gf);
    strcpy(pk + strlen(pk)-2, "pk");
    hGF =
      GFtoPKProcs->Initialize(pContext->pWin32Context->lpfCallback,
			      pContext->pWin32Context->lpvCallbackData,
			      pContext->pWin32Context->lpszWorkDir);
    if (hGF) {
      LONG ccode;
      LPCSTR gfbase = _mbsrchr(gf, '/');
      LPCSTR pkbase = _mbsrchr(pk, '/');
      gfbase = gfbase ? gfbase + 1 : gf;
      pkbase = pkbase ? pkbase + 1 : pk;
      ccode = GFtoPKProcs->VaMain(hGF, "gftopk", gfbase, pkbase, NULL);
      if (ccode) {
	code = ccode;
	pContext->output_filename = NULL;
      }
      else {
	pContext->output_filename = pk;
	win32_unix2dos(pk);
      }
      GFtoPKProcs->Uninitialize(hGF);
    }
    else {
      code = 1;
      pContext->output_filename = NULL;
    }
    unlink(gf);
  }
  return code;
}

LONG WINAPI MFtoPKVaMain(HTeX hTeX, LPCSTR name, ...)
{
  va_list va;
  int ac, i;
  char *arg;
  LPSTR *av;
  
  va_start(va, name);
  for (ac=1;arg=va_arg(va, char*);ac++)
    ;
  va_end(va);
  av = win32_malloc(sizeof(LPCSTR)*ac);
  va_start(va, name);
  av[0] = "mf";
  for (i=1;i<ac;i++) {
    arg = va_arg(va, char*);
    av[i] = win32_strdup(arg);
  }
  va_end(va);
  return main_internal(hTeX, ac, av);
}

LONG WINAPI MFtoPKMain(HTeX hTeX, LONG argc, LPCSTR argv[])
{
  LPSTR* av = win32_malloc(sizeof(LPTSTR)*argc);
  LONG ac;
  if (!av) return 1;
  av[0] = "mf";
  for (ac=1;ac<argc;ac++)
    av[ac] = win32_strdup(argv[ac]);
  return main_internal(hTeX, argc, av);
}

DWORD WINAPI MFtoPKGetChecksum(VOID)
{
  return MFProcs->GetChecksum();
}

LPCSTR WINAPI MFtoPKGetJobName(HTeX hTeX)
{
  return MFProcs->GetJobName(hTeX);
}

LPCSTR WINAPI MFtoPKGetOutputFileName(HTeX hTeX)
{
  return MFProcs->GetOutputFileName(hTeX);
}

LPCSTR WINAPI MFtoPKGetOutputBaseName(HTeX hTeX)
{
  return MFProcs->GetOutputBaseName(hTeX);
}

LPCSTR WINAPI MFtoPKGetTFMFileName(HTeX hTeX)
{
  return MFProcs->GetTFMFileName(hTeX);
}

LPCSTR WINAPI MFtoPKGetLogFileName(HTeX hTeX)
{
  return MFProcs->GetLogFileName(hTeX);
}

static TeXProcedures tex_procedures =
{
  MFtoPKGetLibraryFileName,
  MFtoPKInitialize,
  MFtoPKUninitialize,
  MFtoPKMain,
  MFtoPKVaMain,
  MFtoPKGetWindow,
  MFtoPKGetChecksum,
  MFtoPKGetJobName,
  MFtoPKGetOutputBaseName,
  MFtoPKGetOutputFileName,
  MFtoPKGetTFMFileName,
  MFtoPKGetLogFileName,
};

TeXDLL_EXPORT
LPCTeXProcedures WINAPI MFtoPKGetProcedures(VOID)
{
  return &tex_procedures;
}

BOOL APIENTRY DllMain(HANDLE hModule,
                      DWORD ul_reason_for_call, 
		      LPVOID lpReserved)
{
  switch(ul_reason_for_call) {
  case DLL_PROCESS_ATTACH:
    win32_init_module(hModule);
    hMF = win32_load_tex_library("mf.dll");
    hGFtoPK = win32_load_tex_library("gftopk.dll");
    if (hMF && hGFtoPK) {
      LPFTeXGetProceduresProc GetProcs;
      GetProcs =
	(LPFTeXGetProceduresProc)GetProcAddress(hMF, "MFGetProcedures");
      MFProcs = (*GetProcs)();
      GetProcs =
	(LPFTeXGetProceduresProc)GetProcAddress(hGFtoPK, "GFtoPKGetProcedures");
      GFtoPKProcs = (*GetProcs)();
    }
    else {
      if (hMF) {
	FreeLibrary(hMF);
	hMF = NULL;
      }
      if (hGFtoPK) {
	FreeLibrary(hGFtoPK);
	hGFtoPK = NULL;
      }
      return FALSE;
    }
    break;
  case DLL_PROCESS_DETACH:
    if (hMF) FreeLibrary(hMF);
    if (hGFtoPK) FreeLibrary(hGFtoPK);
    break;
  }
  return TRUE;
}
