#include <win32dll/win32lib.h>
#include <mbstring.h>

static HANDLE hStdOut, hStdErr;

VOID win32_init_cui_callback(VOID)
{
  hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);
  hStdErr = GetStdHandle(STD_ERROR_HANDLE);
}

static VOID win32_write_file_text(HANDLE hFile,
				  LPCSTR lpszStr, LONG lLenTotal)
{
  /* Text files on DOS and Windows require CR+LF as line feed. */
  DWORD dwLenTotal = (lLenTotal < 0) ? strlen(lpszStr) : lLenTotal;
  while (dwLenTotal > 0) {
    LPCSTR p = _mbschr(lpszStr, '\n');
    if (p) {
      DWORD dwLenReq = p - lpszStr;
      DWORD dwLen;
      WriteFile(hFile, lpszStr, dwLenReq, &dwLen, NULL);
      lpszStr += (dwLenReq + 1);
      dwLenTotal -= (dwLenReq + 1);
      WriteFile(hFile, "\r\n", 2, &dwLen, NULL);
    }
    else {
      WriteFile(hFile, lpszStr, dwLenTotal, &dwLenTotal, NULL);
      dwLenTotal = 0;
    }
  }
}

VOID win32_write_stdout_text(LPCSTR lpszStr, LONG lLenTotal)
{
  win32_write_file_text(hStdOut, lpszStr, lLenTotal);
}

VOID win32_write_stderr_text(LPCSTR lpszStr, LONG lLenTotal)
{
  win32_write_file_text(hStdErr, lpszStr, lLenTotal);
}

/* Stanadard callback function of TeX DLL for character user interface. */
LONG WINAPI win32_standard_cui_callback(TeXDLLMessage msg,
					DWORD param1, DWORD param2,
					LPVOID app_data)
{
  DWORD dwLen;
  
  switch (msg) {
  case TeXDLL_STDOUT_WRITE:
    if (hStdOut != INVALID_HANDLE_VALUE)
      win32_write_stdout_text((LPCTSTR)param1, param2);
    break;
  case TeXDLL_CONSOLE_WRITE:
    if (hStdErr != INVALID_HANDLE_VALUE)
      win32_write_stderr_text((LPCTSTR)param1, param2);
    break;
  case TeXDLL_CONSOLE_GET:
    return getc(stdin);
  }
  return 0;
}
