#include <stdio.h>
#include <win32dll/texdll.h>
#include <win32dll/win32lib.h>
#include <win32dll/maketexlib.h>

#define MAKETEX_DLL "MakeTeX.dll"

int main(int argc, char **argv)
{
  BOOL code;
  LPCTSTR name, mag, mode;
  DWORD mode_dpi;
  char filename[MAX_PATH + 1];
  HINSTANCE hMakeTeX;

  if (argc != 5 && argc != 6) {
    fputs("Usage: MakeTeXPK <FONT> <DPI> <MODE-DPI> <MAG> [<MODE>]\n", stderr);
    exit(1);
  }
  
  name = argv[1];
  mode_dpi = atoi(argv[3]);
  mag = argv[4];
  mode = (argc == 5) ? NULL : argv[5];

  win32_init_module(GetModuleHandle(NULL));
  hMakeTeX = win32_load_tex_library(MAKETEX_DLL);
  if (hMakeTeX) {
    LPFMakeTeXPKProc Main;
    Main = (LPFMakeTeXPKProc)GetProcAddress(hMakeTeX, "MakeTeXPKMain");
    if (Main) {
      MakeTeXCallbackInfo* pInfo;
      pInfo = MakeTeXInitCallback(FALSE);
      if (pInfo) {
	code = Main(filename, MAX_PATH+1, MakeTeXCallback, (LPVOID)pInfo,
		    name, mag, mode_dpi, mode);
	MakeTeXUninitCallback(pInfo);
	if (code) {
	  puts(filename);
	}
      }
    }
    else {
      fputs("MakeTeXPKMain: Could not resolve the entry point.\n", stderr);
    }
    FreeLibrary(hMakeTeX);
  }
  else {
    fputs(MAKETEX_DLL ": Could not load.\n", stderr);
  }
  
  return 0;
}
