/* makempx.c: this program emulates the makempx shell script from Metapost.

Copyright (C) 1997 Fabrice POPINEAU.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* #!/bin/sh */
/* # '$Id: makempx.in,v 1.7 1996/11/18 18:26:51 karl Exp karl $' */
/* # Make an MPX file from the labels in a MetaPost source file, */
/* # using mpto and either dvitomp (TeX) or dmp (troff). */
/* # From John Hobby's original (though there's not much of it left by now). */
/* # Public domain. */

/* rcs_revision='$Revision: 1.7 $' */
/* version=`set - $rcs_revision; echo $2` */

/* : ${DMP=dmp} */
/* : ${DVITOMP=dvitomp} */
/* : ${MAKEMPX_BINDIR="j:\\TeX\\bin"} */
/* : ${MPTEXPRE=mptexpre.tex} */
/* : ${MPTOTEX="mpto -tex"} */
/* : ${MPTOTR="mpto -troff"} */
/* : ${NEWER=newer} */
/* : ${TEX=tex} */
/* : ${TROFF='eqn -d\$\$ | troff -Tpost'} */

/* PATH=$MAKEMPX_BINDIR:/bin:/usr/bin:$PATH */

/* # These names are documented in the MetaPost manual, so it's */
/* # unwise to change them. */
/* ERRLOG=mpxerr.log               # file for an error log if necessary */
/* TEXERR=mpxerr.tex               # file for erroneous TeX if any */
/* DVIERR=mpxerr.dvi               # troublesome dvi file if any */
/* TROFF_INERR=mpxerr              # file for erroneous troff input, if any */
/* TROFF_OUTERR=mpxerr.t           # file for troublesome troff output, if any */


/* usage="Usage: $0 [-tex|-troff] MPFILE MPXFILE. */
/*   If MPXFILE is older than MPFILE, translate the labels from the MetaPost */
/*   input file MPFIle to low-level commands in MPXFILE, by running */
/*     $MPTOTEX, $TEX, and $DVITOMP */
/*   by default; or, if -troff is specified, */
/*     $MPTOTR, $TROFF, and $DMP. */

/*   The current directory is used for writing temporary files.  Errors are */
/*   left in mpxerr.{tex,log,dvi}. */

/*   If the file named in \$MPTEXPRE (mptexpre.tex by default) exists, it is */
/*   prepended to the output in tex mode. */

/* Email bug reports to tex-k@mail.tug.org." */


/* mode=tex */

/* while test $# -gt 0; do */
/*   case "$1" in */
/*     -help|--help)  */
/*       echo "$usage"; exit 0;; */
/*     -version|--version) */
/*       echo "`basename $0` (Web2c 6.98) $version" */
/*       echo "There is NO warranty.  This script is public domain. */
/* Primary author: John Hobby; Web2c maintainer: K. Berry." */
/*       exit 0;; */
/*     -troff|--troff) mode=troff;; */
/*     -tex|--tex) mode=tex;; */
/*     -*)  */
/*       echo "$0: Invalid option: $1." >&2 */
/*       echo "Try \``basename $0` --help' for more information." >&2  */
/*       exit 1;; */
/*     *)  */
/*       if test -z "$MPFILE"; then */
/*         MPFILE=$1                   # input file */
/*       elif test -z "$MPXFILE"; then */
/*         MPXFILE=$1                  # output file */
/*       else */
/*         echo "$0: Extra argument $1." >&2  */
/*         echo "Try \``basename $0` --help' for more information." >&2 */
/*         exit 1 */
/*       fi;; */
/*   esac */
/*   shift */
/* done */

/* if test -z "$MPFILE" || test -z "$MPXFILE"; then */
/*   echo "$0: Need exactly two file arguments." >&2 */
/*   echo "Try \``basename $0` --help' for more information." >&2 */
/*   exit 1 */
/* fi */

/* trap "rm -f mpx$$.* $ERRLOG; exit 4" 1 2 3 15 */

/* # If MPX file is up-to-date, do nothing. */
/* if $NEWER $MPFILE $MPXFILE; then */

/*   # Have to remake. */
/*   # Step 0: Check typesetter mode for consistency. */
/*   case "$mode" in */
/*       tex) MPTO="$MPTOTEX";; */
/*     troff) MPTO="$MPTOTR";; */
/*         *) echo "$0: Unknown typesetter mode: $mode" >&2 */
/*            exit 1;; */
/*   esac */
  
/*   # Step 1: Extract typesetter source from MetaPost source. */
/*   if $MPTO $MPFILE >mpx$$.tex 2>$ERRLOG; then :; */
/*     # success */
/*   else */
/*     # failure */
/*     echo "$0: Command failed: $MPTO $MPFILE" >&2 */
/*     cat $ERRLOG >&2 */
/*     rm -f mpx$$.tex */
/*     exit 1 */
/*   fi */
/*   if test "$mode" = troff; then */
/*     mv -f mpx$$.tex mpx$$.i */
/*   fi */
  
/*   # Step 2: Run typesetter. */
/*   if test "$mode" = tex; then */
/*     if test -r $MPTEXPRE; then */
/*       # Prepend user file. */
/*       cat $MPTEXPRE mpx$$.tex >mpx$$.tmp */
/*       mv mpx$$.tmp mpx$$.tex */
/*     fi */

/*     if $TEX '\batchmode\input 'mpx$$.tex </dev/null >/dev/null; then */
/*       WHATEVER_TO_MPX="$DVITOMP" */
/*       INFILE=mpx$$.dvi */
/*       INERROR=$DVIERR */
/*     else */
/*       # failure */
/*       mv -f mpx$$.tex $TEXERR */
/*       mv -f mpx$$.log $ERRLOG */
/*       echo "$0: Command failed: $TEX $TEXERR; see $ERRLOG" >&2 */
/*       exit 2 */
/*     fi */
/*   elif test "$mode" = troff; then */
/*     if cat mpx$$.i | eval $TROFF >mpx$$.t; then */
/*       # success, prepare for step 3. */
/*       WHATEVER_TO_MPX="$DMP" */
/*       INFILE=mpx$$.t */
/*       INERROR=$TROFF_OUTERR */
/*     else */
/*       # failure */
/*       mv -f mpx$$.i $TROFF_INERR */
/*       echo "$0: Command failed: cat $TROFFERR | $TROFF" >&2 */
/*       rm -f mpx$$.t */
/*       exit 2 */
/*     fi */
/*   else */
/*     echo "$0: Unknown typesetter mode: $mode; how did this happen?" >&2 */
/*     exit 2 */
/*   fi */

/*   # Step 3: Translate typesetter output to a MetaPost MPX. */
/*   if $WHATEVER_TO_MPX $INFILE $MPXFILE >$ERRLOG; then */
/*     : # success */
/*   else  */
/*     # failure */
/*     mv -f $INFILE $INERROR */
/*     test $mode = troff && mv -f mpx$$.i $TROFF_INERR */
/*     echo "$0: Command failed: $WHATEVER_TO_MPX $INERROR $MPXFILE" >&2 */
/*     # Better to remove $MPXFILE if something went wrong rather than */
/*     # leaving behind an unfinished or unusable version since $NEWER */
/*     # might think that all is fine if $MPXFILE exists. */
/*     rm -f $MPXFILE */
/*     cat $ERRLOG >&2 */
/*     exit 3 */
/*   fi */

/*   rm -f $ERRLOG mpx$$.* */
/* fi */

/* exit 0 */

/*
  Global Variables
  */
/* #include <assert.h>
#include <direct.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <process.h>
#include <sys/stat.h>
#include <string.h>
#include <windows.h> */

#include <kpathsea/config.h>
#include <kpathsea/kpathsea.h>

#define popen _popen
#define pclose _pclose

static char *DMP;
static char *DVITOMP;
static char *MAKEMPX_BINDIR;
static char *MPTEXPRE;
static char *MPTOTEX;
static char *MPTOTR;
static char *NEWER;
static char *TEX;
static char *TROFF;

static struct alist {
  char *key;
  char **var;
  char *val;
} vardef[] = {
  {"DMP",            &DMP, "dmp"},
  {"DVITOMP",        &DVITOMP, "dvitomp"},
  {"MAKEMPX_BINDIR", &MAKEMPX_BINDIR, "j:\\TeX\\bin"},
  {"MPTEXPRE",       &MPTEXPRE, "mptexpre.tex"},
  {"MPTOTEX",        &MPTOTEX, "mpto -tex"},
  {"MPTOTR",         &MPTOTR, "mpto -tr"},
  {"NEWER",          &NEWER, "newer"},
  {"TEX",            &TEX, "tex"},
  {"TROFF",          &TROFF, "eqn -d$$ | troff -Tpost"},
  {NULL, NULL, NULL}
};

static char *MPTO, *INFILE, *INERROR, *WHATEVER_TO_MPX;
static char *mptemplate = "mpxXXXXXX";

/* These names are documented in the MetaPost manual, so it's */
/* unwise to change them. */
char *ERRLOG="mpxerr.log";	/* file for an error log if necessary */
char *TEXERR="mpxerr.tex";      /* file for erroneous TeX if any */
char *DVIERR="mpxerr.dvi";      /* troublesome dvi file if any */
char *TROFF_INERR="mpxerr";	/* file for erroneous troff input, if any */
char *TROFF_OUTERR="mpxerr.t";; /* file for troublesome troff output, if any */
char *MPFILE = NULL;
char *MPXFILE = NULL;

char *progname;
char *version = "Revision: 1.7";

typedef enum { TEXMODE = 0, TROFFMODE} typeset_mode;

/* extern void mt_exit(int); */
extern BOOL HandlerRoutine(DWORD);

void popenv();

void usage(int exit_code)
{
  fprintf(stderr, "Usage: $0 [-troff] MPFILE MPXFILE.\n\
If MPXFILE is older than MPFILE, translate the labels from the MetaPost\n\
input file MPFIle to low-level commands in MPXFILE, by running\n\
$MPTOTEX, $TEX, and $DVITOMP by default; or, if -troff is specified,\n\
$MPTOTR, $TROFF, and $DMP.\n\
\n\
The current directory is used for writing temporary files.  Errors are\n\
left in mpxerr.{tex,log,dvi}.\n\
\n\
If the file named in $MPTEXPRE (mptexpre.tex by default) exists, it is\n\
prepended to the output in tex mode.\n\
\n\
Email bug reports to tex-k@mail.tug.org.\n");
   mt_exit(exit_code);
}

void printversion()
{
  fprintf(stderr, "%s: (Web2c 6.992) %s\n", progname, version);
  fprintf(stderr, "There is NO warranty.  This program is public domain.\n\
Primary author: John Hobby; Web2c maintainer: K. Berry; C version: F. Popineau.");
  mt_exit(0);
}

void output_file(FILE *f, const_string name)
{
  FILE *fname;
  string line;

  if ((fname = fopen(name, "r")) == NULL) {
      perror(name);
  }
  else {
    while((line = read_line(fname)) != NULL) {
      fputs(line, f);
      free(line);
    }
    fclose(fname);
  }
}

void output_and_cleanup(int code)
{
  WIN32_FIND_DATA ffd;
  HANDLE hnd;
  boolean go_on;
  string temp = concat(mptemplate, ".*");
  /* rm -f mpxXXXXX.* */
  hnd = FindFirstFile(temp, &ffd);
  go_on = (hnd != INVALID_HANDLE_VALUE); 
  while (go_on) {
    DeleteFile(ffd.cFileName);
    go_on = (FindNextFile(hnd, &ffd) == TRUE);
  }
  FindClose(hnd);
  free(temp);
  
  /* ERRLOG is removed only on normal exit. */
  if (code == 0)
    remove(ERRLOG);
  
}

void mvfile(string a, string b)
{
  /* MoveFileEx should do the same */
  if (CopyFile(a, b, FALSE) == FALSE)
    fprintf(stderr, "Error copying %s to %s : %d\n", a, b, GetLastError());

  if (DeleteFile(a) == FALSE)
    fprintf(stderr, "Error deleting %s : %d\n", a, GetLastError());
}

char *change_suffix(char *old, char *suf)
{
  char *p, *new;
  new = strdup(old);
  p = strrchr(new, '.');
  if (p)
    strcpy(p, suf);
  else
    strcat(new, suf);
  return new;
}

int test_file(char c, char *path)
{
  struct stat stat_buf;
  int file_exists = (stat(path, &stat_buf) != -1);
  if (!file_exists) return FALSE;
  switch (c) {
  case 'd':
    return ((stat_buf.st_mode & S_IFMT) == S_IFDIR);
  case 'e':
    return TRUE;
  case 'f':
  case 'r':
    return ((stat_buf.st_mode & S_IFMT) == S_IFREG);
  case 's':
    return (stat_buf.st_size > 0);
  }
}

main(int argc, char *argv[])
{
  struct alist *p;
  char *e, buf[1024];
  char cmd[256];
  typeset_mode mode = TEXMODE;
  int i, newfd[3];
  FILE *ferr, *fmpx, *ftroff;
  struct stat x, y;
  char mpxtex[32];
  char *mpxtextr, *mpxi, *mpxt, *mpxtmp, *mpxlog, *mpxdvi;
  string path;

  if (!progname)
    progname = argv[0];
  kpse_set_progname (progname);

  SetConsoleCtrlHandler((PHANDLER_ROUTINE)mt_exit, TRUE);

  /* First assigning default values to all variables. */
  for(p = vardef; p->key != NULL; p++) {
    /* testing if there is an env var */
    strcpy(buf, "$"); strcat(buf, p->key);
    *(p->var) = kpse_var_expand(buf);
    if (*(p->var) == NULL || **(p->var) == '\0')
      *(p->var) = p->val;
  }

  /* Modifying $PATH */
  path = concat3(MAKEMPX_BINDIR, ENV_SEP_STRING, getenv("PATH"));
  xputenv("PATH", path);
  fprintf(stderr, "path :\n%s\n", getenv("PATH"));
  free(path);

  if (argc == 1)
    usage(1);

  for (i = 1; i <argc; i++) {
    if (!strcmp(argv[i], "-help") || !strcmp(argv[i], "--help")
	|| !strcmp(argv[i], "-h")) {
      usage(0);
    }
    if (!strcmp(argv[i], "-version") || !strcmp(argv[i], "--version")
	|| !strcmp(argv[i], "-v")) {
      printversion();
    }
    if (!strcmp(argv[i], "-troff")) {
      mode = TROFFMODE;
    }
    if (*argv[i] == '-') {
      fprintf(stderr, "%s: Invalid option: %s.\nTry '%s --help' for more information.\n", program_invocation_short_name, 
	      argv[i], program_invocation_short_name);
      mt_exit(1);
    }
    if (!MPFILE)
      MPFILE = argv[i];
    else if (!MPXFILE)
      MPXFILE = argv[i];
    else {
      fprintf(stderr, "%s: Extra argument %s; use --help if you need it.\n", program_invocation_short_name, argv[i]);
      mt_exit(1);
    }
  }
  if (!MPXFILE || !MPFILE) {
    fprintf(stderr, "%s: Missing file argument. Try --help for more information.\n", progname);
    mt_exit(1);
  }

  /* does the first file exist? */
  if (stat (MPFILE, &x) < 0)
    mt_exit(1);
  
  /* does the second file exist? */
  if (stat (MPXFILE, &y) == 0 &&  
      /* MPXFILE is newer than MPFILE */
      x.st_mtime < y.st_mtime)
    mt_exit(0);
  
  *cmd = '\0';
  switch(mode) {
  case TEXMODE:
    MPTO = MPTOTEX;
    break;
  case TROFFMODE:
    MPTO = MPTOTR;
    break;
  default:
    fprintf(stderr, "%s: Unknown typesetter.\n", progname);
    mt_exit(1);
  }
  if (mktemp(mptemplate) == NULL) {
    fprintf(stderr, "%s: mktemp can't create the template.\n", progname);
    mt_exit(1);
  }
  strcpy(mpxtex, mptemplate); strcat(mpxtex, ".tex");
  /* redirecting 1 -> mpx$$.tex 2 -> ERRLOG */
  if (!(fmpx = fopen(mpxtex, "w"))) {
    perror(mpxtex);
    mt_exit(1);
  }
  if (!(ferr = fopen(ERRLOG, "w"))) {
    perror(ERRLOG);
    mt_exit(1);
  }
  
  newfd[0] = 0; newfd[1] = fileno(fmpx); newfd[2] = fileno(ferr);
  push_fd(newfd);

  if (spawnlp(_P_WAIT, "mpto", MPTO, MPFILE, NULL) != 0) {
    fprintf(stderr, "%s: Command failed: '%s %s'.\n", progname, MPTO, MPFILE);
    output_file(stderr, ERRLOG);
    mt_exit(2);
  }
  fcloseall();
  pop_fd();

  /* Step 2 */
  switch(mode) {
  case TEXMODE:
    mpxdvi = change_suffix(mpxtex, ".dvi");
    mpxtmp = change_suffix(mpxtex, ".tmp");
    mpxlog = change_suffix(mpxtex, ".log");
    
    if (test_file('r', MPTEXPRE)) {
      sprintf(cmd, "copy %s+%s %s", MPTEXPRE, mpxtex, mpxtmp);
      if (system(cmd)) {
	fprintf(stderr, "%s: prepending %s failed.\n", progname, MPTEXPRE);
	mt_exit(1);
      }
      mvfile(mpxtmp, mpxtex);
    }
    sprintf(cmd, "%s \"\\batchmode\\input %s\" < nul > nul", TEX, mpxtex);
    if (system(cmd)) {
      fprintf(stderr, "%s: command failed '%s'.\n", progname, cmd);
      mvfile(mpxtex, TEXERR);
      mvfile(mpxlog, ERRLOG);
      output_file(stderr, ERRLOG);
      mt_exit(2);
    }
    WHATEVER_TO_MPX = DVITOMP;
    INFILE = mpxdvi;
    INERROR = DVIERR;
    break;
  case TROFFMODE:
    mpxi = change_suffix(mpxtex, ".i");
    mpxt = change_suffix(mpxtex, ".t");
    mvfile(mpxtex, mpxi);
    sprintf(cmd, "%s > %s", TROFF, mpxt);
    if ((ftroff = popen(cmd, "w")) == NULL) {
      perror(cmd);
      mt_exit(1);
    }
    if (!(fmpx = fopen(mpxi, "r"))) {
      perror(mpxi);
      mt_exit(1);
    }
    while (fgets(buf, 1024, fmpx))
      fputs(buf, ftroff);
    if (pclose(ftroff) != 0) {
      fprintf(stderr, "%s: command failed: cat %s | %s.\n", progname,
	      mpxi, cmd);
      mt_exit(1);
    }
    fclose(fmpx);
    WHATEVER_TO_MPX = DMP;
    INFILE = mpxt;
    INERROR = TROFF_INERR;
    break;
  default:
    fprintf(stderr, "%s: Impossible mode.\n", progname);
    mt_exit(3);
  }

  /* Step 3 */
  sprintf(cmd, "%s %s %s > %s", WHATEVER_TO_MPX, INFILE, MPXFILE, ERRLOG);
  if (system(cmd)) {
    fprintf(stderr, "%s: command failed '%s'.\n", progname, cmd);
    mvfile(INFILE, INERROR);
    if (mode == TROFFMODE)
      mvfile(mpxi, TROFF_INERR);
    output_file(stderr, ERRLOG);
    mt_exit(2);
  }
  mt_exit(0);
}
