#ifndef win32dll_h_included
#define win32dll_h_included

#if !defined(TANGLEBOOT) && !defined(NO_WIN32_FAKE)

#include <win32dll/win32lib.h>

/* Memory Allocation */

#define malloc(s) win32_malloc(s)
#define xmalloc(s) win32_malloc(s)
#define realloc(b,s) win32_realloc(b,s)
#define xrealloc(b,s) win32_realloc(b,s)
#define free(s)   win32_free(s)
#define xfree(s)   win32_free(s)
#define strdup(s) win32_strdup(s)
#define xstrdup(s) win32_strdup(s)

#define getenv(s) win32_var_value(s)

/* File I/O */

#undef stdout
#undef stderr
#undef stdin
#define stdout WIN32_STDOUT
#define stderr WIN32_STDERR
#define stdin  WIN32_STDIN

#undef fileno
#define fileno(f) win32_fileno(f)

#undef fopen
#define fopen(f,m) win32_fopen(f,m)
#undef fclose
#define fclose(f) win32_fclose(f)
#define xfopen(n,m) win32_xfopen(n,m)
#define xfclose(f,n) win32_fclose(f)

#undef getc
#define getc(f) win32_getc(f)
#define fgetc(f) win32_getc(f)
#undef ungetc
#define ungetc(c,f) win32_ungetc(c,f)
#undef getchar
#define getchar() win32_getc(stdin)
#define fgets(b,c,f) win32_gets(b,c,f)
#undef feof
#define feof(f) win32_feof(f)
#define printf win32_stdout_printf
#define fprintf win32_printf
#undef putc
#define putc(c,f) win32_putc(c,f)
#define fputc(c,f) win32_putc(c,f)
#define puts(s) (win32_puts(s,stdout), win32_putc('\n',stdout))
#define fputs(s,f) win32_puts(s,f)
#define fflush(f) win32_flush(f)
#define xfseek(f,off,org,fn) win32_seek(f, off, org)
#define xftell(f,fn)        win32_tell(f)
#define fwrite(b,s,c,f)     win32_write(b,s,c,f)
#undef ferror
#define ferror(f) win32_ferror(f)

/* kpathsea */
#define program_invocation_name win32_program_name
#define program_invocation_short_name win32_program_short_name
#define kpse_make_tex_discard_errors (*p_win32_make_tex_discard_errors)
#define kpathsea_debug  (*p_win32_kpathsea_debug)
#define kpse_fallback_resolutions_string (*p_win32_fallback_resolutions_string)
#define kpse_format_info win32_format_info

#define kpse_find_file(n,f,e) win32_find_file(n,f,e)
#define kpse_path_search(p,n,e) win32_path_search(p,n,e)
#define kpse_var_value(v)     win32_var_value(v)
#define kpse_path_expand(v)   win32_path_expand(v)
#define kpse_var_expand(v)    win32_var_expand(v)
#define kpse_set_progname(n)  win32_set_progname(n)
#define kpse_init_prog(p,d,m,f) win32_init_prog(p,d,m,f)
#define kpse_readable_file(n) win32_readable_file(n)
#define kpse_open_file(n,t)   win32_open_file(n,t)
#define kpse_set_program_enabled(f,d,s) win32_set_program_enabled(f,d,s)
#define kpse_maketex_option(s, b) /* */
#define kpse_find_glyph(fn, dpi, fmt, gf) win32_find_glyph(fn, dpi, fmt, gf)
#define kpse_tex_hush(w) win32_tex_hush(w)
#define kpse_magstep_fix(dpi, bdpi, pret) win32_magstep_fix(dpi, bdpi, pret)
#define kpse_bitmap_tolerance(dpi1, dpi2) win32_bitmap_tolerance(dpi1, dpi2)
#define kpse_fopen_trace(fn, m) win32_fopen(fn, m)
#define kpse_fclose_trace(f) win32_fclose(f)

/* system */
#define exit(c) win32_exit(c)
#define uexit(c) win32_exit(c)
#define perror(s) win32_perror(s)

/* string */
#define concat(s1,s2)     win32_concat(s1,s2)
#define concat3(s1,s2,s3) win32_concat3(s1,s2,s3)
#define concatn           win32_concatn
#define basename(s)       win32_basename(s)
#define extend_filename(s1,s2) win32_extend_filename(s1,s2)
#define make_suffix(s1,s2)    win32_make_suffix(s1,s2)
#define find_suffix(s) win32_find_suffix(s)
#define atou(s) win32_atou(s)

/* misc. */
#define versionstring win32_versionstring
#define kpathsea_version_string win32_kpathsea_version_string
#define kpse_bug_address        win32_kpathsea_bug_address

#define win32notifypagebegin(n) win32_notify_page_begin(n)
#define win32notifypageend(n) win32_notify_page_end(n)

#endif /* !TANGLEBOOT */

#endif /* win32dll_h_included */
