#if defined(BibTeX) && !defined(JBibTeX)
#  define TeXMain              BibTeXMain
#  define TeXVaMain            BibTeXVaMain
#  define TeXInitialize        BibTeXInitialize
#  define TeXUninitialize         BibTeXUninitialize
#  define TeXGetLibraryFileName BibTeXGetLibraryFileName
#  define TeXGetProcedures     BibTeXGetProcedures
#  define outputfilename      sbblextension
#endif
#ifdef JBibTeX
#  define TeXMain              JBibTeXMain
#  define TeXVaMain            JBibTeXVaMain
#  define TeXInitialize        JBibTeXInitialize
#  define TeXUninitialize         JBibTeXUninitialize
#  define TeXGetLibraryFileName JBibTeXGetLibraryFileName
#  define TeXGetProcedures     JBibTeXGetProcedures
#  define outputfilename      sbblextension
#endif
#ifdef PatGen
#  define TeXMain              PatGenMain
#  define TeXVaMain            PatGenVaMain
#  define TeXInitialize        PatGenInitialize
#  define TeXUninitialize         PatGenUninitialize
#  define TeXGetLibraryFileName PatGenGetLibraryFileName
#  define TeXGetProcedures     PatGenGetProcedures
#endif
#ifdef GFtoDVI
#  define TeXMain              GFtoDVIMain
#  define TeXVaMain            GFtoDVIVaMain
#  define TeXInitialize        GFtoDVIInitialize
#  define TeXUninitialize         GFtoDVIUninitialize
#  define TeXGetLibraryFileName GFtoDVIGetLibraryFileName
#  define TeXGetProcedures     GFtoDVIGetProcedures
#endif
#ifdef GFtoPK
#  define TeXMain              GFtoPKMain
#  define TeXVaMain            GFtoPKVaMain
#  define TeXInitialize        GFtoPKInitialize
#  define TeXUninitialize         GFtoPKUninitialize
#  define TeXGetLibraryFileName GFtoPKGetLibraryFileName
#  define TeXGetProcedures     GFtoPKGetProcedures
#endif
#ifdef GFType
#  define TeXMain              GFTypeMain
#  define TeXVaMain            GFTypeVaMain
#  define TeXInitialize        GFTypeInitialize
#  define TeXUninitialize         GFTypeUninitialize
#  define TeXGetLibraryFileName GFTypeGetLibraryFileName
#  define TeXGetProcedures     GFTypeGetProcedures
#endif
#ifdef PKtoGF
#  define TeXMain              PKtoGFMain
#  define TeXVaMain            PKtoGFVaMain
#  define TeXInitialize        PKtoGFInitialize
#  define TeXUninitialize         PKtoGFUninitialize
#  define TeXGetLibraryFileName PKtoGFGetLibraryFileName
#  define TeXGetProcedures     PKtoGFGetProcedures
#endif
#ifdef PKType
#  define TeXMain              PKTypeMain
#  define TeXVaMain            PKTypeVaMain
#  define TeXInitialize        PKTypeInitialize
#  define TeXUninitialize         PKTypeUninitialize
#  define TeXGetLibraryFileName PKTypeGetLibraryFileName
#  define TeXGetProcedures     PKTypeGetProcedures
#endif
#ifdef PLtoTF
#  define TeXMain              PLtoTFMain
#  define TeXVaMain            PLtoTFVaMain
#  define TeXInitialize        PLtoTFInitialize
#  define TeXUninitialize         PLtoTFUninitialize
#  define TeXGetLibraryFileName PLtoTFGetLibraryFileName
#  define TeXGetProcedures     PLtoTFGetProcedures
#endif
#ifdef TFtoPL
#  define TeXMain              TFtoPLMain
#  define TeXVaMain            TFtoPLVaMain
#  define TeXInitialize        TFtoPLInitialize
#  define TeXUninitialize         TFtoPLUninitialize
#  define TeXGetLibraryFileName TFtoPLGetLibraryFileName
#  define TeXGetProcedures     TFtoPLGetProcedures
#endif
#ifdef VFtoVP
#  define TeXMain              VFtoVPMain
#  define TeXVaMain            VFtoVPVaMain
#  define TeXInitialize        VFtoVPInitialize
#  define TeXUninitialize         VFtoVPUninitialize
#  define TeXGetLibraryFileName VFtoVPGetLibraryFileName
#  define TeXGetProcedures     VFtoVPGetProcedures
#endif
#ifdef VPtoVF
#  define TeXMain              VPtoVFMain
#  define TeXVaMain            VPtoVFVaMain
#  define TeXInitialize        VPtoVFInitialize
#  define TeXUninitialize         VPtoVFUninitialize
#  define TeXGetLibraryFileName VPtoVFGetLibraryFileName
#  define TeXGetProcedures     VPtoVFGetProcedures
#endif
#ifdef MFT
#  define TeXMain              MFTMain
#  define TeXVaMain            MFTVaMain
#  define TeXInitialize        MFTInitialize
#  define TeXUninitialize         MFTUninitialize
#  define TeXGetLibraryFileName MFTGetLibraryFileName
#  define TeXGetProcedures     MFTGetProcedures
#endif
#ifdef DVICopy
#  define TeXMain              DVICopyMain
#  define TeXVaMain            DVICopyVaMain
#  define TeXInitialize        DVICopyInitialize
#  define TeXUninitialize         DVICopyUninitialize
#  define TeXGetLibraryFileName DVICopyGetLibraryFileName
#  define TeXGetProcedures     DVICopyGetProcedures
#endif
#ifdef DVItoMP
#  define TeXMain              DVItoMPMain
#  define TeXVaMain            DVItoMPVaMain
#  define TeXInitialize        DVItoMPInitialize
#  define TeXUninitialize         DVItoMPUninitialize
#  define TeXGetLibraryFileName DVItoMPGetLibraryFileName
#  define TeXGetProcedures     DVItoMPGetProcedures
#endif
#ifdef DVIType
#  define TeXMain              DVITypeMain
#  define TeXVaMain            DVITypeVaMain
#  define TeXInitialize        DVITypeInitialize
#  define TeXUninitialize         DVITypeUninitialize
#  define TeXGetLibraryFileName DVITypeGetLibraryFileName
#  define TeXGetProcedures     DVITypeGetProcedures
#endif
#ifdef PDVIType
#  define TeXMain              PDVITypeMain
#  define TeXVaMain            PDVITypeVaMain
#  define TeXInitialize        PDVITypeInitialize
#  define TeXUninitialize         PDVITypeUninitialize
#  define TeXGetLibraryFileName PDVITypeGetLibraryFileName
#  define TeXGetProcedures     PDVITypeGetProcedures
#endif
#ifdef Tangle
#  define TeXMain              TangleMain
#  define TeXVaMain            TangleVaMain
#  define TeXInitialize        TangleInitialize
#  define TeXUninitialize         TangleUninitialize
#  define TeXGetLibraryFileName TangleGetLibraryFileName
#  define TeXGetProcedures     TangleGetProcedures
#endif
#ifdef Weave
#  define TeXMain              WeaveMain
#  define TeXVaMain            WeaveVaMain
#  define TeXInitialize        WeaveInitialize
#  define TeXUninitialize         WeaveUninitialize
#  define TeXGetLibraryFileName WeaveGetLibraryFileName
#  define TeXGetProcedures     WeaveGetProcedures
#endif
#ifdef PoolType
#  define TeXMain              PoolTypeMain
#  define TeXVaMain            PoolTypeVaMain
#  define TeXInitialize        PoolTypeInitialize
#  define TeXUninitialize         PoolTypeUninitialize
#  define TeXGetLibraryFileName PoolTypeGetLibraryFileName
#  define TeXGetProcedures     PoolTypeGetProcedures
#endif
#ifdef Mendex
#  define TeXMain              MendexMain
#  define TeXVaMain            MendexVaMain
#  define TeXInitialize        MendexInitialize
#  define TeXUninitialize         MendexUninitialize
#  define TeXGetLibraryFileName MendexGetLibraryFileName
#  define TeXGetProcedures     MendexGetProcedures
#endif

static BOOL beforejob(LPTeXContext pContext)
{
#ifdef BibTeX
  bibtex_zero();
#endif
#ifdef Mendex
  extern char *styfile, *dicfile;
  extern int dlines, elines;
  extern int line_length;
  extern int sym,alpha,kana;
  styfile = dicfile = NULL;
  dlines = elines = line_length = 0;
  sym = alpha = kana = 0;
#endif
  return TRUE;
}

void afterjob(LPTeXContext pContext, int exit_code)
{
  pContext->exit_code = exit_code;
}

static TeXProcedures tex_procedures =
{
  TeXGetLibraryFileName,
  TeXInitialize,
  TeXUninitialize,
  TeXMain,
  TeXVaMain,
  NULL, /* GetWindow */
  NULL, /* GetChecksum */
  NULL, /* GetJobName */
  NULL, /* GetOutputBaseName */
  NULL, /* GetOutputFileName */
  NULL, /* GetTFMFileName */
  NULL, /* GetLogFileName */
};

TeXDLL_EXPORT
LPCTeXProcedures WINAPI TeXGetProcedures(VOID)
{
  return &tex_procedures;
}
