#include <setjmp.h>

static CRITICAL_SECTION critical_section;

BOOL APIENTRY DllMain(HANDLE hModule, 
		      DWORD ul_reason_for_call, 
		      LPVOID lpReserved)
{
  switch(ul_reason_for_call) {
  case DLL_PROCESS_ATTACH:
    InitializeCriticalSection(&critical_section);
    win32_init_module(hModule);
    break;
  case DLL_PROCESS_DETACH:
    DeleteCriticalSection(&critical_section);
    break;
  }
  return TRUE;
}

LONG WINAPI DVIPSMain(LPFTeXCallbackProc callback,
		      LPVOID callback_data,
		      LPCSTR work_dir,
		      LONG argc, const char**argv)
{
  volatile int code;
  
  EnterCriticalSection(&critical_section);
  if (win32_init_main(callback, callback_data, work_dir)) {
    char **av;
    int i;
    
    win32_return_short_filename(TRUE);
    av = win32_malloc(sizeof(char*)*argc);
    for (i=0;i<argc;i++)
      av[i] = win32_strdup(argv[i]);
    code = main_internal(argc, av);
    win32_uninit_main();
  }
  else code = 1;
  LeaveCriticalSection(&critical_section);
  
  return code;
}

LONG WINAPI DVIPSVaMain(LPFTeXCallbackProc callback,
			LPVOID callback_data,
			LPCSTR work_dir,
			LPCSTR progname, ...)
{
  volatile int code;
  
  EnterCriticalSection(&critical_section);
  if (win32_init_main(callback, callback_data, work_dir)) {
    char **av;
    va_list va;
    int argc;
    int i;
    
    win32_return_short_filename(TRUE);
    va_start(va, progname);
    for (argc=1;va_arg(va, const char*);argc++) ;
    va_end(va);
    av = win32_malloc(sizeof(char*)*argc);
    av[0] = win32_strdup(progname);
    va_start(va, progname);
    for (i=1;i<argc;i++)
      av[i] = win32_strdup(va_arg(va, const char*));
    va_end(va);
    code = main_internal(argc, av);
    win32_uninit_main();
  }
  else code = 1;
  LeaveCriticalSection(&critical_section);
  
  return code;
}

static int main_internal(int argc, char**argv)
{
  volatile int exit_code;
  extern jmp_buf win32_exit_jmp;
  
  if ((exit_code = setjmp(win32_exit_jmp)) != 0) {
    return exit_code;
  }
  exit_code = main_sub(argc, argv);
  return exit_code;
}

#define main main_sub
