#include <win32dll/texdll.h>
#include <win32dll/win32lib.h>

#define MAKETEX_DLL "MakeTeX.dll"

void usage(int code)
{
  fputs("Usage: MakeTeXls-R [-h] [-o <output-filename>] [<top-directory>]\n",
	stderr);
  exit(code);
}

int main(int argc, char *argv[])
{
  HINSTANCE hMakeTeX;
  int code = 1;
  LPCSTR lpszTopDir = NULL;
  LPCSTR lpszLSR = NULL;
  int i;

  for (i=1;i<argc;i++) {
    if (*argv[i] != '-') break;
    else if (strcmp(argv[i] + 1, "o") == 0) {
      if (i + 1 >= argc) {
	fprintf(stderr, "%s: Just one argument is required.\n", argv[i]);
	usage(1);
      }
      i++;
      lpszLSR = argv[i];
    }
    else if (strcmp(argv[i] + 1, "h") == 0)
      usage(0);
    else {
      fprintf(stderr, "%s: Unknown flag.\n", argv[i]);
      usage(1);
    }
  }
  if (i + 1 < argc) {
    usage(1);
  }
  if (i < argc)
    lpszTopDir = argv[i];
  
  hMakeTeX = win32_load_tex_library(MAKETEX_DLL);
  
  if (hMakeTeX) {
    LPFMakeTeXlsRProc Main =
      (LPFMakeTeXlsRProc)GetProcAddress(hMakeTeX, "MakeTeXlsRMain");
    if (Main) {
      code = (Main(lpszTopDir, lpszLSR) != TRUE);
      if (code) {
	fputs("Could not create ls-R.\n", stderr);
      }
    }
    else {
      fputs("MakeTeXlsRMain: Could not resolve the entry point.\n", stderr);
    }
    FreeLibrary(hMakeTeX);
  }
  else {
    fputs(MAKETEX_DLL ": Could not load.\n", stderr);
  }
  
  return code;
}
