/* stackenv.c: routines that help to mimic shell scripts.

Copyright (C) 1997 Fabrice POPINEAU.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <assert.h>
#include <direct.h>
#include <stdio.h>

#include <kpathsea/c-pathch.h>

#include "win32-compat.h"

#if defined(__STDC__) || defined(WIN32)
#define NeedVarargsPrototypes   1
#include <stdarg.h>
#else
#define NeedVarargsPrototypes   0
#include <varargs.h>
#endif

#if 0
#define fopen(f, m) (fprintf(stderr, "opening %s\n", f), fopen(f, m))
#define fclose(f) (fprintf(stderr, "closing %x\n", f), fclose(f))
#endif

extern char *output;
extern char tmpdir[];

/*
  We are keeping trace of the environment (ie: cwd, file redirections)
  with the help of these ops and structures. There is a global stack
  inidcating wich actions have been taken.
  */
typedef enum { CHDIR = 1, REDIRECT } op_env;
typedef struct mod_env {
  op_env op;
  union {
  char *path;
  int oldfd[3];
  } data;
} mod_env;

/* The global stack. */
static mod_env stack_env[256];
static int index_env = 0;

void mt_exit(int);

#if     NeedVarargsPrototypes
void
oops(const char *message, ...)
#else
/* VARARGS */
void
oops(va_alist)
        va_dcl
#endif
{
#if     !NeedVarargsPrototypes
        const char *message;
#endif
        va_list args;

#if     NeedVarargsPrototypes
        va_start(args, message);
#else
        va_start(args);
        message = va_arg(args, const char *);
#endif
        vfprintf(stderr, message, args);
        va_end(args);
        fputc('\n', stderr);
        mt_exit(1);
}

/* pushd */
void pushd(char *p)
{
#if 0
  fprintf(stderr, "pushing %s\n", p);
#endif
  if ((stack_env[index_env].data.path = malloc(MAXPATHLEN)) == NULL
      || getcwd(stack_env[index_env].data.path, MAXPATHLEN) == NULL) {
    fprintf(stderr, "pushd error!\n");
    mt_exit(1);
  }
  stack_env[index_env].op = CHDIR;
  index_env++;
  if (chdir(p) == -1) {
    perror(p);
    mt_exit(1);
  }
}
/* popd */
void popd()
{
  index_env--;
#if 0
  fprintf(stderr, "popping %s\n", stack_env[index_env].data.path);
#endif
  assert(stack_env[index_env].op == CHDIR);
  if (chdir(stack_env[index_env].data.path) == -1) {
    perror(stack_env[index_env].data.path);
    mt_exit(1);
  }
  free(stack_env[index_env].data.path);
}
/* redirect */
void push_fd(int newfd[3])
{
  int i;
#if 0
  fprintf(stderr, "pushing fds %d %d %d\n", newfd[0], newfd[1], newfd[2]);
#endif
  flushall();
  stack_env[index_env].op = REDIRECT;
  for(i = 0; i < 3; i++) {
    if (i == newfd[i])
      stack_env[index_env].data.oldfd[i] = i;
    else {
      if ((stack_env[index_env].data.oldfd[i] = dup(i)) == -1) {
	perror("push_fd: dup");
	mt_exit(1);
      }
      if (dup2(newfd[i], i)) {
	perror("push_fd : dup2");
	mt_exit(1);
      }
    }
  }
  index_env++;
}

void pop_fd()
{
  int i;
  index_env--;
  assert(stack_env[index_env].op == REDIRECT);
#if 0
  fprintf(stderr, "popping fds %d %d %d\n", 
	  stack_env[index_env].data.oldfd[0],
	  stack_env[index_env].data.oldfd[1],
	  stack_env[index_env].data.oldfd[2]);
#endif
  flushall();
  for(i = 0; i < 3; i++)
    if (i != stack_env[index_env].data.oldfd[i]) {
      close(i);
#if 0
      fprintf(stderr, "Closing %d\n", i);
#endif
      if (dup2(stack_env[index_env].data.oldfd[i], i)) {
	perror("pop_fd : dup2");
	mt_exit(1);
      }
      close(stack_env[index_env].data.oldfd[i]);
#if 0
      fprintf(stderr, "Closing %d\n", stack_env[index_env].data.oldfd[i]);
#endif
    }
}

/* popenv */
void popenv()
{
  switch(stack_env[index_env-1].op) {
  case CHDIR:
    popd();
    break;
  case REDIRECT:
    pop_fd();
    break;
  default:
    fprintf(stderr, "popenv : unknown op %d.\n", stack_env[index_env-1].op);
    break;
  }
}

BOOL HandlerRoutine(DWORD dwCtrlType)
{
  /* Fix me : there is a problem if a system() command is running.
     We should wait for the son process to be interrupted.
     Only way I can think of to do that : rewrite system() based on
     spawn() with parsing of the command line and set a global pid
     Next cwait(pid) in the HandlerRoutine. 
     */
  Sleep(10000);
  switch (dwCtrlType) {
  case CTRL_C_EVENT:
  case CTRL_BREAK_EVENT:
    mt_exit(3);
    return FALSE;
  default:
    return TRUE;
  }
}

void mt_exit(int code)
{
  /* rtablir les 0, 1 et 2 d'origine avant de tenter quoi que ce soit ! */

  FILE *f;
  char buf[256];

  fcloseall();

  /* unstack all env from main) */
  for( ; index_env > 0; popenv());
  /* output the result and rm any unneeded file */
  output_and_cleanup(code);

  exit(code);
}

