/* Generated by re2c 0.15.3 on Mon Dec 21 10:25:55 2020 */
#line 1 "parse_date.re"
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2019 Derick Rethans
 * Copyright (c) 2018 MongoDB, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "timelib.h"
#include "timelib_private.h"

#include <ctype.h>
#include <math.h>
#include <assert.h>

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, TIMELIB_ERR_DOUBLE_DATE, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, TIMELIB_ERR_DOUBLE_TZ, "Double timezone specification") : add_warning(s, TIMELIB_WARN_DOUBLE_TZ, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

typedef struct _timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct _Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	timelib_error_container *errors;

	timelib_time        *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
	const char *name;
	int         type;
	int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
static const timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, int error_code, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, int error_code, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, int error_code, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, int error_code, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!timelib_strncasecmp(*ptr, "nd", 2) || !timelib_strncasecmp(*ptr, "rd", 2) ||!timelib_strncasecmp(*ptr, "st", 2) || !timelib_strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static timelib_sll timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin);
	memcpy(str, begin + 1, end - begin - 1);
	tmp_nr = strtod(str, NULL) * pow(10, 7 - (end - begin));
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
		**ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: s->time->relative.us += amount * relunit->multiplier; break;
		case TIMELIB_SECOND:   s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE:   s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:     s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:      s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:    s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:     s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

static const timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (timelib_strcasecmp("utc", word) == 0 || timelib_strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if (fmp->gmtoffset == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = tp->gmtoffset;
		*dst = tp->type;
		value -= tp->type * 3600;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

#define sHOUR(a) (int)(a * 3600)
#define sMIN(a) (int)(a * 60)

static timelib_long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	timelib_long  tmp;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1: /* H */
		case 2: /* HH */
			return sHOUR(strtol(begin, NULL, 10));
			break;
		case 3: /* H:M */
		case 4: /* H:MM, HH:M, HHMM */
			if (begin[1] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 2, NULL, 10));
				return tmp;
			} else if (begin[2] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return sHOUR(tmp / 100) + sMIN(tmp % 100);
			}
		case 5: /* HH:MM */
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
			return tmp;
	}
	return 0;
}

static timelib_long timelib_parse_tz_minutes(char **ptr, timelib_time *t)
{
	timelib_long retval = TIMELIB_UNSET;
	char *begin = *ptr;

	/* First character must be +/- */
	if (**ptr != '+' && **ptr != '-') {
		return retval;
	}

	++*ptr;
	while (isdigit(**ptr)) {
		++*ptr;
	}

	if (*begin == '+') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = sMIN(strtol(begin + 1, NULL, 10));
	} else if (*begin == '-') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * sMIN(strtol(begin + 1, NULL, 10));
	}
	return retval;
}

timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			int dummy_error_code;

			if ((res = tz_wrapper(tz_abbr, tzdb, &dummy_error_code)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;
#line 1011 "parse_date.re"



#line 892 "<stdout>"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  50,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 50,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,  64,  32,  80,  48,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   4,   0,   0,   0,   0,   0, 
		  0,  12,  12,  12,  44,  12,  12,  12, 
		 44,  12,  12,  12,  12,  12,  44,  12, 
		 12,  12,  44,  44,  44,  12,  12,  12, 
		 12,  12,  12,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 33) YYFILL(33);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy51;
	case '\t':
	case ' ':	goto yy48;
	case '(':	goto yy45;
	case '+':
	case '-':	goto yy30;
	case ',':
	case '.':	goto yy50;
	case '0':	goto yy25;
	case '1':	goto yy26;
	case '2':	goto yy27;
	case '3':	goto yy28;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy29;
	case '@':	goto yy11;
	case 'A':	goto yy36;
	case 'B':	goto yy17;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy46;
	case 'D':	goto yy40;
	case 'E':	goto yy21;
	case 'F':	goto yy13;
	case 'G':	goto yy44;
	case 'I':	goto yy31;
	case 'J':	goto yy34;
	case 'L':	goto yy15;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy38;
	case 'P':	goto yy23;
	case 'S':	goto yy19;
	case 'T':	goto yy9;
	case 'V':	goto yy32;
	case 'W':	goto yy42;
	case 'X':	goto yy33;
	case 'Y':	goto yy2;
	case 'a':	goto yy37;
	case 'b':	goto yy18;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy47;
	case 'd':	goto yy41;
	case 'e':	goto yy22;
	case 'f':	goto yy14;
	case 'j':	goto yy35;
	case 'l':	goto yy16;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy39;
	case 'p':	goto yy24;
	case 's':	goto yy20;
	case 't':	goto yy10;
	case 'w':	goto yy43;
	case 'y':	goto yy4;
	default:	goto yy53;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy175;
			goto yy1533;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy175;
			if (yych >= 'a') goto yy180;
		} else {
			if (yych <= 'e') goto yy1542;
			if (yych <= 'z') goto yy180;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);
#line 1719 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1043 "<stdout>"
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy175;
			goto yy1533;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'e') goto yy1533;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1504;
				goto yy175;
			} else {
				if (yych <= 'I') goto yy1505;
				if (yych <= 'N') goto yy175;
				goto yy1503;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy175;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1520;
				goto yy180;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1521;
				goto yy180;
			} else {
				if (yych <= 'o') goto yy1519;
				if (yych <= 'z') goto yy180;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1504;
				goto yy175;
			} else {
				if (yych <= 'I') goto yy1505;
				if (yych <= 'N') goto yy175;
				goto yy1503;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy175;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1504;
				goto yy175;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1505;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy1503;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy1473;
		} else {
			if (yych == 'I') goto yy1474;
			if (yych <= 'N') goto yy175;
			goto yy1475;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1488;
			goto yy180;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1489;
				goto yy180;
			} else {
				if (yych <= 'o') goto yy1490;
				if (yych <= 'z') goto yy180;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy1473;
		} else {
			if (yych == 'I') goto yy1474;
			if (yych <= 'N') goto yy175;
			goto yy1475;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1473;
			goto yy175;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1474;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy1475;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy174;
	case '0':
	case '1':	goto yy1403;
	case '2':	goto yy1404;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1405;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy175;
	case 'E':	goto yy1398;
	case 'H':	goto yy1399;
	case 'O':	goto yy1400;
	case 'U':	goto yy1401;
	case 'W':	goto yy1402;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy180;
	case 'e':	goto yy1441;
	case 'h':	goto yy1442;
	case 'o':	goto yy1443;
	case 'u':	goto yy1444;
	case 'w':	goto yy1445;
	default:	goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy174;
	case '0':
	case '1':	goto yy1403;
	case '2':	goto yy1404;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1405;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy175;
	case 'E':
	case 'e':	goto yy1398;
	case 'H':
	case 'h':	goto yy1399;
	case 'O':
	case 'o':	goto yy1400;
	case 'U':
	case 'u':	goto yy1401;
	case 'W':
	case 'w':	goto yy1402;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1386;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1387;
yy12:
	YYDEBUG(12, *YYCURSOR);
#line 1814 "parse_date.re"
	{
		add_error(s, TIMELIB_ERR_UNEXPECTED_CHARACTER, "Unexpected character");
		goto std;
	}
#line 1357 "<stdout>"
yy13:
	YYDEBUG(13, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy175;
				goto yy1321;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1322;
				goto yy175;
			} else {
				if (yych <= 'O') goto yy1323;
				if (yych <= 'Q') goto yy175;
				goto yy1324;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy175;
				if (yych <= '`') goto yy3;
				goto yy180;
			} else {
				if (yych <= 'e') goto yy1363;
				if (yych <= 'h') goto yy180;
				goto yy1364;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1365;
				goto yy180;
			} else {
				if (yych <= 'r') goto yy1366;
				if (yych <= 'z') goto yy180;
				goto yy3;
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy175;
				goto yy1321;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1322;
				goto yy175;
			} else {
				if (yych <= 'O') goto yy1323;
				if (yych <= 'Q') goto yy175;
				goto yy1324;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy175;
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy1321;
				if (yych <= 'h') goto yy175;
				goto yy1322;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1323;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1324;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
		goto yy1307;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy175;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1318;
			if (yych <= 'z') goto yy180;
			goto yy3;
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
		goto yy1307;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy175;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1307;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
		goto yy1286;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy175;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1304;
			if (yych <= 'z') goto yy180;
			goto yy3;
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
		goto yy1286;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy175;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1286;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1229;
				goto yy175;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1228;
				goto yy175;
			} else {
				if (yych <= 'I') goto yy1230;
				if (yych <= 'T') goto yy175;
				goto yy1231;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy175;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1258;
				if (yych <= 'd') goto yy180;
				goto yy1257;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1259;
				goto yy180;
			} else {
				if (yych <= 'u') goto yy1260;
				if (yych <= 'z') goto yy180;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1229;
				goto yy175;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1228;
				goto yy175;
			} else {
				if (yych <= 'I') goto yy1230;
				if (yych <= 'T') goto yy175;
				goto yy1231;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy175;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1229;
				if (yych <= 'd') goto yy175;
				goto yy1228;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1230;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy1231;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1198;
			if (yych <= 'K') goto yy175;
			goto yy1199;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy180;
			goto yy1216;
		} else {
			if (yych == 'l') goto yy1217;
			if (yych <= 'z') goto yy180;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1198;
			if (yych <= 'K') goto yy175;
			goto yy1199;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy175;
			goto yy1198;
		} else {
			if (yych == 'l') goto yy1199;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy175;
			goto yy1072;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy180;
		} else {
			if (yych <= 'r') goto yy1191;
			if (yych <= 'z') goto yy180;
			goto yy3;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy175;
			goto yy1072;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'r') goto yy1072;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1026;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy1028;
					if (yych <= ',') goto yy12;
					goto yy447;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy1038;
					if (yych <= '/') goto yy446;
					goto yy1071;
				} else {
					if (yych <= '9') goto yy1070;
					if (yych <= ':') goto yy1039;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy1028;
					if (yych <= 'C') goto yy12;
					goto yy1028;
				} else {
					if (yych == 'F') goto yy1028;
					goto yy12;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy1028;
					if (yych <= 'L') goto yy12;
					goto yy1028;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy1028;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy1028;
					if (yych <= 'c') goto yy12;
					goto yy1028;
				} else {
					if (yych == 'f') goto yy1028;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy1028;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy1028;
					goto yy444;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'o') goto yy1028;
					if (yych <= 'q') goto yy12;
					goto yy445;
				} else {
					if (yych <= 's') goto yy439;
					if (yych <= 't') goto yy442;
					goto yy1028;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy1028;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy1028;
					if (yych == 0xC2) goto yy1028;
					goto yy12;
				}
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy434;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy436;
					if (yych <= ',') goto yy12;
					goto yy447;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy448;
					if (yych <= '/') goto yy446;
					goto yy1070;
				} else {
					if (yych <= '9') goto yy1037;
					if (yych <= ':') goto yy457;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy436;
					if (yych <= 'C') goto yy12;
					goto yy436;
				} else {
					if (yych == 'F') goto yy436;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy436;
					if (yych <= 'L') goto yy12;
					goto yy436;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy436;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy436;
					if (yych <= 'c') goto yy12;
					goto yy436;
				} else {
					if (yych == 'f') goto yy436;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy436;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy436;
					goto yy444;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy436;
					if (yych <= 'q') goto yy12;
					goto yy445;
				} else {
					if (yych <= 's') goto yy439;
					if (yych <= 't') goto yy442;
					goto yy436;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy436;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy436;
					if (yych == 0xC2) goto yy436;
					goto yy12;
				}
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy434;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy436;
					if (yych <= ',') goto yy12;
					goto yy447;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy448;
					if (yych <= '/') goto yy446;
					goto yy1037;
				} else {
					if (yych <= '9') goto yy1024;
					if (yych <= ':') goto yy457;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy436;
					if (yych <= 'C') goto yy12;
					goto yy436;
				} else {
					if (yych == 'F') goto yy436;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy436;
					if (yych <= 'L') goto yy12;
					goto yy436;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy436;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy436;
					if (yych <= 'c') goto yy12;
					goto yy436;
				} else {
					if (yych == 'f') goto yy436;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy436;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy436;
					goto yy444;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy436;
					if (yych <= 'q') goto yy12;
					goto yy445;
				} else {
					if (yych <= 's') goto yy439;
					if (yych <= 't') goto yy442;
					goto yy436;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy436;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy436;
					if (yych == 0xC2) goto yy436;
					goto yy12;
				}
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy434;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy436;
					if (yych <= ',') goto yy12;
					goto yy447;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy448;
					if (yych <= '/') goto yy446;
					goto yy1024;
				} else {
					if (yych <= '9') goto yy443;
					if (yych <= ':') goto yy457;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy436;
					if (yych <= 'C') goto yy12;
					goto yy436;
				} else {
					if (yych == 'F') goto yy436;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy436;
					if (yych <= 'L') goto yy12;
					goto yy436;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy436;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy436;
					if (yych <= 'c') goto yy12;
					goto yy436;
				} else {
					if (yych == 'f') goto yy436;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy436;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy436;
					goto yy444;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy436;
					if (yych <= 'q') goto yy12;
					goto yy445;
				} else {
					if (yych <= 's') goto yy439;
					if (yych <= 't') goto yy442;
					goto yy436;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy436;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy436;
					if (yych == 0xC2) goto yy436;
					goto yy12;
				}
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy434;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy436;
					if (yych <= ',') goto yy12;
					goto yy447;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy448;
					if (yych <= '/') goto yy446;
					goto yy443;
				} else {
					if (yych <= ':') goto yy457;
					if (yych <= '@') goto yy12;
					goto yy436;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy436;
					goto yy12;
				} else {
					if (yych == 'G') goto yy12;
					goto yy436;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy12;
					if (yych <= 'P') goto yy436;
					goto yy12;
				} else {
					if (yych <= 'Y') goto yy436;
					if (yych <= '`') goto yy12;
					goto yy436;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy436;
					goto yy12;
				} else {
					if (yych == 'g') goto yy12;
					goto yy436;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy436;
					goto yy12;
				} else {
					if (yych == 'n') goto yy444;
					goto yy436;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'q') goto yy12;
					if (yych <= 'r') goto yy445;
					goto yy439;
				} else {
					if (yych <= 't') goto yy442;
					if (yych <= 'u') goto yy436;
					goto yy12;
				}
			} else {
				if (yych <= 'y') {
					if (yych == 'x') goto yy12;
					goto yy436;
				} else {
					if (yych == 0xC2) goto yy436;
					goto yy12;
				}
			}
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy56;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy414;
	case '0':
	case '1':	goto yy411;
	case '2':	goto yy412;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy413;
	default:	goto yy12;
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy230;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'I') goto yy410;
				if (yych <= 'U') goto yy175;
				goto yy409;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy409;
				goto yy175;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy180;
				goto yy3;
			}
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy3;
			goto yy230;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy230;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy230;
			if (yych <= '@') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy406;
				goto yy175;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy180;
				goto yy3;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy3;
			goto yy230;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy230;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy230;
			if (yych <= '@') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy404;
				goto yy175;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy180;
				goto yy3;
			}
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy387;
			if (yych <= 'T') goto yy175;
			goto yy386;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy396;
		} else {
			if (yych == 'u') goto yy395;
			if (yych <= 'z') goto yy180;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy387;
			if (yych <= 'T') goto yy175;
			goto yy386;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy387;
		} else {
			if (yych == 'u') goto yy386;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy365;
				goto yy175;
			} else {
				if (yych <= 'P') goto yy364;
				if (yych <= 'T') goto yy175;
				goto yy363;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy175;
				goto yy3;
			} else {
				if (yych == 'g') goto yy377;
				goto yy180;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy376;
				goto yy180;
			} else {
				if (yych <= 'u') goto yy375;
				if (yych <= 'z') goto yy180;
				goto yy3;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy365;
				goto yy175;
			} else {
				if (yych <= 'P') goto yy364;
				if (yych <= 'T') goto yy175;
				goto yy363;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy175;
				goto yy3;
			} else {
				if (yych == 'g') goto yy365;
				goto yy175;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy364;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy363;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy175;
			goto yy353;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy180;
		} else {
			if (yych <= 'c') goto yy358;
			if (yych <= 'z') goto yy180;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy175;
			goto yy353;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'c') goto yy353;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy175;
			goto yy226;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy180;
		} else {
			if (yych <= 'e') goto yy344;
			if (yych <= 'z') goto yy180;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy175;
			goto yy226;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'e') goto yy226;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy175;
			goto yy199;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy180;
		} else {
			if (yych <= 'e') goto yy213;
			if (yych <= 'z') goto yy180;
			goto yy3;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy175;
			goto yy199;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy175;
			if (yych <= '`') goto yy3;
			goto yy175;
		} else {
			if (yych <= 'e') goto yy199;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
		goto yy175;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy191;
			goto yy175;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy180;
			goto yy3;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy190;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy190;
	goto yy12;
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy175;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy180;
		goto yy3;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy175;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy175;
		goto yy3;
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy56;
	}
	if (yych <= '/') goto yy49;
	if (yych <= '9') goto yy54;
yy49:
	YYDEBUG(49, *YYCURSOR);
#line 1803 "parse_date.re"
	{
		goto std;
	}
#line 2605 "<stdout>"
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy49;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(52, *YYCURSOR);
#line 1808 "parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 2619 "<stdout>"
yy53:
	YYDEBUG(53, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy54:
	YYDEBUG(54, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy70;
	goto yy59;
yy55:
	YYDEBUG(55, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy3;
						} else {
							goto yy12;
						}
					} else {
						goto yy49;
					}
				} else {
					if (yyaccept == 3) {
						goto yy84;
					} else {
						goto yy201;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy228;
					} else {
						goto yy242;
					}
				} else {
					if (yyaccept == 7) {
						goto yy256;
					} else {
						goto yy367;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy450;
					} else {
						goto yy465;
					}
				} else {
					if (yyaccept == 11) {
						goto yy586;
					} else {
						goto yy631;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy641;
					} else {
						goto yy738;
					}
				} else {
					if (yyaccept == 15) {
						goto yy758;
					} else {
						goto yy789;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept == 17) {
							goto yy796;
						} else {
							goto yy823;
						}
					} else {
						goto yy768;
					}
				} else {
					if (yyaccept == 20) {
						goto yy429;
					} else {
						goto yy948;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept == 22) {
						goto yy817;
					} else {
						goto yy1042;
					}
				} else {
					if (yyaccept == 24) {
						goto yy1050;
					} else {
						goto yy1094;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept == 26) {
						goto yy1118;
					} else {
						goto yy1294;
					}
				} else {
					if (yyaccept == 28) {
						goto yy1389;
					} else {
						goto yy1427;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept == 30) {
						goto yy1430;
					} else {
						goto yy1510;
					}
				} else {
					if (yyaccept == 32) {
						goto yy1518;
					} else {
						goto yy1541;
					}
				}
			}
		}
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 24) YYFILL(24);
	yych = *YYCURSOR;
	YYDEBUG(57, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy56;
	}
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy54;
	goto yy55;
yy58:
	YYDEBUG(58, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy59:
	YYDEBUG(59, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy58;
				if (yych <= 0x1F) goto yy55;
				goto yy58;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy55;
					goto yy65;
				} else {
					if (yych == 'F') goto yy66;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy64;
					goto yy55;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy55;
					goto yy63;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy69;
					goto yy62;
				} else {
					if (yych == 'W') goto yy68;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy67;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy65;
					if (yych <= 'e') goto yy55;
					goto yy66;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy55;
					goto yy64;
				} else {
					if (yych != 'm') goto yy55;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy63;
					goto yy69;
				} else {
					if (yych <= 'u') goto yy62;
					if (yych <= 'v') goto yy55;
					goto yy68;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy67;
				} else {
					if (yych == 0xC2) goto yy61;
					goto yy55;
				}
			}
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy148;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy147;
			if (yych <= 'R') goto yy55;
			goto yy149;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy148;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy147;
			if (yych == 's') goto yy149;
			goto yy55;
		}
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy144;
	goto yy55;
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy142;
	if (yych == 's') goto yy142;
	goto yy55;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy129;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy130;
			if (yych <= 'T') goto yy55;
			goto yy128;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy129;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy130;
			if (yych == 'u') goto yy128;
			goto yy55;
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy126;
	if (yych == 'o') goto yy126;
	goto yy55;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy125;
	if (yych == 'a') goto yy125;
	goto yy55;
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy110;
		if (yych <= 'Q') goto yy55;
		goto yy109;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy55;
			goto yy110;
		} else {
			if (yych == 'r') goto yy109;
			goto yy55;
		}
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy106;
	if (yych == 'e') goto yy106;
	goto yy55;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy94;
	if (yych == 'e') goto yy94;
	goto yy55;
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy81;
		if (yych <= 'T') goto yy55;
		goto yy82;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy81;
		} else {
			if (yych == 'u') goto yy82;
			goto yy55;
		}
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy58;
	goto yy59;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy89;
	if (yych == 'u') goto yy89;
	goto yy55;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy83;
	if (yych != 'e') goto yy55;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy85;
	if (yych == 's') goto yy85;
yy84:
	YYDEBUG(84, *YYCURSOR);
#line 1787 "parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3056 "<stdout>"
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy86;
	if (yych != 'd') goto yy55;
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy87;
	if (yych != 'a') goto yy55;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy88;
	if (yych != 'y') goto yy55;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy84;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy90;
	if (yych != 'r') goto yy84;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy91;
	if (yych != 's') goto yy55;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy92;
	if (yych != 'd') goto yy55;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy93;
	if (yych != 'a') goto yy55;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy88;
	if (yych == 'y') goto yy88;
	goto yy55;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy55;
		if (yych <= 'D') goto yy96;
	} else {
		if (yych <= 'c') goto yy55;
		if (yych <= 'd') goto yy96;
		if (yych >= 'f') goto yy55;
	}
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy102;
	if (yych == 'k') goto yy102;
	goto yy55;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy97;
	if (yych != 'n') goto yy84;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy98;
	if (yych != 'e') goto yy55;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy99;
	if (yych != 's') goto yy55;
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy100;
	if (yych != 'd') goto yy55;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy101;
	if (yych != 'a') goto yy55;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy88;
	if (yych == 'y') goto yy88;
	goto yy55;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy103;
		if (yych <= 'R') goto yy84;
		goto yy88;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy84;
		} else {
			if (yych == 's') goto yy88;
			goto yy84;
		}
	}
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy104;
	if (yych != 'a') goto yy55;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy105;
	if (yych != 'y') goto yy55;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy88;
	if (yych == 's') goto yy88;
	goto yy84;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy107;
	if (yych != 'a') goto yy55;
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy108;
	if (yych != 'r') goto yy55;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy88;
	if (yych == 's') goto yy88;
	goto yy84;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy122;
	if (yych == 'i') goto yy122;
	goto yy55;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy111;
	if (yych != 'r') goto yy55;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy112;
	if (yych != 't') goto yy55;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy114;
		if (yych <= 'M') goto yy55;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy114;
		} else {
			if (yych != 'n') goto yy55;
		}
	}
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy119;
	if (yych == 'i') goto yy119;
	goto yy55;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy115;
	if (yych != 'n') goto yy55;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy116;
	if (yych != 'i') goto yy55;
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy117;
	if (yych != 'g') goto yy55;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy118;
	if (yych != 'h') goto yy55;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy108;
	if (yych == 't') goto yy108;
	goto yy55;
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy120;
	if (yych != 'g') goto yy55;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy121;
	if (yych != 'h') goto yy55;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy108;
	if (yych == 't') goto yy108;
	goto yy55;
yy122:
	YYDEBUG(122, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy123;
	if (yych != 'd') goto yy84;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy124;
	if (yych != 'a') goto yy55;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy88;
	if (yych == 'y') goto yy88;
	goto yy55;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy108;
	if (yych == 'y') goto yy108;
	goto yy55;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy127;
	if (yych != 'u') goto yy55;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy108;
	if (yych == 'r') goto yy108;
	goto yy55;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy139;
	if (yych == 'n') goto yy139;
	goto yy55;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy134;
	if (yych == 't') goto yy134;
	goto yy55;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy131;
	if (yych != 'c') goto yy55;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy132;
		if (yych <= 'R') goto yy84;
		goto yy88;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy84;
		} else {
			if (yych == 's') goto yy88;
			goto yy84;
		}
	}
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy133;
	if (yych != 'n') goto yy55;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy108;
	if (yych == 'd') goto yy108;
	goto yy55;
yy134:
	YYDEBUG(134, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy135;
	if (yych != 'u') goto yy84;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy136;
	if (yych != 'r') goto yy55;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy137;
	if (yych != 'd') goto yy55;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy138;
	if (yych != 'a') goto yy55;
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy88;
	if (yych == 'y') goto yy88;
	goto yy55;
yy139:
	YYDEBUG(139, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy140;
	if (yych != 'd') goto yy84;
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy141;
	if (yych != 'a') goto yy55;
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy88;
	if (yych == 'y') goto yy88;
	goto yy55;
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy143;
	if (yych != 'e') goto yy55;
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy108;
	if (yych == 'c') goto yy108;
	goto yy55;
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy145;
	if (yych != 's') goto yy55;
yy145:
	YYDEBUG(145, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy146;
	if (yych != 'e') goto yy84;
yy146:
	YYDEBUG(146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy108;
	if (yych == 'c') goto yy108;
	goto yy55;
yy147:
	YYDEBUG(147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy170;
	if (yych == 'n') goto yy170;
	goto yy55;
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy152;
			goto yy55;
		} else {
			if (yych <= 'L') goto yy151;
			if (yych <= 'M') goto yy55;
			goto yy153;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy152;
			goto yy55;
		} else {
			if (yych <= 'l') goto yy151;
			if (yych == 'n') goto yy153;
			goto yy55;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy150;
	if (yych != 'e') goto yy84;
yy150:
	YYDEBUG(150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy108;
	if (yych == 'c') goto yy108;
	goto yy55;
yy151:
	YYDEBUG(151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy163;
	if (yych == 'l') goto yy163;
	goto yy55;
yy152:
	YYDEBUG(152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy156;
	if (yych == 'r') goto yy156;
	goto yy55;
yy153:
	YYDEBUG(153, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy88;
		if (yych <= 'T') goto yy84;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy84;
			goto yy88;
		} else {
			if (yych != 'u') goto yy84;
		}
	}
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy155;
	if (yych != 't') goto yy55;
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy108;
	if (yych == 'e') goto yy108;
	goto yy55;
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy157;
	if (yych != 'o') goto yy55;
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy158;
	if (yych != 's') goto yy55;
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy159;
	if (yych != 'e') goto yy55;
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy160;
	if (yych != 'c') goto yy55;
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy161;
	if (yych != 'o') goto yy55;
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy162;
	if (yych != 'n') goto yy55;
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy108;
	if (yych == 'd') goto yy108;
	goto yy55;
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy164;
	if (yych != 'i') goto yy55;
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy165;
	if (yych != 's') goto yy55;
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy166;
	if (yych != 'e') goto yy55;
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy167;
	if (yych != 'c') goto yy55;
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy168;
	if (yych != 'o') goto yy55;
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy169;
	if (yych != 'n') goto yy55;
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy108;
	if (yych == 'd') goto yy108;
	goto yy55;
yy170:
	YYDEBUG(170, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy171;
		if (yych <= 'S') goto yy84;
		goto yy172;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy84;
		} else {
			if (yych == 't') goto yy172;
			goto yy84;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy173;
	if (yych == 'a') goto yy173;
	goto yy55;
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy108;
	if (yych == 'h') goto yy108;
	goto yy55;
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy88;
	if (yych == 'y') goto yy88;
	goto yy55;
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy176;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy177;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy178;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy179;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy179:
	YYDEBUG(179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy174;
	goto yy3;
yy180:
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy182;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy176;
			goto yy3;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy177;
			goto yy3;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy183;
	}
	goto yy55;
yy183:
	YYDEBUG(183, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(184, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy183;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy182;
		goto yy3;
	} else {
		if (yych <= '/') goto yy182;
		if (yych == '_') goto yy182;
		goto yy3;
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy182;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy178;
			goto yy3;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy182;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy179;
			goto yy3;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy187:
	YYDEBUG(187, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy174;
		if (yych <= ',') goto yy3;
		goto yy182;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy182;
		} else {
			if (yych == '_') goto yy182;
			goto yy3;
		}
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy189:
	YYDEBUG(189, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy182;
		goto yy55;
	} else {
		if (yych <= '/') goto yy182;
		if (yych == '_') goto yy182;
		goto yy55;
	}
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy175;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy175;
		goto yy3;
	}
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
		goto yy176;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy176;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
	YYDEBUG(192, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych != '+') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy193;
			if (yych <= '@') goto yy3;
			goto yy177;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy194;
	if (yych <= '2') goto yy195;
	if (yych <= '9') goto yy196;
	goto yy55;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy196;
	if (yych <= ':') goto yy197;
	goto yy3;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy3;
		if (yych >= '5') goto yy198;
	} else {
		if (yych <= '9') goto yy174;
		if (yych <= ':') goto yy197;
		goto yy3;
	}
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy198;
	if (yych <= '9') goto yy174;
	if (yych >= ';') goto yy3;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy198;
	if (yych <= '9') goto yy174;
	goto yy3;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy174;
	goto yy3;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy176;
			if (yych >= 'E') goto yy202;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'd') goto yy200;
			if (yych <= 'e') goto yy202;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy174;
		} else {
			if (yych <= '@') goto yy201;
			if (yych <= 'M') goto yy177;
			goto yy208;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy177;
			if (yych >= 'a') goto yy177;
		} else {
			if (yych <= 'n') goto yy208;
			if (yych <= 'z') goto yy177;
		}
	}
yy201:
	YYDEBUG(201, *YYCURSOR);
#line 1650 "parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 3976 "<stdout>"
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy177;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'k') goto yy203;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy178;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'd') goto yy204;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy179;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy205;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy206;
		if (yych != 'y') goto yy3;
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy207;
	if (yych != 's') goto yy201;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy201;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy178;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'e') goto yy209;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy179;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy210:
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy211;
		if (yych != 'd') goto yy3;
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy212;
	if (yych != 'a') goto yy55;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy207;
	if (yych == 'y') goto yy207;
	goto yy55;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy182;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy176;
				goto yy200;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy202;
				goto yy176;
			} else {
				if (yych == '_') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy181;
			} else {
				if (yych <= 'e') goto yy215;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
	YYDEBUG(214, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy201;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy201;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy208;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy201;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy201;
				goto yy185;
			} else {
				if (yych <= 'n') goto yy221;
				if (yych <= 'z') goto yy185;
				goto yy201;
			}
		}
	}
yy215:
	YYDEBUG(215, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy203;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'k') goto yy216;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy216:
	YYDEBUG(216, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy204;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'd') goto yy217;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy217:
	YYDEBUG(217, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy205;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy218;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy206;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'y') goto yy219;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy219:
	YYDEBUG(219, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy182;
			goto yy201;
		} else {
			if (yych <= '/') goto yy182;
			if (yych <= 'R') goto yy201;
			goto yy207;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy182;
			goto yy201;
		} else {
			if (yych == 's') goto yy220;
			if (yych <= 'z') goto yy188;
			goto yy201;
		}
	}
yy220:
	YYDEBUG(220, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy182;
		goto yy201;
	} else {
		if (yych <= '/') goto yy182;
		if (yych == '_') goto yy182;
		goto yy201;
	}
yy221:
	YYDEBUG(221, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy209;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'e') goto yy222;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy222:
	YYDEBUG(222, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy210;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 's') goto yy223;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy223:
	YYDEBUG(223, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy211;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'd') goto yy224;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy212;
	if (yych != 'a') goto yy189;
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy207;
	if (yych == 'y') goto yy220;
	goto yy189;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy176;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'c') goto yy227;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy227:
	YYDEBUG(227, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy230;
			} else {
				if (yych == ' ') goto yy230;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
			} else {
				if (yych == 'E') goto yy235;
				goto yy177;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy177;
			} else {
				if (yych <= 'e') goto yy235;
				if (yych <= 'z') goto yy177;
			}
		}
	}
yy228:
	YYDEBUG(228, *YYCURSOR);
#line 1709 "parse_date.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 4505 "<stdout>"
yy229:
	YYDEBUG(229, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 23) YYFILL(23);
	yych = *YYCURSOR;
yy230:
	YYDEBUG(230, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy229;
	}
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy232;
	if (yych <= '3') goto yy233;
	if (yych <= '9') goto yy234;
	goto yy55;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy230;
	if (yych <= '0') goto yy334;
	if (yych <= '2') goto yy335;
	if (yych <= '3') goto yy336;
	goto yy230;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy248;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy246;
				if (yych <= 0x1F) goto yy55;
				goto yy246;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy246;
				goto yy55;
			} else {
				if (yych <= '.') goto yy246;
				if (yych <= '/') goto yy55;
				goto yy333;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy246;
			} else {
				if (yych == 'h') goto yy246;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy243;
				if (yych <= 'q') goto yy55;
				goto yy244;
			} else {
				if (yych <= 's') goto yy241;
				if (yych <= 't') goto yy245;
				goto yy55;
			}
		}
	}
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy248;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy246;
				if (yych <= 0x1F) goto yy55;
				goto yy246;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy246;
				goto yy55;
			} else {
				if (yych <= '.') goto yy246;
				if (yych <= '/') goto yy55;
				goto yy333;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy240;
				if (yych <= 'c') goto yy55;
				goto yy246;
			} else {
				if (yych == 'h') goto yy246;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy243;
				if (yych <= 'q') goto yy55;
				goto yy244;
			} else {
				if (yych <= 's') goto yy241;
				if (yych <= 't') goto yy245;
				goto yy55;
			}
		}
	}
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy248;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy246;
				if (yych <= 0x1F) goto yy55;
				goto yy246;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy246;
				goto yy55;
			} else {
				if (yych <= '.') goto yy246;
				if (yych <= '/') goto yy55;
				goto yy240;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy246;
			} else {
				if (yych == 'h') goto yy246;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy243;
				if (yych <= 'q') goto yy55;
				goto yy244;
			} else {
				if (yych <= 's') goto yy241;
				if (yych <= 't') goto yy245;
				goto yy55;
			}
		}
	}
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy178;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'm') goto yy236;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy179;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'b') goto yy237;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy237:
	YYDEBUG(237, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy238;
		if (yych != 'e') goto yy3;
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy239;
	if (yych != 'r') goto yy55;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy230;
		if (yych <= 0x1F) goto yy228;
		goto yy230;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy228;
			goto yy230;
		} else {
			if (yych <= '/') goto yy228;
			if (yych <= '9') goto yy230;
			goto yy228;
		}
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy330;
	goto yy55;
yy241:
	YYDEBUG(241, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy329;
	goto yy247;
yy242:
	YYDEBUG(242, *YYCURSOR);
#line 1455 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 4767 "<stdout>"
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy329;
	goto yy247;
yy244:
	YYDEBUG(244, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy329;
	goto yy247;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy329;
	goto yy247;
yy246:
	YYDEBUG(246, *YYCURSOR);
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy247:
	YYDEBUG(247, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy246;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy242;
		if (yych <= '0') goto yy320;
		if (yych <= '1') goto yy321;
		goto yy322;
	} else {
		if (yych <= '9') goto yy323;
		if (yych == 'T') goto yy249;
		goto yy242;
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych <= '/') goto yy242;
			goto yy250;
		} else {
			if (yych <= '1') goto yy251;
			if (yych <= '2') goto yy252;
			goto yy253;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= 'S') goto yy242;
		} else {
			if (yych != 't') goto yy242;
		}
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy318;
	if (yych <= '2') goto yy319;
	if (yych <= '9') goto yy308;
	goto yy55;
yy250:
	YYDEBUG(250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy309;
		goto yy55;
	} else {
		if (yych <= '0') goto yy308;
		if (yych <= '9') goto yy253;
		if (yych <= ':') goto yy309;
		goto yy55;
	}
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy254;
		goto yy55;
	} else {
		if (yych <= '2') goto yy253;
		if (yych <= '9') goto yy308;
		if (yych <= ':') goto yy254;
		goto yy55;
	}
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy254;
		goto yy55;
	} else {
		if (yych <= '4') goto yy308;
		if (yych == ':') goto yy254;
		goto yy55;
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy254;
	if (yych != ':') goto yy55;
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy255;
	if (yych <= '9') goto yy257;
	goto yy55;
yy255:
	YYDEBUG(255, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy258;
	} else {
		if (yych <= '9') goto yy301;
		if (yych <= ':') goto yy258;
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
#line 1757 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 4923 "<stdout>"
yy257:
	YYDEBUG(257, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy258;
	if (yych != ':') goto yy256;
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy259;
	if (yych <= '6') goto yy260;
	if (yych <= '9') goto yy261;
	goto yy55;
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy256;
	if (yych <= '9') goto yy262;
	goto yy256;
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy262;
	goto yy256;
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy256;
yy262:
	YYDEBUG(262, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy264;
			goto yy256;
		} else {
			if (yych <= ' ') goto yy264;
			if (yych == '(') goto yy264;
			goto yy256;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy256;
			if (yych <= '-') goto yy264;
			goto yy256;
		} else {
			if (yych <= 'Z') goto yy264;
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy264;
			goto yy256;
		}
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy264:
	YYDEBUG(264, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy55;
				goto yy263;
			} else {
				if (yych == ' ') goto yy263;
				goto yy55;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy267;
				if (yych <= '*') goto yy55;
				goto yy266;
			} else {
				if (yych == '-') goto yy266;
				goto yy55;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy268;
				if (yych <= 'F') goto yy269;
			} else {
				if (yych == 'P') goto yy268;
				goto yy269;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy55;
				if (yych <= 'a') goto yy270;
				goto yy271;
			} else {
				if (yych <= 'p') goto yy270;
				if (yych <= 'z') goto yy271;
				goto yy55;
			}
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy261;
		if (yych <= '@') goto yy256;
		goto yy272;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy299;
			goto yy272;
		} else {
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy283;
			goto yy256;
		}
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy294;
	if (yych <= '2') goto yy295;
	if (yych <= '9') goto yy296;
	goto yy55;
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy55;
	if (yych <= 'Z') goto yy271;
	if (yych <= '`') goto yy55;
	if (yych <= 'z') goto yy271;
	goto yy55;
yy268:
	YYDEBUG(268, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy261;
			goto yy256;
		} else {
			if (yych <= '.') goto yy277;
			if (yych <= '@') goto yy256;
			goto yy272;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy278;
			if (yych <= 'Z') goto yy272;
			goto yy256;
		} else {
			if (yych == 'm') goto yy293;
			if (yych <= 'z') goto yy283;
			goto yy256;
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy261;
		goto yy256;
	} else {
		if (yych <= 'Z') goto yy272;
		if (yych <= '`') goto yy256;
		if (yych <= 'z') goto yy283;
		goto yy256;
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy261;
			goto yy256;
		} else {
			if (yych <= '.') goto yy277;
			if (yych <= '@') goto yy256;
			goto yy272;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy278;
			if (yych <= 'Z') goto yy272;
			goto yy256;
		} else {
			if (yych == 'm') goto yy278;
			if (yych <= 'z') goto yy272;
			goto yy256;
		}
	}
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy261;
		goto yy256;
	} else {
		if (yych <= 'Z') goto yy272;
		if (yych <= '`') goto yy256;
		if (yych >= '{') goto yy256;
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy261;
		goto yy256;
	} else {
		if (yych <= 'Z') goto yy273;
		if (yych <= '`') goto yy256;
		if (yych >= '{') goto yy256;
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy261;
		goto yy256;
	} else {
		if (yych <= 'Z') goto yy274;
		if (yych <= '`') goto yy256;
		if (yych >= '{') goto yy256;
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy261;
		goto yy256;
	} else {
		if (yych <= 'Z') goto yy275;
		if (yych <= '`') goto yy256;
		if (yych >= '{') goto yy256;
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy261;
		goto yy256;
	} else {
		if (yych <= 'Z') goto yy276;
		if (yych <= '`') goto yy256;
		if (yych >= '{') goto yy256;
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy261;
	goto yy256;
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy282;
	if (yych == 'm') goto yy282;
	goto yy55;
yy278:
	YYDEBUG(278, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy280;
			if (yych <= 0x08) goto yy256;
			goto yy280;
		} else {
			if (yych == ' ') goto yy280;
			if (yych <= '(') goto yy256;
			goto yy261;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy256;
		} else {
			if (yych <= 'Z') goto yy273;
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy273;
			goto yy256;
		}
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy280;
		if (yych <= 0x08) goto yy55;
	} else {
		if (yych != ' ') goto yy55;
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(281, *YYCURSOR);
#line 1733 "parse_date.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 5244 "<stdout>"
yy282:
	YYDEBUG(282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy280;
		if (yych == '\t') goto yy280;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy280;
		if (yych == '.') goto yy279;
		goto yy55;
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy261;
			goto yy256;
		} else {
			if (yych == '.') goto yy256;
			goto yy285;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy256;
			if (yych <= 'Z') goto yy273;
			goto yy256;
		} else {
			if (yych <= '_') goto yy285;
			if (yych <= '`') goto yy256;
			if (yych >= '{') goto yy256;
		}
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy261;
			goto yy256;
		} else {
			if (yych == '.') goto yy256;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy256;
			if (yych <= 'Z') goto yy274;
			goto yy256;
		} else {
			if (yych <= '_') goto yy285;
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy288;
			goto yy256;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy55;
	if (yych <= 'Z') goto yy286;
	if (yych <= '`') goto yy55;
	if (yych >= '{') goto yy55;
yy286:
	YYDEBUG(286, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(287, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy256;
			goto yy285;
		} else {
			if (yych == '/') goto yy285;
			goto yy256;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy286;
			if (yych <= '^') goto yy256;
			goto yy285;
		} else {
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy286;
			goto yy256;
		}
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy261;
			goto yy256;
		} else {
			if (yych == '.') goto yy256;
			goto yy285;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy256;
			if (yych <= 'Z') goto yy275;
			goto yy256;
		} else {
			if (yych <= '_') goto yy285;
			if (yych <= '`') goto yy256;
			if (yych >= '{') goto yy256;
		}
	}
	YYDEBUG(289, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy261;
			goto yy256;
		} else {
			if (yych == '.') goto yy256;
			goto yy285;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy256;
			if (yych <= 'Z') goto yy276;
			goto yy256;
		} else {
			if (yych <= '_') goto yy285;
			if (yych <= '`') goto yy256;
			if (yych >= '{') goto yy256;
		}
	}
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy256;
			goto yy261;
		} else {
			if (yych == '-') goto yy285;
			goto yy256;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy285;
			if (yych <= '^') goto yy256;
			goto yy285;
		} else {
			if (yych <= '`') goto yy256;
			if (yych >= '{') goto yy256;
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(292, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy285;
		if (yych <= '.') goto yy55;
		goto yy285;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy55;
			goto yy285;
		} else {
			if (yych <= '`') goto yy55;
			if (yych <= 'z') goto yy291;
			goto yy55;
		}
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy280;
			if (yych == '\t') goto yy280;
			goto yy256;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy280;
				goto yy256;
			} else {
				if (yych <= ')') goto yy261;
				if (yych <= ',') goto yy256;
				goto yy285;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy279;
			if (yych <= '/') goto yy285;
			if (yych <= '@') goto yy256;
			goto yy273;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy256;
				goto yy285;
			} else {
				if (yych <= '`') goto yy256;
				if (yych <= 'z') goto yy284;
				goto yy256;
			}
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy256;
	if (yych <= '9') goto yy296;
	if (yych <= ':') goto yy297;
	goto yy256;
yy295:
	YYDEBUG(295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy256;
		if (yych >= '5') goto yy298;
	} else {
		if (yych <= '9') goto yy261;
		if (yych <= ':') goto yy297;
		goto yy256;
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy256;
	if (yych <= '5') goto yy298;
	if (yych <= '9') goto yy261;
	if (yych >= ';') goto yy256;
yy297:
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy256;
	if (yych <= '5') goto yy298;
	if (yych <= '9') goto yy261;
	goto yy256;
yy298:
	YYDEBUG(298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy256;
	if (yych <= '9') goto yy261;
	goto yy256;
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy261;
		if (yych <= '@') goto yy256;
		goto yy273;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy273;
		} else {
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy273;
			goto yy256;
		}
	}
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy256;
			goto yy261;
		} else {
			if (yych == '+') goto yy266;
			goto yy256;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy266;
			if (yych <= '@') goto yy256;
			goto yy274;
		} else {
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy274;
			goto yy256;
		}
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy302;
			if (yych <= 0x1F) goto yy256;
		} else {
			if (yych == '.') goto yy258;
			if (yych <= '9') goto yy256;
			goto yy258;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy304;
			if (yych <= 'O') goto yy256;
			goto yy304;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy256;
				goto yy304;
			} else {
				if (yych == 'p') goto yy304;
				goto yy256;
			}
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(303, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy302;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy302;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy304;
			if (yych != 'p') goto yy55;
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy306;
		if (yych == 'm') goto yy306;
		goto yy55;
	}
	YYDEBUG(305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy306;
	if (yych != 'm') goto yy55;
yy306:
	YYDEBUG(306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy280;
		if (yych == '\t') goto yy280;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy280;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy280;
		if (yych <= 0x08) goto yy55;
		goto yy280;
	} else {
		if (yych == ' ') goto yy280;
		goto yy55;
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy309;
	if (yych != ':') goto yy55;
yy309:
	YYDEBUG(309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy310;
	if (yych <= '9') goto yy311;
	goto yy55;
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy312;
		goto yy256;
	} else {
		if (yych <= '9') goto yy311;
		if (yych <= ':') goto yy312;
		goto yy256;
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy312;
	if (yych != ':') goto yy256;
yy312:
	YYDEBUG(312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy313;
	if (yych <= '6') goto yy314;
	if (yych <= '9') goto yy261;
	goto yy55;
yy313:
	YYDEBUG(313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy256;
	if (yych <= '9') goto yy315;
	goto yy256;
yy314:
	YYDEBUG(314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy256;
yy315:
	YYDEBUG(315, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy317;
			goto yy256;
		} else {
			if (yych <= ' ') goto yy317;
			if (yych == '(') goto yy317;
			goto yy256;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy256;
			if (yych <= '-') goto yy317;
			goto yy256;
		} else {
			if (yych <= 'Z') goto yy317;
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy317;
			goto yy256;
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy317:
	YYDEBUG(317, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy316;
			if (yych <= 0x1F) goto yy55;
			goto yy316;
		} else {
			if (yych == '(') goto yy267;
			if (yych <= '*') goto yy55;
			goto yy266;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy266;
			if (yych <= '@') goto yy55;
			goto yy269;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy265;
				goto yy269;
			} else {
				if (yych <= '`') goto yy55;
				if (yych <= 'z') goto yy271;
				goto yy55;
			}
		}
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy309;
		goto yy55;
	} else {
		if (yych <= '9') goto yy308;
		if (yych <= ':') goto yy309;
		goto yy55;
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy309;
		goto yy55;
	} else {
		if (yych <= '4') goto yy308;
		if (yych == ':') goto yy309;
		goto yy55;
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy309;
		goto yy242;
	} else {
		if (yych <= '0') goto yy327;
		if (yych <= '9') goto yy328;
		if (yych <= ':') goto yy309;
		goto yy242;
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy254;
		goto yy242;
	} else {
		if (yych <= '2') goto yy328;
		if (yych <= '9') goto yy327;
		if (yych <= ':') goto yy254;
		goto yy242;
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy254;
		goto yy242;
	} else {
		if (yych <= '4') goto yy327;
		if (yych <= '9') goto yy324;
		if (yych <= ':') goto yy254;
		goto yy242;
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy254;
		goto yy242;
	} else {
		if (yych <= '9') goto yy324;
		if (yych <= ':') goto yy254;
		goto yy242;
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy242;
	if (yych >= ':') goto yy242;
yy325:
	YYDEBUG(325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy242;
	if (yych >= ':') goto yy242;
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy242;
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy309;
		goto yy242;
	} else {
		if (yych <= '9') goto yy325;
		if (yych <= ':') goto yy309;
		goto yy242;
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy254;
		goto yy242;
	} else {
		if (yych <= '9') goto yy325;
		if (yych <= ':') goto yy254;
		goto yy242;
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy248;
	goto yy247;
yy330:
	YYDEBUG(330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(331, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(332, *YYCURSOR);
#line 1427 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 5864 "<stdout>"
yy333:
	YYDEBUG(333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy248;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy246;
				if (yych <= 0x1F) goto yy55;
				goto yy246;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy246;
				goto yy55;
			} else {
				if (yych <= '.') goto yy246;
				if (yych <= '/') goto yy55;
				goto yy330;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy246;
			} else {
				if (yych == 'h') goto yy246;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy243;
				if (yych <= 'q') goto yy55;
				goto yy244;
			} else {
				if (yych <= 's') goto yy241;
				if (yych <= 't') goto yy245;
				goto yy55;
			}
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy248;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy246;
				if (yych <= 0x1F) goto yy55;
				goto yy246;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy246;
				goto yy55;
			} else {
				if (yych <= '.') goto yy246;
				if (yych <= '/') goto yy55;
				goto yy337;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy246;
			} else {
				if (yych == 'h') goto yy246;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy243;
				if (yych <= 'q') goto yy55;
				goto yy244;
			} else {
				if (yych <= 's') goto yy241;
				if (yych <= 't') goto yy245;
				goto yy55;
			}
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy248;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy246;
				if (yych <= 0x1F) goto yy55;
				goto yy246;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy246;
				goto yy55;
			} else {
				if (yych <= '.') goto yy246;
				if (yych <= '/') goto yy55;
				goto yy337;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy246;
			} else {
				if (yych == 'h') goto yy246;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy243;
				if (yych <= 'q') goto yy55;
				goto yy244;
			} else {
				if (yych <= 's') goto yy241;
				if (yych <= 't') goto yy245;
				goto yy55;
			}
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy248;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy246;
				if (yych <= 0x1F) goto yy55;
				goto yy246;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy246;
				goto yy55;
			} else {
				if (yych <= '.') goto yy246;
				if (yych <= '/') goto yy55;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy240;
				if (yych <= 'c') goto yy55;
				goto yy246;
			} else {
				if (yych == 'h') goto yy246;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy243;
				if (yych <= 'q') goto yy55;
				goto yy244;
			} else {
				if (yych <= 's') goto yy241;
				if (yych <= 't') goto yy245;
				goto yy55;
			}
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy248;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy246;
				if (yych <= 0x1F) goto yy55;
				goto yy246;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy55;
				if (yych <= ',') goto yy246;
			} else {
				if (yych <= '.') goto yy246;
				if (yych <= '/') goto yy55;
				goto yy330;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy246;
			} else {
				if (yych == 'h') goto yy246;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy243;
				if (yych <= 'q') goto yy55;
				goto yy244;
			} else {
				if (yych <= 's') goto yy241;
				if (yych <= 't') goto yy245;
				goto yy55;
			}
		}
	}
	YYDEBUG(338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(339, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy340;
	if (yych <= '9') goto yy341;
yy340:
	YYDEBUG(340, *YYCURSOR);
#line 1571 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 6108 "<stdout>"
yy341:
	YYDEBUG(341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy340;
	if (yych >= ':') goto yy340;
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy340;
	if (yych >= ':') goto yy340;
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy340;
yy344:
	YYDEBUG(344, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy227;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'c') goto yy345;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'E') goto yy235;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'e') goto yy347;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy183;
	}
	if (yych <= '/') goto yy230;
	if (yych <= '0') goto yy334;
	if (yych <= '2') goto yy335;
	if (yych <= '3') goto yy336;
	goto yy230;
yy347:
	YYDEBUG(347, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy236;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'm') goto yy348;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy237;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'b') goto yy349;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy238;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'e') goto yy350;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy239;
	if (yych != 'r') goto yy189;
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy228;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych <= ',') goto yy228;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy182;
			goto yy230;
		} else {
			if (yych == '_') goto yy182;
			goto yy228;
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy183;
	}
	goto yy230;
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy176;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 't') goto yy354;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych != 'O') goto yy177;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'o') goto yy355;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy178;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'b') goto yy356;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy179;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'e') goto yy357;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy239;
		if (yych == 'r') goto yy239;
		goto yy3;
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy354;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 't') goto yy359;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'O') goto yy355;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'o') goto yy360;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy356;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'b') goto yy361;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy357;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'e') goto yy362;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy239;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'r') goto yy351;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy176;
			goto yy371;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'g') goto yy371;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy176;
			goto yy368;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'r') goto yy368;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy176;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'o') goto yy366;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy174;
	} else {
		if (yych <= 'Z') goto yy177;
		if (yych <= '`') goto yy367;
		if (yych <= 'z') goto yy177;
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
#line 1629 "parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 6710 "<stdout>"
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych != 'I') goto yy177;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'i') goto yy369;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy178;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'l') goto yy370;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy228;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych == ')') goto yy174;
			goto yy228;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy228;
			if (yych <= '9') goto yy230;
			goto yy228;
		} else {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy228;
			if (yych <= 'z') goto yy179;
			goto yy228;
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych != 'U') goto yy177;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'u') goto yy372;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy178;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 's') goto yy373;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy179;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 't') goto yy374;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy228;
			goto yy230;
		} else {
			if (yych == ' ') goto yy230;
			goto yy228;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy174;
			if (yych <= ',') goto yy228;
			goto yy230;
		} else {
			if (yych <= '/') goto yy228;
			if (yych <= '9') goto yy230;
			goto yy228;
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy371;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'g') goto yy382;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy368;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'r') goto yy379;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy366;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'o') goto yy378;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy367;
		} else {
			if (yych == '.') goto yy367;
			goto yy182;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy367;
			if (yych <= 'Z') goto yy177;
			goto yy367;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy367;
			if (yych <= 'z') goto yy185;
			goto yy367;
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'I') goto yy369;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'i') goto yy380;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy370;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'l') goto yy381;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy228;
			goto yy230;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy228;
				goto yy174;
			} else {
				if (yych <= ',') goto yy228;
				if (yych <= '-') goto yy352;
				goto yy230;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy182;
			if (yych <= '9') goto yy230;
			if (yych <= '@') goto yy228;
			goto yy179;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy228;
				goto yy182;
			} else {
				if (yych <= '`') goto yy228;
				if (yych <= 'z') goto yy187;
				goto yy228;
			}
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'U') goto yy372;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'u') goto yy383;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy373;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 's') goto yy384;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy374;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 't') goto yy385;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy228;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych == ')') goto yy174;
			goto yy228;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy352;
			if (yych <= '.') goto yy230;
			goto yy182;
		} else {
			if (yych <= '9') goto yy230;
			if (yych == '_') goto yy182;
			goto yy228;
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == 'L') goto yy393;
			if (yych <= 'M') goto yy176;
			goto yy392;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy176;
			goto yy393;
		} else {
			if (yych == 'n') goto yy392;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy176;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'n') goto yy388;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych != 'U') goto yy177;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'u') goto yy389;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy178;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy390;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy179;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'r') goto yy391;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy239;
		if (yych == 'y') goto yy239;
		goto yy3;
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych == 'E') goto yy394;
				goto yy177;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'e') goto yy394;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych != 'Y') goto yy177;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy394;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy228;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych == ')') goto yy174;
			goto yy228;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy228;
			if (yych <= '9') goto yy230;
			goto yy228;
		} else {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy228;
			if (yych <= 'z') goto yy178;
			goto yy228;
		}
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych == '-') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy182;
				goto yy3;
			} else {
				if (yych == 'L') goto yy393;
				goto yy176;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy392;
				goto yy176;
			} else {
				if (yych == '_') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy402;
				goto yy181;
			} else {
				if (yych <= 'n') goto yy401;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy388;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'n') goto yy397;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'U') goto yy389;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'u') goto yy398;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy390;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy399;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy391;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'r') goto yy400;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy239;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'y') goto yy351;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'E') goto yy394;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'e') goto yy403;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'Y') goto yy394;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'y') goto yy403;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy228;
			goto yy230;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy228;
				goto yy174;
			} else {
				if (yych <= ',') goto yy228;
				if (yych <= '-') goto yy352;
				goto yy230;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy182;
			if (yych <= '9') goto yy230;
			if (yych <= '@') goto yy228;
			goto yy178;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy228;
				goto yy182;
			} else {
				if (yych <= '`') goto yy228;
				if (yych <= 'z') goto yy186;
				goto yy228;
			}
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy3;
			goto yy230;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy230;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy230;
			if (yych <= '@') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy176;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych == ')') goto yy174;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy230;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy3;
			goto yy230;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy230;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy230;
			if (yych <= '@') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy176;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy3;
			goto yy230;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy230;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy230;
			if (yych <= '@') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy177;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
	YYDEBUG(408, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych == ')') goto yy174;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy230;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych == ')') goto yy174;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy230;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy3;
			goto yy230;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy230;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy230;
			if (yych <= '@') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy405;
				goto yy176;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy431;
				} else {
					if (yych <= ':') goto yy197;
					if (yych <= 'C') goto yy3;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy3;
					goto yy59;
				} else {
					if (yych == 'H') goto yy59;
					goto yy3;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy3;
					goto yy59;
				} else {
					if (yych == ' ') goto yy59;
					goto yy3;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy431;
					goto yy416;
				} else {
					if (yych <= '9') goto yy417;
					if (yych <= ':') goto yy197;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy59;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy416;
				} else {
					if (yych <= '9') goto yy417;
					if (yych <= ':') goto yy197;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy59;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 24) YYFILL(24);
	yych = *YYCURSOR;
	YYDEBUG(415, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy56;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy414;
		goto yy55;
	} else {
		if (yych <= '-') goto yy414;
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy54;
		goto yy55;
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy430;
				} else {
					if (yych == 'D') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy59;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy59;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy419:
	YYDEBUG(419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy420;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy73;
	goto yy59;
yy420:
	YYDEBUG(420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy421;
	if (yych <= '1') goto yy422;
	goto yy55;
yy421:
	YYDEBUG(421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy423;
	goto yy55;
yy422:
	YYDEBUG(422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '3') goto yy55;
yy423:
	YYDEBUG(423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy55;
	YYDEBUG(424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy425;
	if (yych <= '2') goto yy426;
	if (yych <= '3') goto yy427;
	goto yy55;
yy425:
	YYDEBUG(425, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy428;
	goto yy55;
yy426:
	YYDEBUG(426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy428;
	goto yy55;
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '2') goto yy55;
yy428:
	YYDEBUG(428, *YYCURSOR);
	++YYCURSOR;
yy429:
	YYDEBUG(429, *YYCURSOR);
#line 1332 "parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 8504 "<stdout>"
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy419;
				} else {
					if (yych == 'D') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy59;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy430;
					if (yych <= ':') goto yy197;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy59;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy59;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '-') {
					if (yych <= ',') goto yy3;
					goto yy420;
				} else {
					if (yych <= '/') goto yy3;
					if (yych <= '9') goto yy73;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy59;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy434:
	YYDEBUG(434, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy436;
	if (yych <= '0') goto yy710;
	if (yych <= '1') goto yy711;
	if (yych <= '9') goto yy712;
	goto yy436;
yy435:
	YYDEBUG(435, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy436:
	YYDEBUG(436, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy435;
					goto yy55;
				} else {
					if (yych <= ' ') goto yy435;
					if (yych <= ',') goto yy55;
					goto yy551;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy454;
					goto yy55;
				} else {
					if (yych <= 'D') goto yy440;
					if (yych == 'F') goto yy441;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy64;
					if (yych <= 'I') goto yy449;
					goto yy453;
				} else {
					if (yych <= 'L') goto yy55;
					if (yych <= 'M') goto yy437;
					if (yych <= 'N') goto yy456;
					goto yy455;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy458;
					if (yych <= 'R') goto yy55;
					goto yy438;
				} else {
					if (yych <= 'T') goto yy69;
					if (yych <= 'U') goto yy62;
					if (yych <= 'V') goto yy451;
					goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy452;
					if (yych <= 'Y') goto yy67;
					goto yy55;
				} else {
					if (yych <= 'a') goto yy454;
					if (yych == 'd') goto yy440;
					goto yy55;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy441;
					if (yych <= 'g') goto yy55;
					goto yy64;
				} else {
					if (yych == 'j') goto yy453;
					if (yych <= 'l') goto yy55;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy456;
					if (yych <= 'o') goto yy455;
					goto yy458;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy438;
					if (yych <= 't') goto yy69;
					goto yy62;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy68;
					goto yy55;
				} else {
					if (yych <= 'y') goto yy67;
					if (yych == 0xC2) goto yy61;
					goto yy55;
				}
			}
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy566;
			if (yych <= 'H') goto yy55;
			goto yy148;
		} else {
			if (yych == 'O') goto yy147;
			if (yych <= 'R') goto yy55;
			goto yy149;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy566;
			if (yych <= 'h') goto yy55;
			goto yy148;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy55;
				goto yy147;
			} else {
				if (yych == 's') goto yy149;
				goto yy55;
			}
		}
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy129;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy1023;
			if (yych <= 'T') goto yy55;
			goto yy128;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy129;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy1023;
			if (yych == 'u') goto yy128;
			goto yy55;
		}
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy129;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy1023;
			if (yych == 'U') goto yy128;
			goto yy55;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy129;
			if (yych <= 'd') goto yy55;
			goto yy1023;
		} else {
			if (yych <= 's') goto yy55;
			if (yych <= 't') goto yy703;
			if (yych <= 'u') goto yy128;
			goto yy55;
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy125;
		if (yych <= 'D') goto yy55;
		goto yy553;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy125;
		} else {
			if (yych == 'e') goto yy553;
			goto yy55;
		}
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy569;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy110;
			if (yych <= 'Q') goto yy55;
			goto yy109;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy569;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy110;
			if (yych == 'r') goto yy109;
			goto yy55;
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy81;
		if (yych <= 'T') goto yy55;
		goto yy82;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy1022;
		} else {
			if (yych == 'u') goto yy82;
			goto yy55;
		}
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy716;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy715;
	goto yy59;
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy504;
		goto yy55;
	} else {
		if (yych <= 'd') goto yy703;
		if (yych == 'o') goto yy504;
		goto yy55;
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy703;
	goto yy55;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy640;
	case '3':	goto yy642;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy643;
	case 'A':
	case 'a':	goto yy647;
	case 'D':
	case 'd':	goto yy651;
	case 'F':
	case 'f':	goto yy645;
	case 'J':
	case 'j':	goto yy644;
	case 'M':
	case 'm':	goto yy646;
	case 'N':
	case 'n':	goto yy650;
	case 'O':
	case 'o':	goto yy649;
	case 'S':
	case 's':	goto yy648;
	default:	goto yy55;
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy590;
	case '1':	goto yy591;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy592;
	case 'A':
	case 'a':	goto yy596;
	case 'D':
	case 'd':	goto yy600;
	case 'F':
	case 'f':	goto yy594;
	case 'J':
	case 'j':	goto yy593;
	case 'M':
	case 'm':	goto yy595;
	case 'N':
	case 'n':	goto yy599;
	case 'O':
	case 'o':	goto yy598;
	case 'S':
	case 's':	goto yy597;
	default:	goto yy552;
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy552;
		if (yych <= '0') goto yy542;
		goto yy543;
	} else {
		if (yych <= '5') goto yy544;
		if (yych <= '9') goto yy545;
		goto yy552;
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '.') goto yy506;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy508;
			if (yych == 'I') goto yy541;
		} else {
			if (yych == 'W') goto yy450;
			if (yych <= 'X') goto yy514;
		}
	}
yy450:
	YYDEBUG(450, *YYCURSOR);
#line 1469 "parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 9167 "<stdout>"
yy451:
	YYDEBUG(451, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy450;
			goto yy506;
		} else {
			if (yych == ' ') goto yy506;
			goto yy450;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy506;
			if (yych <= '/') goto yy450;
			goto yy508;
		} else {
			if (yych == 'I') goto yy539;
			goto yy450;
		}
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy450;
			goto yy506;
		} else {
			if (yych == ' ') goto yy506;
			goto yy450;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy506;
			if (yych <= '/') goto yy450;
			goto yy508;
		} else {
			if (yych == 'I') goto yy538;
			goto yy450;
		}
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy531;
		if (yych <= 'T') goto yy55;
		goto yy530;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy531;
		} else {
			if (yych == 'u') goto yy530;
			goto yy55;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy459;
			goto yy55;
		} else {
			if (yych <= 'M') goto yy460;
			if (yych == 'P') goto yy524;
			goto yy55;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy523;
			if (yych == 'm') goto yy460;
			goto yy55;
		} else {
			if (yych <= 'p') goto yy524;
			if (yych == 'u') goto yy523;
			goto yy55;
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy518;
	if (yych == 'c') goto yy518;
	goto yy55;
yy456:
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy504;
	if (yych == 'o') goto yy504;
	goto yy55;
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy464;
	if (yych <= '9') goto yy466;
	goto yy55;
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy460;
		if (yych == 'm') goto yy460;
		goto yy55;
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy460;
	if (yych != 'm') goto yy55;
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy462;
		if (yych == '\t') goto yy462;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy462;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy462;
		if (yych <= 0x08) goto yy55;
	} else {
		if (yych != ' ') goto yy55;
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(463, *YYCURSOR);
#line 1187 "parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 9324 "<stdout>"
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy467;
	} else {
		if (yych <= '9') goto yy481;
		if (yych <= ':') goto yy467;
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
#line 1224 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 9362 "<stdout>"
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy467;
	if (yych != ':') goto yy465;
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy468;
	if (yych <= '6') goto yy469;
	if (yych <= '9') goto yy470;
	goto yy55;
yy468:
	YYDEBUG(468, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych <= '/') goto yy465;
	if (yych <= '9') goto yy474;
	goto yy465;
yy469:
	YYDEBUG(469, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych == '0') goto yy474;
	goto yy465;
yy470:
	YYDEBUG(470, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy465;
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy472;
	}
	goto yy55;
yy472:
	YYDEBUG(472, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(473, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy472;
	}
	goto yy465;
yy474:
	YYDEBUG(474, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy465;
		} else {
			if (yych <= ' ') goto yy475;
			if (yych == '.') goto yy471;
			goto yy465;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy477;
			if (yych == 'P') goto yy477;
			goto yy465;
		} else {
			if (yych <= 'a') goto yy477;
			if (yych == 'p') goto yy477;
			goto yy465;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(476, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy475;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy475;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy477;
			if (yych != 'p') goto yy55;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy479;
		if (yych == 'm') goto yy479;
		goto yy55;
	}
	YYDEBUG(478, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy479;
	if (yych != 'm') goto yy55;
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy462;
		if (yych == '\t') goto yy462;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy462;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy462;
		if (yych <= 0x08) goto yy55;
		goto yy462;
	} else {
		if (yych == ' ') goto yy462;
		goto yy55;
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy482;
			if (yych <= 0x1F) goto yy465;
		} else {
			if (yych == '.') goto yy467;
			if (yych <= '9') goto yy465;
			goto yy485;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy484;
			if (yych <= 'O') goto yy465;
			goto yy484;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy465;
				goto yy484;
			} else {
				if (yych == 'p') goto yy484;
				goto yy465;
			}
		}
	}
yy482:
	YYDEBUG(482, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(483, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy482;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy482;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy484;
			if (yych != 'p') goto yy55;
		}
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy501;
		goto yy55;
	} else {
		if (yych <= 'M') goto yy502;
		if (yych == 'm') goto yy502;
		goto yy55;
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy486;
	if (yych <= '6') goto yy487;
	if (yych <= '9') goto yy470;
	goto yy55;
yy486:
	YYDEBUG(486, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych <= '/') goto yy465;
	if (yych <= '9') goto yy488;
	goto yy465;
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych != '0') goto yy465;
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy475;
			if (yych <= 0x1F) goto yy465;
			goto yy475;
		} else {
			if (yych == '.') goto yy489;
			if (yych <= '9') goto yy465;
			goto yy490;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy477;
			if (yych <= 'O') goto yy465;
			goto yy477;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy465;
				goto yy477;
			} else {
				if (yych == 'p') goto yy477;
				goto yy465;
			}
		}
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy499;
	goto yy55;
yy490:
	YYDEBUG(490, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy491:
	YYDEBUG(491, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(492, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy55;
			goto yy491;
		} else {
			if (yych != 'A') goto yy55;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy493;
			if (yych <= '`') goto yy55;
		} else {
			if (yych != 'p') goto yy55;
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy495;
		if (yych == 'm') goto yy495;
		goto yy55;
	}
	YYDEBUG(494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy495;
	if (yych != 'm') goto yy55;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy497;
		if (yych == '\t') goto yy497;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy497;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy497;
		if (yych <= 0x08) goto yy55;
	} else {
		if (yych != ' ') goto yy55;
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(498, *YYCURSOR);
#line 1204 "parse_date.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 9694 "<stdout>"
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(500, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy465;
			goto yy499;
		} else {
			if (yych == 'A') goto yy493;
			goto yy465;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy493;
			if (yych <= '`') goto yy465;
			goto yy493;
		} else {
			if (yych == 'p') goto yy493;
			goto yy465;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy502;
	if (yych != 'm') goto yy55;
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy462;
		if (yych == '\t') goto yy462;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy462;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy462;
		if (yych <= 0x08) goto yy55;
		goto yy462;
	} else {
		if (yych == ' ') goto yy462;
		goto yy55;
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy505;
	if (yych != 'v') goto yy55;
yy505:
	YYDEBUG(505, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'E') goto yy510;
			if (yych == 'e') goto yy510;
			goto yy450;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy507:
	YYDEBUG(507, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy506;
		if (yych <= 0x1F) goto yy55;
		goto yy506;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy55;
			goto yy506;
		} else {
			if (yych <= '/') goto yy55;
			if (yych >= ':') goto yy55;
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy509;
	if (yych <= '9') goto yy515;
yy509:
	YYDEBUG(509, *YYCURSOR);
#line 1386 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 9814 "<stdout>"
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy511;
	if (yych != 'm') goto yy55;
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy512;
	if (yych != 'b') goto yy55;
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy513;
	if (yych != 'e') goto yy55;
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy514;
	if (yych != 'r') goto yy55;
yy514:
	YYDEBUG(514, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy506;
		if (yych <= 0x1F) goto yy450;
		goto yy506;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy450;
			goto yy506;
		} else {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy509;
	if (yych >= ':') goto yy509;
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy509;
	if (yych >= ':') goto yy509;
	YYDEBUG(517, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy509;
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy519;
	if (yych != 't') goto yy55;
yy519:
	YYDEBUG(519, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'O') goto yy520;
			if (yych != 'o') goto yy450;
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy521;
	if (yych != 'b') goto yy55;
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy522;
	if (yych != 'e') goto yy55;
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy514;
	if (yych == 'r') goto yy514;
	goto yy55;
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy527;
	if (yych == 'g') goto yy527;
	goto yy55;
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy525;
	if (yych != 'r') goto yy55;
yy525:
	YYDEBUG(525, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'I') goto yy526;
			if (yych != 'i') goto yy450;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy514;
	if (yych == 'l') goto yy514;
	goto yy55;
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'U') goto yy528;
			if (yych != 'u') goto yy450;
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy529;
	if (yych != 's') goto yy55;
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy514;
	if (yych == 't') goto yy514;
	goto yy55;
yy530:
	YYDEBUG(530, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy537;
		if (yych <= 'M') goto yy55;
		goto yy536;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy537;
		} else {
			if (yych == 'n') goto yy536;
			goto yy55;
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy532;
	if (yych != 'n') goto yy55;
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'U') goto yy533;
			if (yych != 'u') goto yy450;
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy534;
	if (yych != 'a') goto yy55;
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy535;
	if (yych != 'r') goto yy55;
yy535:
	YYDEBUG(535, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy514;
	if (yych == 'y') goto yy514;
	goto yy55;
yy536:
	YYDEBUG(536, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'E') goto yy514;
			if (yych == 'e') goto yy514;
			goto yy450;
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'Y') goto yy514;
			if (yych == 'y') goto yy514;
			goto yy450;
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy450;
			goto yy506;
		} else {
			if (yych == ' ') goto yy506;
			goto yy450;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy506;
			if (yych <= '/') goto yy450;
			goto yy508;
		} else {
			if (yych == 'I') goto yy514;
			goto yy450;
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy450;
			goto yy506;
		} else {
			if (yych == ' ') goto yy506;
			goto yy450;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy506;
			if (yych <= '/') goto yy450;
			goto yy508;
		} else {
			if (yych != 'I') goto yy450;
		}
	}
	YYDEBUG(540, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy450;
			goto yy506;
		} else {
			if (yych == ' ') goto yy506;
			goto yy450;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy506;
			if (yych <= '/') goto yy450;
			goto yy508;
		} else {
			if (yych == 'I') goto yy514;
			goto yy450;
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy450;
			goto yy506;
		} else {
			if (yych == ' ') goto yy506;
			goto yy450;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy506;
			if (yych <= '/') goto yy450;
			goto yy508;
		} else {
			if (yych == 'I') goto yy514;
			goto yy450;
		}
	}
yy542:
	YYDEBUG(542, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy465;
		if (yych <= '-') goto yy576;
		goto yy575;
	} else {
		if (yych <= '/') goto yy465;
		if (yych <= '9') goto yy589;
		if (yych <= ':') goto yy467;
		goto yy465;
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy465;
		if (yych <= '-') goto yy576;
		if (yych <= '.') goto yy575;
		goto yy465;
	} else {
		if (yych <= '2') goto yy589;
		if (yych <= '9') goto yy588;
		if (yych <= ':') goto yy467;
		goto yy465;
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy465;
		if (yych <= '-') goto yy576;
		goto yy575;
	} else {
		if (yych <= '/') goto yy465;
		if (yych <= '9') goto yy588;
		if (yych <= ':') goto yy467;
		goto yy465;
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy465;
		if (yych <= '-') goto yy576;
		goto yy575;
	} else {
		if (yych == ':') goto yy467;
		goto yy465;
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy569;
	if (yych == 'e') goto yy569;
	goto yy55;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy566;
	if (yych == 'a') goto yy566;
	goto yy55;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy524;
		if (yych <= 'T') goto yy55;
		goto yy523;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy524;
		} else {
			if (yych == 'u') goto yy523;
			goto yy55;
		}
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy559;
	if (yych == 'e') goto yy559;
	goto yy55;
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy553;
	if (yych == 'e') goto yy553;
	goto yy55;
yy551:
	YYDEBUG(551, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy552:
	YYDEBUG(552, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy551;
	case 'A':
	case 'a':	goto yy548;
	case 'D':
	case 'd':	goto yy550;
	case 'F':
	case 'f':	goto yy546;
	case 'I':	goto yy449;
	case 'J':
	case 'j':	goto yy453;
	case 'M':
	case 'm':	goto yy547;
	case 'N':
	case 'n':	goto yy456;
	case 'O':
	case 'o':	goto yy455;
	case 'S':
	case 's':	goto yy549;
	case 'V':	goto yy451;
	case 'X':	goto yy452;
	default:	goto yy55;
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy554;
	if (yych != 'c') goto yy55;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'E') goto yy555;
			if (yych != 'e') goto yy450;
		}
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy556;
	if (yych != 'm') goto yy55;
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy557;
	if (yych != 'b') goto yy55;
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy558;
	if (yych != 'e') goto yy55;
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy514;
	if (yych == 'r') goto yy514;
	goto yy55;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy560;
	if (yych != 'p') goto yy55;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'T') goto yy561;
			if (yych != 't') goto yy450;
		}
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'E') goto yy562;
			if (yych != 'e') goto yy450;
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy563;
	if (yych != 'm') goto yy55;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy564;
	if (yych != 'b') goto yy55;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy565;
	if (yych != 'e') goto yy55;
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy514;
	if (yych == 'r') goto yy514;
	goto yy55;
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy567;
		if (yych <= 'X') goto yy55;
		goto yy514;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
		} else {
			if (yych == 'y') goto yy514;
			goto yy55;
		}
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'C') goto yy568;
			if (yych != 'c') goto yy450;
		}
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy514;
	if (yych == 'h') goto yy514;
	goto yy55;
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy570;
	if (yych != 'b') goto yy55;
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			goto yy506;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'R') goto yy571;
			if (yych != 'r') goto yy450;
		}
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy572;
	if (yych != 'u') goto yy55;
yy572:
	YYDEBUG(572, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy573;
	if (yych != 'a') goto yy55;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy574;
	if (yych != 'r') goto yy55;
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy514;
	if (yych == 'y') goto yy514;
	goto yy55;
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy582;
	if (yych <= '6') goto yy583;
	if (yych <= '9') goto yy584;
	goto yy55;
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(580, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(581, *YYCURSOR);
#line 1401 "parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 10561 "<stdout>"
yy582:
	YYDEBUG(582, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych <= '/') goto yy465;
	if (yych <= '9') goto yy587;
	goto yy465;
yy583:
	YYDEBUG(583, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy471;
		goto yy465;
	} else {
		if (yych <= '0') goto yy587;
		if (yych <= '9') goto yy585;
		goto yy465;
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych <= '/') goto yy465;
	if (yych >= ':') goto yy465;
yy585:
	YYDEBUG(585, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy586;
	if (yych <= '9') goto yy579;
yy586:
	YYDEBUG(586, *YYCURSOR);
#line 1413 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 10610 "<stdout>"
yy587:
	YYDEBUG(587, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy475;
			if (yych <= 0x1F) goto yy465;
			goto yy475;
		} else {
			if (yych == '.') goto yy471;
			if (yych <= '/') goto yy465;
			goto yy579;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy477;
			if (yych <= 'O') goto yy465;
			goto yy477;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy465;
				goto yy477;
			} else {
				if (yych == 'p') goto yy477;
				goto yy465;
			}
		}
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy482;
			if (yych <= 0x1F) goto yy465;
			goto yy482;
		} else {
			if (yych == '.') goto yy467;
			if (yych <= '9') goto yy465;
			goto yy467;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy484;
			if (yych <= 'O') goto yy465;
			goto yy484;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy465;
				goto yy484;
			} else {
				if (yych == 'p') goto yy484;
				goto yy465;
			}
		}
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy482;
			if (yych <= 0x1F) goto yy465;
			goto yy482;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy465;
				goto yy576;
			} else {
				if (yych <= '.') goto yy575;
				if (yych <= '9') goto yy465;
				goto yy467;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy484;
			if (yych <= 'O') goto yy465;
			goto yy484;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy465;
				goto yy484;
			} else {
				if (yych == 'p') goto yy484;
				goto yy465;
			}
		}
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy629;
		goto yy576;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy592;
		goto yy55;
	}
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy629;
		goto yy576;
	} else {
		if (yych <= '/') goto yy55;
		if (yych >= '3') goto yy55;
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '-') goto yy629;
	if (yych <= '.') goto yy576;
	goto yy55;
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy625;
		if (yych <= 'T') goto yy55;
		goto yy624;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy625;
		} else {
			if (yych == 'u') goto yy624;
			goto yy55;
		}
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy622;
	if (yych == 'e') goto yy622;
	goto yy55;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy619;
	if (yych == 'a') goto yy619;
	goto yy55;
yy596:
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy616;
		if (yych <= 'T') goto yy55;
		goto yy615;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy616;
		} else {
			if (yych == 'u') goto yy615;
			goto yy55;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy612;
	if (yych == 'e') goto yy612;
	goto yy55;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy610;
	if (yych == 'c') goto yy610;
	goto yy55;
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy608;
	if (yych == 'o') goto yy608;
	goto yy55;
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy601;
	if (yych != 'e') goto yy55;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy602;
	if (yych != 'c') goto yy55;
yy602:
	YYDEBUG(602, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych >= '.') goto yy506;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'E') goto yy555;
			if (yych == 'e') goto yy555;
			goto yy450;
		}
	}
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy507;
	if (yych <= '0') goto yy604;
	if (yych <= '2') goto yy605;
	if (yych <= '3') goto yy606;
	goto yy507;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy509;
	if (yych <= '9') goto yy607;
	goto yy509;
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy509;
	if (yych <= '9') goto yy607;
	goto yy509;
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy509;
	if (yych <= '1') goto yy607;
	if (yych <= '9') goto yy515;
	goto yy509;
yy607:
	YYDEBUG(607, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy509;
	if (yych <= '9') goto yy516;
	goto yy509;
yy608:
	YYDEBUG(608, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy609;
	if (yych != 'v') goto yy55;
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'E') goto yy510;
			if (yych == 'e') goto yy510;
			goto yy450;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy611;
	if (yych != 't') goto yy55;
yy611:
	YYDEBUG(611, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'O') goto yy520;
			if (yych == 'o') goto yy520;
			goto yy450;
		}
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy613;
	if (yych != 'p') goto yy55;
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'T') goto yy614;
			if (yych != 't') goto yy450;
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'E') goto yy562;
			if (yych == 'e') goto yy562;
			goto yy450;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy618;
	if (yych == 'g') goto yy618;
	goto yy55;
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy617;
	if (yych != 'r') goto yy55;
yy617:
	YYDEBUG(617, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'I') goto yy526;
			if (yych == 'i') goto yy526;
			goto yy450;
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'U') goto yy528;
			if (yych == 'u') goto yy528;
			goto yy450;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy620;
		if (yych <= 'X') goto yy55;
		goto yy621;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
		} else {
			if (yych == 'y') goto yy621;
			goto yy55;
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'C') goto yy568;
			if (yych == 'c') goto yy568;
			goto yy450;
		}
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy450;
			goto yy506;
		} else {
			if (yych == ' ') goto yy506;
			goto yy450;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy603;
			goto yy506;
		} else {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy623;
	if (yych != 'b') goto yy55;
yy623:
	YYDEBUG(623, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'R') goto yy571;
			if (yych == 'r') goto yy571;
			goto yy450;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy628;
		if (yych <= 'M') goto yy55;
		goto yy627;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy628;
		} else {
			if (yych == 'n') goto yy627;
			goto yy55;
		}
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy626;
	if (yych != 'n') goto yy55;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'U') goto yy533;
			if (yych == 'u') goto yy533;
			goto yy450;
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'E') goto yy514;
			if (yych == 'e') goto yy514;
			goto yy450;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy450;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych <= ',') goto yy450;
			if (yych <= '-') goto yy603;
			goto yy506;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy450;
			if (yych <= '9') goto yy508;
			goto yy450;
		} else {
			if (yych <= 'Y') goto yy514;
			if (yych == 'y') goto yy514;
			goto yy450;
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy630;
	if (yych <= '3') goto yy632;
	if (yych <= '9') goto yy633;
	goto yy55;
yy630:
	YYDEBUG(630, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '9') goto yy639;
		if (yych >= 'n') goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
		}
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
#line 1372 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 11264 "<stdout>"
yy632:
	YYDEBUG(632, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy631;
			goto yy639;
		} else {
			if (yych <= '9') goto yy578;
			if (yych <= 'm') goto yy631;
			goto yy635;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '9') goto yy578;
		if (yych <= 'm') goto yy631;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy638;
	goto yy55;
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy638;
	goto yy55;
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy638;
	goto yy55;
yy637:
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy55;
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy631;
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '9') goto yy579;
		if (yych <= 'm') goto yy631;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy697;
		} else {
			if (yych <= '9') goto yy643;
			if (yych >= 'n') goto yy694;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
#line 1316 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 11385 "<stdout>"
yy642:
	YYDEBUG(642, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy641;
			goto yy697;
		} else {
			if (yych <= '1') goto yy643;
			if (yych <= 'm') goto yy641;
			goto yy694;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy641;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy641;
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy697;
		if (yych <= 'm') goto yy641;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy641;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy641;
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy692;
		if (yych <= 'T') goto yy55;
		goto yy691;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy692;
		} else {
			if (yych == 'u') goto yy691;
			goto yy55;
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy690;
	if (yych == 'e') goto yy690;
	goto yy55;
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy689;
	if (yych == 'a') goto yy689;
	goto yy55;
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy688;
		if (yych <= 'T') goto yy55;
		goto yy687;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy688;
		} else {
			if (yych == 'u') goto yy687;
			goto yy55;
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy685;
	if (yych == 'e') goto yy685;
	goto yy55;
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy684;
	if (yych == 'c') goto yy684;
	goto yy55;
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy683;
	if (yych == 'o') goto yy683;
	goto yy55;
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy652;
	if (yych != 'e') goto yy55;
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy653;
	if (yych != 'c') goto yy55;
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy55;
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy660;
	if (yych <= '2') goto yy661;
	goto yy55;
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy662;
	goto yy55;
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '5') goto yy55;
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '6') goto yy55;
	YYDEBUG(664, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy667;
	if (yych <= '6') goto yy668;
	goto yy55;
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy669;
	goto yy55;
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy55;
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy670;
	if (yych != ' ') goto yy55;
yy670:
	YYDEBUG(670, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(671, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy55;
			goto yy670;
		} else {
			if (yych == ' ') goto yy670;
			goto yy55;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy55;
			goto yy673;
		} else {
			if (yych != 'G') goto yy55;
		}
	}
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy681;
	goto yy55;
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy674;
	if (yych <= '2') goto yy676;
	if (yych <= '9') goto yy677;
	goto yy55;
yy674:
	YYDEBUG(674, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy675;
	if (yych <= '9') goto yy677;
	if (yych <= ':') goto yy678;
yy675:
	YYDEBUG(675, *YYCURSOR);
#line 1599 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 11638 "<stdout>"
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy675;
		if (yych >= '5') goto yy679;
	} else {
		if (yych <= '9') goto yy680;
		if (yych <= ':') goto yy678;
		goto yy675;
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy675;
	if (yych <= '5') goto yy679;
	if (yych <= '9') goto yy680;
	if (yych >= ';') goto yy675;
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy675;
	if (yych <= '5') goto yy679;
	if (yych <= '9') goto yy680;
	goto yy675;
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy675;
	if (yych >= ':') goto yy675;
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy675;
yy681:
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy55;
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy673;
	if (yych == '-') goto yy673;
	goto yy55;
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy653;
	if (yych == 'v') goto yy653;
	goto yy55;
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy653;
	if (yych == 't') goto yy653;
	goto yy55;
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy686;
	if (yych != 'p') goto yy55;
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy654;
		goto yy55;
	} else {
		if (yych <= 'T') goto yy653;
		if (yych == 't') goto yy653;
		goto yy55;
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy653;
	if (yych == 'g') goto yy653;
	goto yy55;
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy653;
	if (yych == 'r') goto yy653;
	goto yy55;
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy653;
		if (yych <= 'X') goto yy55;
		goto yy653;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
			goto yy653;
		} else {
			if (yych == 'y') goto yy653;
			goto yy55;
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy653;
	if (yych == 'b') goto yy653;
	goto yy55;
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy653;
		if (yych <= 'M') goto yy55;
		goto yy653;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy653;
		} else {
			if (yych == 'n') goto yy653;
			goto yy55;
		}
	}
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy653;
	if (yych == 'n') goto yy653;
	goto yy55;
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy702;
	goto yy55;
yy694:
	YYDEBUG(694, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy702;
	goto yy55;
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy702;
	goto yy55;
yy696:
	YYDEBUG(696, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy702;
	goto yy55;
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy641;
	if (yych >= ':') goto yy641;
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy641;
	if (yych >= ':') goto yy641;
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy641;
	if (yych >= ':') goto yy641;
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy641;
yy702:
	YYDEBUG(702, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy697;
	goto yy641;
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy705;
		goto yy552;
	} else {
		if (yych <= '-') goto yy706;
		if (yych <= '.') goto yy705;
		if (yych >= '0') goto yy552;
	}
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy647;
	case 'D':
	case 'd':	goto yy651;
	case 'F':
	case 'f':	goto yy645;
	case 'J':
	case 'j':	goto yy644;
	case 'M':
	case 'm':	goto yy646;
	case 'N':
	case 'n':	goto yy650;
	case 'O':
	case 'o':	goto yy649;
	case 'S':
	case 's':	goto yy648;
	default:	goto yy55;
	}
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy552;
	if (yych <= '0') goto yy710;
	if (yych <= '1') goto yy711;
	if (yych <= '9') goto yy712;
	goto yy552;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy552;
	if (yych <= '0') goto yy707;
	if (yych <= '1') goto yy708;
	if (yych <= '9') goto yy709;
	goto yy552;
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '.') goto yy576;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy709;
	goto yy55;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '.') goto yy576;
	if (yych <= '/') goto yy55;
	if (yych >= '3') goto yy55;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '.') goto yy576;
	goto yy55;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy576;
		goto yy713;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy712;
		goto yy55;
	}
yy711:
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy576;
		goto yy713;
	} else {
		if (yych <= '/') goto yy55;
		if (yych >= '3') goto yy55;
	}
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '-') goto yy576;
	if (yych >= '/') goto yy55;
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy585;
	goto yy55;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy759;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy757;
	goto yy59;
yy716:
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy725;
	case '1':	goto yy726;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy727;
	case 'A':
	case 'a':	goto yy720;
	case 'D':
	case 'd':	goto yy724;
	case 'F':
	case 'f':	goto yy718;
	case 'J':
	case 'j':	goto yy717;
	case 'M':
	case 'm':	goto yy719;
	case 'N':
	case 'n':	goto yy723;
	case 'O':
	case 'o':	goto yy722;
	case 'S':
	case 's':	goto yy721;
	default:	goto yy55;
	}
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy756;
		if (yych <= 'T') goto yy55;
		goto yy755;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy756;
		} else {
			if (yych == 'u') goto yy755;
			goto yy55;
		}
	}
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy754;
	if (yych == 'e') goto yy754;
	goto yy55;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy753;
	if (yych == 'a') goto yy753;
	goto yy55;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy752;
		if (yych <= 'T') goto yy55;
		goto yy751;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy752;
		} else {
			if (yych == 'u') goto yy751;
			goto yy55;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy749;
	if (yych == 'e') goto yy749;
	goto yy55;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy748;
	if (yych == 'c') goto yy748;
	goto yy55;
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy747;
	if (yych == 'o') goto yy747;
	goto yy55;
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy739;
	if (yych == 'e') goto yy739;
	goto yy55;
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy728;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy732;
	goto yy55;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy728;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy732;
	goto yy55;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy55;
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy729;
	if (yych <= '3') goto yy730;
	if (yych <= '9') goto yy731;
	goto yy55;
yy729:
	YYDEBUG(729, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '9') goto yy731;
		if (yych <= 'm') goto yy631;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '1') goto yy731;
		if (yych <= 'm') goto yy631;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy731:
	YYDEBUG(731, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy635;
		goto yy631;
	} else {
		if (yych <= 'r') goto yy636;
		if (yych <= 's') goto yy634;
		if (yych <= 't') goto yy637;
		goto yy631;
	}
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy55;
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy55;
		if (yych >= '1') goto yy735;
	} else {
		if (yych <= '3') goto yy736;
		if (yych <= '9') goto yy731;
		goto yy55;
	}
	YYDEBUG(734, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '9') goto yy737;
		if (yych <= 'm') goto yy631;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy735:
	YYDEBUG(735, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '9') goto yy737;
		if (yych <= 'm') goto yy631;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '1') goto yy737;
		if (yych <= 'm') goto yy631;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy635;
	} else {
		if (yych <= 'r') goto yy636;
		if (yych <= 's') goto yy634;
		if (yych <= 't') goto yy637;
	}
yy738:
	YYDEBUG(738, *YYCURSOR);
#line 1344 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 12201 "<stdout>"
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy740;
	if (yych != 'c') goto yy55;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy55;
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy742;
	if (yych <= '2') goto yy743;
	if (yych <= '3') goto yy744;
	goto yy55;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy745;
	goto yy55;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy745;
	goto yy55;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '2') goto yy55;
yy745:
	YYDEBUG(745, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(746, *YYCURSOR);
#line 1585 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 12253 "<stdout>"
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy740;
	if (yych == 'v') goto yy740;
	goto yy55;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy740;
	if (yych == 't') goto yy740;
	goto yy55;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy750;
	if (yych != 'p') goto yy55;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy741;
		goto yy55;
	} else {
		if (yych <= 'T') goto yy740;
		if (yych == 't') goto yy740;
		goto yy55;
	}
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy740;
	if (yych == 'g') goto yy740;
	goto yy55;
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy740;
	if (yych == 'r') goto yy740;
	goto yy55;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy740;
		if (yych <= 'X') goto yy55;
		goto yy740;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
			goto yy740;
		} else {
			if (yych == 'y') goto yy740;
			goto yy55;
		}
	}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy740;
	if (yych == 'b') goto yy740;
	goto yy55;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy740;
		if (yych <= 'M') goto yy55;
		goto yy740;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy740;
		} else {
			if (yych == 'n') goto yy740;
			goto yy55;
		}
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy740;
	if (yych == 'n') goto yy740;
	goto yy55;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy765;
				} else {
					if (yych <= ' ') goto yy765;
					if (yych >= '-') goto yy762;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy766;
					if (yych <= '/') goto yy763;
					goto yy779;
				} else {
					if (yych <= '1') goto yy780;
					if (yych <= '2') goto yy782;
					goto yy783;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy73;
					if (yych <= ':') goto yy781;
				} else {
					if (yych <= 'A') goto yy765;
					if (yych >= 'D') goto yy765;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy765;
				} else {
					if (yych <= 'J') goto yy765;
					if (yych >= 'M') goto yy765;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy758;
					if (yych <= 'V') goto yy765;
					goto yy784;
				} else {
					if (yych <= 'Y') goto yy765;
					if (yych >= 'a') goto yy765;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy765;
				} else {
					if (yych != 'g') goto yy765;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy765;
				} else {
					if (yych <= 'o') goto yy765;
					if (yych >= 's') goto yy765;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy765;
				} else {
					if (yych <= 'y') goto yy765;
					if (yych == 0xC2) goto yy765;
				}
			}
		}
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
#line 1620 "parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 12426 "<stdout>"
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy760;
	case '1':	goto yy761;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy727;
	case 'A':
	case 'a':	goto yy720;
	case 'D':
	case 'd':	goto yy724;
	case 'F':
	case 'f':	goto yy718;
	case 'J':
	case 'j':	goto yy717;
	case 'M':
	case 'm':	goto yy719;
	case 'N':
	case 'n':	goto yy723;
	case 'O':
	case 'o':	goto yy722;
	case 'S':
	case 's':	goto yy721;
	default:	goto yy55;
	}
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy728;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy727;
	goto yy55;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy728;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy727;
	goto yy55;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy947;
	case '1':	goto yy949;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy950;
	case 'A':
	case 'a':	goto yy941;
	case 'D':
	case 'd':	goto yy945;
	case 'F':
	case 'f':	goto yy939;
	case 'J':
	case 'j':	goto yy938;
	case 'M':
	case 'm':	goto yy940;
	case 'N':
	case 'n':	goto yy944;
	case 'O':
	case 'o':	goto yy943;
	case 'S':
	case 's':	goto yy942;
	case 'W':	goto yy946;
	default:	goto yy913;
	}
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy921;
	if (yych <= '1') goto yy922;
	if (yych <= '9') goto yy923;
	goto yy55;
yy764:
	YYDEBUG(764, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy765:
	YYDEBUG(765, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy764;
					goto yy55;
				} else {
					if (yych <= ' ') goto yy764;
					if (yych <= ',') goto yy55;
					goto yy912;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy774;
					goto yy55;
				} else {
					if (yych <= 'D') goto yy778;
					if (yych == 'F') goto yy772;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy64;
					if (yych <= 'I') goto yy767;
					goto yy771;
				} else {
					if (yych <= 'L') goto yy55;
					if (yych <= 'M') goto yy773;
					goto yy777;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy776;
					if (yych <= 'R') goto yy55;
					goto yy775;
				} else {
					if (yych <= 'T') goto yy69;
					if (yych <= 'U') goto yy62;
					if (yych <= 'V') goto yy769;
					goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy770;
					if (yych <= 'Y') goto yy67;
					goto yy55;
				} else {
					if (yych <= 'a') goto yy774;
					if (yych <= 'c') goto yy55;
					goto yy778;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy772;
					goto yy55;
				} else {
					if (yych <= 'h') goto yy64;
					if (yych == 'j') goto yy771;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy773;
					if (yych <= 'n') goto yy777;
					goto yy776;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy775;
					if (yych <= 't') goto yy69;
					goto yy62;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy68;
					goto yy55;
				} else {
					if (yych <= 'y') goto yy67;
					if (yych == 0xC2) goto yy61;
					goto yy55;
				}
			}
		}
	}
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy913;
	if (yych <= '0') goto yy905;
	if (yych <= '2') goto yy906;
	if (yych <= '3') goto yy907;
	goto yy913;
yy767:
	YYDEBUG(767, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy904;
	} else {
		if (yych == 'W') goto yy768;
		if (yych <= 'X') goto yy858;
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
#line 1441 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 12644 "<stdout>"
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy902;
	goto yy768;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy901;
	goto yy768;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy894;
		if (yych <= 'T') goto yy55;
		goto yy893;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy894;
		} else {
			if (yych == 'u') goto yy893;
			goto yy55;
		}
	}
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy887;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy110;
			if (yych <= 'Q') goto yy55;
			goto yy109;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy887;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy110;
			if (yych == 'r') goto yy109;
			goto yy55;
		}
	}
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy884;
			if (yych <= 'H') goto yy55;
			goto yy148;
		} else {
			if (yych == 'O') goto yy147;
			if (yych <= 'R') goto yy55;
			goto yy149;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy884;
			if (yych <= 'h') goto yy55;
			goto yy148;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy55;
				goto yy147;
			} else {
				if (yych == 's') goto yy149;
				goto yy55;
			}
		}
	}
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy878;
		if (yych <= 'T') goto yy55;
		goto yy877;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy878;
		} else {
			if (yych == 'u') goto yy877;
			goto yy55;
		}
	}
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy129;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy870;
			if (yych <= 'T') goto yy55;
			goto yy128;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy129;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy870;
			if (yych == 'u') goto yy128;
			goto yy55;
		}
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy865;
	if (yych == 'c') goto yy865;
	goto yy55;
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy859;
	if (yych == 'o') goto yy859;
	goto yy55;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy125;
		if (yych <= 'D') goto yy55;
		goto yy852;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy125;
		} else {
			if (yych == 'e') goto yy852;
			goto yy55;
		}
	}
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy849;
	if (yych <= '9') goto yy850;
	goto yy59;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy818;
	if (yych <= '9') goto yy797;
	goto yy59;
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy798;
	if (yych <= '1') goto yy799;
	goto yy55;
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy797;
	goto yy59;
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy793;
	if (yych <= '6') goto yy794;
	if (yych <= '9') goto yy74;
	goto yy59;
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy55;
		if (yych <= '0') goto yy785;
		if (yych <= '4') goto yy786;
		goto yy787;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy55;
			goto yy94;
		} else {
			if (yych == 'e') goto yy94;
			goto yy55;
		}
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy55;
	if (yych <= '9') goto yy788;
	goto yy55;
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy788;
	goto yy55;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '4') goto yy55;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy790;
	if (yych <= '/') goto yy789;
	if (yych <= '7') goto yy791;
yy789:
	YYDEBUG(789, *YYCURSOR);
#line 1552 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 12883 "<stdout>"
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '8') goto yy55;
yy791:
	YYDEBUG(791, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(792, *YYCURSOR);
#line 1533 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 12911 "<stdout>"
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy795;
	goto yy59;
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '6') goto yy795;
	if (yych <= '9') goto yy75;
	goto yy59;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= '9') {
					if (yych >= '0') goto yy76;
				} else {
					if (yych == 'D') goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy796;
				if (yych <= 'H') goto yy59;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
				} else {
					if (yych != 'V') goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych >= 'd') goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy59;
				} else {
					if (yych == 'h') goto yy59;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
				} else {
					if (yych != 'v') goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
				}
			}
		}
	}
yy796:
	YYDEBUG(796, *YYCURSOR);
#line 1519 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 12996 "<stdout>"
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy795;
	goto yy59;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy800;
	goto yy55;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '3') goto yy55;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy802;
	if (yych <= '2') goto yy803;
	if (yych <= '3') goto yy804;
	goto yy55;
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy805;
	goto yy55;
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy805;
	goto yy55;
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '2') goto yy55;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy55;
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy807;
	if (yych <= '2') goto yy808;
	goto yy55;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy809;
	goto yy55;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '5') goto yy55;
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '6') goto yy55;
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy814;
	if (yych <= '6') goto yy815;
	goto yy55;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy816;
	goto yy55;
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy55;
yy816:
	YYDEBUG(816, *YYCURSOR);
	++YYCURSOR;
yy817:
	YYDEBUG(817, *YYCURSOR);
#line 1493 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->us = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 13124 "<stdout>"
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy59;
		if (yych >= '1') goto yy820;
	} else {
		if (yych <= '3') goto yy821;
		if (yych <= '9') goto yy795;
		goto yy59;
	}
yy819:
	YYDEBUG(819, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy796;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy796;
					goto yy822;
				} else {
					if (yych == 'D') goto yy59;
					goto yy796;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy796;
				if (yych <= 'H') goto yy59;
				goto yy796;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy796;
				} else {
					if (yych == 'V') goto yy796;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy796;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy796;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy796;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy796;
				} else {
					if (yych == 'v') goto yy796;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy796;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy796;
				}
			}
		}
	}
yy820:
	YYDEBUG(820, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy796;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy796;
					goto yy822;
				} else {
					if (yych == 'D') goto yy59;
					goto yy796;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy796;
				if (yych <= 'H') goto yy59;
				goto yy796;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy796;
				} else {
					if (yych == 'V') goto yy796;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy796;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy796;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy796;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy796;
				} else {
					if (yych == 'v') goto yy796;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy796;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy796;
				}
			}
		}
	}
yy821:
	YYDEBUG(821, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy796;
				goto yy59;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy796;
				} else {
					if (yych <= '9') goto yy76;
					if (yych <= 'C') goto yy796;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy796;
					goto yy59;
				} else {
					if (yych == 'H') goto yy59;
					goto yy796;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy796;
				} else {
					if (yych == 'V') goto yy796;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy796;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy796;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy796;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy796;
				} else {
					if (yych == 'v') goto yy796;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy796;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy796;
				}
			}
		}
	}
yy822:
	YYDEBUG(822, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy58;
				} else {
					if (yych == ' ') goto yy58;
				}
			} else {
				if (yych <= 'C') {
					if (yych <= '9') goto yy77;
				} else {
					if (yych <= 'D') goto yy65;
					if (yych >= 'F') goto yy66;
				}
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') {
					if (yych >= 'H') goto yy64;
				} else {
					if (yych == 'M') goto yy60;
				}
			} else {
				if (yych <= 'T') {
					if (yych <= 'S') goto yy63;
					goto yy824;
				} else {
					if (yych <= 'U') goto yy62;
					if (yych >= 'W') goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych >= 'Y') goto yy67;
				} else {
					if (yych == 'd') goto yy65;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy66;
				} else {
					if (yych <= 'h') goto yy64;
					if (yych >= 'm') goto yy60;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych >= 's') goto yy63;
				} else {
					if (yych <= 't') goto yy825;
					if (yych <= 'u') goto yy62;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'w') goto yy68;
					if (yych >= 'y') goto yy67;
				} else {
					if (yych == 0xC2) goto yy61;
				}
			}
		}
	}
yy823:
	YYDEBUG(823, *YYCURSOR);
#line 1481 "parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 13431 "<stdout>"
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy55;
			if (yych <= '1') goto yy839;
			goto yy840;
		} else {
			if (yych <= '9') goto yy841;
			if (yych <= 'G') goto yy55;
			goto yy81;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy82;
			goto yy55;
		} else {
			if (yych <= 'h') goto yy81;
			if (yych == 'u') goto yy82;
			goto yy55;
		}
	}
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy55;
			if (yych >= '2') goto yy827;
		} else {
			if (yych <= '9') goto yy828;
			if (yych <= 'G') goto yy55;
			goto yy81;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy82;
			goto yy55;
		} else {
			if (yych <= 'h') goto yy81;
			if (yych == 'u') goto yy82;
			goto yy55;
		}
	}
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy833;
	if (yych <= '9') goto yy828;
	goto yy55;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy833;
	if (yych <= '5') goto yy829;
	goto yy55;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '6') goto yy55;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy831;
	if (yych <= '6') goto yy832;
	goto yy55;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy816;
	goto yy55;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy816;
	goto yy55;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy834;
	if (yych <= '9') goto yy830;
	goto yy55;
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy835;
	if (yych <= '6') goto yy836;
	if (yych <= '9') goto yy830;
	goto yy55;
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy837;
	if (yych <= '6') goto yy838;
	if (yych <= '9') goto yy816;
	goto yy55;
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy837;
	if (yych <= '5') goto yy831;
	if (yych <= '6') goto yy832;
	goto yy55;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy817;
	if (yych <= '9') goto yy816;
	goto yy817;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy816;
	goto yy817;
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy848;
	if (yych <= '9') goto yy841;
	if (yych <= ':') goto yy842;
	goto yy55;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy55;
		if (yych <= '4') goto yy848;
		goto yy829;
	} else {
		if (yych == ':') goto yy842;
		goto yy55;
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy829;
	if (yych != ':') goto yy55;
yy842:
	YYDEBUG(842, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '6') goto yy55;
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(844, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy846;
	if (yych <= '6') goto yy847;
	goto yy55;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy816;
	goto yy55;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy816;
	goto yy55;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy834;
	if (yych <= '9') goto yy830;
	if (yych <= ':') goto yy842;
	goto yy55;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy59;
		if (yych <= '0') goto yy851;
		goto yy820;
	} else {
		if (yych <= '3') goto yy821;
		if (yych <= '9') goto yy795;
		goto yy59;
	}
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy59;
		if (yych <= '0') goto yy819;
		goto yy820;
	} else {
		if (yych <= '3') goto yy821;
		if (yych <= '9') goto yy795;
		goto yy59;
	}
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy822;
	goto yy59;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy853;
	if (yych != 'c') goto yy55;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy854;
	if (yych != 'e') goto yy768;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy855;
	if (yych != 'm') goto yy55;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy856;
	if (yych != 'b') goto yy55;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy857;
	if (yych != 'e') goto yy55;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy858;
	if (yych != 'r') goto yy55;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy768;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy860;
	if (yych != 'v') goto yy55;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy861;
	if (yych != 'e') goto yy768;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy862;
	if (yych != 'm') goto yy55;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy863;
	if (yych != 'b') goto yy55;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy864;
	if (yych != 'e') goto yy55;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy858;
	if (yych == 'r') goto yy858;
	goto yy55;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy866;
	if (yych != 't') goto yy55;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy867;
	if (yych != 'o') goto yy768;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy868;
	if (yych != 'b') goto yy55;
yy868:
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy869;
	if (yych != 'e') goto yy55;
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy858;
	if (yych == 'r') goto yy858;
	goto yy55;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy131;
		if (yych <= 'O') goto yy55;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy55;
			goto yy131;
		} else {
			if (yych != 'p') goto yy55;
		}
	}
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy872;
	if (yych != 't') goto yy768;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy873;
	if (yych != 'e') goto yy768;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy874;
	if (yych != 'm') goto yy55;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy875;
	if (yych != 'b') goto yy55;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy876;
	if (yych != 'e') goto yy55;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy858;
	if (yych == 'r') goto yy858;
	goto yy55;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy881;
	if (yych == 'g') goto yy881;
	goto yy55;
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy879;
	if (yych != 'r') goto yy55;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy880;
	if (yych != 'i') goto yy768;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy858;
	if (yych == 'l') goto yy858;
	goto yy55;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy882;
	if (yych != 'u') goto yy768;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy883;
	if (yych != 's') goto yy55;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy858;
	if (yych == 't') goto yy858;
	goto yy55;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy885;
		if (yych <= 'X') goto yy55;
		goto yy858;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
		} else {
			if (yych == 'y') goto yy858;
			goto yy55;
		}
	}
yy885:
	YYDEBUG(885, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy886;
	if (yych != 'c') goto yy768;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy858;
	if (yych == 'h') goto yy858;
	goto yy55;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy888;
	if (yych != 'b') goto yy55;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy889;
	if (yych != 'r') goto yy768;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy890;
	if (yych != 'u') goto yy55;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy891;
	if (yych != 'a') goto yy55;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy892;
	if (yych != 'r') goto yy55;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy858;
	if (yych == 'y') goto yy858;
	goto yy55;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy900;
		if (yych <= 'M') goto yy55;
		goto yy899;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy900;
		} else {
			if (yych == 'n') goto yy899;
			goto yy55;
		}
	}
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy895;
	if (yych != 'n') goto yy55;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy896;
	if (yych != 'u') goto yy768;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy897;
	if (yych != 'a') goto yy55;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy898;
	if (yych != 'r') goto yy55;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy858;
	if (yych == 'y') goto yy858;
	goto yy55;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy858;
	if (yych == 'e') goto yy858;
	goto yy768;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy858;
	if (yych == 'y') goto yy858;
	goto yy768;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy858;
	goto yy768;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy768;
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy858;
	goto yy768;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy858;
	goto yy768;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy920;
	if (yych <= '9') goto yy919;
	goto yy55;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy918;
	goto yy55;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy916;
	if (yych <= '6') goto yy915;
	goto yy55;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy887;
	if (yych == 'e') goto yy887;
	goto yy55;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy884;
	if (yych == 'a') goto yy884;
	goto yy55;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy914;
	if (yych == 'e') goto yy914;
	goto yy55;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy852;
	if (yych == 'e') goto yy852;
	goto yy55;
yy912:
	YYDEBUG(912, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy913:
	YYDEBUG(913, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy912;
	case 'A':
	case 'a':	goto yy774;
	case 'D':
	case 'd':	goto yy911;
	case 'F':
	case 'f':	goto yy908;
	case 'I':	goto yy767;
	case 'J':
	case 'j':	goto yy771;
	case 'M':
	case 'm':	goto yy909;
	case 'N':
	case 'n':	goto yy777;
	case 'O':
	case 'o':	goto yy776;
	case 'S':
	case 's':	goto yy910;
	case 'V':	goto yy769;
	case 'X':	goto yy770;
	default:	goto yy55;
	}
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy871;
	if (yych == 'p') goto yy871;
	goto yy55;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '6') goto yy917;
	goto yy55;
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy796;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy917;
	goto yy55;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy917;
	goto yy55;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy55;
	if (yych <= '9') goto yy917;
	goto yy55;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy55;
	if (yych <= '/') goto yy924;
	if (yych <= '9') goto yy932;
	goto yy55;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy55;
	if (yych <= '/') goto yy924;
	if (yych <= '2') goto yy932;
	goto yy55;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy55;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy925;
	if (yych <= '3') goto yy926;
	if (yych <= '9') goto yy927;
	goto yy55;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy429;
		if (yych <= '9') goto yy927;
		if (yych <= 'm') goto yy429;
		goto yy929;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy429;
			goto yy930;
		} else {
			if (yych <= 's') goto yy928;
			if (yych <= 't') goto yy931;
			goto yy429;
		}
	}
yy926:
	YYDEBUG(926, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy429;
		if (yych <= '1') goto yy927;
		if (yych <= 'm') goto yy429;
		goto yy929;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy429;
			goto yy930;
		} else {
			if (yych <= 's') goto yy928;
			if (yych <= 't') goto yy931;
			goto yy429;
		}
	}
yy927:
	YYDEBUG(927, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy929;
		goto yy429;
	} else {
		if (yych <= 'r') goto yy930;
		if (yych <= 's') goto yy928;
		if (yych <= 't') goto yy931;
		goto yy429;
	}
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy428;
	goto yy55;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy428;
	goto yy55;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy428;
	goto yy55;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy428;
	goto yy55;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy55;
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy55;
		if (yych >= '1') goto yy935;
	} else {
		if (yych <= '3') goto yy936;
		if (yych <= '9') goto yy927;
		goto yy55;
	}
	YYDEBUG(934, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy429;
		if (yych <= '9') goto yy937;
		if (yych <= 'm') goto yy429;
		goto yy929;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy429;
			goto yy930;
		} else {
			if (yych <= 's') goto yy928;
			if (yych <= 't') goto yy931;
			goto yy429;
		}
	}
yy935:
	YYDEBUG(935, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy429;
		if (yych <= '9') goto yy937;
		if (yych <= 'm') goto yy429;
		goto yy929;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy429;
			goto yy930;
		} else {
			if (yych <= 's') goto yy928;
			if (yych <= 't') goto yy931;
			goto yy429;
		}
	}
yy936:
	YYDEBUG(936, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy429;
		if (yych <= '1') goto yy937;
		if (yych <= 'm') goto yy429;
		goto yy929;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy429;
			goto yy930;
		} else {
			if (yych <= 's') goto yy928;
			if (yych <= 't') goto yy931;
			goto yy429;
		}
	}
yy937:
	YYDEBUG(937, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy428;
		if (yych <= 'm') goto yy429;
		goto yy929;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy429;
			goto yy930;
		} else {
			if (yych <= 's') goto yy928;
			if (yych <= 't') goto yy931;
			goto yy429;
		}
	}
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1018;
		if (yych <= 'T') goto yy55;
		goto yy1017;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy1018;
		} else {
			if (yych == 'u') goto yy1017;
			goto yy55;
		}
	}
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1015;
	if (yych == 'e') goto yy1015;
	goto yy55;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1012;
	if (yych == 'a') goto yy1012;
	goto yy55;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1009;
		if (yych <= 'T') goto yy55;
		goto yy1008;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy1009;
		} else {
			if (yych == 'u') goto yy1008;
			goto yy55;
		}
	}
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1005;
	if (yych == 'e') goto yy1005;
	goto yy55;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1003;
	if (yych == 'c') goto yy1003;
	goto yy55;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1001;
	if (yych == 'o') goto yy1001;
	goto yy55;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy999;
	if (yych == 'e') goto yy999;
	goto yy55;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy785;
	if (yych <= '4') goto yy786;
	if (yych <= '5') goto yy787;
	goto yy55;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy951;
	if (yych <= '/') goto yy948;
	if (yych <= '9') goto yy970;
yy948:
	YYDEBUG(948, *YYCURSOR);
#line 1358 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 14363 "<stdout>"
yy949:
	YYDEBUG(949, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy951;
	if (yych <= '/') goto yy948;
	if (yych <= '2') goto yy970;
	goto yy948;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy948;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy952;
	if (yych <= '3') goto yy953;
	if (yych <= '9') goto yy954;
	goto yy55;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy631;
			goto yy954;
		} else {
			if (yych == 'T') goto yy959;
			goto yy631;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy956;
			if (yych <= 'q') goto yy631;
			goto yy957;
		} else {
			if (yych <= 's') goto yy955;
			if (yych <= 't') goto yy958;
			goto yy631;
		}
	}
yy953:
	YYDEBUG(953, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy631;
		} else {
			if (yych == 'T') goto yy959;
			goto yy631;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy956;
			if (yych <= 'q') goto yy631;
			goto yy957;
		} else {
			if (yych <= 's') goto yy955;
			if (yych <= 't') goto yy958;
			goto yy631;
		}
	}
yy954:
	YYDEBUG(954, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy959;
		if (yych <= 'm') goto yy631;
		goto yy956;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy957;
		} else {
			if (yych <= 's') goto yy955;
			if (yych <= 't') goto yy958;
			goto yy631;
		}
	}
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy969;
	goto yy55;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy969;
	goto yy55;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy969;
	goto yy55;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy969;
	goto yy55;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy960;
	if (yych <= '2') goto yy961;
	if (yych <= '9') goto yy962;
	goto yy55;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy962;
	if (yych <= ':') goto yy963;
	goto yy55;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy962;
	if (yych == ':') goto yy963;
	goto yy55;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy964;
	if (yych <= '9') goto yy965;
	goto yy55;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy965;
	if (yych <= ':') goto yy966;
	goto yy55;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy967;
	if (yych <= '6') goto yy968;
	if (yych <= '9') goto yy816;
	goto yy55;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy817;
	if (yych <= '9') goto yy816;
	goto yy817;
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy816;
	goto yy817;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy959;
	goto yy631;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy948;
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy55;
		if (yych >= '1') goto yy973;
	} else {
		if (yych <= '3') goto yy974;
		if (yych <= '9') goto yy954;
		goto yy55;
	}
	YYDEBUG(972, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy631;
			goto yy975;
		} else {
			if (yych == 'T') goto yy959;
			goto yy631;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy956;
			if (yych <= 'q') goto yy631;
			goto yy957;
		} else {
			if (yych <= 's') goto yy955;
			if (yych <= 't') goto yy958;
			goto yy631;
		}
	}
yy973:
	YYDEBUG(973, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy631;
			goto yy975;
		} else {
			if (yych == 'T') goto yy959;
			goto yy631;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy956;
			if (yych <= 'q') goto yy631;
			goto yy957;
		} else {
			if (yych <= 's') goto yy955;
			if (yych <= 't') goto yy958;
			goto yy631;
		}
	}
yy974:
	YYDEBUG(974, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy631;
		} else {
			if (yych == 'T') goto yy959;
			goto yy631;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy956;
			if (yych <= 'q') goto yy631;
			goto yy957;
		} else {
			if (yych <= 's') goto yy955;
			if (yych <= 't') goto yy958;
			goto yy631;
		}
	}
yy975:
	YYDEBUG(975, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy976;
		if (yych <= 'm') goto yy429;
		goto yy956;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy429;
			goto yy957;
		} else {
			if (yych <= 's') goto yy955;
			if (yych <= 't') goto yy958;
			goto yy429;
		}
	}
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy977;
	if (yych <= '2') goto yy978;
	if (yych <= '9') goto yy962;
	goto yy55;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy979;
	if (yych <= ':') goto yy963;
	goto yy55;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy979;
	if (yych == ':') goto yy963;
	goto yy55;
yy979:
	YYDEBUG(979, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy981;
	if (yych <= '9') goto yy965;
	goto yy55;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy982;
	if (yych <= ':') goto yy966;
	goto yy55;
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy984;
	if (yych <= '6') goto yy985;
	if (yych <= '9') goto yy816;
	goto yy55;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy817;
	if (yych <= '9') goto yy986;
	goto yy817;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy817;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy817;
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yyaccept = 22;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(989, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy991;
		if (yych <= ',') goto yy817;
		goto yy991;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy817;
			goto yy988;
		} else {
			if (yych != 'G') goto yy817;
		}
	}
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy997;
	goto yy55;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy992;
	if (yych <= '2') goto yy993;
	if (yych <= '9') goto yy994;
	goto yy55;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy817;
	if (yych <= '9') goto yy994;
	if (yych <= ':') goto yy995;
	goto yy817;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy817;
		if (yych >= '5') goto yy996;
	} else {
		if (yych <= '9') goto yy816;
		if (yych <= ':') goto yy995;
		goto yy817;
	}
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy817;
	if (yych <= '5') goto yy996;
	if (yych <= '9') goto yy816;
	if (yych >= ';') goto yy817;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy817;
	if (yych <= '5') goto yy996;
	if (yych <= '9') goto yy816;
	goto yy817;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy817;
	if (yych <= '9') goto yy816;
	goto yy817;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy55;
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy991;
	if (yych == '-') goto yy991;
	goto yy55;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1000;
	if (yych != 'c') goto yy55;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'E') goto yy854;
		if (yych == 'e') goto yy854;
		goto yy768;
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1002;
	if (yych != 'v') goto yy55;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'E') goto yy861;
		if (yych == 'e') goto yy861;
		goto yy768;
	}
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1004;
	if (yych != 't') goto yy55;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'O') goto yy867;
		if (yych == 'o') goto yy867;
		goto yy768;
	}
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1006;
	if (yych != 'p') goto yy55;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'T') goto yy1007;
		if (yych != 't') goto yy768;
	}
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'E') goto yy873;
		if (yych == 'e') goto yy873;
		goto yy768;
	}
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1011;
	if (yych == 'g') goto yy1011;
	goto yy55;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1010;
	if (yych != 'r') goto yy55;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'I') goto yy880;
		if (yych == 'i') goto yy880;
		goto yy768;
	}
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'U') goto yy882;
		if (yych == 'u') goto yy882;
		goto yy768;
	}
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1013;
		if (yych <= 'X') goto yy55;
		goto yy1014;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
		} else {
			if (yych == 'y') goto yy1014;
			goto yy55;
		}
	}
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'C') goto yy886;
		if (yych == 'c') goto yy886;
		goto yy768;
	}
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy741;
	goto yy768;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1016;
	if (yych != 'b') goto yy55;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'R') goto yy889;
		if (yych == 'r') goto yy889;
		goto yy768;
	}
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1021;
		if (yych <= 'M') goto yy55;
		goto yy1020;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy1021;
		} else {
			if (yych == 'n') goto yy1020;
			goto yy55;
		}
	}
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1019;
	if (yych != 'n') goto yy55;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'U') goto yy896;
		if (yych == 'u') goto yy896;
		goto yy768;
	}
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'E') goto yy858;
		if (yych == 'e') goto yy858;
		goto yy768;
	}
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy741;
		goto yy768;
	} else {
		if (yych <= 'Y') goto yy858;
		if (yych == 'y') goto yy858;
		goto yy768;
	}
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy552;
			goto yy705;
		} else {
			if (yych <= ',') goto yy552;
			if (yych <= '-') goto yy706;
			goto yy705;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy704;
			if (yych <= 'T') goto yy552;
			goto yy89;
		} else {
			if (yych == 'u') goto yy89;
			goto yy552;
		}
	}
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy131;
		if (yych <= 'O') goto yy55;
		goto yy560;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy55;
			goto yy131;
		} else {
			if (yych == 'p') goto yy560;
			goto yy55;
		}
	}
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1026;
			goto yy1028;
		} else {
			if (yych <= '-') goto yy1025;
			if (yych <= '.') goto yy705;
			if (yych <= '/') goto yy704;
			goto yy715;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy444;
			goto yy1028;
		} else {
			if (yych <= 'r') goto yy445;
			if (yych <= 's') goto yy439;
			if (yych <= 't') goto yy442;
			goto yy1028;
		}
	}
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1029;
	case '1':	goto yy1030;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy592;
	case 'A':
	case 'a':	goto yy596;
	case 'D':
	case 'd':	goto yy600;
	case 'F':
	case 'f':	goto yy594;
	case 'J':
	case 'j':	goto yy593;
	case 'M':
	case 'm':	goto yy595;
	case 'N':
	case 'n':	goto yy599;
	case 'O':
	case 'o':	goto yy598;
	case 'S':
	case 's':	goto yy597;
	default:	goto yy552;
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1028;
	if (yych <= '0') goto yy710;
	if (yych <= '1') goto yy711;
	if (yych <= '9') goto yy712;
	goto yy1028;
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1027;
					goto yy55;
				} else {
					if (yych <= ' ') goto yy1027;
					if (yych <= ',') goto yy55;
					goto yy551;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy548;
					goto yy55;
				} else {
					if (yych <= 'D') goto yy440;
					if (yych == 'F') goto yy441;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy64;
					if (yych <= 'I') goto yy449;
					goto yy453;
				} else {
					if (yych <= 'L') goto yy55;
					if (yych <= 'M') goto yy437;
					goto yy456;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy455;
					if (yych <= 'R') goto yy55;
					goto yy438;
				} else {
					if (yych <= 'T') goto yy69;
					if (yych <= 'U') goto yy62;
					if (yych <= 'V') goto yy451;
					goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy452;
					if (yych <= 'Y') goto yy67;
					goto yy55;
				} else {
					if (yych <= 'a') goto yy548;
					if (yych <= 'c') goto yy55;
					goto yy440;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy441;
					goto yy55;
				} else {
					if (yych <= 'h') goto yy64;
					if (yych == 'j') goto yy453;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy437;
					if (yych <= 'n') goto yy456;
					goto yy455;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy438;
					if (yych <= 't') goto yy69;
					goto yy62;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy68;
					goto yy55;
				} else {
					if (yych <= 'y') goto yy67;
					if (yych == 0xC2) goto yy61;
					goto yy55;
				}
			}
		}
	}
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy629;
		goto yy576;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy1031;
		goto yy55;
	}
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy629;
		goto yy576;
	} else {
		if (yych <= '/') goto yy55;
		if (yych >= '3') goto yy55;
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '-') goto yy1032;
	if (yych <= '.') goto yy576;
	goto yy55;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy55;
		if (yych >= '1') goto yy1034;
	} else {
		if (yych <= '3') goto yy1035;
		if (yych <= '9') goto yy633;
		goto yy55;
	}
	YYDEBUG(1033, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '9') goto yy1036;
		if (yych <= 'm') goto yy631;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy631;
		if (yych <= '9') goto yy1036;
		if (yych <= 'm') goto yy631;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy631;
		} else {
			if (yych <= '9') goto yy578;
			if (yych <= 'm') goto yy631;
			goto yy635;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy631;
		}
	}
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy738;
		if (yych <= '9') goto yy579;
		if (yych <= 'm') goto yy738;
		goto yy635;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy738;
			goto yy636;
		} else {
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy637;
			goto yy738;
		}
	}
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1026;
			if (yych <= ',') goto yy1028;
			goto yy1025;
		} else {
			if (yych <= '.') goto yy1038;
			if (yych <= '/') goto yy704;
			if (yych <= '5') goto yy1040;
			goto yy715;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1039;
			if (yych == 'n') goto yy444;
			goto yy1028;
		} else {
			if (yych <= 'r') goto yy445;
			if (yych <= 's') goto yy439;
			if (yych <= 't') goto yy442;
			goto yy1028;
		}
	}
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy552;
		if (yych <= '0') goto yy1062;
		goto yy1063;
	} else {
		if (yych <= '5') goto yy1064;
		if (yych <= '9') goto yy1065;
		goto yy552;
	}
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1057;
	if (yych <= '9') goto yy1058;
	goto yy55;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy759;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(1041, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy765;
				} else {
					if (yych <= ' ') goto yy765;
					if (yych >= '-') goto yy762;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy766;
					if (yych <= '/') goto yy763;
					goto yy1043;
				} else {
					if (yych <= '1') goto yy1044;
					if (yych <= '2') goto yy1045;
					goto yy1046;
				}
			}
		} else {
			if (yych <= 'A') {
				if (yych <= '9') {
					if (yych <= '5') goto yy1047;
					if (yych <= '6') goto yy1048;
					goto yy73;
				} else {
					if (yych <= ':') goto yy781;
					if (yych >= 'A') goto yy765;
				}
			} else {
				if (yych <= 'E') {
					if (yych == 'D') goto yy765;
				} else {
					if (yych == 'G') goto yy1042;
					if (yych <= 'J') goto yy765;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'O') goto yy765;
					if (yych >= 'S') goto yy765;
				} else {
					if (yych <= 'W') goto yy784;
					if (yych <= 'Y') goto yy765;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy765;
					if (yych >= 'd') goto yy765;
				} else {
					if (yych == 'f') goto yy765;
					if (yych >= 'h') goto yy765;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy765;
				} else {
					if (yych <= 'o') goto yy765;
					if (yych >= 's') goto yy765;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy765;
				} else {
					if (yych <= 'y') goto yy765;
					if (yych == 0xC2) goto yy765;
				}
			}
		}
	}
yy1042:
	YYDEBUG(1042, *YYCURSOR);
#line 1250 "parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 15478 "<stdout>"
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy1055;
	if (yych <= '9') goto yy1056;
	goto yy59;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1054;
	if (yych <= '9') goto yy1053;
	goto yy59;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1053;
	goto yy59;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1051;
	if (yych <= '6') goto yy1052;
	if (yych <= '9') goto yy1049;
	goto yy59;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1049;
	goto yy59;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy1049;
	if (yych <= '9') goto yy74;
	goto yy59;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= '9') {
					if (yych >= '0') goto yy75;
				} else {
					if (yych == 'D') goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1050;
				if (yych <= 'H') goto yy59;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
				} else {
					if (yych != 'V') goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych >= 'd') goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy59;
				} else {
					if (yych == 'h') goto yy59;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
				} else {
					if (yych != 'v') goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
				}
			}
		}
	}
yy1050:
	YYDEBUG(1050, *YYCURSOR);
#line 1296 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 15597 "<stdout>"
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy1050;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1050;
					goto yy795;
				} else {
					if (yych == 'D') goto yy59;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1050;
				if (yych <= 'H') goto yy59;
				goto yy1050;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'V') goto yy1050;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy1050;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1050;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'v') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1050;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1050;
				}
			}
		}
	}
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy1050;
				goto yy59;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1050;
					goto yy795;
				} else {
					if (yych <= '9') goto yy75;
					if (yych <= 'C') goto yy1050;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy1050;
					goto yy59;
				} else {
					if (yych == 'H') goto yy59;
					goto yy1050;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'V') goto yy1050;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy1050;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1050;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'v') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1050;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1050;
				}
			}
		}
	}
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy1050;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1050;
					goto yy795;
				} else {
					if (yych == 'D') goto yy59;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1050;
				if (yych <= 'H') goto yy59;
				goto yy1050;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'V') goto yy1050;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy1050;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1050;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'v') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1050;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1050;
				}
			}
		}
	}
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1050;
					goto yy59;
				} else {
					if (yych == ' ') goto yy59;
					goto yy1050;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy819;
					goto yy820;
				} else {
					if (yych <= '3') goto yy821;
					if (yych <= '9') goto yy795;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'G') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1050;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy1050;
					if (yych <= 'U') goto yy59;
					goto yy1050;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy1050;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1050;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'v') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1050;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1050;
				}
			}
		}
	}
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1050;
					goto yy59;
				} else {
					if (yych == ' ') goto yy59;
					goto yy1050;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy851;
					goto yy820;
				} else {
					if (yych <= '3') goto yy821;
					if (yych <= '9') goto yy795;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'G') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1050;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy1050;
					if (yych <= 'U') goto yy59;
					goto yy1050;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy1050;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1050;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'v') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1050;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1050;
				}
			}
		}
	}
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1050;
					goto yy59;
				} else {
					if (yych == ' ') goto yy59;
					goto yy1050;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy819;
					goto yy820;
				} else {
					if (yych <= '3') goto yy821;
					if (yych <= '9') goto yy795;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'G') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1050;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy1050;
					if (yych <= 'U') goto yy59;
					goto yy1050;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy1050;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1050;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1050;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1050;
				} else {
					if (yych == 'v') goto yy1050;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1050;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1050;
				}
			}
		}
	}
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1059;
		goto yy465;
	} else {
		if (yych <= '9') goto yy1058;
		if (yych <= ':') goto yy1059;
		goto yy465;
	}
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1059;
	if (yych != ':') goto yy465;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1060;
	if (yych <= '6') goto yy1061;
	if (yych <= '9') goto yy470;
	goto yy55;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych <= '/') goto yy465;
	if (yych <= '9') goto yy470;
	goto yy465;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych == '0') goto yy470;
	goto yy465;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy465;
		if (yych <= '-') goto yy576;
		goto yy1066;
	} else {
		if (yych <= '/') goto yy465;
		if (yych <= '9') goto yy1065;
		if (yych <= ':') goto yy1059;
		goto yy465;
	}
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy465;
		if (yych <= '-') goto yy576;
		if (yych <= '.') goto yy1066;
		goto yy465;
	} else {
		if (yych <= '2') goto yy1065;
		if (yych <= '9') goto yy1058;
		if (yych <= ':') goto yy1059;
		goto yy465;
	}
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy465;
		if (yych <= '-') goto yy576;
		goto yy1066;
	} else {
		if (yych <= '/') goto yy465;
		if (yych <= '9') goto yy1058;
		if (yych <= ':') goto yy1059;
		goto yy465;
	}
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy465;
		if (yych <= '-') goto yy576;
	} else {
		if (yych == ':') goto yy1059;
		goto yy465;
	}
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1067;
	if (yych <= '6') goto yy1068;
	if (yych <= '9') goto yy584;
	goto yy55;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych <= '/') goto yy465;
	if (yych <= '9') goto yy1069;
	goto yy465;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy471;
		goto yy465;
	} else {
		if (yych <= '0') goto yy1069;
		if (yych <= '9') goto yy585;
		goto yy465;
	}
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy471;
	if (yych <= '/') goto yy465;
	if (yych <= '9') goto yy579;
	goto yy465;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy434;
			if (yych <= ',') goto yy436;
			goto yy1025;
		} else {
			if (yych <= '.') goto yy448;
			if (yych <= '/') goto yy446;
			if (yych <= '5') goto yy1040;
			goto yy715;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy457;
			if (yych == 'n') goto yy444;
			goto yy436;
		} else {
			if (yych <= 'r') goto yy445;
			if (yych <= 's') goto yy439;
			if (yych <= 't') goto yy442;
			goto yy436;
		}
	}
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1026;
			if (yych <= ',') goto yy1028;
			goto yy1025;
		} else {
			if (yych <= '.') goto yy1038;
			if (yych <= '/') goto yy446;
			if (yych <= '5') goto yy1040;
			goto yy715;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1039;
			if (yych == 'n') goto yy444;
			goto yy1028;
		} else {
			if (yych <= 'r') goto yy445;
			if (yych <= 's') goto yy439;
			if (yych <= 't') goto yy442;
			goto yy1028;
		}
	}
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy176;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'e') goto yy1073;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy177;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'v') goto yy1074;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy178;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'i') goto yy1075;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy179;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'o') goto yy1076;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy1077;
		if (yych != 'u') goto yy3;
	}
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1078;
	if (yych != 's') goto yy55;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1079;
	if (yych != ' ') goto yy55;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1079;
				if (yych <= 0x1F) goto yy55;
				goto yy1079;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy55;
					goto yy1086;
				} else {
					if (yych == 'F') goto yy1087;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1085;
					goto yy55;
				} else {
					if (yych <= 'M') goto yy1081;
					if (yych <= 'R') goto yy55;
					goto yy1084;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1090;
					goto yy1083;
				} else {
					if (yych == 'W') goto yy1089;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1088;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy1086;
					if (yych <= 'e') goto yy55;
					goto yy1087;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy55;
					goto yy1085;
				} else {
					if (yych != 'm') goto yy55;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1084;
					goto yy1090;
				} else {
					if (yych <= 'u') goto yy1083;
					if (yych <= 'v') goto yy55;
					goto yy1089;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy1088;
				} else {
					if (yych == 0xC2) goto yy1082;
					goto yy55;
				}
			}
		}
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy1165;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy1164;
			if (yych <= 'R') goto yy55;
			goto yy1166;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy1165;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy1164;
			if (yych == 's') goto yy1166;
			goto yy55;
		}
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy1161;
	goto yy55;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1159;
	if (yych == 's') goto yy1159;
	goto yy55;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1146;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy1147;
			if (yych <= 'T') goto yy55;
			goto yy1145;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1146;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy1147;
			if (yych == 'u') goto yy1145;
			goto yy55;
		}
	}
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1143;
	if (yych == 'o') goto yy1143;
	goto yy55;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1142;
	if (yych == 'a') goto yy1142;
	goto yy55;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1127;
		if (yych <= 'Q') goto yy55;
		goto yy1126;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy55;
			goto yy1127;
		} else {
			if (yych == 'r') goto yy1126;
			goto yy55;
		}
	}
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1123;
	if (yych == 'e') goto yy1123;
	goto yy55;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1109;
	if (yych == 'e') goto yy1109;
	goto yy55;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1091;
		if (yych <= 'T') goto yy55;
		goto yy1092;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
		} else {
			if (yych == 'u') goto yy1092;
			goto yy55;
		}
	}
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1104;
	if (yych == 'u') goto yy1104;
	goto yy55;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1093;
	if (yych != 'e') goto yy55;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1095;
		if (yych >= ' ') goto yy1095;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1097;
		} else {
			if (yych == 's') goto yy1097;
		}
	}
yy1094:
	YYDEBUG(1094, *YYCURSOR);
#line 1692 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 16589 "<stdout>"
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(1096, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1095;
		if (yych <= 0x1F) goto yy55;
		goto yy1095;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy55;
			goto yy1101;
		} else {
			if (yych == 'o') goto yy1101;
			goto yy55;
		}
	}
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1098;
	if (yych != 'd') goto yy55;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1099;
	if (yych != 'a') goto yy55;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1100;
	if (yych != 'y') goto yy55;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1095;
	if (yych == ' ') goto yy1095;
	goto yy1094;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1102;
	if (yych != 'f') goto yy55;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1103, *YYCURSOR);
#line 1165 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
#line 16661 "<stdout>"
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1095;
		if (yych <= 0x1F) goto yy1094;
		goto yy1095;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1094;
		} else {
			if (yych != 'r') goto yy1094;
		}
	}
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1106;
	if (yych != 's') goto yy55;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1107;
	if (yych != 'd') goto yy55;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1108;
	if (yych != 'a') goto yy55;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1100;
	if (yych == 'y') goto yy1100;
	goto yy55;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy55;
		if (yych <= 'D') goto yy1111;
	} else {
		if (yych <= 'c') goto yy55;
		if (yych <= 'd') goto yy1111;
		if (yych >= 'f') goto yy55;
	}
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1117;
	if (yych == 'k') goto yy1117;
	goto yy55;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1095;
		if (yych <= 0x1F) goto yy1094;
		goto yy1095;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1094;
		} else {
			if (yych != 'n') goto yy1094;
		}
	}
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1113;
	if (yych != 'e') goto yy55;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1114;
	if (yych != 's') goto yy55;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1115;
	if (yych != 'd') goto yy55;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1116;
	if (yych != 'a') goto yy55;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1100;
	if (yych == 'y') goto yy1100;
	goto yy55;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1120;
		if (yych >= 'S') goto yy1119;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1120;
		} else {
			if (yych == 's') goto yy1119;
		}
	}
yy1118:
	YYDEBUG(1118, *YYCURSOR);
#line 1668 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 16792 "<stdout>"
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1094;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1121;
	if (yych != 'a') goto yy55;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1122;
	if (yych != 'y') goto yy55;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1119;
	if (yych == 's') goto yy1119;
	goto yy1094;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1124;
	if (yych != 'a') goto yy55;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1125;
	if (yych != 'r') goto yy55;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1119;
	if (yych == 's') goto yy1119;
	goto yy1094;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1139;
	if (yych == 'i') goto yy1139;
	goto yy55;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1128;
	if (yych != 'r') goto yy55;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1129;
	if (yych != 't') goto yy55;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1131;
		if (yych <= 'M') goto yy55;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy1131;
		} else {
			if (yych != 'n') goto yy55;
		}
	}
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1136;
	if (yych == 'i') goto yy1136;
	goto yy55;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1132;
	if (yych != 'n') goto yy55;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1133;
	if (yych != 'i') goto yy55;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1134;
	if (yych != 'g') goto yy55;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1135;
	if (yych != 'h') goto yy55;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1125;
	if (yych == 't') goto yy1125;
	goto yy55;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1137;
	if (yych != 'g') goto yy55;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1138;
	if (yych != 'h') goto yy55;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1125;
	if (yych == 't') goto yy1125;
	goto yy55;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1095;
		if (yych <= 0x1F) goto yy1094;
		goto yy1095;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1094;
		} else {
			if (yych != 'd') goto yy1094;
		}
	}
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1141;
	if (yych != 'a') goto yy55;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1100;
	if (yych == 'y') goto yy1100;
	goto yy55;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1125;
	if (yych == 'y') goto yy1125;
	goto yy55;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1144;
	if (yych != 'u') goto yy55;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1125;
	if (yych == 'r') goto yy1125;
	goto yy55;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1156;
	if (yych == 'n') goto yy1156;
	goto yy55;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1151;
	if (yych == 't') goto yy1151;
	goto yy55;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1148;
	if (yych != 'c') goto yy55;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1149;
		if (yych <= 'R') goto yy1094;
		goto yy1119;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1094;
		} else {
			if (yych == 's') goto yy1119;
			goto yy1094;
		}
	}
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1150;
	if (yych != 'n') goto yy55;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1125;
	if (yych == 'd') goto yy1125;
	goto yy55;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1095;
		if (yych <= 0x1F) goto yy1094;
		goto yy1095;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1094;
		} else {
			if (yych != 'u') goto yy1094;
		}
	}
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1153;
	if (yych != 'r') goto yy55;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1154;
	if (yych != 'd') goto yy55;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1155;
	if (yych != 'a') goto yy55;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1100;
	if (yych == 'y') goto yy1100;
	goto yy55;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1095;
		if (yych <= 0x1F) goto yy1094;
		goto yy1095;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1094;
		} else {
			if (yych != 'd') goto yy1094;
		}
	}
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1158;
	if (yych != 'a') goto yy55;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1100;
	if (yych == 'y') goto yy1100;
	goto yy55;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1160;
	if (yych != 'e') goto yy55;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1125;
	if (yych == 'c') goto yy1125;
	goto yy55;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1162;
	if (yych != 's') goto yy55;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1163;
	if (yych != 'e') goto yy1094;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1125;
	if (yych == 'c') goto yy1125;
	goto yy55;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1187;
	if (yych == 'n') goto yy1187;
	goto yy55;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1169;
			goto yy55;
		} else {
			if (yych <= 'L') goto yy1168;
			if (yych <= 'M') goto yy55;
			goto yy1170;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1169;
			goto yy55;
		} else {
			if (yych <= 'l') goto yy1168;
			if (yych == 'n') goto yy1170;
			goto yy55;
		}
	}
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1167;
	if (yych != 'e') goto yy1094;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1125;
	if (yych == 'c') goto yy1125;
	goto yy55;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1180;
	if (yych == 'l') goto yy1180;
	goto yy55;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1173;
	if (yych == 'r') goto yy1173;
	goto yy55;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1119;
		if (yych <= 'T') goto yy1094;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1094;
			goto yy1119;
		} else {
			if (yych != 'u') goto yy1094;
		}
	}
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1172;
	if (yych != 't') goto yy55;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1125;
	if (yych == 'e') goto yy1125;
	goto yy55;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1174;
	if (yych != 'o') goto yy55;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1175;
	if (yych != 's') goto yy55;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1176;
	if (yych != 'e') goto yy55;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1177;
	if (yych != 'c') goto yy55;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1178;
	if (yych != 'o') goto yy55;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1179;
	if (yych != 'n') goto yy55;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1125;
	if (yych == 'd') goto yy1125;
	goto yy55;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1181;
	if (yych != 'i') goto yy55;
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1182;
	if (yych != 's') goto yy55;
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1183;
	if (yych != 'e') goto yy55;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1184;
	if (yych != 'c') goto yy55;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1185;
	if (yych != 'o') goto yy55;
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1186;
	if (yych != 'n') goto yy55;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1125;
	if (yych == 'd') goto yy1125;
	goto yy55;
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1095;
			goto yy1094;
		} else {
			if (yych <= ' ') goto yy1095;
			if (yych <= 'C') goto yy1094;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1189;
			goto yy1094;
		} else {
			if (yych <= 'd') goto yy1188;
			if (yych == 't') goto yy1189;
			goto yy1094;
		}
	}
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1190;
	if (yych == 'a') goto yy1190;
	goto yy55;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1125;
	if (yych == 'h') goto yy1125;
	goto yy55;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1100;
	if (yych == 'y') goto yy1100;
	goto yy55;
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1073;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'e') goto yy1192;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1074;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'v') goto yy1193;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1075;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'i') goto yy1194;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1076;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'o') goto yy1195;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1077;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'u') goto yy1196;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1078;
	if (yych != 's') goto yy189;
	YYDEBUG(1197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy55;
			goto yy1079;
		} else {
			if (yych == ' ') goto yy1079;
			goto yy55;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy55;
			goto yy182;
		} else {
			if (yych == '_') goto yy182;
			goto yy55;
		}
	}
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy176;
			goto yy1212;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'g') goto yy1212;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy176;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'e') goto yy1200;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy177;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'v') goto yy1201;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy178;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'e') goto yy1202;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy179;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'n') goto yy1203;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy1204;
		if (yych != 't') goto yy3;
	}
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1205;
	if (yych != 'h') goto yy55;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1206;
	if (yych != ' ') goto yy55;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1206;
				if (yych <= 0x1F) goto yy55;
				goto yy1206;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy55;
					goto yy1086;
				} else {
					if (yych == 'F') goto yy1087;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1085;
					goto yy55;
				} else {
					if (yych <= 'M') goto yy1081;
					if (yych <= 'R') goto yy55;
					goto yy1084;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1090;
					goto yy1083;
				} else {
					if (yych != 'W') goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1088;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy1086;
					if (yych <= 'e') goto yy55;
					goto yy1087;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy55;
					goto yy1085;
				} else {
					if (yych == 'm') goto yy1081;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1084;
					goto yy1090;
				} else {
					if (yych <= 'u') goto yy1083;
					if (yych <= 'v') goto yy55;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy1088;
				} else {
					if (yych == 0xC2) goto yy1082;
					goto yy55;
				}
			}
		}
	}
	YYDEBUG(1208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1209;
	if (yych != 'e') goto yy55;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy55;
		if (yych <= 'D') goto yy1111;
	} else {
		if (yych <= 'c') goto yy55;
		if (yych <= 'd') goto yy1111;
		if (yych >= 'f') goto yy55;
	}
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1211;
	if (yych != 'k') goto yy55;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1120;
		if (yych <= 'R') goto yy55;
		goto yy1119;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy55;
			goto yy1120;
		} else {
			if (yych == 's') goto yy1119;
			goto yy55;
		}
	}
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy177;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'h') goto yy1213;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy178;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 't') goto yy1214;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1206;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1206;
			if (yych == ')') goto yy174;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1215;
			if (yych <= 'Z') goto yy179;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1215;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1206;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy1206;
		if (yych == ')') goto yy174;
		goto yy3;
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1212;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'g') goto yy1224;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1200;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'e') goto yy1218;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1201;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'v') goto yy1219;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1202;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'e') goto yy1220;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1203;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'n') goto yy1221;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1204;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 't') goto yy1222;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1205;
	if (yych != 'h') goto yy189;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy55;
			goto yy1206;
		} else {
			if (yych == ' ') goto yy1206;
			goto yy55;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy55;
			goto yy182;
		} else {
			if (yych == '_') goto yy182;
			goto yy55;
		}
	}
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1213;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'h') goto yy1225;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1214;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 't') goto yy1226;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy1206;
			} else {
				if (yych == ' ') goto yy1206;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy182;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy179;
			} else {
				if (yych <= 'H') goto yy1215;
				if (yych <= 'Z') goto yy179;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'h') goto yy1227;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1206;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1206;
			if (yych <= '(') goto yy3;
			goto yy174;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy182;
			goto yy3;
		} else {
			if (yych <= '/') goto yy182;
			if (yych == '_') goto yy182;
			goto yy3;
		}
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1244;
				goto yy176;
			} else {
				if (yych <= 'P') goto yy1246;
				if (yych <= 'U') goto yy176;
				goto yy1245;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy176;
				goto yy3;
			} else {
				if (yych == 'c') goto yy1244;
				goto yy176;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1246;
				goto yy176;
			} else {
				if (yych <= 'v') goto yy1245;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy176;
			goto yy1239;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 't') goto yy1239;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy176;
			goto yy1236;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'x') goto yy1236;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy176;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'n') goto yy1232;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy201;
			goto yy174;
		} else {
			if (yych <= '@') goto yy201;
			if (yych <= 'C') goto yy177;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy201;
			goto yy177;
		} else {
			if (yych <= 'd') goto yy1233;
			if (yych <= 'z') goto yy177;
			goto yy201;
		}
	}
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy178;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1234;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy179;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'y') goto yy1235;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy174;
	goto yy201;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy177;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 't') goto yy1237;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy178;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1206;
		} else {
			if (yych == ' ') goto yy1206;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy179;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy201;
			goto yy174;
		} else {
			if (yych <= '@') goto yy201;
			if (yych <= 'T') goto yy177;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy201;
			goto yy177;
		} else {
			if (yych <= 'u') goto yy1240;
			if (yych <= 'z') goto yy177;
			goto yy201;
		}
	}
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy178;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'r') goto yy1241;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy179;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'd') goto yy1242;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1243;
		if (yych != 'a') goto yy3;
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy207;
	if (yych == 'y') goto yy207;
	goto yy55;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy177;
			goto yy1255;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'o') goto yy1255;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy177;
			goto yy1252;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'e') goto yy1252;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych != 'T') goto yy177;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 't') goto yy1247;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych != 'E') goto yy178;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy228;
				goto yy178;
			} else {
				if (yych <= 'e') goto yy1248;
				if (yych <= 'z') goto yy178;
				goto yy228;
			}
		}
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy179;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'm') goto yy1249;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy1250;
		if (yych != 'b') goto yy3;
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1251;
	if (yych != 'e') goto yy55;
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy239;
	if (yych == 'r') goto yy239;
	goto yy55;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy178;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'n') goto yy1253;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy179;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 't') goto yy1254;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1205;
		if (yych == 'h') goto yy1205;
		goto yy3;
	}
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy178;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'n') goto yy1256;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy179;
			goto yy1215;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'd') goto yy1215;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy174;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy182;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy176;
				goto yy1244;
			} else {
				if (yych == 'P') goto yy1246;
				goto yy176;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1245;
				if (yych <= 'Z') goto yy176;
				goto yy3;
			} else {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy3;
				goto yy181;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1273;
				if (yych <= 'o') goto yy181;
				goto yy1275;
			} else {
				if (yych == 'v') goto yy1274;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1239;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 't') goto yy1268;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1236;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'x') goto yy1265;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1232;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'n') goto yy1261;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy201;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy201;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1233;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy201;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy201;
				goto yy185;
			} else {
				if (yych <= 'd') goto yy1262;
				if (yych <= 'z') goto yy185;
				goto yy201;
			}
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1234;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1263;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1235;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'y') goto yy1264;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy174;
		if (yych <= ',') goto yy201;
		goto yy182;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy201;
			goto yy182;
		} else {
			if (yych == '_') goto yy182;
			goto yy201;
		}
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1237;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 't') goto yy1266;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1206;
			if (yych <= 0x1F) goto yy3;
			goto yy1206;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy182;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy201;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy201;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1240;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy201;
			goto yy182;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy201;
				goto yy185;
			} else {
				if (yych <= 'u') goto yy1269;
				if (yych <= 'z') goto yy185;
				goto yy201;
			}
		}
	}
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1241;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'r') goto yy1270;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1242;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'd') goto yy1271;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1243;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1272;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy207;
	if (yych == 'y') goto yy220;
	goto yy189;
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1255;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'o') goto yy1284;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1252;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'e') goto yy1281;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'T') goto yy1247;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 't') goto yy1276;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy228;
				goto yy178;
			} else {
				if (yych <= 'E') goto yy1248;
				if (yych <= 'Z') goto yy178;
				goto yy228;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy186;
			} else {
				if (yych <= 'e') goto yy1277;
				if (yych <= 'z') goto yy186;
				goto yy228;
			}
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1249;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'm') goto yy1278;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1250;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1279;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1251;
	if (yych != 'e') goto yy189;
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy239;
	if (yych == 'r') goto yy351;
	goto yy189;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1253;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'n') goto yy1282;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1254;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 't') goto yy1283;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1205;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1223;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1256;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'n') goto yy1285;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1215;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'd') goto yy1227;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy176;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'c') goto yy1287;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy177;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'k') goto yy1288;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1289;
		if (yych <= '(') goto yy3;
		goto yy174;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy178;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1290;
	if (yych != 'o') goto yy55;
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1291;
	if (yych != 'f') goto yy55;
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy55;
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1293;
	if (yych <= '2') goto yy1295;
	if (yych <= '9') goto yy1296;
	goto yy55;
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1297;
		} else {
			if (yych <= ' ') goto yy1297;
			if (yych <= '/') goto yy1294;
			if (yych <= '9') goto yy1296;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1299;
			if (yych == 'P') goto yy1299;
		} else {
			if (yych <= 'a') goto yy1299;
			if (yych == 'p') goto yy1299;
		}
	}
yy1294:
	YYDEBUG(1294, *YYCURSOR);
#line 1142 "parse_date.re"
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 19663 "<stdout>"
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1297;
			goto yy1294;
		} else {
			if (yych <= ' ') goto yy1297;
			if (yych <= '/') goto yy1294;
			if (yych >= '5') goto yy1294;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1299;
			if (yych == 'P') goto yy1299;
			goto yy1294;
		} else {
			if (yych <= 'a') goto yy1299;
			if (yych == 'p') goto yy1299;
			goto yy1294;
		}
	}
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy1294;
		} else {
			if (yych <= ' ') goto yy1297;
			if (yych <= '@') goto yy1294;
			goto yy1299;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1299;
			goto yy1294;
		} else {
			if (yych <= 'a') goto yy1299;
			if (yych == 'p') goto yy1299;
			goto yy1294;
		}
	}
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1298, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1297;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy1297;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy1299;
			if (yych != 'p') goto yy55;
		}
	}
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy1301;
		if (yych == 'm') goto yy1301;
		goto yy55;
	}
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1301;
	if (yych != 'm') goto yy55;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1303;
		if (yych == '\t') goto yy1303;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy1303;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1303;
		if (yych <= 0x08) goto yy55;
	} else {
		if (yych != ' ') goto yy55;
	}
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1294;
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1287;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'c') goto yy1305;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1288;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'k') goto yy1306;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1289;
			goto yy3;
		} else {
			if (yych <= ')') goto yy174;
			if (yych == '-') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy182;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy178;
			goto yy3;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy176;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 's') goto yy1308;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy177;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 't') goto yy1309;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1079;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy178;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1311;
	if (yych != 'd') goto yy1080;
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1312;
	if (yych != 'a') goto yy55;
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1313;
	if (yych != 'y') goto yy55;
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1094;
	} else {
		if (yych <= 'S') goto yy1119;
		if (yych == 's') goto yy1119;
		goto yy1094;
	}
	YYDEBUG(1314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1315;
	if (yych != 'o') goto yy55;
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1316;
	if (yych != 'f') goto yy55;
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1317, *YYCURSOR);
#line 1125 "parse_date.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 19978 "<stdout>"
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1308;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 's') goto yy1319;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1309;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 't') goto yy1320;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1079;
			if (yych <= 0x1F) goto yy3;
			goto yy1310;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy182;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy176;
			goto yy1358;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'b') goto yy1358;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == 'F') goto yy1348;
			if (yych <= 'Q') goto yy176;
			goto yy1347;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy176;
			goto yy1348;
		} else {
			if (yych == 'r') goto yy1347;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy176;
			goto yy1344;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'u') goto yy1344;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1326;
			if (yych <= 'N') goto yy176;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy176;
			goto yy1326;
		} else {
			if (yych == 'o') goto yy1325;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy177;
			goto yy1329;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'n') goto yy1329;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy201;
			goto yy174;
		} else {
			if (yych <= '@') goto yy201;
			if (yych <= 'C') goto yy177;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy201;
			goto yy177;
		} else {
			if (yych <= 'd') goto yy1327;
			if (yych <= 'z') goto yy177;
			goto yy201;
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy178;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1328;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy179;
			goto yy1235;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'y') goto yy1235;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy178;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 't') goto yy1330;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1331;
		if (yych <= '(') goto yy3;
		goto yy174;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy179;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1332;
	if (yych != 'o') goto yy55;
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1333;
	if (yych != 'f') goto yy55;
yy1333:
	YYDEBUG(1333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy55;
	YYDEBUG(1334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1335;
	if (yych <= '2') goto yy1336;
	if (yych <= '9') goto yy1337;
	goto yy55;
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1338;
			goto yy1294;
		} else {
			if (yych <= ' ') goto yy1338;
			if (yych <= '/') goto yy1294;
			if (yych <= '9') goto yy1337;
			goto yy1294;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1340;
			if (yych == 'P') goto yy1340;
			goto yy1294;
		} else {
			if (yych <= 'a') goto yy1340;
			if (yych == 'p') goto yy1340;
			goto yy1294;
		}
	}
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1338;
			goto yy1294;
		} else {
			if (yych <= ' ') goto yy1338;
			if (yych <= '/') goto yy1294;
			if (yych >= '5') goto yy1294;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1340;
			if (yych == 'P') goto yy1340;
			goto yy1294;
		} else {
			if (yych <= 'a') goto yy1340;
			if (yych == 'p') goto yy1340;
			goto yy1294;
		}
	}
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy1294;
		} else {
			if (yych <= ' ') goto yy1338;
			if (yych <= '@') goto yy1294;
			goto yy1340;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1340;
			goto yy1294;
		} else {
			if (yych <= 'a') goto yy1340;
			if (yych == 'p') goto yy1340;
			goto yy1294;
		}
	}
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1339, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1338;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy1338;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy1340;
			if (yych != 'p') goto yy55;
		}
	}
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy1342;
		if (yych == 'm') goto yy1342;
		goto yy55;
	}
	YYDEBUG(1341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1342;
	if (yych != 'm') goto yy55;
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1303;
		if (yych == '\t') goto yy1303;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy1303;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(1343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1303;
		if (yych <= 0x08) goto yy55;
		goto yy1303;
	} else {
		if (yych == ' ') goto yy1303;
		goto yy55;
	}
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy177;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'r') goto yy1345;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy178;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 't') goto yy1346;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy179;
			goto yy1215;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'h') goto yy1215;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy177;
			goto yy1350;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 's') goto yy1350;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy177;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 't') goto yy1349;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy178;
			goto yy1238;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1350:
	YYDEBUG(1350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy178;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 't') goto yy1351;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1206;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy179;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1353;
	if (yych != 'd') goto yy1207;
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1354;
	if (yych != 'a') goto yy55;
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1355;
	if (yych != 'y') goto yy55;
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1094;
	} else {
		if (yych <= 'S') goto yy1119;
		if (yych == 's') goto yy1119;
		goto yy1094;
	}
	YYDEBUG(1356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1357;
	if (yych != 'o') goto yy55;
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1316;
	if (yych == 'f') goto yy1316;
	goto yy55;
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych != 'R') goto yy177;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy1359;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy178;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'u') goto yy1360;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy179;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1361;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy1362;
		if (yych != 'r') goto yy3;
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy239;
	if (yych == 'y') goto yy239;
	goto yy55;
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1358;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'b') goto yy1381;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych == '-') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy182;
				goto yy3;
			} else {
				if (yych == 'F') goto yy1348;
				goto yy176;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1347;
				goto yy176;
			} else {
				if (yych == '_') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1377;
				goto yy181;
			} else {
				if (yych <= 'r') goto yy1376;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1344;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'u') goto yy1373;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych == '-') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy182;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1326;
				goto yy176;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1325;
				goto yy176;
			} else {
				if (yych == '_') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1368;
				goto yy181;
			} else {
				if (yych <= 'o') goto yy1367;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1329;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'n') goto yy1371;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy201;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy201;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1327;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy201;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy201;
				goto yy185;
			} else {
				if (yych <= 'd') goto yy1369;
				if (yych <= 'z') goto yy185;
				goto yy201;
			}
		}
	}
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1328;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1370;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1235;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'y') goto yy1264;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1330;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 't') goto yy1372;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1331;
			goto yy3;
		} else {
			if (yych <= ')') goto yy174;
			if (yych == '-') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy182;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy179;
			goto yy3;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1345;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'r') goto yy1374;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1346;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 't') goto yy1375;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1215;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'h') goto yy1227;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1350;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 's') goto yy1379;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1349;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 't') goto yy1378;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1351;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 't') goto yy1380;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1206;
			if (yych <= 0x1F) goto yy3;
			goto yy1352;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy182;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1381:
	YYDEBUG(1381, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'R') goto yy1359;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'r') goto yy1382;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy1382:
	YYDEBUG(1382, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1360;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'u') goto yy1383;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1383:
	YYDEBUG(1383, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1361;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1384;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1362;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1385;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy239;
	if (yych == 'y') goto yy351;
	goto yy189;
yy1386:
	YYDEBUG(1386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy1387:
	YYDEBUG(1387, *YYCURSOR);
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	YYDEBUG(1388, *YYCURSOR);
	if (yych == '.') goto yy1390;
	if (yych <= '/') goto yy1389;
	if (yych <= '9') goto yy1387;
yy1389:
	YYDEBUG(1389, *YYCURSOR);
#line 1071 "parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21492 "<stdout>"
yy1390:
	YYDEBUG(1390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(1391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(1392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(1393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(1394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(1395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(1396, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1397, *YYCURSOR);
#line 1097 "parse_date.re"
	{
		timelib_ull i, us;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		us = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->relative.us = us;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21548 "<stdout>"
yy1398:
	YYDEBUG(1398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy176;
			goto yy1439;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'n') goto yy1439;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1431;
			if (yych <= 'T') goto yy176;
			goto yy1432;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy176;
			goto yy1431;
		} else {
			if (yych == 'u') goto yy1432;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1420;
			if (yych <= 'L') goto yy176;
			goto yy1421;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy176;
			goto yy1420;
		} else {
			if (yych == 'm') goto yy1421;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy176;
			goto yy1416;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'e') goto yy1416;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy176;
			goto yy1412;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'e') goto yy1412;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1039;
		goto yy55;
	} else {
		if (yych <= '9') goto yy1406;
		if (yych <= ':') goto yy1039;
		goto yy55;
	}
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1039;
		goto yy55;
	} else {
		if (yych <= '4') goto yy1406;
		if (yych == ':') goto yy1039;
		goto yy55;
	}
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1039;
	if (yych == ':') goto yy1039;
	goto yy55;
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1039;
		goto yy55;
	} else {
		if (yych <= '5') goto yy1407;
		if (yych == ':') goto yy1039;
		goto yy55;
	}
yy1407:
	YYDEBUG(1407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(1408, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1042;
	if (yych <= '5') goto yy1409;
	if (yych <= '6') goto yy1410;
	goto yy1042;
yy1409:
	YYDEBUG(1409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1411;
	goto yy55;
yy1410:
	YYDEBUG(1410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy55;
yy1411:
	YYDEBUG(1411, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1050;
yy1412:
	YYDEBUG(1412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy177;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'l') goto yy1413;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1413:
	YYDEBUG(1413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy178;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'f') goto yy1414;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1414:
	YYDEBUG(1414, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy179;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 't') goto yy1415;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1415:
	YYDEBUG(1415, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1205;
		if (yych == 'h') goto yy1205;
		goto yy3;
	}
yy1416:
	YYDEBUG(1416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy201;
			goto yy174;
		} else {
			if (yych <= '@') goto yy201;
			if (yych <= 'R') goto yy177;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy201;
			goto yy177;
		} else {
			if (yych <= 's') goto yy1417;
			if (yych <= 'z') goto yy177;
			goto yy201;
		}
	}
yy1417:
	YYDEBUG(1417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy178;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'd') goto yy1418;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1418:
	YYDEBUG(1418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy179;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1419;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1419:
	YYDEBUG(1419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy207;
		if (yych == 'y') goto yy207;
		goto yy3;
	}
yy1420:
	YYDEBUG(1420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
		goto yy1428;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy177;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1428;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1421:
	YYDEBUG(1421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy177;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'o') goto yy1422;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1422:
	YYDEBUG(1422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy178;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'r') goto yy1423;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1423:
	YYDEBUG(1423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy179;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'r') goto yy1424;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1424:
	YYDEBUG(1424, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1425;
		if (yych != 'o') goto yy3;
	}
yy1425:
	YYDEBUG(1425, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1426;
	if (yych != 'w') goto yy55;
yy1426:
	YYDEBUG(1426, *YYCURSOR);
	++YYCURSOR;
yy1427:
	YYDEBUG(1427, *YYCURSOR);
#line 1059 "parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21995 "<stdout>"
yy1428:
	YYDEBUG(1428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy178;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'y') goto yy1429;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1429:
	YYDEBUG(1429, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy174;
	} else {
		if (yych <= 'Z') goto yy179;
		if (yych <= '`') goto yy1430;
		if (yych <= 'z') goto yy179;
	}
yy1430:
	YYDEBUG(1430, *YYCURSOR);
#line 1049 "parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22039 "<stdout>"
yy1431:
	YYDEBUG(1431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy177;
			if (yych <= 'R') goto yy1437;
			goto yy1438;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'r') goto yy1437;
			if (yych <= 's') goto yy1438;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1432:
	YYDEBUG(1432, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy201;
			goto yy174;
		} else {
			if (yych <= '@') goto yy201;
			if (yych <= 'Q') goto yy177;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy201;
			goto yy177;
		} else {
			if (yych <= 'r') goto yy1433;
			if (yych <= 'z') goto yy177;
			goto yy201;
		}
	}
yy1433:
	YYDEBUG(1433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy178;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 's') goto yy1434;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1434:
	YYDEBUG(1434, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy179;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'd') goto yy1435;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1435:
	YYDEBUG(1435, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1436;
		if (yych != 'a') goto yy3;
	}
yy1436:
	YYDEBUG(1436, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy207;
	if (yych == 'y') goto yy207;
	goto yy55;
yy1437:
	YYDEBUG(1437, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy178;
			goto yy1238;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'd') goto yy1238;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1438:
	YYDEBUG(1438, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1079;
		} else {
			if (yych == ' ') goto yy1079;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy178;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1439:
	YYDEBUG(1439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy177;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 't') goto yy1440;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1440:
	YYDEBUG(1440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy178;
			goto yy1238;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1441:
	YYDEBUG(1441, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1439;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'n') goto yy1471;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1442:
	YYDEBUG(1442, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych == '-') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy182;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1431;
				goto yy176;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1432;
				goto yy176;
			} else {
				if (yych == '_') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1463;
				goto yy181;
			} else {
				if (yych <= 'u') goto yy1464;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1443:
	YYDEBUG(1443, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych == '-') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy182;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1420;
				goto yy176;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1421;
				goto yy176;
			} else {
				if (yych == '_') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1454;
				goto yy181;
			} else {
				if (yych <= 'm') goto yy1455;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1444:
	YYDEBUG(1444, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1416;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'e') goto yy1450;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1445:
	YYDEBUG(1445, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1412;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'e') goto yy1446;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1446:
	YYDEBUG(1446, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1413;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'l') goto yy1447;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1447:
	YYDEBUG(1447, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1414;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'f') goto yy1448;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1448:
	YYDEBUG(1448, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1415;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 't') goto yy1449;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1449:
	YYDEBUG(1449, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1205;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1223;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1450:
	YYDEBUG(1450, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy201;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy201;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1417;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy201;
			goto yy182;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy201;
				goto yy185;
			} else {
				if (yych <= 's') goto yy1451;
				if (yych <= 'z') goto yy185;
				goto yy201;
			}
		}
	}
yy1451:
	YYDEBUG(1451, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1418;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'd') goto yy1452;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1452:
	YYDEBUG(1452, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1419;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1453;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy1453:
	YYDEBUG(1453, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy207;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'y') goto yy220;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1454:
	YYDEBUG(1454, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1428;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1461;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1455:
	YYDEBUG(1455, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1422;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'o') goto yy1456;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1456:
	YYDEBUG(1456, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1423;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'r') goto yy1457;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1457:
	YYDEBUG(1457, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1424;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'r') goto yy1458;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1458:
	YYDEBUG(1458, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1425;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1459;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1459:
	YYDEBUG(1459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1426;
	if (yych != 'w') goto yy189;
	YYDEBUG(1460, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy182;
		goto yy1427;
	} else {
		if (yych <= '/') goto yy182;
		if (yych == '_') goto yy182;
		goto yy1427;
	}
yy1461:
	YYDEBUG(1461, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1429;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'y') goto yy1462;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1462:
	YYDEBUG(1462, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy1430;
		} else {
			if (yych == '.') goto yy1430;
			goto yy182;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1430;
			if (yych <= 'Z') goto yy179;
			goto yy1430;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy1430;
			if (yych <= 'z') goto yy187;
			goto yy1430;
		}
	}
yy1463:
	YYDEBUG(1463, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy182;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy177;
				goto yy1437;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1438;
				goto yy177;
			} else {
				if (yych == '_') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy185;
				goto yy1469;
			} else {
				if (yych <= 's') goto yy1470;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1464:
	YYDEBUG(1464, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy201;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy201;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1433;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy201;
			goto yy182;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy201;
				goto yy185;
			} else {
				if (yych <= 'r') goto yy1465;
				if (yych <= 'z') goto yy185;
				goto yy201;
			}
		}
	}
yy1465:
	YYDEBUG(1465, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1434;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 's') goto yy1466;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1466:
	YYDEBUG(1466, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1435;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'd') goto yy1467;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1467:
	YYDEBUG(1467, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1436;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1468;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1468:
	YYDEBUG(1468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy207;
	if (yych == 'y') goto yy220;
	goto yy189;
yy1469:
	YYDEBUG(1469, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1238;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'd') goto yy1267;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1470:
	YYDEBUG(1470, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1079;
			if (yych <= 0x1F) goto yy3;
			goto yy1079;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy182;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1471:
	YYDEBUG(1471, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1440;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 't') goto yy1472;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1472:
	YYDEBUG(1472, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1473:
	YYDEBUG(1473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1485;
			if (yych <= 'X') goto yy176;
			goto yy1486;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy176;
			goto yy1485;
		} else {
			if (yych == 'y') goto yy1486;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1474:
	YYDEBUG(1474, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy176;
			goto yy1479;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'd') goto yy1479;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1475:
	YYDEBUG(1475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy176;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'n') goto yy1476;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1476:
	YYDEBUG(1476, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy201;
			goto yy174;
		} else {
			if (yych <= '@') goto yy201;
			if (yych <= 'C') goto yy177;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy201;
			goto yy177;
		} else {
			if (yych <= 'd') goto yy1477;
			if (yych <= 'z') goto yy177;
			goto yy201;
		}
	}
yy1477:
	YYDEBUG(1477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy174;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy178;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1478;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1478:
	YYDEBUG(1478, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy179;
			goto yy1235;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'y') goto yy1235;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1479:
	YYDEBUG(1479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy177;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'n') goto yy1480;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1480:
	YYDEBUG(1480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy178;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'i') goto yy1481;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1481:
	YYDEBUG(1481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy179;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'g') goto yy1482;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1482:
	YYDEBUG(1482, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1483;
		if (yych != 'h') goto yy3;
	}
yy1483:
	YYDEBUG(1483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1484;
	if (yych != 't') goto yy55;
yy1484:
	YYDEBUG(1484, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1430;
yy1485:
	YYDEBUG(1485, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych == 'C') goto yy1487;
				goto yy177;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'c') goto yy1487;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy1486:
	YYDEBUG(1486, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy228;
			goto yy230;
		} else {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy228;
			goto yy231;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy228;
			if (yych <= '9') goto yy230;
			goto yy228;
		} else {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy228;
			if (yych <= 'z') goto yy177;
			goto yy228;
		}
	}
yy1487:
	YYDEBUG(1487, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy178;
			goto yy370;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'h') goto yy370;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1488:
	YYDEBUG(1488, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych == '-') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy182;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1485;
				goto yy176;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1486;
				goto yy176;
			} else {
				if (yych == '_') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1500;
				goto yy181;
			} else {
				if (yych <= 'y') goto yy1501;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1489:
	YYDEBUG(1489, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1479;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'd') goto yy1494;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1490:
	YYDEBUG(1490, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1476;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'n') goto yy1491;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1491:
	YYDEBUG(1491, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy201;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy201;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1477;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy201;
			goto yy182;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy201;
				goto yy185;
			} else {
				if (yych <= 'd') goto yy1492;
				if (yych <= 'z') goto yy185;
				goto yy201;
			}
		}
	}
yy1492:
	YYDEBUG(1492, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1478;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1493;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1493:
	YYDEBUG(1493, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1235;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'y') goto yy1264;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1494:
	YYDEBUG(1494, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1480;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'n') goto yy1495;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1495:
	YYDEBUG(1495, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1481;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'i') goto yy1496;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1496:
	YYDEBUG(1496, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1482;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'g') goto yy1497;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1497:
	YYDEBUG(1497, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1483;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1498;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1498:
	YYDEBUG(1498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1484;
	if (yych != 't') goto yy189;
	YYDEBUG(1499, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy182;
		goto yy1430;
	} else {
		if (yych <= '/') goto yy182;
		if (yych == '_') goto yy182;
		goto yy1430;
	}
yy1500:
	YYDEBUG(1500, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'C') goto yy1487;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'c') goto yy1502;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy1501:
	YYDEBUG(1501, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy228;
			goto yy230;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy228;
				goto yy174;
			} else {
				if (yych <= ',') goto yy228;
				if (yych <= '-') goto yy346;
				goto yy230;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy182;
			if (yych <= '9') goto yy230;
			if (yych <= '@') goto yy228;
			goto yy177;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy228;
				goto yy182;
			} else {
				if (yych <= '`') goto yy228;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy1502:
	YYDEBUG(1502, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy370;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'h') goto yy381;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1503:
	YYDEBUG(1503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy174;
			if (yych <= '@') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'O') goto yy1511;
			if (yych <= 'U') goto yy176;
			if (yych <= 'V') goto yy1512;
			goto yy1509;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy176;
			goto yy1511;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy176;
				goto yy1512;
			} else {
				if (yych <= 'w') goto yy1509;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1504:
	YYDEBUG(1504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy176;
			goto yy1508;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'x') goto yy1508;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1505:
	YYDEBUG(1505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy176;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 'n') goto yy1506;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1506:
	YYDEBUG(1506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy177;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 't') goto yy1507;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1507:
	YYDEBUG(1507, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy178;
			goto yy1238;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1508:
	YYDEBUG(1508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy177;
			goto yy1438;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 't') goto yy1438;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1509:
	YYDEBUG(1509, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy174;
	} else {
		if (yych <= 'Z') goto yy177;
		if (yych <= '`') goto yy1510;
		if (yych <= 'z') goto yy177;
	}
yy1510:
	YYDEBUG(1510, *YYCURSOR);
#line 1028 "parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 24059 "<stdout>"
yy1511:
	YYDEBUG(1511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy177;
			goto yy1517;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 'n') goto yy1517;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1512:
	YYDEBUG(1512, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy174;
				goto yy228;
			} else {
				if (yych <= '-') goto yy231;
				if (yych <= '.') goto yy230;
				goto yy228;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy230;
				goto yy228;
			} else {
				if (yych != 'E') goto yy177;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'e') goto yy1513;
				if (yych <= 'z') goto yy177;
				goto yy228;
			}
		}
	}
yy1513:
	YYDEBUG(1513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy178;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'm') goto yy1514;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1514:
	YYDEBUG(1514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy179;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'b') goto yy1515;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1515:
	YYDEBUG(1515, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1516;
		if (yych != 'e') goto yy3;
	}
yy1516:
	YYDEBUG(1516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy239;
	if (yych == 'r') goto yy239;
	goto yy55;
yy1517:
	YYDEBUG(1517, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy174;
	} else {
		if (yych <= 'Z') goto yy178;
		if (yych <= '`') goto yy1518;
		if (yych <= 'z') goto yy178;
	}
yy1518:
	YYDEBUG(1518, *YYCURSOR);
#line 1037 "parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 24209 "<stdout>"
yy1519:
	YYDEBUG(1519, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy174;
			} else {
				if (yych == '-') goto yy182;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy182;
				if (yych <= '@') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'O') goto yy1511;
				if (yych <= 'U') goto yy176;
				goto yy1512;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1509;
				if (yych <= 'Z') goto yy176;
				goto yy3;
			} else {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy3;
				goto yy181;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1526;
				if (yych <= 'u') goto yy181;
				goto yy1527;
			} else {
				if (yych <= 'w') goto yy1525;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1520:
	YYDEBUG(1520, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1508;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'x') goto yy1524;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1521:
	YYDEBUG(1521, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1506;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 'n') goto yy1522;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1522:
	YYDEBUG(1522, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1507;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 't') goto yy1523;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1523:
	YYDEBUG(1523, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1524:
	YYDEBUG(1524, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1438;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 't') goto yy1470;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1525:
	YYDEBUG(1525, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy1510;
		} else {
			if (yych == '.') goto yy1510;
			goto yy182;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1510;
			if (yych <= 'Z') goto yy177;
			goto yy1510;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy1510;
			if (yych <= 'z') goto yy185;
			goto yy1510;
		}
	}
yy1526:
	YYDEBUG(1526, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1517;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 'n') goto yy1532;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1527:
	YYDEBUG(1527, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy228;
				goto yy230;
			} else {
				if (yych == ' ') goto yy230;
				goto yy228;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy174;
				if (yych <= ',') goto yy228;
				goto yy346;
			} else {
				if (yych == '/') goto yy182;
				goto yy230;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy228;
				goto yy177;
			} else {
				if (yych <= 'E') goto yy1513;
				if (yych <= 'Z') goto yy177;
				goto yy228;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy182;
				if (yych <= '`') goto yy228;
				goto yy185;
			} else {
				if (yych <= 'e') goto yy1528;
				if (yych <= 'z') goto yy185;
				goto yy228;
			}
		}
	}
yy1528:
	YYDEBUG(1528, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1514;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'm') goto yy1529;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1529:
	YYDEBUG(1529, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1515;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'b') goto yy1530;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1530:
	YYDEBUG(1530, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1516;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1531;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1531:
	YYDEBUG(1531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy239;
	if (yych == 'r') goto yy351;
	goto yy189;
yy1532:
	YYDEBUG(1532, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy1518;
		} else {
			if (yych == '.') goto yy1518;
			goto yy182;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1518;
			if (yych <= 'Z') goto yy178;
			goto yy1518;
		} else {
			if (yych <= '_') goto yy182;
			if (yych <= '`') goto yy1518;
			if (yych <= 'z') goto yy186;
			goto yy1518;
		}
	}
yy1533:
	YYDEBUG(1533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy176;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy176;
			if (yych <= '`') goto yy3;
			goto yy176;
		} else {
			if (yych <= 's') goto yy1534;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1534:
	YYDEBUG(1534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy177;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy177;
			if (yych <= '`') goto yy3;
			goto yy177;
		} else {
			if (yych <= 't') goto yy1535;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1535:
	YYDEBUG(1535, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy178;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy178;
			if (yych <= '`') goto yy3;
			goto yy178;
		} else {
			if (yych <= 'e') goto yy1536;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1536:
	YYDEBUG(1536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy174;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy179;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy179;
			if (yych <= '`') goto yy3;
			goto yy179;
		} else {
			if (yych <= 'r') goto yy1537;
			if (yych <= 'z') goto yy179;
			goto yy3;
		}
	}
yy1537:
	YYDEBUG(1537, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy174;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1538;
		if (yych != 'd') goto yy3;
	}
yy1538:
	YYDEBUG(1538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1539;
	if (yych != 'a') goto yy55;
yy1539:
	YYDEBUG(1539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1540;
	if (yych != 'y') goto yy55;
yy1540:
	YYDEBUG(1540, *YYCURSOR);
	++YYCURSOR;
yy1541:
	YYDEBUG(1541, *YYCURSOR);
#line 1016 "parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 24753 "<stdout>"
yy1542:
	YYDEBUG(1542, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy176;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1534;
			if (yych <= 'Z') goto yy176;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy181;
			} else {
				if (yych <= 's') goto yy1543;
				if (yych <= 'z') goto yy181;
				goto yy3;
			}
		}
	}
yy1543:
	YYDEBUG(1543, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy177;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1535;
			if (yych <= 'Z') goto yy177;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy185;
			} else {
				if (yych <= 't') goto yy1544;
				if (yych <= 'z') goto yy185;
				goto yy3;
			}
		}
	}
yy1544:
	YYDEBUG(1544, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy178;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1536;
			if (yych <= 'Z') goto yy178;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'e') goto yy1545;
				if (yych <= 'z') goto yy186;
				goto yy3;
			}
		}
	}
yy1545:
	YYDEBUG(1545, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy174;
			if (yych <= ',') goto yy3;
			goto yy182;
		} else {
			if (yych == '/') goto yy182;
			if (yych <= '@') goto yy3;
			goto yy179;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1537;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'r') goto yy1546;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy1546:
	YYDEBUG(1546, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy174;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy182;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1538;
			if (yych == '_') goto yy182;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1547;
			if (yych <= 'z') goto yy188;
			goto yy3;
		}
	}
yy1547:
	YYDEBUG(1547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1539;
	if (yych != 'a') goto yy189;
	YYDEBUG(1548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1540;
	if (yych != 'y') goto yy189;
	YYDEBUG(1549, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy188;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy182;
		goto yy1541;
	} else {
		if (yych <= '/') goto yy182;
		if (yych == '_') goto yy182;
		goto yy1541;
	}
}
#line 1818 "parse_date.re"

}

#define YYMAXFILL 33

timelib_time* timelib_strtotime(char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, TIMELIB_ERR_EMPTY_STRING, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->us = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->us = 0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->us == TIMELIB_UNSET ) time->us = 0;
}

static const timelib_format_specifier default_format_map[] = {
	{'+', TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS},
	{'#', TIMELIB_FORMAT_ANY_SEPARATOR},
	{'j', TIMELIB_FORMAT_DAY_TWO_DIGIT},
	{'d', TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED},
	{'z', TIMELIB_FORMAT_DAY_OF_YEAR},
	{'S', TIMELIB_FORMAT_DAY_SUFFIX},
	{'U', TIMELIB_FORMAT_EPOCH_SECONDS},
	{'\\', TIMELIB_FORMAT_ESCAPE},
	{'h', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX},
	{'g', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED},
	{'H', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX},
	{'G', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED},
	{'a', TIMELIB_FORMAT_MERIDIAN},
	{'A', TIMELIB_FORMAT_MERIDIAN},
	{'u', TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT},
	{'v', TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT},
	{'i', TIMELIB_FORMAT_MINUTE_TWO_DIGIT},
	{'n', TIMELIB_FORMAT_MONTH_TWO_DIGIT},
	{'m', TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED},
	{'?', TIMELIB_FORMAT_RANDOM_CHAR},
	{'!', TIMELIB_FORMAT_RESET_ALL},
	{'|', TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET},
	{'s', TIMELIB_FORMAT_SECOND_TWO_DIGIT},
	{';', TIMELIB_FORMAT_SEPARATOR},
	{':', TIMELIB_FORMAT_SEPARATOR},
	{'/', TIMELIB_FORMAT_SEPARATOR},
	{'.', TIMELIB_FORMAT_SEPARATOR},
	{',', TIMELIB_FORMAT_SEPARATOR},
	{'-', TIMELIB_FORMAT_SEPARATOR},
	{'(', TIMELIB_FORMAT_SEPARATOR},
	{')', TIMELIB_FORMAT_SEPARATOR},
	{'*', TIMELIB_FORMAT_SKIP_TO_SEPARATOR},
	{'D', TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER},
	{'l', TIMELIB_FORMAT_TEXTUAL_DAY_FULL},
	{'M', TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER},
	{'F', TIMELIB_FORMAT_TEXTUAL_MONTH_FULL},
	{'e', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'P', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'T', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'O', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{' ', TIMELIB_FORMAT_WHITESPACE},
	{'y', TIMELIB_FORMAT_YEAR_TWO_DIGIT},
	{'Y', TIMELIB_FORMAT_YEAR_FOUR_DIGIT},
	{'\0', TIMELIB_FORMAT_END}
};

static const timelib_format_config default_format_config = {
	default_format_map,
	// No prefix required by default.
	'\0'
};

static timelib_format_specifier_code timelib_lookup_format(char input, const timelib_format_specifier* format_map)
{
	while (format_map && format_map->specifier != '\0') {
		if (format_map->specifier == input) {
			return format_map->code;
		}
		format_map++;
	}
	return TIMELIB_FORMAT_LITERAL;
}

timelib_time *timelib_parse_from_format(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	return timelib_parse_from_format_with_map(format, string, len, errors, tzdb, tz_get_wrapper, &default_format_config);
}

timelib_time *timelib_parse_from_format_with_map(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper, const timelib_format_config* format_config)
{
	char        *fptr = format;
	char        *ptr = string;
	char        *begin;
	timelib_sll  tmp;
	Scanner      in;
	Scanner     *s = &in;
	bool         allow_extra = false;
	bool         prefix_found = false;
	int          iso_year = TIMELIB_UNSET;
	int          iso_week_of_year = TIMELIB_UNSET;
	int          iso_day_of_week = TIMELIB_UNSET;
	char         prefix_char = format_config->prefix_char;
	const timelib_format_specifier *format_map = format_config->format_map;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;

		if (prefix_char) {
			/* There are 2 cases where the input string and format string
			 * should match the next literal:
			 *
			 * 1. No prefix has been specified yet in the format, so expect 1:1
			 *    match.
			 * 2. Sequential prefix characters indicating that the second
			 *    prefix is escaped. (e.g. "%%" is expecting literal "%")
			 */
			if ((!prefix_found && *fptr != prefix_char) ||
				(prefix_found && *fptr == prefix_char)) {
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_FORMAT_LITERAL_MISMATCH, "Format literal not found", string, begin);
				}
				ptr++;
				fptr++;
				prefix_found = false;
				continue;
			}

			if (*fptr == prefix_char) {
				fptr++;
				prefix_found = true;
				continue;
			}

			/* Fall through case is that the prefix has been found and the next
			 * character is the format specifier. */
			prefix_found = false;
		}

		switch (timelib_lookup_format(*fptr, format_map)) {
			case TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER: /* three letter day */
			case TIMELIB_FORMAT_TEXTUAL_DAY_FULL: /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_DAY, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case TIMELIB_FORMAT_DAY_TWO_DIGIT: /* two digit day, without leading zero */
			case TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED: /* two digit day, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_DAY, "A two digit day could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_DAY_SUFFIX: /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case TIMELIB_FORMAT_DAY_OF_YEAR: /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_DAY_OF_YEAR, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case TIMELIB_FORMAT_MONTH_TWO_DIGIT: /* two digit month, without leading zero */
			case TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED: /* two digit month, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MONTH, "A two digit month could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER: /* three letter month */
			case TIMELIB_FORMAT_TEXTUAL_MONTH_FULL: /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_MONTH, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case TIMELIB_FORMAT_YEAR_TWO_DIGIT: /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_YEAR, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case TIMELIB_FORMAT_YEAR_FOUR_DIGIT: /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "A four digit year could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX: /* two digit hour, without leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED: /* two digit hour, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, TIMELIB_ERR_HOUR_LARGER_THAN_12, "Hour can not be higher than 12", string, begin);
				}
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED: /* two digit hour, with leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX: /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_MERIDIAN: /* am/pm/a.m./p.m. AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_MERIDIAN, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case TIMELIB_FORMAT_MINUTE_TWO_DIGIT: /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MINUTE, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case TIMELIB_FORMAT_SECOND_TWO_DIGIT: /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_SECOND, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT: /* up to six digit microsecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_SIX_DIGIT_MICROSECOND, "A six digit microsecond could not be found", string, begin);
					} else {
						s->time->us = (f * pow(10, 6 - (ptr - tptr)));
					}
				}
				break;
			case TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT: /* up to three digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_MILLISECOND, "A three digit millisecond could not be found", string, begin);
					} else {
						s->time->us = (f * pow(10, 3 - (ptr - tptr)) * 1000);
					}
				}
				break;
			case TIMELIB_FORMAT_WHITESPACE: /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case TIMELIB_FORMAT_EPOCH_SECONDS: /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				break;
			case TIMELIB_FORMAT_ANY_SEPARATOR: /* separation symbol */
				if (timelib_lookup_format(*ptr, format_map) == TIMELIB_FORMAT_SEPARATOR) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case TIMELIB_FORMAT_SEPARATOR:
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol could not be found", string, begin);
				}
				break;

			case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RANDOM_CHAR: /* random char */
				++ptr;
				break;

			case TIMELIB_FORMAT_ESCAPE: /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, TIMELIB_ERR_EXPECTED_ESCAPE_CHAR, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_ESCAPED_CHAR, "The escaped character could not be found", string, begin);
				}
				break;

			case TIMELIB_FORMAT_SKIP_TO_SEPARATOR: /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS: /* allow extra chars in the format */
				allow_extra = true;
				break;
			case TIMELIB_FORMAT_YEAR_ISO:
				if ((iso_year = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR_ISO, "A four digit ISO year could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_WEEK_OF_YEAR_ISO:
				if ((iso_week_of_year = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_WEEK, "A two digit ISO week could not be found", string, begin);
				}
				/* Range is 1 - 53  for ISO week of year */
				if (iso_week_of_year < 1 || iso_week_of_year > 53) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_WEEK, "ISO Week must be between 1 and 53", string, begin);
				}
				break;
			case TIMELIB_FORMAT_DAY_OF_WEEK_ISO:
				if ((iso_day_of_week = timelib_get_nr((char **) &ptr, 1)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_DAY_OF_WEEK, "A single digit day of week could not be found", string, begin);
				}
				if (iso_day_of_week < 1 || iso_day_of_week > 7) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_DAY_OF_WEEK, "Day of week must be between 1 and 7", string, begin);
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET: /* timezone */
				{
					int tz_not_found;

					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database", string, begin);
					}
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET_MINUTES: /* timezone format +/-mmm */
				s->time->z = timelib_parse_tz_minutes((char **) &ptr, s->time);
				if (s->time->z == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_TZ_OFFSET, "Invalid timezone offset in minutes", string, begin);
				}
				break;
			case TIMELIB_FORMAT_LITERAL:
			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_WRONG_FORMAT_SEP, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, TIMELIB_WARN_TRAILING_DATA, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, TIMELIB_ERR_TRAILING_DATA, "Trailing data", string, ptr);
		}
	}

	if (*fptr) {
		/* Trailing reset specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (timelib_lookup_format(*fptr, format_map)) {
				case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;
				case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS:
					break;

				default:
					add_pbf_error(s, TIMELIB_ERR_DATA_MISSING, "Data missing", string, ptr);
					done = 1;
			}
			fptr++;
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET || s->time->us != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
		if (s->time->us == TIMELIB_UNSET ) {
			s->time->us = 0;
		}
	}

	/* Check for mixing of ISO dates with natural dates. */
	if (s->time->y != TIMELIB_UNSET && (iso_week_of_year != TIMELIB_UNSET || iso_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}
	if (iso_year != TIMELIB_UNSET && (s->time->y != TIMELIB_UNSET || s->time->m != TIMELIB_UNSET || s->time->d != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}

	/* Convert ISO values */
	if (iso_year != TIMELIB_UNSET) {
		/* Default week of year and day of week to 1. */
		if (iso_week_of_year == TIMELIB_UNSET) {
			iso_week_of_year = 1;
		}
		if (iso_day_of_week == TIMELIB_UNSET) {
			iso_day_of_week = 1;
		}
		timelib_date_from_isodate(iso_year, iso_week_of_year, iso_day_of_week, &s->time->y, &s->time->m, &s->time->d);
	} else if (iso_week_of_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->us = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->us == TIMELIB_UNSET) parsed->us = 0;
	} else {
		if (parsed->us == TIMELIB_UNSET) parsed->us = now->us != TIMELIB_UNSET ? now->us : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
