/*
 * "streamable kanji code filter and converter"
 * Copyright (c) 1998-2002 HappySize, Inc. All rights reserved.
 *
 * LICENSE NOTICES
 *
 * This file is part of "streamable kanji code filter and converter",
 * which is distributed under the terms of GNU Lesser General Public 
 * License (version 2) as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with "streamable kanji code filter and converter";
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 *
 * The author of this part: Maksym Veremeyenko <verem@m1.tv>
 *
 */

#ifndef UNICODE_TABLE_KOI8U_H
#define UNICODE_TABLE_KOI8U_H

/* KOI8-U (RFC2319) to Unicode */
static const unsigned short koi8u_ucs_table[] = {
 0x2500,    /* BOX DRAWINGS  LIGHT HORIZONTAL  */ 
 0x2502,    /* BOX DRAWINGS  LIGHT VERTICAL */ 
 0x250C,    /* BOX DRAWINGS  LIGHT DOWN AND RIGHT */ 
 0x2510,    /* BOX DRAWINGS  LIGHT DOWN AND LEFT */ 
 0x2514,    /* BOX DRAWINGS  LIGHT UP AND RIGHT */ 
 0x2518,    /* BOX DRAWINGS  LIGHT UP AND LEFT */ 
 0x251C,    /* BOX DRAWINGS  LIGHT VERTICAL AND RIGHT */ 
 0x2524,    /* BOX DRAWINGS  LIGHT VERTICAL AND LEFT */ 
 0x252C,    /* BOX DRAWINGS  LIGHT DOWN AND HORIZONTAL */ 
 0x2534,    /* BOX DRAWINGS  LIGHT UP AND HORIZONTAL */ 
 0x253C,    /* BOX DRAWINGS  LIGHT VERTICAL AND HORIZONTAL */ 
 0x2580,    /* UPPER HALF BLOCK */ 
 0x2584,    /* LOWER HALF BLOCK */ 
 0x2588,    /* FULL BLOCK */ 
 0x258C,    /* LEFT HALF BLOCK */ 
 0x2590,    /* RIGHT HALF BLOCK */ 
 0x2591,    /* LIGHT SHADE */ 
 0x2592,    /* MEDIUM SHADE */ 
 0x2593,    /* DARK SHADE */ 
 0x2320,    /* TOP HALF INTEGRAL */ 
 0x25A0,    /* BLACK SQUARE */ 
 0x2219,    /* BULLET OPERATOR */ 
 0x221A,    /* SQUARE ROOT */ 
 0x2248,    /* ALMOST EQUAL TO */ 
 0x2264,    /* LESS THAN OR EQUAL TO */ 
 0x2265,    /* GREATER THAN OR EQUAL TO */ 
 0x00A0,    /* NO-BREAK SPACE */ 
 0x2321,    /* BOTTOM HALF INTEGRAL */ 
 0x00B0,    /* DEGREE SIGN */ 
 0x00B2,    /* SUPERSCRIPT TWO */ 
 0x00B7,    /* MIDDLE DOT */ 
 0x00F7,    /* DIVISION SIGN */ 
 0x2550,    /* BOX DRAWINGS  DOUBLE HORIZONTAL */ 
 0x2551,    /* BOX DRAWINGS  DOUBLE VERTICAL */ 
 0x2552,    /* BOX DRAWINGS  DOWN SINGLE AND RIGHT DOUBLE */ 
 0x0451,    /* CYRILLIC SMALL LETTER IO */ 
 0x0454,    /* CYRILLIC SMALL LETTER UKRAINIAN IE */ 
 0x2554,    /* BOX DRAWINGS  DOUBLE DOWN AND RIGHT */ 
 0x0456,    /* CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */ 
 0x0457,    /* CYRILLIC SMALL LETTER YI (UKRAINIAN) */ 
 0x2557,    /* BOX DRAWINGS  DOUBLE DOWN AND LEFT */ 
 0x2558,    /* BOX DRAWINGS  UP SINGLE AND RIGHT DOUBLE */ 
 0x2559,    /* BOX DRAWINGS  UP DOUBLE AND RIGHT SINGLE */ 
 0x255A,    /* BOX DRAWINGS  DOUBLE UP AND RIGHT */ 
 0x255B,    /* BOX DRAWINGS  UP SINGLE AND LEFT DOUBLE */ 
 0x0491,    /* CYRILLIC SMALL LETTER GHE WITH UPTURN */ 
 0x255D,    /* BOX DRAWINGS  DOUBLE UP AND LEFT */ 
 0x255E,    /* BOX DRAWINGS  VERTICAL SINGLE AND RIGHT DOUBLE */ 
 0x255F,    /* BOX DRAWINGS  VERTICAL DOUBLE AND RIGHT SINGLE */ 
 0x2560,    /* BOX DRAWINGS  DOUBLE VERTICAL AND RIGHT */ 
 0x2561,    /* BOX DRAWINGS  VERTICAL SINGLE AND LEFT DOUBLE */ 
 0x0401,    /* CYRILLIC CAPITAL LETTER IO */ 
 0x0404,    /* CYRILLIC CAPITAL LETTER UKRAINIAN IE */ 
 0x2563,    /* BOX DRAWINGS DOUBLE VERTICAL AND LEFT */ 
 0x0406,    /* CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */ 
 0x0407,    /* CYRILLIC CAPITAL LETTER YI (UKRAINIAN) */ 
 0x2566,    /* BOX DRAWINGS  DOUBLE DOWN AND HORIZONTAL */ 
 0x2567,    /* BOX DRAWINGS  UP SINGLE AND HORIZONTAL DOUBLE */ 
 0x2568,    /* BOX DRAWINGS  UP DOUBLE AND HORIZONTAL SINGLE */ 
 0x2569,    /* BOX DRAWINGS  DOUBLE UP AND HORIZONTAL */ 
 0x256A,    /* BOX DRAWINGS  VERTICAL SINGLE AND HORIZONTAL DOUBLE */ 
 0x0490,    /* CYRILLIC CAPITAL LETTER GHE WITH UPTURN */ 
 0x256C,    /* BOX DRAWINGS  DOUBLE VERTICAL AND HORIZONTAL */ 
 0x00A9,    /* COPYRIGHT SIGN */ 
 0x044E,    /* CYRILLIC SMALL LETTER YU */ 
 0x0430,    /* CYRILLIC SMALL LETTER A */ 
 0x0431,    /* CYRILLIC SMALL LETTER BE */ 
 0x0446,    /* CYRILLIC SMALL LETTER TSE */ 
 0x0434,    /* CYRILLIC SMALL LETTER DE */ 
 0x0435,    /* CYRILLIC SMALL LETTER IE */ 
 0x0444,    /* CYRILLIC SMALL LETTER EF */ 
 0x0433,    /* CYRILLIC SMALL LETTER GHE */ 
 0x0445,    /* CYRILLIC SMALL LETTER KHA */ 
 0x0438,    /* CYRILLIC SMALL LETTER I */ 
 0x0439,    /* CYRILLIC SMALL LETTER SHORT I */ 
 0x043A,    /* CYRILLIC SMALL LETTER KA */ 
 0x043B,    /* CYRILLIC SMALL LETTER EL */ 
 0x043C,    /* CYRILLIC SMALL LETTER EM */ 
 0x043D,    /* CYRILLIC SMALL LETTER EN */ 
 0x043E,    /* CYRILLIC SMALL LETTER O */ 
 0x043F,    /* CYRILLIC SMALL LETTER PE */ 
 0x044F,    /* CYRILLIC SMALL LETTER YA */ 
 0x0440,    /* CYRILLIC SMALL LETTER ER */ 
 0x0441,    /* CYRILLIC SMALL LETTER ES */ 
 0x0442,    /* CYRILLIC SMALL LETTER TE */ 
 0x0443,    /* CYRILLIC SMALL LETTER U */ 
 0x0436,    /* CYRILLIC SMALL LETTER ZHE */ 
 0x0432,    /* CYRILLIC SMALL LETTER VE */ 
 0x044C,    /* CYRILLIC SMALL LETTER SOFT SIGN */ 
 0x044B,    /* CYRILLIC SMALL LETTER YERU */ 
 0x0437,    /* CYRILLIC SMALL LETTER ZE */ 
 0x0448,    /* CYRILLIC SMALL LETTER SHA */ 
 0x044D,    /* CYRILLIC SMALL LETTER E */ 
 0x0449,    /* CYRILLIC SMALL LETTER SHCHA */ 
 0x0447,    /* CYRILLIC SMALL LETTER CHE */ 
 0x044A,    /* CYRILLIC SMALL LETTER HARD SIGN */ 
 0x042E,    /* CYRILLIC CAPITAL LETTER YU */ 
 0x0410,    /* CYRILLIC CAPITAL LETTER A */ 
 0x0411,    /* CYRILLIC CAPITAL LETTER BE */ 
 0x0426,    /* CYRILLIC CAPITAL LETTER TSE */ 
 0x0414,    /* CYRILLIC CAPITAL LETTER DE */ 
 0x0415,    /* CYRILLIC CAPITAL LETTER IE */ 
 0x0424,    /* CYRILLIC CAPITAL LETTER EF */ 
 0x0413,    /* CYRILLIC CAPITAL LETTER GHE */ 
 0x0425,    /* CYRILLIC CAPITAL LETTER KHA */ 
 0x0418,    /* CYRILLIC CAPITAL LETTER I */ 
 0x0419,    /* CYRILLIC CAPITAL LETTER SHORT I */ 
 0x041A,    /* CYRILLIC CAPITAL LETTER KA */ 
 0x041B,    /* CYRILLIC CAPITAL LETTER EL */ 
 0x041C,    /* CYRILLIC CAPITAL LETTER EM */ 
 0x041D,    /* CYRILLIC CAPITAL LETTER EN */ 
 0x041E,    /* CYRILLIC CAPITAL LETTER O */ 
 0x041F,    /* CYRILLIC CAPITAL LETTER PE */ 
 0x042F,    /* CYRILLIC CAPITAL LETTER YA */ 
 0x0420,    /* CYRILLIC CAPITAL LETTER ER */ 
 0x0421,    /* CYRILLIC CAPITAL LETTER ES */ 
 0x0422,    /* CYRILLIC CAPITAL LETTER TE */ 
 0x0423,    /* CYRILLIC CAPITAL LETTER U */ 
 0x0416,    /* CYRILLIC CAPITAL LETTER ZHE */ 
 0x0412,    /* CYRILLIC CAPITAL LETTER VE */ 
 0x042C,    /* CYRILLIC CAPITAL LETTER SOFT SIGN */ 
 0x042B,    /* CYRILLIC CAPITAL LETTER YERU */ 
 0x0417,    /* CYRILLIC CAPITAL LETTER ZE */ 
 0x0428,    /* CYRILLIC CAPITAL LETTER SHA */ 
 0x042D,    /* CYRILLIC CAPITAL LETTER E */ 
 0x0429,    /* CYRILLIC CAPITAL LETTER SHCHA */ 
 0x0427,    /* CYRILLIC CAPITAL LETTER CHE */ 
 0x042A     /* CYRILLIC CAPITAL LETTER HARD SIGN */
};
static const int koi8u_ucs_table_min = 0x80;
static const int koi8u_ucs_table_len = (sizeof (koi8u_ucs_table) / sizeof (unsigned short));
static const int koi8u_ucs_table_max = 0x80 + (sizeof (koi8u_ucs_table) / sizeof (unsigned short));



#endif /* UNNICODE_TABLE_KOI8U_H */

