/* Generated by re2c 0.13.5 on Sun Aug 25 15:12:48 2013 */
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2013 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id$ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, "Double timezone specification") : add_warning(s, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static void add_pbf_warning(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_pbf_error(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	if (str[0] == ':') {
		str[0] = '.';
	}
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
           **ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

const static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (tp->full_tz_name && strcasecmp(word, tp->full_tz_name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}


	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/") || strcmp(tz_abbr, "UTC") == 0) {
			if ((res = tz_wrapper(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   0,   0,   0,   0,   0,   0, 
		  0,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   0,   0,   0,   0,   0, 
		  0,  24,  24,  24,  88,  24,  24,  24, 
		 88,  24,  24,  24,  24,  24,  88,  24, 
		 24,  24,  88,  88,  88,  24,  24,  24, 
		 24,  24,  24,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};

	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 31) YYFILL(31);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case 0x00:
	case '\n':	goto yy52;
	case '\t':
	case ' ':	goto yy49;
	case '(':	goto yy46;
	case '+':
	case '-':	goto yy31;
	case ',':
	case '.':	goto yy51;
	case '0':	goto yy26;
	case '1':	goto yy27;
	case '2':	goto yy28;
	case '3':	goto yy29;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy30;
	case '@':	goto yy12;
	case 'A':	goto yy37;
	case 'B':	goto yy18;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy47;
	case 'D':	goto yy41;
	case 'E':	goto yy22;
	case 'F':	goto yy14;
	case 'G':	goto yy45;
	case 'I':	goto yy32;
	case 'J':	goto yy35;
	case 'L':	goto yy16;
	case 'M':	goto yy8;
	case 'N':	goto yy6;
	case 'O':	goto yy39;
	case 'P':	goto yy24;
	case 'S':	goto yy20;
	case 'T':	goto yy10;
	case 'V':	goto yy33;
	case 'W':	goto yy43;
	case 'X':	goto yy34;
	case 'Y':	goto yy3;
	case 'a':	goto yy38;
	case 'b':	goto yy19;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy48;
	case 'd':	goto yy42;
	case 'e':	goto yy23;
	case 'f':	goto yy15;
	case 'j':	goto yy36;
	case 'l':	goto yy17;
	case 'm':	goto yy9;
	case 'n':	goto yy7;
	case 'o':	goto yy40;
	case 'p':	goto yy25;
	case 's':	goto yy21;
	case 't':	goto yy11;
	case 'w':	goto yy44;
	case 'y':	goto yy5;
	default:	goto yy54;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l') {
			s->time->relative.first_last_day_of = 2;
		} else {
			s->time->relative.first_last_day_of = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy3:
	YYDEBUG(3, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy141;
			goto yy1523;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych >= 'a') goto yy146;
		} else {
			if (yych <= 'e') goto yy1532;
			if (yych <= 'z') goto yy146;
		}
	}
yy4:
	YYDEBUG(4, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy141;
			goto yy1523;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1523;
			if (yych <= 'z') goto yy141;
			goto yy4;
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1494;
				goto yy141;
			} else {
				if (yych <= 'I') goto yy1495;
				if (yych <= 'N') goto yy141;
				goto yy1493;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy4;
			} else {
				if (yych == 'e') goto yy1510;
				goto yy146;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1511;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy1509;
				if (yych <= 'z') goto yy146;
				goto yy4;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1494;
				goto yy141;
			} else {
				if (yych <= 'I') goto yy1495;
				if (yych <= 'N') goto yy141;
				goto yy1493;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy4;
			} else {
				if (yych == 'e') goto yy1494;
				goto yy141;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1495;
				goto yy141;
			} else {
				if (yych <= 'o') goto yy1493;
				if (yych <= 'z') goto yy141;
				goto yy4;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy1463;
		} else {
			if (yych == 'I') goto yy1464;
			if (yych <= 'N') goto yy141;
			goto yy1465;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1478;
			goto yy146;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1479;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy1480;
				if (yych <= 'z') goto yy146;
				goto yy4;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy1463;
		} else {
			if (yych == 'I') goto yy1464;
			if (yych <= 'N') goto yy141;
			goto yy1465;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1463;
			goto yy141;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1464;
				goto yy141;
			} else {
				if (yych <= 'o') goto yy1465;
				if (yych <= 'z') goto yy141;
				goto yy4;
			}
		}
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case ')':	goto yy140;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'E':	goto yy1388;
	case 'H':	goto yy1389;
	case 'O':	goto yy1390;
	case 'U':	goto yy1391;
	case 'W':	goto yy1392;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'e':	goto yy1431;
	case 'h':	goto yy1432;
	case 'o':	goto yy1433;
	case 'u':	goto yy1434;
	case 'w':	goto yy1435;
	default:	goto yy4;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case ')':	goto yy140;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'E':
	case 'e':	goto yy1388;
	case 'H':
	case 'h':	goto yy1389;
	case 'O':
	case 'o':	goto yy1390;
	case 'U':
	case 'u':	goto yy1391;
	case 'W':
	case 'w':	goto yy1392;
	default:	goto yy4;
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1384;
	if (yych <= '/') goto yy13;
	if (yych <= '9') goto yy1385;
yy13:
	YYDEBUG(13, *YYCURSOR);
	{
		add_error(s, "Unexpected character");
		goto std;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych <= '@') goto yy4;
				if (yych <= 'D') goto yy141;
				goto yy1320;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1321;
				goto yy141;
			} else {
				if (yych <= 'O') goto yy1322;
				if (yych <= 'Q') goto yy141;
				goto yy1323;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy141;
				if (yych <= '`') goto yy4;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1361;
				if (yych <= 'h') goto yy146;
				goto yy1362;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1363;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy1364;
				if (yych <= 'z') goto yy146;
				goto yy4;
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych <= '@') goto yy4;
				if (yych <= 'D') goto yy141;
				goto yy1320;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1321;
				goto yy141;
			} else {
				if (yych <= 'O') goto yy1322;
				if (yych <= 'Q') goto yy141;
				goto yy1323;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy141;
				if (yych <= '`') goto yy4;
				goto yy141;
			} else {
				if (yych <= 'e') goto yy1320;
				if (yych <= 'h') goto yy141;
				goto yy1321;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1322;
				goto yy141;
			} else {
				if (yych <= 'r') goto yy1323;
				if (yych <= 'z') goto yy141;
				goto yy4;
			}
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
		goto yy1307;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1317;
			if (yych <= 'z') goto yy146;
			goto yy4;
		}
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
		goto yy1307;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1307;
			if (yych <= 'z') goto yy141;
			goto yy4;
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
		goto yy1287;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1304;
			if (yych <= 'z') goto yy146;
			goto yy4;
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
		goto yy1287;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1287;
			if (yych <= 'z') goto yy141;
			goto yy4;
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych <= '@') goto yy4;
				if (yych <= 'A') goto yy1230;
				goto yy141;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1229;
				goto yy141;
			} else {
				if (yych <= 'I') goto yy1231;
				if (yych <= 'T') goto yy141;
				goto yy1232;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy4;
			} else {
				if (yych <= 'a') goto yy1259;
				if (yych <= 'd') goto yy146;
				goto yy1258;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1260;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy1261;
				if (yych <= 'z') goto yy146;
				goto yy4;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych <= '@') goto yy4;
				if (yych <= 'A') goto yy1230;
				goto yy141;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1229;
				goto yy141;
			} else {
				if (yych <= 'I') goto yy1231;
				if (yych <= 'T') goto yy141;
				goto yy1232;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy4;
			} else {
				if (yych <= 'a') goto yy1230;
				if (yych <= 'd') goto yy141;
				goto yy1229;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1231;
				goto yy141;
			} else {
				if (yych <= 'u') goto yy1232;
				if (yych <= 'z') goto yy141;
				goto yy4;
			}
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == 'I') goto yy1199;
			if (yych <= 'K') goto yy141;
			goto yy1200;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			if (yych <= 'h') goto yy146;
			goto yy1217;
		} else {
			if (yych == 'l') goto yy1218;
			if (yych <= 'z') goto yy146;
			goto yy4;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == 'I') goto yy1199;
			if (yych <= 'K') goto yy141;
			goto yy1200;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			if (yych <= 'h') goto yy141;
			goto yy1199;
		} else {
			if (yych == 'l') goto yy1200;
			if (yych <= 'z') goto yy141;
			goto yy4;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'Q') goto yy141;
			goto yy1098;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy146;
		} else {
			if (yych <= 'r') goto yy1192;
			if (yych <= 'z') goto yy146;
			goto yy4;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'Q') goto yy141;
			goto yy1098;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy1098;
			if (yych <= 'z') goto yy141;
			goto yy4;
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy1052;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy1054;
	case '-':	goto yy473;
	case '.':	goto yy1064;
	case '/':	goto yy472;
	case '0':	goto yy1097;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1096;
	case ':':	goto yy1065;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy460;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy462;
	case '-':	goto yy473;
	case '.':	goto yy474;
	case '/':	goto yy472;
	case '0':
	case '1':
	case '2':	goto yy1096;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1063;
	case ':':	goto yy483;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy460;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy462;
	case '-':	goto yy473;
	case '.':	goto yy474;
	case '/':	goto yy472;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1063;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1050;
	case ':':	goto yy483;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy460;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy462;
	case '-':	goto yy473;
	case '.':	goto yy474;
	case '/':	goto yy472;
	case '0':
	case '1':	goto yy1050;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy469;
	case ':':	goto yy483;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy460;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy462;
	case '-':	goto yy473;
	case '.':	goto yy474;
	case '/':	goto yy472;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy469;
	case ':':	goto yy483;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy58;
	}
	YYDEBUG(-1, yych);
	switch (yych) {
	case '+':
	case '-':	goto yy440;
	case '0':
	case '1':	goto yy437;
	case '2':	goto yy438;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy439;
	default:	goto yy13;
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy4;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy4;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy4;
			} else {
				if (yych == '/') goto yy4;
				goto yy196;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy4;
				goto yy141;
			} else {
				if (yych <= 'I') goto yy436;
				if (yych <= 'U') goto yy141;
				goto yy435;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy435;
				goto yy141;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy146;
				goto yy4;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy4;
			goto yy196;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy196;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy4;
			if (yych <= '9') goto yy196;
			if (yych <= '@') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy432;
				goto yy141;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy146;
				goto yy4;
			}
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy4;
			goto yy196;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy196;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy4;
			if (yych <= '9') goto yy196;
			if (yych <= '@') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy430;
				goto yy141;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy146;
				goto yy4;
			}
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych <= 'A') goto yy413;
			if (yych <= 'T') goto yy141;
			goto yy412;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy422;
		} else {
			if (yych == 'u') goto yy421;
			if (yych <= 'z') goto yy146;
			goto yy4;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych <= 'A') goto yy413;
			if (yych <= 'T') goto yy141;
			goto yy412;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy413;
		} else {
			if (yych == 'u') goto yy412;
			if (yych <= 'z') goto yy141;
			goto yy4;
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy391;
				goto yy141;
			} else {
				if (yych <= 'P') goto yy390;
				if (yych <= 'T') goto yy141;
				goto yy389;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy4;
			} else {
				if (yych == 'g') goto yy403;
				goto yy146;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy402;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy401;
				if (yych <= 'z') goto yy146;
				goto yy4;
			}
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy391;
				goto yy141;
			} else {
				if (yych <= 'P') goto yy390;
				if (yych <= 'T') goto yy141;
				goto yy389;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy4;
			} else {
				if (yych == 'g') goto yy391;
				goto yy141;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy390;
				goto yy141;
			} else {
				if (yych <= 'u') goto yy389;
				if (yych <= 'z') goto yy141;
				goto yy4;
			}
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'B') goto yy141;
			goto yy379;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy146;
		} else {
			if (yych <= 'c') goto yy384;
			if (yych <= 'z') goto yy146;
			goto yy4;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'B') goto yy141;
			goto yy379;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'c') goto yy379;
			if (yych <= 'z') goto yy141;
			goto yy4;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy141;
			goto yy192;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy146;
		} else {
			if (yych <= 'e') goto yy370;
			if (yych <= 'z') goto yy146;
			goto yy4;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy141;
			goto yy192;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy192;
			if (yych <= 'z') goto yy141;
			goto yy4;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy141;
			goto yy165;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy146;
		} else {
			if (yych <= 'e') goto yy179;
			if (yych <= 'z') goto yy146;
			goto yy4;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy141;
			goto yy165;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy4;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy165;
			if (yych <= 'z') goto yy141;
			goto yy4;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
		goto yy141;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy157;
			goto yy141;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy146;
			goto yy4;
		}
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy13;
	if (yych <= 'Z') goto yy156;
	if (yych <= '`') goto yy13;
	if (yych <= 'z') goto yy156;
	goto yy13;
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy4;
		if (yych <= 'z') goto yy146;
		goto yy4;
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy4;
		if (yych <= 'z') goto yy141;
		goto yy4;
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy58;
	}
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy55;
yy50:
	YYDEBUG(50, *YYCURSOR);
	{
		goto std;
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy50;
yy52:
	YYDEBUG(52, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(53, *YYCURSOR);
	{
		s->pos = cursor; s->line++;
		goto std;
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy13;
yy55:
	YYDEBUG(55, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(56, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy55;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy65;
				if (yych >= 'F') goto yy66;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy64;
				if (yych >= 'M') goto yy63;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy62;
				} else {
					if (yych <= 'T') goto yy69;
					if (yych >= 'W') goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy67;
				if (yych >= 'd') goto yy65;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy66;
				} else {
					if (yych == 'h') goto yy64;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy63;
				if (yych <= 'r') goto yy57;
				if (yych <= 's') goto yy62;
				goto yy69;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy68;
				} else {
					if (yych == 'y') goto yy67;
				}
			}
		}
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept <= 0) {
							goto yy4;
						} else {
							goto yy13;
						}
					} else {
						goto yy50;
					}
				} else {
					if (yyaccept <= 3) {
						goto yy73;
					} else {
						goto yy167;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept <= 5) {
						goto yy194;
					} else {
						goto yy199;
					}
				} else {
					if (yyaccept <= 7) {
						goto yy223;
					} else {
						goto yy295;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept <= 9) {
						goto yy393;
					} else {
						goto yy476;
					}
				} else {
					if (yyaccept <= 11) {
						goto yy491;
					} else {
						goto yy612;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept <= 13) {
						goto yy657;
					} else {
						goto yy667;
					}
				} else {
					if (yyaccept <= 15) {
						goto yy764;
					} else {
						goto yy784;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept <= 17) {
							goto yy815;
						} else {
							goto yy822;
						}
					} else {
						goto yy849;
					}
				} else {
					if (yyaccept <= 20) {
						goto yy794;
					} else {
						goto yy455;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept <= 22) {
						goto yy974;
					} else {
						goto yy843;
					}
				} else {
					if (yyaccept <= 24) {
						goto yy1068;
					} else {
						goto yy1076;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept <= 26) {
						goto yy1118;
					} else {
						goto yy1142;
					}
				} else {
					if (yyaccept <= 28) {
						goto yy1295;
					} else {
						goto yy1417;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept <= 30) {
						goto yy1420;
					} else {
						goto yy1500;
					}
				} else {
					if (yyaccept <= 32) {
						goto yy1508;
					} else {
						goto yy1531;
					}
				}
			}
		}
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(59, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy58;
	}
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy55;
	goto yy57;
yy60:
	YYDEBUG(60, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy61:
	YYDEBUG(61, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy57;
				goto yy60;
			} else {
				if (yych == 'D') goto yy65;
				if (yych <= 'E') goto yy57;
				goto yy66;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy64;
				if (yych <= 'L') goto yy57;
				goto yy63;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy57;
				} else {
					if (yych <= 'T') goto yy69;
					if (yych <= 'V') goto yy57;
					goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy67;
				if (yych <= 'c') goto yy57;
				goto yy65;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy57;
					goto yy66;
				} else {
					if (yych == 'h') goto yy64;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy63;
				if (yych <= 'r') goto yy57;
				if (yych >= 't') goto yy69;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy57;
					goto yy68;
				} else {
					if (yych == 'y') goto yy67;
					goto yy57;
				}
			}
		}
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy127;
			goto yy57;
		} else {
			if (yych <= 'E') goto yy128;
			if (yych <= 'T') goto yy57;
			goto yy126;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy127;
			goto yy57;
		} else {
			if (yych <= 'e') goto yy128;
			if (yych == 'u') goto yy126;
			goto yy57;
		}
	}
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy118;
		if (yych <= 'N') goto yy57;
		goto yy117;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy57;
			goto yy118;
		} else {
			if (yych == 'o') goto yy117;
			goto yy57;
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy115;
	if (yych == 'o') goto yy115;
	goto yy57;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy114;
	if (yych == 'a') goto yy114;
	goto yy57;
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy99;
		if (yych <= 'Q') goto yy57;
		goto yy98;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy57;
			goto yy99;
		} else {
			if (yych == 'r') goto yy98;
			goto yy57;
		}
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy95;
	if (yych == 'e') goto yy95;
	goto yy57;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy83;
	if (yych == 'e') goto yy83;
	goto yy57;
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy70;
		if (yych <= 'T') goto yy57;
		goto yy71;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy57;
		} else {
			if (yych == 'u') goto yy71;
			goto yy57;
		}
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy78;
	if (yych == 'u') goto yy78;
	goto yy57;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy72;
	if (yych != 'e') goto yy57;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy74;
	if (yych == 's') goto yy74;
yy73:
	YYDEBUG(73, *YYCURSOR);
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy75;
	if (yych != 'd') goto yy57;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy76;
	if (yych != 'a') goto yy57;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy77;
	if (yych != 'y') goto yy57;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy73;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy79;
	if (yych != 'r') goto yy73;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy80;
	if (yych != 's') goto yy57;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy81;
	if (yych != 'd') goto yy57;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy82;
	if (yych != 'a') goto yy57;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy77;
	if (yych == 'y') goto yy77;
	goto yy57;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy57;
		if (yych <= 'D') goto yy85;
	} else {
		if (yych <= 'c') goto yy57;
		if (yych <= 'd') goto yy85;
		if (yych >= 'f') goto yy57;
	}
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy91;
	if (yych == 'k') goto yy91;
	goto yy57;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy86;
	if (yych != 'n') goto yy73;
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy87;
	if (yych != 'e') goto yy57;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy88;
	if (yych != 's') goto yy57;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy89;
	if (yych != 'd') goto yy57;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy90;
	if (yych != 'a') goto yy57;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy77;
	if (yych == 'y') goto yy77;
	goto yy57;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy92;
		if (yych <= 'R') goto yy73;
		goto yy77;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy73;
		} else {
			if (yych == 's') goto yy77;
			goto yy73;
		}
	}
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy93;
	if (yych != 'a') goto yy57;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy94;
	if (yych != 'y') goto yy57;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy77;
	if (yych == 's') goto yy77;
	goto yy73;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy96;
	if (yych != 'a') goto yy57;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy97;
	if (yych != 'r') goto yy57;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy77;
	if (yych == 's') goto yy77;
	goto yy73;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy111;
	if (yych == 'i') goto yy111;
	goto yy57;
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy100;
	if (yych != 'r') goto yy57;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy101;
	if (yych != 't') goto yy57;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy103;
		if (yych <= 'M') goto yy57;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy57;
			goto yy103;
		} else {
			if (yych != 'n') goto yy57;
		}
	}
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy108;
	if (yych == 'i') goto yy108;
	goto yy57;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy104;
	if (yych != 'n') goto yy57;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy105;
	if (yych != 'i') goto yy57;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy106;
	if (yych != 'g') goto yy57;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy107;
	if (yych != 'h') goto yy57;
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy97;
	if (yych == 't') goto yy97;
	goto yy57;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy109;
	if (yych != 'g') goto yy57;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy110;
	if (yych != 'h') goto yy57;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy97;
	if (yych == 't') goto yy97;
	goto yy57;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy112;
	if (yych != 'd') goto yy73;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy113;
	if (yych != 'a') goto yy57;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy77;
	if (yych == 'y') goto yy77;
	goto yy57;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy97;
	if (yych == 'y') goto yy97;
	goto yy57;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy116;
	if (yych != 'u') goto yy57;
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy97;
	if (yych == 'r') goto yy97;
	goto yy57;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy122;
	if (yych == 'n') goto yy122;
	goto yy57;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy119;
	if (yych != 'n') goto yy57;
yy119:
	YYDEBUG(119, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy77;
		if (yych <= 'T') goto yy73;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy73;
			goto yy77;
		} else {
			if (yych != 'u') goto yy73;
		}
	}
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy121;
	if (yych != 't') goto yy57;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy97;
	if (yych == 'e') goto yy97;
	goto yy57;
yy122:
	YYDEBUG(122, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy123;
		if (yych <= 'S') goto yy73;
		goto yy124;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy73;
		} else {
			if (yych == 't') goto yy124;
			goto yy73;
		}
	}
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy125;
	if (yych == 'a') goto yy125;
	goto yy57;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy97;
	if (yych == 'h') goto yy97;
	goto yy57;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy77;
	if (yych == 'y') goto yy77;
	goto yy57;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy137;
	if (yych == 'n') goto yy137;
	goto yy57;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy132;
	if (yych == 't') goto yy132;
	goto yy57;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy129;
	if (yych != 'c') goto yy57;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy130;
		if (yych <= 'R') goto yy73;
		goto yy77;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy73;
		} else {
			if (yych == 's') goto yy77;
			goto yy73;
		}
	}
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy131;
	if (yych != 'n') goto yy57;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy97;
	if (yych == 'd') goto yy97;
	goto yy57;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy133;
	if (yych != 'u') goto yy73;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy134;
	if (yych != 'r') goto yy57;
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy135;
	if (yych != 'd') goto yy57;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy136;
	if (yych != 'a') goto yy57;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy77;
	if (yych == 'y') goto yy77;
	goto yy57;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy138;
	if (yych != 'd') goto yy73;
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy139;
	if (yych != 'a') goto yy57;
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy77;
	if (yych == 'y') goto yy77;
	goto yy57;
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy4;
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy4;
		if (yych >= '{') goto yy4;
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy4;
		if (yych >= '{') goto yy4;
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy4;
		if (yych >= '{') goto yy4;
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Z') goto yy145;
		if (yych <= '`') goto yy4;
		if (yych >= '{') goto yy4;
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy140;
	goto yy4;
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			goto yy148;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy4;
			if (yych <= 'Z') goto yy142;
			goto yy4;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy4;
			if (yych >= '{') goto yy4;
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy4;
			if (yych <= 'Z') goto yy143;
			goto yy4;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy151;
			goto yy4;
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy149;
	}
	goto yy57;
yy149:
	YYDEBUG(149, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(150, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy149;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy148;
		goto yy4;
	} else {
		if (yych <= '/') goto yy148;
		if (yych == '_') goto yy148;
		goto yy4;
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			goto yy148;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy4;
			if (yych <= 'Z') goto yy144;
			goto yy4;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy4;
			if (yych >= '{') goto yy4;
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			goto yy148;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy4;
			if (yych <= 'Z') goto yy145;
			goto yy4;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy4;
			if (yych >= '{') goto yy4;
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy140;
		if (yych <= ',') goto yy4;
		goto yy148;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy4;
			goto yy148;
		} else {
			if (yych == '_') goto yy148;
			goto yy4;
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy155:
	YYDEBUG(155, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy148;
		goto yy57;
	} else {
		if (yych <= '/') goto yy148;
		if (yych == '_') goto yy148;
		goto yy57;
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy4;
		if (yych <= 'z') goto yy141;
		goto yy4;
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
		goto yy142;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy142;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
	YYDEBUG(158, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych != '+') goto yy4;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy159;
			if (yych <= '@') goto yy4;
			goto yy143;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy160;
	if (yych <= '2') goto yy161;
	if (yych <= '9') goto yy162;
	goto yy57;
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy4;
	if (yych <= '9') goto yy162;
	if (yych <= ':') goto yy163;
	goto yy4;
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy4;
		if (yych >= '5') goto yy164;
	} else {
		if (yych <= '9') goto yy140;
		if (yych <= ':') goto yy163;
		goto yy4;
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy4;
	if (yych <= '5') goto yy164;
	if (yych <= '9') goto yy140;
	if (yych >= ';') goto yy4;
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy4;
	if (yych <= '5') goto yy164;
	if (yych <= '9') goto yy140;
	goto yy4;
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy4;
	if (yych <= '9') goto yy140;
	goto yy4;
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych <= 'C') goto yy142;
			if (yych >= 'E') goto yy168;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy166;
			if (yych <= 'e') goto yy168;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy140;
		} else {
			if (yych <= '@') goto yy167;
			if (yych <= 'M') goto yy143;
			goto yy174;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych >= 'a') goto yy143;
		} else {
			if (yych <= 'n') goto yy174;
			if (yych <= 'z') goto yy143;
		}
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'J') goto yy143;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'k') goto yy169;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy170;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy145;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy171;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Y') goto yy172;
		if (yych != 'y') goto yy4;
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy173;
	if (yych != 's') goto yy167;
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy167;
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy144;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'e') goto yy175;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'R') goto yy145;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 's') goto yy176;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'D') goto yy177;
		if (yych != 'd') goto yy4;
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy178;
	if (yych != 'a') goto yy57;
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy173;
	if (yych == 'y') goto yy173;
	goto yy57;
yy179:
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy4;
				goto yy148;
			} else {
				if (yych <= '@') goto yy4;
				if (yych <= 'C') goto yy142;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy168;
				goto yy142;
			} else {
				if (yych == '_') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy147;
			} else {
				if (yych <= 'e') goto yy181;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy167;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy167;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy174;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy167;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy167;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy187;
				if (yych <= 'z') goto yy151;
				goto yy167;
			}
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy169;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'k') goto yy182;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy170;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy183;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy171;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy184;
			if (yych <= 'z') goto yy153;
			goto yy4;
		}
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy172;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'y') goto yy185;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy148;
			goto yy167;
		} else {
			if (yych <= '/') goto yy148;
			if (yych <= 'R') goto yy167;
			goto yy173;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy148;
			goto yy167;
		} else {
			if (yych == 's') goto yy186;
			if (yych <= 'z') goto yy154;
			goto yy167;
		}
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy148;
		goto yy167;
	} else {
		if (yych <= '/') goto yy148;
		if (yych == '_') goto yy148;
		goto yy167;
	}
yy187:
	YYDEBUG(187, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'e') goto yy188;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy176;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 's') goto yy189;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy189:
	YYDEBUG(189, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy177;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'd') goto yy190;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy178;
	if (yych != 'a') goto yy155;
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy173;
	if (yych == 'y') goto yy186;
	goto yy155;
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'B') goto yy142;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'c') goto yy193;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy196;
			} else {
				if (yych == ' ') goto yy196;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
			} else {
				if (yych == 'E') goto yy202;
				goto yy143;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy143;
			} else {
				if (yych <= 'e') goto yy202;
				if (yych <= 'z') goto yy143;
			}
		}
	}
yy194:
	YYDEBUG(194, *YYCURSOR);
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy195:
	YYDEBUG(195, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 21) YYFILL(21);
	yych = *YYCURSOR;
yy196:
	YYDEBUG(196, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy195;
	}
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy198;
	if (yych <= '3') goto yy200;
	if (yych <= '9') goto yy201;
	goto yy57;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy196;
	if (yych <= '0') goto yy357;
	if (yych <= '2') goto yy358;
	if (yych <= '3') goto yy359;
	goto yy196;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy216;
			if (yych <= '0') goto yy298;
			goto yy299;
		} else {
			if (yych <= '2') goto yy355;
			if (yych <= '9') goto yy356;
			goto yy216;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy212;
			if (yych <= 'q') goto yy216;
			goto yy213;
		} else {
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy199:
	YYDEBUG(199, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy216;
			if (yych <= '0') goto yy298;
			goto yy299;
		} else {
			if (yych <= '2') goto yy209;
			if (yych <= '9') goto yy210;
			goto yy216;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy212;
			if (yych <= 'q') goto yy216;
			goto yy213;
		} else {
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy201:
	YYDEBUG(201, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy216;
			if (yych <= '0') goto yy207;
			goto yy208;
		} else {
			if (yych <= '2') goto yy209;
			if (yych <= '9') goto yy210;
			goto yy216;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy212;
			if (yych <= 'q') goto yy216;
			goto yy213;
		} else {
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'L') goto yy144;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'm') goto yy203;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'A') goto yy145;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'b') goto yy204;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy204:
	YYDEBUG(204, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'E') goto yy205;
		if (yych != 'e') goto yy4;
	}
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy206;
	if (yych != 'r') goto yy57;
yy206:
	YYDEBUG(206, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy196;
		if (yych <= 0x1F) goto yy194;
		goto yy196;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy194;
			goto yy196;
		} else {
			if (yych <= '/') goto yy194;
			if (yych <= '9') goto yy196;
			goto yy194;
		}
	}
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy221;
		goto yy57;
	} else {
		if (yych <= '0') goto yy296;
		if (yych <= '9') goto yy297;
		if (yych <= ':') goto yy221;
		goto yy57;
	}
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy57;
	} else {
		if (yych <= '2') goto yy297;
		if (yych <= '9') goto yy296;
		if (yych <= ':') goto yy264;
		goto yy57;
	}
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy57;
	} else {
		if (yych <= '4') goto yy296;
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy264;
		goto yy57;
	}
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy57;
	} else {
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy264;
		goto yy57;
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy216;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy216;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy216;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy216;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy216:
	YYDEBUG(216, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy215;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy199;
		if (yych <= '0') goto yy259;
		if (yych <= '1') goto yy260;
		goto yy261;
	} else {
		if (yych <= '9') goto yy262;
		if (yych != 'T') goto yy199;
	}
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy218;
	if (yych <= '2') goto yy219;
	if (yych <= '9') goto yy220;
	goto yy57;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy221;
		goto yy57;
	} else {
		if (yych <= '9') goto yy220;
		if (yych <= ':') goto yy221;
		goto yy57;
	}
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy221;
		goto yy57;
	} else {
		if (yych <= '4') goto yy220;
		if (yych == ':') goto yy221;
		goto yy57;
	}
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy221;
	if (yych != ':') goto yy57;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy222;
	if (yych <= '9') goto yy224;
	goto yy57;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy225;
	} else {
		if (yych <= '9') goto yy224;
		if (yych <= ':') goto yy225;
	}
yy223:
	YYDEBUG(223, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy224:
	YYDEBUG(224, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy225;
	if (yych != ':') goto yy223;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy226;
	if (yych <= '6') goto yy227;
	if (yych <= '9') goto yy228;
	goto yy57;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '9') goto yy229;
	goto yy223;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy229;
	goto yy223;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy223;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy231;
			goto yy223;
		} else {
			if (yych <= ' ') goto yy231;
			if (yych == '(') goto yy231;
			goto yy223;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy223;
			if (yych <= '-') goto yy231;
			goto yy223;
		} else {
			if (yych <= 'Z') goto yy231;
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy231;
			goto yy223;
		}
	}
yy230:
	YYDEBUG(230, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy231:
	YYDEBUG(231, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy57;
			goto yy230;
		} else {
			if (yych == '(') goto yy234;
			if (yych <= '*') goto yy57;
			goto yy233;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy233;
			if (yych <= '@') goto yy57;
			goto yy235;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'H') goto yy235;
			} else {
				if (yych <= '`') goto yy57;
				if (yych <= 'z') goto yy236;
				goto yy57;
			}
		}
	}
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy228;
		if (yych <= '@') goto yy223;
		goto yy237;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy257;
			goto yy237;
		} else {
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy242;
			goto yy223;
		}
	}
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy252;
	if (yych <= '2') goto yy253;
	if (yych <= '9') goto yy254;
	goto yy57;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy57;
	if (yych <= 'Z') goto yy236;
	if (yych <= '`') goto yy57;
	if (yych <= 'z') goto yy236;
	goto yy57;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy228;
		goto yy223;
	} else {
		if (yych <= 'Z') goto yy237;
		if (yych <= '`') goto yy223;
		if (yych <= 'z') goto yy242;
		goto yy223;
	}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy228;
		goto yy223;
	} else {
		if (yych <= 'Z') goto yy237;
		if (yych <= '`') goto yy223;
		if (yych >= '{') goto yy223;
	}
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy228;
		goto yy223;
	} else {
		if (yych <= 'Z') goto yy238;
		if (yych <= '`') goto yy223;
		if (yych >= '{') goto yy223;
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy228;
		goto yy223;
	} else {
		if (yych <= 'Z') goto yy239;
		if (yych <= '`') goto yy223;
		if (yych >= '{') goto yy223;
	}
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy228;
		goto yy223;
	} else {
		if (yych <= 'Z') goto yy240;
		if (yych <= '`') goto yy223;
		if (yych >= '{') goto yy223;
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy228;
		goto yy223;
	} else {
		if (yych <= 'Z') goto yy241;
		if (yych <= '`') goto yy223;
		if (yych >= '{') goto yy223;
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy228;
	goto yy223;
yy242:
	YYDEBUG(242, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych == '.') goto yy223;
			goto yy244;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy223;
			if (yych <= 'Z') goto yy238;
			goto yy223;
		} else {
			if (yych <= '_') goto yy244;
			if (yych <= '`') goto yy223;
			if (yych >= '{') goto yy223;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych == '.') goto yy223;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy223;
			if (yych <= 'Z') goto yy239;
			goto yy223;
		} else {
			if (yych <= '_') goto yy244;
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy247;
			goto yy223;
		}
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy57;
	if (yych <= 'Z') goto yy245;
	if (yych <= '`') goto yy57;
	if (yych >= '{') goto yy57;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(246, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy223;
			goto yy244;
		} else {
			if (yych == '/') goto yy244;
			goto yy223;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy245;
			if (yych <= '^') goto yy223;
			goto yy244;
		} else {
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy245;
			goto yy223;
		}
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych == '.') goto yy223;
			goto yy244;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy223;
			if (yych <= 'Z') goto yy240;
			goto yy223;
		} else {
			if (yych <= '_') goto yy244;
			if (yych <= '`') goto yy223;
			if (yych >= '{') goto yy223;
		}
	}
	YYDEBUG(248, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych == '.') goto yy223;
			goto yy244;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy223;
			if (yych <= 'Z') goto yy241;
			goto yy223;
		} else {
			if (yych <= '_') goto yy244;
			if (yych <= '`') goto yy223;
			if (yych >= '{') goto yy223;
		}
	}
	YYDEBUG(249, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy223;
			goto yy228;
		} else {
			if (yych == '-') goto yy244;
			goto yy223;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy244;
			if (yych <= '^') goto yy223;
			goto yy244;
		} else {
			if (yych <= '`') goto yy223;
			if (yych >= '{') goto yy223;
		}
	}
yy250:
	YYDEBUG(250, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(251, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy244;
		if (yych <= '.') goto yy57;
		goto yy244;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy57;
			goto yy244;
		} else {
			if (yych <= '`') goto yy57;
			if (yych <= 'z') goto yy250;
			goto yy57;
		}
	}
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '9') goto yy254;
	if (yych <= ':') goto yy255;
	goto yy223;
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy223;
		if (yych >= '5') goto yy256;
	} else {
		if (yych <= '9') goto yy228;
		if (yych <= ':') goto yy255;
		goto yy223;
	}
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '5') goto yy256;
	if (yych <= '9') goto yy228;
	if (yych >= ';') goto yy223;
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '5') goto yy256;
	if (yych <= '9') goto yy228;
	goto yy223;
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '9') goto yy228;
	goto yy223;
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy228;
		if (yych <= '@') goto yy223;
		goto yy238;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy238;
		} else {
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy238;
			goto yy223;
		}
	}
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy223;
			goto yy228;
		} else {
			if (yych == '+') goto yy233;
			goto yy223;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy233;
			if (yych <= '@') goto yy223;
			goto yy239;
		} else {
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy239;
			goto yy223;
		}
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy221;
		goto yy199;
	} else {
		if (yych <= '0') goto yy291;
		if (yych <= '9') goto yy292;
		if (yych <= ':') goto yy221;
		goto yy199;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy199;
	} else {
		if (yych <= '2') goto yy292;
		if (yych <= '9') goto yy291;
		if (yych <= ':') goto yy264;
		goto yy199;
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy199;
	} else {
		if (yych <= '4') goto yy291;
		if (yych <= '9') goto yy263;
		if (yych <= ':') goto yy264;
		goto yy199;
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy199;
	} else {
		if (yych <= '9') goto yy263;
		if (yych <= ':') goto yy264;
		goto yy199;
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy289;
	goto yy199;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy265;
	if (yych <= '9') goto yy266;
	goto yy57;
yy265:
	YYDEBUG(265, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy267;
		goto yy223;
	} else {
		if (yych <= '9') goto yy282;
		if (yych <= ':') goto yy267;
		goto yy223;
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy267;
	if (yych != ':') goto yy223;
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy268;
	if (yych <= '6') goto yy269;
	if (yych <= '9') goto yy228;
	goto yy57;
yy268:
	YYDEBUG(268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '9') goto yy270;
	goto yy223;
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy223;
yy270:
	YYDEBUG(270, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy272;
			goto yy223;
		} else {
			if (yych <= ' ') goto yy272;
			if (yych == '(') goto yy272;
			goto yy223;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy223;
			if (yych <= '-') goto yy272;
			goto yy223;
		} else {
			if (yych <= 'Z') goto yy272;
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy272;
			goto yy223;
		}
	}
yy271:
	YYDEBUG(271, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy272:
	YYDEBUG(272, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy57;
				goto yy271;
			} else {
				if (yych == ' ') goto yy271;
				goto yy57;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy234;
				if (yych <= '*') goto yy57;
				goto yy233;
			} else {
				if (yych == '-') goto yy233;
				goto yy57;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy273;
				if (yych <= 'F') goto yy235;
				goto yy232;
			} else {
				if (yych != 'P') goto yy235;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy57;
				if (yych <= 'a') goto yy274;
				goto yy236;
			} else {
				if (yych <= 'p') goto yy274;
				if (yych <= 'z') goto yy236;
				goto yy57;
			}
		}
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych <= '.') goto yy275;
			if (yych <= '@') goto yy223;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy276;
			if (yych <= 'Z') goto yy237;
			goto yy223;
		} else {
			if (yych == 'm') goto yy281;
			if (yych <= 'z') goto yy242;
			goto yy223;
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych <= '.') goto yy275;
			if (yych <= '@') goto yy223;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy276;
			if (yych <= 'Z') goto yy237;
			goto yy223;
		} else {
			if (yych == 'm') goto yy276;
			if (yych <= 'z') goto yy237;
			goto yy223;
		}
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy280;
	if (yych == 'm') goto yy280;
	goto yy57;
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy278;
			if (yych <= 0x08) goto yy223;
			goto yy278;
		} else {
			if (yych == ' ') goto yy278;
			if (yych <= '(') goto yy223;
			goto yy228;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy223;
		} else {
			if (yych <= 'Z') goto yy238;
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy238;
			goto yy223;
		}
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy278;
		if (yych <= 0x08) goto yy57;
	} else {
		if (yych != ' ') goto yy57;
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(279, *YYCURSOR);
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy278;
		if (yych == '\t') goto yy278;
		goto yy57;
	} else {
		if (yych <= ' ') goto yy278;
		if (yych == '.') goto yy277;
		goto yy57;
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy278;
			if (yych == '\t') goto yy278;
			goto yy223;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy278;
				goto yy223;
			} else {
				if (yych <= ')') goto yy228;
				if (yych <= ',') goto yy223;
				goto yy244;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy277;
			if (yych <= '/') goto yy244;
			if (yych <= '@') goto yy223;
			goto yy238;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy223;
				goto yy244;
			} else {
				if (yych <= '`') goto yy223;
				if (yych <= 'z') goto yy243;
				goto yy223;
			}
		}
	}
yy282:
	YYDEBUG(282, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy283;
			if (yych <= 0x1F) goto yy223;
		} else {
			if (yych == '.') goto yy267;
			if (yych <= '9') goto yy223;
			goto yy267;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy285;
			if (yych <= 'O') goto yy223;
			goto yy285;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy223;
				goto yy285;
			} else {
				if (yych == 'p') goto yy285;
				goto yy223;
			}
		}
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(284, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy283;
			goto yy57;
		} else {
			if (yych <= ' ') goto yy283;
			if (yych <= '@') goto yy57;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy57;
		} else {
			if (yych <= 'a') goto yy285;
			if (yych != 'p') goto yy57;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy57;
	} else {
		if (yych <= 'M') goto yy287;
		if (yych == 'm') goto yy287;
		goto yy57;
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy287;
	if (yych != 'm') goto yy57;
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy278;
		if (yych == '\t') goto yy278;
		goto yy57;
	} else {
		if (yych <= ' ') goto yy278;
		if (yych != '.') goto yy57;
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy278;
		if (yych <= 0x08) goto yy57;
		goto yy278;
	} else {
		if (yych == ' ') goto yy278;
		goto yy57;
	}
yy289:
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy199;
	if (yych >= ':') goto yy199;
	YYDEBUG(290, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy199;
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy221;
		goto yy199;
	} else {
		if (yych <= '9') goto yy289;
		if (yych <= ':') goto yy221;
		goto yy199;
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy199;
	} else {
		if (yych <= '9') goto yy289;
		if (yych <= ':') goto yy264;
		goto yy199;
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy294:
	YYDEBUG(294, *YYCURSOR);
	++YYCURSOR;
yy295:
	YYDEBUG(295, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy221;
		goto yy57;
	} else {
		if (yych <= '9') goto yy294;
		if (yych <= ':') goto yy221;
		goto yy57;
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy57;
	} else {
		if (yych <= '9') goto yy294;
		if (yych <= ':') goto yy264;
		goto yy57;
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy331;
			goto yy216;
		} else {
			if (yych <= '0') goto yy332;
			if (yych <= '1') goto yy302;
			if (yych <= '2') goto yy303;
			goto yy297;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy221;
			if (yych == 'n') goto yy212;
			goto yy216;
		} else {
			if (yych <= 'r') goto yy213;
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych != '.') goto yy216;
		} else {
			if (yych <= '0') goto yy301;
			if (yych <= '1') goto yy302;
			if (yych <= '2') goto yy303;
			goto yy297;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy264;
			if (yych == 'n') goto yy212;
			goto yy216;
		} else {
			if (yych <= 'r') goto yy213;
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy216;
		if (yych <= '0') goto yy306;
		goto yy307;
	} else {
		if (yych <= '2') goto yy308;
		if (yych <= '5') goto yy309;
		if (yych <= '9') goto yy310;
		goto yy216;
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy57;
	} else {
		if (yych <= '0') goto yy304;
		if (yych <= '9') goto yy305;
		if (yych <= ':') goto yy264;
		goto yy57;
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy57;
	} else {
		if (yych <= '2') goto yy305;
		if (yych <= '9') goto yy304;
		if (yych <= ':') goto yy264;
		goto yy57;
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy264;
		goto yy57;
	} else {
		if (yych <= '4') goto yy304;
		if (yych <= '9') goto yy294;
		if (yych <= ':') goto yy264;
		goto yy57;
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy221;
	if (yych == ':') goto yy221;
	goto yy295;
yy305:
	YYDEBUG(305, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy264;
	if (yych == ':') goto yy264;
	goto yy295;
yy306:
	YYDEBUG(306, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy326;
		goto yy199;
	} else {
		if (yych <= '0') goto yy325;
		if (yych <= '9') goto yy330;
		if (yych <= ':') goto yy326;
		goto yy199;
	}
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy311;
		goto yy199;
	} else {
		if (yych <= '2') goto yy330;
		if (yych <= '9') goto yy325;
		if (yych <= ':') goto yy311;
		goto yy199;
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy311;
		goto yy199;
	} else {
		if (yych <= '4') goto yy325;
		if (yych <= '9') goto yy324;
		if (yych <= ':') goto yy311;
		goto yy199;
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy311;
		goto yy199;
	} else {
		if (yych <= '9') goto yy324;
		if (yych <= ':') goto yy311;
		goto yy199;
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy199;
	} else {
		if (yych <= '9') goto yy263;
		if (yych >= ';') goto yy199;
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy312;
	if (yych <= '6') goto yy313;
	if (yych <= '9') goto yy266;
	goto yy57;
yy312:
	YYDEBUG(312, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy267;
		goto yy223;
	} else {
		if (yych <= '9') goto yy314;
		if (yych <= ':') goto yy267;
		goto yy223;
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy267;
		goto yy223;
	} else {
		if (yych <= '0') goto yy270;
		if (yych == ':') goto yy267;
		goto yy223;
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy316;
			if (yych <= 0x1F) goto yy223;
			goto yy316;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy223;
				goto yy316;
			} else {
				if (yych == '+') goto yy316;
				goto yy223;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy316;
			if (yych <= '.') goto yy267;
			if (yych <= '9') goto yy223;
			goto yy267;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy223;
				goto yy316;
			} else {
				if (yych <= '`') goto yy223;
				if (yych <= 'z') goto yy316;
				goto yy223;
			}
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy316:
	YYDEBUG(316, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy57;
				goto yy315;
			} else {
				if (yych == ' ') goto yy315;
				goto yy57;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy234;
				if (yych <= '*') goto yy57;
				goto yy233;
			} else {
				if (yych == '-') goto yy233;
				goto yy57;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy317;
				if (yych <= 'F') goto yy235;
				goto yy232;
			} else {
				if (yych != 'P') goto yy235;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy57;
				if (yych <= 'a') goto yy318;
				goto yy236;
			} else {
				if (yych <= 'p') goto yy318;
				if (yych <= 'z') goto yy236;
				goto yy57;
			}
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych <= '.') goto yy320;
			if (yych <= '@') goto yy223;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy319;
			if (yych <= 'Z') goto yy237;
			goto yy223;
		} else {
			if (yych == 'm') goto yy323;
			if (yych <= 'z') goto yy242;
			goto yy223;
		}
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych <= '.') goto yy320;
			if (yych <= '@') goto yy223;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy319;
			if (yych <= 'Z') goto yy237;
			goto yy223;
		} else {
			if (yych == 'm') goto yy319;
			if (yych <= 'z') goto yy237;
			goto yy223;
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy278;
			if (yych <= 0x08) goto yy223;
			goto yy278;
		} else {
			if (yych == ' ') goto yy278;
			if (yych <= '(') goto yy223;
			goto yy228;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy322;
			goto yy223;
		} else {
			if (yych <= 'Z') goto yy238;
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy238;
			goto yy223;
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy321;
	if (yych != 'm') goto yy57;
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy278;
		if (yych == '\t') goto yy278;
		goto yy57;
	} else {
		if (yych <= ' ') goto yy278;
		if (yych != '.') goto yy57;
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy278;
		if (yych <= 0x08) goto yy57;
		goto yy278;
	} else {
		if (yych == ' ') goto yy278;
		goto yy57;
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy278;
			if (yych == '\t') goto yy278;
			goto yy223;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy278;
				goto yy223;
			} else {
				if (yych <= ')') goto yy228;
				if (yych <= ',') goto yy223;
				goto yy244;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy322;
			if (yych <= '/') goto yy244;
			if (yych <= '@') goto yy223;
			goto yy238;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy223;
				goto yy244;
			} else {
				if (yych <= '`') goto yy223;
				if (yych <= 'z') goto yy243;
				goto yy223;
			}
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy283;
			if (yych <= 0x1F) goto yy199;
			goto yy283;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy199;
				goto yy267;
			} else {
				if (yych <= '/') goto yy199;
				if (yych <= '9') goto yy289;
				goto yy267;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy285;
			if (yych <= 'O') goto yy199;
			goto yy285;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy199;
				goto yy285;
			} else {
				if (yych == 'p') goto yy285;
				goto yy199;
			}
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy283;
			if (yych <= 0x1F) goto yy199;
			goto yy283;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy199;
			} else {
				if (yych <= '/') goto yy199;
				if (yych <= '9') goto yy289;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy285;
			if (yych <= 'O') goto yy199;
			goto yy285;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy199;
				goto yy285;
			} else {
				if (yych == 'p') goto yy285;
				goto yy199;
			}
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy327;
	if (yych <= '6') goto yy328;
	if (yych <= '9') goto yy224;
	goto yy57;
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy225;
		goto yy223;
	} else {
		if (yych <= '9') goto yy329;
		if (yych <= ':') goto yy225;
		goto yy223;
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy225;
		goto yy223;
	} else {
		if (yych <= '0') goto yy270;
		if (yych == ':') goto yy225;
		goto yy223;
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy272;
			if (yych <= 0x1F) goto yy223;
			goto yy272;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy223;
				goto yy272;
			} else {
				if (yych == '+') goto yy272;
				goto yy223;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy272;
			if (yych <= '.') goto yy225;
			if (yych <= '9') goto yy223;
			goto yy225;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy223;
				goto yy272;
			} else {
				if (yych <= '`') goto yy223;
				if (yych <= 'z') goto yy272;
				goto yy223;
			}
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy283;
			if (yych <= 0x1F) goto yy199;
			goto yy283;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy199;
				goto yy311;
			} else {
				if (yych <= '/') goto yy199;
				if (yych <= '9') goto yy289;
				goto yy311;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy285;
			if (yych <= 'O') goto yy199;
			goto yy285;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy199;
				goto yy285;
			} else {
				if (yych == 'p') goto yy285;
				goto yy199;
			}
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy216;
		if (yych <= '0') goto yy333;
		goto yy334;
	} else {
		if (yych <= '2') goto yy335;
		if (yych <= '5') goto yy336;
		if (yych <= '9') goto yy337;
		goto yy216;
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy221;
		goto yy57;
	} else {
		if (yych <= '0') goto yy304;
		if (yych <= '9') goto yy305;
		if (yych <= ':') goto yy221;
		goto yy57;
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy350;
		goto yy199;
	} else {
		if (yych <= '0') goto yy349;
		if (yych <= '9') goto yy354;
		if (yych <= ':') goto yy350;
		goto yy199;
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy338;
		goto yy199;
	} else {
		if (yych <= '2') goto yy354;
		if (yych <= '9') goto yy349;
		if (yych <= ':') goto yy338;
		goto yy199;
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy338;
		goto yy199;
	} else {
		if (yych <= '4') goto yy349;
		if (yych <= '9') goto yy348;
		if (yych <= ':') goto yy338;
		goto yy199;
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy338;
		goto yy199;
	} else {
		if (yych <= '9') goto yy348;
		if (yych <= ':') goto yy338;
		goto yy199;
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy199;
	} else {
		if (yych <= '9') goto yy263;
		if (yych >= ';') goto yy199;
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy339;
	if (yych <= '6') goto yy340;
	if (yych <= '9') goto yy266;
	goto yy57;
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy267;
		goto yy223;
	} else {
		if (yych <= '9') goto yy341;
		if (yych <= ':') goto yy267;
		goto yy223;
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy267;
		goto yy223;
	} else {
		if (yych <= '0') goto yy229;
		if (yych == ':') goto yy267;
		goto yy223;
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy343;
			if (yych <= 0x1F) goto yy223;
			goto yy343;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy223;
				goto yy343;
			} else {
				if (yych == '+') goto yy343;
				goto yy223;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy343;
			if (yych <= '.') goto yy267;
			if (yych <= '9') goto yy223;
			goto yy267;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy223;
				goto yy343;
			} else {
				if (yych <= '`') goto yy223;
				if (yych <= 'z') goto yy343;
				goto yy223;
			}
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy343:
	YYDEBUG(343, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy57;
				goto yy342;
			} else {
				if (yych == ' ') goto yy342;
				goto yy57;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy234;
				if (yych <= '*') goto yy57;
				goto yy233;
			} else {
				if (yych == '-') goto yy233;
				goto yy57;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy344;
				if (yych <= 'F') goto yy235;
				goto yy232;
			} else {
				if (yych != 'P') goto yy235;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy57;
				if (yych <= 'a') goto yy345;
				goto yy236;
			} else {
				if (yych <= 'p') goto yy345;
				if (yych <= 'z') goto yy236;
				goto yy57;
			}
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych <= '.') goto yy286;
			if (yych <= '@') goto yy223;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy346;
			if (yych <= 'Z') goto yy237;
			goto yy223;
		} else {
			if (yych == 'm') goto yy347;
			if (yych <= 'z') goto yy242;
			goto yy223;
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy228;
			goto yy223;
		} else {
			if (yych <= '.') goto yy286;
			if (yych <= '@') goto yy223;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy346;
			if (yych <= 'Z') goto yy237;
			goto yy223;
		} else {
			if (yych == 'm') goto yy346;
			if (yych <= 'z') goto yy237;
			goto yy223;
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy278;
			if (yych <= 0x08) goto yy223;
			goto yy278;
		} else {
			if (yych == ' ') goto yy278;
			if (yych <= '(') goto yy223;
			goto yy228;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy288;
			goto yy223;
		} else {
			if (yych <= 'Z') goto yy238;
			if (yych <= '`') goto yy223;
			if (yych <= 'z') goto yy238;
			goto yy223;
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy278;
			if (yych == '\t') goto yy278;
			goto yy223;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy278;
				goto yy223;
			} else {
				if (yych <= ')') goto yy228;
				if (yych <= ',') goto yy223;
				goto yy244;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy288;
			if (yych <= '/') goto yy244;
			if (yych <= '@') goto yy223;
			goto yy238;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy223;
				goto yy244;
			} else {
				if (yych <= '`') goto yy223;
				if (yych <= 'z') goto yy243;
				goto yy223;
			}
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy225;
		goto yy199;
	} else {
		if (yych <= '9') goto yy289;
		if (yych <= ':') goto yy225;
		goto yy199;
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy199;
	} else {
		if (yych <= '9') goto yy289;
		if (yych >= ';') goto yy199;
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy351;
	if (yych <= '6') goto yy352;
	if (yych <= '9') goto yy224;
	goto yy57;
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy225;
		goto yy223;
	} else {
		if (yych <= '9') goto yy353;
		if (yych <= ':') goto yy225;
		goto yy223;
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy225;
		goto yy223;
	} else {
		if (yych <= '0') goto yy229;
		if (yych == ':') goto yy225;
		goto yy223;
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy231;
			if (yych <= 0x1F) goto yy223;
			goto yy231;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy223;
				goto yy231;
			} else {
				if (yych == '+') goto yy231;
				goto yy223;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy231;
			if (yych <= '.') goto yy225;
			if (yych <= '9') goto yy223;
			goto yy225;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy223;
				goto yy231;
			} else {
				if (yych <= '`') goto yy223;
				if (yych <= 'z') goto yy231;
				goto yy223;
			}
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy338;
		goto yy199;
	} else {
		if (yych <= '9') goto yy289;
		if (yych <= ':') goto yy338;
		goto yy199;
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy300;
			goto yy216;
		} else {
			if (yych <= '0') goto yy332;
			if (yych <= '1') goto yy302;
			if (yych <= '2') goto yy303;
			goto yy297;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy264;
			if (yych == 'n') goto yy212;
			goto yy216;
		} else {
			if (yych <= 'r') goto yy213;
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy300;
			goto yy216;
		} else {
			if (yych <= '0') goto yy332;
			if (yych <= '1') goto yy302;
			if (yych <= '2') goto yy303;
			goto yy297;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy264;
			if (yych == 'n') goto yy212;
			goto yy216;
		} else {
			if (yych <= 'r') goto yy213;
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy216;
			if (yych <= '0') goto yy360;
			goto yy361;
		} else {
			if (yych <= '2') goto yy368;
			if (yych <= '9') goto yy369;
			goto yy216;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy212;
			if (yych <= 'q') goto yy216;
			goto yy213;
		} else {
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy216;
			if (yych <= '0') goto yy360;
			goto yy361;
		} else {
			if (yych <= '2') goto yy368;
			if (yych <= '9') goto yy369;
			goto yy216;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy212;
			if (yych <= 'q') goto yy216;
			goto yy213;
		} else {
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy216;
			if (yych >= '1') goto yy361;
		} else {
			if (yych <= '2') goto yy209;
			if (yych <= '9') goto yy210;
			goto yy216;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy212;
			if (yych <= 'q') goto yy216;
			goto yy213;
		} else {
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy216;
			if (yych <= '-') goto yy362;
			if (yych <= '.') goto yy331;
			goto yy216;
		} else {
			if (yych <= '0') goto yy332;
			if (yych <= '1') goto yy302;
			if (yych <= '2') goto yy303;
			goto yy297;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy221;
			if (yych == 'n') goto yy212;
			goto yy216;
		} else {
			if (yych <= 'r') goto yy213;
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy216;
			if (yych <= '-') goto yy362;
			if (yych <= '.') goto yy300;
			goto yy216;
		} else {
			if (yych <= '0') goto yy301;
			if (yych <= '1') goto yy302;
			if (yych <= '2') goto yy303;
			goto yy297;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy264;
			if (yych == 'n') goto yy212;
			goto yy216;
		} else {
			if (yych <= 'r') goto yy213;
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(363, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy364;
	if (yych <= '9') goto yy365;
yy364:
	YYDEBUG(364, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy364;
	if (yych >= ':') goto yy364;
	YYDEBUG(366, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy364;
	if (yych >= ':') goto yy364;
	YYDEBUG(367, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy364;
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy216;
			if (yych <= '-') goto yy362;
			if (yych <= '.') goto yy300;
			goto yy216;
		} else {
			if (yych <= '0') goto yy332;
			if (yych <= '1') goto yy302;
			if (yych <= '2') goto yy303;
			goto yy297;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy264;
			if (yych == 'n') goto yy212;
			goto yy216;
		} else {
			if (yych <= 'r') goto yy213;
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy216;
			if (yych <= '-') goto yy362;
			if (yych <= '.') goto yy300;
			goto yy216;
		} else {
			if (yych <= '0') goto yy332;
			if (yych <= '1') goto yy302;
			if (yych <= '2') goto yy303;
			goto yy297;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy264;
			if (yych == 'n') goto yy212;
			goto yy216;
		} else {
			if (yych <= 'r') goto yy213;
			if (yych <= 's') goto yy211;
			if (yych <= 't') goto yy214;
			goto yy216;
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy193;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'c') goto yy371;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'E') goto yy202;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy373;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy149;
	}
	if (yych <= '/') goto yy196;
	if (yych <= '0') goto yy357;
	if (yych <= '2') goto yy358;
	if (yych <= '3') goto yy359;
	goto yy196;
yy373:
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy203;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'm') goto yy374;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy204;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'b') goto yy375;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy205;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'e') goto yy376;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy206;
	if (yych != 'r') goto yy155;
yy377:
	YYDEBUG(377, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy196;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy196;
			if (yych <= ',') goto yy194;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy148;
			goto yy196;
		} else {
			if (yych == '_') goto yy148;
			goto yy194;
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy149;
	}
	goto yy196;
yy379:
	YYDEBUG(379, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 't') goto yy380;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych != 'O') goto yy143;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'o') goto yy381;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'A') goto yy144;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'b') goto yy382;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy145;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'e') goto yy383;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'R') goto yy206;
		if (yych == 'r') goto yy206;
		goto yy4;
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy380;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 't') goto yy385;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'O') goto yy381;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'o') goto yy386;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy382;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'b') goto yy387;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy383;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'e') goto yy388;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy206;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'r') goto yy377;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'F') goto yy142;
			goto yy397;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'g') goto yy397;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'Q') goto yy142;
			goto yy394;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy394;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'N') goto yy142;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'o') goto yy392;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy140;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy393;
		if (yych <= 'z') goto yy143;
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych != 'I') goto yy143;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'i') goto yy395;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'K') goto yy144;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'l') goto yy396;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy196;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy196;
			if (yych == ')') goto yy140;
			goto yy194;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy194;
			if (yych <= '9') goto yy196;
			goto yy194;
		} else {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy194;
			if (yych <= 'z') goto yy145;
			goto yy194;
		}
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych != 'U') goto yy143;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'u') goto yy398;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'R') goto yy144;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 's') goto yy399;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy145;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 't') goto yy400;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy194;
			goto yy196;
		} else {
			if (yych == ' ') goto yy196;
			goto yy194;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy140;
			if (yych <= ',') goto yy194;
			goto yy196;
		} else {
			if (yych <= '/') goto yy194;
			if (yych <= '9') goto yy196;
			goto yy194;
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy397;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'g') goto yy408;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy394;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'r') goto yy405;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy392;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'o') goto yy404;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy393;
		} else {
			if (yych == '.') goto yy393;
			goto yy148;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy393;
			if (yych <= 'Z') goto yy143;
			goto yy393;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy393;
			if (yych <= 'z') goto yy151;
			goto yy393;
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'I') goto yy395;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy406;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy396;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'l') goto yy407;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy194;
			goto yy196;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy194;
				goto yy140;
			} else {
				if (yych <= ',') goto yy194;
				if (yych <= '-') goto yy378;
				goto yy196;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy148;
			if (yych <= '9') goto yy196;
			if (yych <= '@') goto yy194;
			goto yy145;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy194;
				goto yy148;
			} else {
				if (yych <= '`') goto yy194;
				if (yych <= 'z') goto yy153;
				goto yy194;
			}
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'U') goto yy398;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'u') goto yy409;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy399;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 's') goto yy410;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy400;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 't') goto yy411;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy196;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy196;
			if (yych == ')') goto yy140;
			goto yy194;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy378;
			if (yych <= '.') goto yy196;
			goto yy148;
		} else {
			if (yych <= '9') goto yy196;
			if (yych == '_') goto yy148;
			goto yy194;
		}
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == 'L') goto yy419;
			if (yych <= 'M') goto yy142;
			goto yy418;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			if (yych <= 'k') goto yy142;
			goto yy419;
		} else {
			if (yych == 'n') goto yy418;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy142;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy414;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych != 'U') goto yy143;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'u') goto yy415;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy416;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'Q') goto yy145;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'r') goto yy417;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Y') goto yy206;
		if (yych == 'y') goto yy206;
		goto yy4;
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych == 'E') goto yy420;
				goto yy143;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy420;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych != 'Y') goto yy143;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'y') goto yy420;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy196;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy196;
			if (yych == ')') goto yy140;
			goto yy194;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy194;
			if (yych <= '9') goto yy196;
			goto yy194;
		} else {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy194;
			if (yych <= 'z') goto yy144;
			goto yy194;
		}
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych == '-') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy148;
				goto yy4;
			} else {
				if (yych == 'L') goto yy419;
				goto yy142;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy418;
				goto yy142;
			} else {
				if (yych == '_') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy428;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy427;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy414;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy423;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'U') goto yy415;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'u') goto yy424;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy416;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy425;
			if (yych <= 'z') goto yy152;
			goto yy4;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy417;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'r') goto yy426;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy206;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'y') goto yy377;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'E') goto yy420;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy429;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'Y') goto yy420;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'y') goto yy429;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy194;
			goto yy196;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy194;
				goto yy140;
			} else {
				if (yych <= ',') goto yy194;
				if (yych <= '-') goto yy378;
				goto yy196;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy148;
			if (yych <= '9') goto yy196;
			if (yych <= '@') goto yy194;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy194;
				goto yy148;
			} else {
				if (yych <= '`') goto yy194;
				if (yych <= 'z') goto yy152;
				goto yy194;
			}
		}
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy4;
			goto yy196;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy196;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy4;
			if (yych <= '9') goto yy196;
			if (yych <= '@') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy142;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy142;
				goto yy4;
			}
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy196;
			goto yy4;
		} else {
			if (yych <= ' ') goto yy196;
			if (yych == ')') goto yy140;
			goto yy4;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy4;
			if (yych <= '9') goto yy196;
			goto yy4;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy4;
			goto yy196;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy196;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy4;
			if (yych <= '9') goto yy196;
			if (yych <= '@') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy142;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy142;
				goto yy4;
			}
		}
	}
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy4;
			goto yy196;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy196;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy4;
			if (yych <= '9') goto yy196;
			if (yych <= '@') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy143;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy143;
				goto yy4;
			}
		}
	}
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy196;
			goto yy4;
		} else {
			if (yych <= ' ') goto yy196;
			if (yych == ')') goto yy140;
			goto yy4;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy4;
			if (yych <= '9') goto yy196;
			goto yy4;
		} else {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy196;
			goto yy4;
		} else {
			if (yych <= ' ') goto yy196;
			if (yych == ')') goto yy140;
			goto yy4;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy4;
			if (yych <= '9') goto yy196;
			goto yy4;
		} else {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy4;
			goto yy196;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy196;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy4;
			if (yych <= '9') goto yy196;
			if (yych <= '@') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy431;
				goto yy142;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy142;
				goto yy4;
			}
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy4;
				goto yy61;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy4;
					goto yy457;
				} else {
					if (yych <= ':') goto yy163;
					if (yych <= 'C') goto yy4;
					goto yy61;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy4;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy4;
					if (yych <= 'T') goto yy61;
					goto yy4;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy4;
				if (yych <= 'Y') goto yy61;
				goto yy4;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy4;
				} else {
					if (yych == 'g') goto yy4;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy4;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy4;
				}
			}
		}
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy4;
				goto yy61;
			} else {
				if (yych <= '4') {
					if (yych <= '/') goto yy4;
					goto yy457;
				} else {
					if (yych <= '5') goto yy442;
					if (yych <= '9') goto yy443;
					goto yy163;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy4;
					goto yy61;
				} else {
					if (yych == 'F') goto yy61;
					goto yy4;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy61;
					goto yy4;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych <= 'R') goto yy4;
					goto yy61;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy61;
				if (yych <= 'X') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy4;
					goto yy61;
				} else {
					if (yych == 'f') goto yy61;
					goto yy4;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy61;
					goto yy4;
				} else {
					if (yych <= 'm') goto yy61;
					if (yych <= 'r') goto yy4;
					goto yy61;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy4;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy4;
				}
			}
		}
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy4;
				goto yy61;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy4;
					goto yy442;
				} else {
					if (yych <= '9') goto yy443;
					if (yych <= ':') goto yy163;
					goto yy4;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy4;
				if (yych <= 'F') goto yy61;
				goto yy4;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy61;
					goto yy4;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych <= 'R') goto yy4;
					goto yy61;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy61;
				if (yych <= 'X') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy4;
					goto yy61;
				} else {
					if (yych == 'f') goto yy61;
					goto yy4;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy61;
					goto yy4;
				} else {
					if (yych <= 'm') goto yy61;
					if (yych <= 'r') goto yy4;
					goto yy61;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy4;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy4;
				}
			}
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(441, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy58;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy440;
		goto yy57;
	} else {
		if (yych <= '-') goto yy440;
		if (yych <= '/') goto yy57;
		if (yych <= '9') goto yy55;
		goto yy57;
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy4;
				goto yy61;
			} else {
				if (yych <= '/') goto yy4;
				if (yych <= '9') goto yy456;
				if (yych <= 'C') goto yy4;
				goto yy61;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy4;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy4;
					if (yych <= 'T') goto yy61;
					goto yy4;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy4;
				if (yych <= 'Y') goto yy61;
				goto yy4;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy4;
				} else {
					if (yych == 'g') goto yy4;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy4;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy4;
				}
			}
		}
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy4;
				goto yy61;
			} else {
				if (yych <= '/') goto yy4;
				if (yych <= '9') goto yy444;
				if (yych <= 'C') goto yy4;
				goto yy61;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy4;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy4;
					if (yych <= 'T') goto yy61;
					goto yy4;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy4;
				if (yych <= 'Y') goto yy61;
				goto yy4;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy4;
				} else {
					if (yych == 'g') goto yy4;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy4;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy4;
				}
			}
		}
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych >= ':') goto yy61;
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy55;
	}
	if (yych != '-') goto yy61;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy447;
	if (yych <= '1') goto yy448;
	goto yy57;
yy447:
	YYDEBUG(447, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy449;
	goto yy57;
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '3') goto yy57;
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy57;
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy451;
	if (yych <= '2') goto yy452;
	if (yych <= '3') goto yy453;
	goto yy57;
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy454;
	goto yy57;
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy454;
	goto yy57;
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '2') goto yy57;
yy454:
	YYDEBUG(454, *YYCURSOR);
	++YYCURSOR;
yy455:
	YYDEBUG(455, *YYCURSOR);
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy4;
				goto yy61;
			} else {
				if (yych <= '/') goto yy4;
				if (yych <= '9') goto yy445;
				if (yych <= 'C') goto yy4;
				goto yy61;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy4;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy4;
					if (yych <= 'T') goto yy61;
					goto yy4;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy4;
				if (yych <= 'Y') goto yy61;
				goto yy4;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy4;
				} else {
					if (yych == 'g') goto yy4;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy4;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy4;
				}
			}
		}
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy4;
				goto yy61;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy4;
				} else {
					if (yych <= '9') goto yy456;
					if (yych <= ':') goto yy163;
					goto yy4;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy4;
				if (yych <= 'F') goto yy61;
				goto yy4;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy61;
					goto yy4;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych <= 'R') goto yy4;
					goto yy61;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy61;
				if (yych <= 'X') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy4;
					goto yy61;
				} else {
					if (yych == 'f') goto yy61;
					goto yy4;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy61;
					goto yy4;
				} else {
					if (yych <= 'm') goto yy61;
					if (yych <= 'r') goto yy4;
					goto yy61;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy4;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy4;
				}
			}
		}
	}
	YYDEBUG(458, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy4;
				goto yy61;
			} else {
				if (yych <= '/') goto yy4;
				if (yych <= '9') goto yy459;
				if (yych <= 'C') goto yy4;
				goto yy61;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy4;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy4;
					if (yych <= 'T') goto yy61;
					goto yy4;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy4;
				if (yych <= 'Y') goto yy61;
				goto yy4;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy4;
				} else {
					if (yych == 'g') goto yy4;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy4;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy4;
				}
			}
		}
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy55;
	}
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy4;
				goto yy61;
			} else {
				if (yych == '-') goto yy446;
				if (yych <= 'C') goto yy4;
				goto yy61;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy4;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy4;
					if (yych <= 'T') goto yy61;
					goto yy4;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy4;
				if (yych <= 'Y') goto yy61;
				goto yy4;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy4;
				} else {
					if (yych == 'g') goto yy4;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy4;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy4;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy4;
				}
			}
		}
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy462;
	if (yych <= '0') goto yy736;
	if (yych <= '1') goto yy737;
	if (yych <= '9') goto yy738;
	goto yy462;
yy461:
	YYDEBUG(461, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy462:
	YYDEBUG(462, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy461;
	case '-':
	case '.':	goto yy577;
	case 'A':
	case 'a':	goto yy480;
	case 'D':
	case 'd':	goto yy466;
	case 'F':
	case 'f':	goto yy467;
	case 'H':
	case 'h':	goto yy64;
	case 'I':	goto yy475;
	case 'J':
	case 'j':	goto yy479;
	case 'M':
	case 'm':	goto yy465;
	case 'N':
	case 'n':	goto yy482;
	case 'O':
	case 'o':	goto yy481;
	case 'P':
	case 'p':	goto yy484;
	case 'S':
	case 's':	goto yy463;
	case 'T':
	case 't':	goto yy69;
	case 'V':	goto yy477;
	case 'W':
	case 'w':	goto yy68;
	case 'X':	goto yy478;
	case 'Y':
	case 'y':	goto yy67;
	default:	goto yy57;
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy127;
			goto yy57;
		} else {
			if (yych <= 'E') goto yy1049;
			if (yych <= 'T') goto yy57;
			goto yy126;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy127;
			goto yy57;
		} else {
			if (yych <= 'e') goto yy1049;
			if (yych == 'u') goto yy126;
			goto yy57;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy127;
			goto yy57;
		} else {
			if (yych <= 'E') goto yy1049;
			if (yych == 'U') goto yy126;
			goto yy57;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy127;
			if (yych <= 'd') goto yy57;
			goto yy1049;
		} else {
			if (yych <= 's') goto yy57;
			if (yych <= 't') goto yy729;
			if (yych <= 'u') goto yy126;
			goto yy57;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy592;
			goto yy57;
		} else {
			if (yych <= 'I') goto yy118;
			if (yych <= 'N') goto yy57;
			goto yy117;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy592;
			goto yy57;
		} else {
			if (yych <= 'i') goto yy118;
			if (yych == 'o') goto yy117;
			goto yy57;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy114;
		if (yych <= 'D') goto yy57;
		goto yy579;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy57;
			goto yy114;
		} else {
			if (yych == 'e') goto yy579;
			goto yy57;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy595;
			goto yy57;
		} else {
			if (yych <= 'O') goto yy99;
			if (yych <= 'Q') goto yy57;
			goto yy98;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy595;
			goto yy57;
		} else {
			if (yych <= 'o') goto yy99;
			if (yych == 'r') goto yy98;
			goto yy57;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy70;
		if (yych <= 'T') goto yy57;
		goto yy71;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy57;
			goto yy1048;
		} else {
			if (yych == 'u') goto yy71;
			goto yy57;
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy742;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy741;
	goto yy61;
yy470:
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy530;
		goto yy57;
	} else {
		if (yych <= 'd') goto yy729;
		if (yych == 'o') goto yy530;
		goto yy57;
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy729;
	goto yy57;
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy666;
	case '3':	goto yy668;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy669;
	case 'A':
	case 'a':	goto yy673;
	case 'D':
	case 'd':	goto yy677;
	case 'F':
	case 'f':	goto yy671;
	case 'J':
	case 'j':	goto yy670;
	case 'M':
	case 'm':	goto yy672;
	case 'N':
	case 'n':	goto yy676;
	case 'O':
	case 'o':	goto yy675;
	case 'S':
	case 's':	goto yy674;
	default:	goto yy57;
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy616;
	case '1':	goto yy617;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy618;
	case 'A':
	case 'a':	goto yy622;
	case 'D':
	case 'd':	goto yy626;
	case 'F':
	case 'f':	goto yy620;
	case 'J':
	case 'j':	goto yy619;
	case 'M':
	case 'm':	goto yy621;
	case 'N':
	case 'n':	goto yy625;
	case 'O':
	case 'o':	goto yy624;
	case 'S':
	case 's':	goto yy623;
	default:	goto yy578;
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy578;
		if (yych <= '0') goto yy568;
		goto yy569;
	} else {
		if (yych <= '5') goto yy570;
		if (yych <= '9') goto yy571;
		goto yy578;
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '.') goto yy532;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy534;
			if (yych == 'I') goto yy567;
		} else {
			if (yych == 'W') goto yy476;
			if (yych <= 'X') goto yy540;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy476;
			goto yy532;
		} else {
			if (yych == ' ') goto yy532;
			goto yy476;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy532;
			if (yych <= '/') goto yy476;
			goto yy534;
		} else {
			if (yych == 'I') goto yy565;
			goto yy476;
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy476;
			goto yy532;
		} else {
			if (yych == ' ') goto yy532;
			goto yy476;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy532;
			if (yych <= '/') goto yy476;
			goto yy534;
		} else {
			if (yych == 'I') goto yy564;
			goto yy476;
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy557;
		if (yych <= 'T') goto yy57;
		goto yy556;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy57;
			goto yy557;
		} else {
			if (yych == 'u') goto yy556;
			goto yy57;
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy485;
			goto yy57;
		} else {
			if (yych <= 'M') goto yy486;
			if (yych == 'P') goto yy550;
			goto yy57;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy549;
			if (yych == 'm') goto yy486;
			goto yy57;
		} else {
			if (yych <= 'p') goto yy550;
			if (yych == 'u') goto yy549;
			goto yy57;
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy544;
	if (yych == 'c') goto yy544;
	goto yy57;
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy530;
	if (yych == 'o') goto yy530;
	goto yy57;
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy490;
	if (yych <= '9') goto yy492;
	goto yy57;
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy57;
	} else {
		if (yych <= 'M') goto yy486;
		if (yych == 'm') goto yy486;
		goto yy57;
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy486;
	if (yych != 'm') goto yy57;
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy488;
		if (yych == '\t') goto yy488;
		goto yy57;
	} else {
		if (yych <= ' ') goto yy488;
		if (yych != '.') goto yy57;
	}
	YYDEBUG(487, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy488;
		if (yych <= 0x08) goto yy57;
	} else {
		if (yych != ' ') goto yy57;
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(489, *YYCURSOR);
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy493;
	} else {
		if (yych <= '9') goto yy507;
		if (yych <= ':') goto yy493;
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy493;
	if (yych != ':') goto yy491;
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy494;
	if (yych <= '6') goto yy495;
	if (yych <= '9') goto yy496;
	goto yy57;
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych <= '/') goto yy491;
	if (yych <= '9') goto yy500;
	goto yy491;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych == '0') goto yy500;
	goto yy491;
yy496:
	YYDEBUG(496, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy491;
yy497:
	YYDEBUG(497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy498:
	YYDEBUG(498, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(499, *YYCURSOR);
	if (yych <= '/') goto yy491;
	if (yych <= '9') goto yy498;
	goto yy491;
yy500:
	YYDEBUG(500, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy491;
		} else {
			if (yych <= ' ') goto yy501;
			if (yych == '.') goto yy497;
			goto yy491;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy503;
			if (yych == 'P') goto yy503;
			goto yy491;
		} else {
			if (yych <= 'a') goto yy503;
			if (yych == 'p') goto yy503;
			goto yy491;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(502, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy501;
			goto yy57;
		} else {
			if (yych <= ' ') goto yy501;
			if (yych <= '@') goto yy57;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy57;
		} else {
			if (yych <= 'a') goto yy503;
			if (yych != 'p') goto yy57;
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy57;
	} else {
		if (yych <= 'M') goto yy505;
		if (yych == 'm') goto yy505;
		goto yy57;
	}
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy505;
	if (yych != 'm') goto yy57;
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy488;
		if (yych == '\t') goto yy488;
		goto yy57;
	} else {
		if (yych <= ' ') goto yy488;
		if (yych != '.') goto yy57;
	}
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy488;
		if (yych <= 0x08) goto yy57;
		goto yy488;
	} else {
		if (yych == ' ') goto yy488;
		goto yy57;
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy508;
			if (yych <= 0x1F) goto yy491;
		} else {
			if (yych == '.') goto yy493;
			if (yych <= '9') goto yy491;
			goto yy511;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy510;
			if (yych <= 'O') goto yy491;
			goto yy510;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy491;
				goto yy510;
			} else {
				if (yych == 'p') goto yy510;
				goto yy491;
			}
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(509, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy508;
			goto yy57;
		} else {
			if (yych <= ' ') goto yy508;
			if (yych <= '@') goto yy57;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy57;
		} else {
			if (yych <= 'a') goto yy510;
			if (yych != 'p') goto yy57;
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy527;
		goto yy57;
	} else {
		if (yych <= 'M') goto yy528;
		if (yych == 'm') goto yy528;
		goto yy57;
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy512;
	if (yych <= '6') goto yy513;
	if (yych <= '9') goto yy496;
	goto yy57;
yy512:
	YYDEBUG(512, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych <= '/') goto yy491;
	if (yych <= '9') goto yy514;
	goto yy491;
yy513:
	YYDEBUG(513, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych != '0') goto yy491;
yy514:
	YYDEBUG(514, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy501;
			if (yych <= 0x1F) goto yy491;
			goto yy501;
		} else {
			if (yych == '.') goto yy515;
			if (yych <= '9') goto yy491;
			goto yy516;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy503;
			if (yych <= 'O') goto yy491;
			goto yy503;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy491;
				goto yy503;
			} else {
				if (yych == 'p') goto yy503;
				goto yy491;
			}
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy525;
	goto yy57;
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy517:
	YYDEBUG(517, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(518, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy57;
			goto yy517;
		} else {
			if (yych != 'A') goto yy57;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy519;
			if (yych <= '`') goto yy57;
		} else {
			if (yych != 'p') goto yy57;
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy57;
	} else {
		if (yych <= 'M') goto yy521;
		if (yych == 'm') goto yy521;
		goto yy57;
	}
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy521;
	if (yych != 'm') goto yy57;
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy523;
		if (yych == '\t') goto yy523;
		goto yy57;
	} else {
		if (yych <= ' ') goto yy523;
		if (yych != '.') goto yy57;
	}
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy523;
		if (yych <= 0x08) goto yy57;
	} else {
		if (yych != ' ') goto yy57;
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(524, *YYCURSOR);
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yyaccept = 11;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(526, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy491;
			goto yy525;
		} else {
			if (yych == 'A') goto yy519;
			goto yy491;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy519;
			if (yych <= '`') goto yy491;
			goto yy519;
		} else {
			if (yych == 'p') goto yy519;
			goto yy491;
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy528;
	if (yych != 'm') goto yy57;
yy528:
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy488;
		if (yych == '\t') goto yy488;
		goto yy57;
	} else {
		if (yych <= ' ') goto yy488;
		if (yych != '.') goto yy57;
	}
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy488;
		if (yych <= 0x08) goto yy57;
		goto yy488;
	} else {
		if (yych == ' ') goto yy488;
		goto yy57;
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy531;
	if (yych != 'v') goto yy57;
yy531:
	YYDEBUG(531, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'E') goto yy536;
			if (yych == 'e') goto yy536;
			goto yy476;
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy533:
	YYDEBUG(533, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy532;
		if (yych <= 0x1F) goto yy57;
		goto yy532;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy57;
			goto yy532;
		} else {
			if (yych <= '/') goto yy57;
			if (yych >= ':') goto yy57;
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy535;
	if (yych <= '9') goto yy541;
yy535:
	YYDEBUG(535, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy537;
	if (yych != 'm') goto yy57;
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy538;
	if (yych != 'b') goto yy57;
yy538:
	YYDEBUG(538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy539;
	if (yych != 'e') goto yy57;
yy539:
	YYDEBUG(539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy540;
	if (yych != 'r') goto yy57;
yy540:
	YYDEBUG(540, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy532;
		if (yych <= 0x1F) goto yy476;
		goto yy532;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy476;
			goto yy532;
		} else {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy535;
	if (yych >= ':') goto yy535;
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy535;
	if (yych >= ':') goto yy535;
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy535;
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy545;
	if (yych != 't') goto yy57;
yy545:
	YYDEBUG(545, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'O') goto yy546;
			if (yych != 'o') goto yy476;
		}
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy547;
	if (yych != 'b') goto yy57;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy548;
	if (yych != 'e') goto yy57;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy540;
	if (yych == 'r') goto yy540;
	goto yy57;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy553;
	if (yych == 'g') goto yy553;
	goto yy57;
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy551;
	if (yych != 'r') goto yy57;
yy551:
	YYDEBUG(551, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'I') goto yy552;
			if (yych != 'i') goto yy476;
		}
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy540;
	if (yych == 'l') goto yy540;
	goto yy57;
yy553:
	YYDEBUG(553, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'U') goto yy554;
			if (yych != 'u') goto yy476;
		}
	}
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy555;
	if (yych != 's') goto yy57;
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy540;
	if (yych == 't') goto yy540;
	goto yy57;
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy563;
		if (yych <= 'M') goto yy57;
		goto yy562;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy57;
			goto yy563;
		} else {
			if (yych == 'n') goto yy562;
			goto yy57;
		}
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy558;
	if (yych != 'n') goto yy57;
yy558:
	YYDEBUG(558, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'U') goto yy559;
			if (yych != 'u') goto yy476;
		}
	}
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy560;
	if (yych != 'a') goto yy57;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy561;
	if (yych != 'r') goto yy57;
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy540;
	if (yych == 'y') goto yy540;
	goto yy57;
yy562:
	YYDEBUG(562, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'E') goto yy540;
			if (yych == 'e') goto yy540;
			goto yy476;
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'Y') goto yy540;
			if (yych == 'y') goto yy540;
			goto yy476;
		}
	}
yy564:
	YYDEBUG(564, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy476;
			goto yy532;
		} else {
			if (yych == ' ') goto yy532;
			goto yy476;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy532;
			if (yych <= '/') goto yy476;
			goto yy534;
		} else {
			if (yych == 'I') goto yy540;
			goto yy476;
		}
	}
yy565:
	YYDEBUG(565, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy476;
			goto yy532;
		} else {
			if (yych == ' ') goto yy532;
			goto yy476;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy532;
			if (yych <= '/') goto yy476;
			goto yy534;
		} else {
			if (yych != 'I') goto yy476;
		}
	}
	YYDEBUG(566, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy476;
			goto yy532;
		} else {
			if (yych == ' ') goto yy532;
			goto yy476;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy532;
			if (yych <= '/') goto yy476;
			goto yy534;
		} else {
			if (yych == 'I') goto yy540;
			goto yy476;
		}
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy476;
			goto yy532;
		} else {
			if (yych == ' ') goto yy532;
			goto yy476;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy532;
			if (yych <= '/') goto yy476;
			goto yy534;
		} else {
			if (yych == 'I') goto yy540;
			goto yy476;
		}
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy491;
		if (yych <= '-') goto yy602;
		goto yy601;
	} else {
		if (yych <= '/') goto yy491;
		if (yych <= '9') goto yy615;
		if (yych <= ':') goto yy493;
		goto yy491;
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy491;
		if (yych <= '-') goto yy602;
		if (yych <= '.') goto yy601;
		goto yy491;
	} else {
		if (yych <= '2') goto yy615;
		if (yych <= '9') goto yy614;
		if (yych <= ':') goto yy493;
		goto yy491;
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy491;
		if (yych <= '-') goto yy602;
		goto yy601;
	} else {
		if (yych <= '/') goto yy491;
		if (yych <= '9') goto yy614;
		if (yych <= ':') goto yy493;
		goto yy491;
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy491;
		if (yych <= '-') goto yy602;
		goto yy601;
	} else {
		if (yych == ':') goto yy493;
		goto yy491;
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy595;
	if (yych == 'e') goto yy595;
	goto yy57;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy592;
	if (yych == 'a') goto yy592;
	goto yy57;
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy550;
		if (yych <= 'T') goto yy57;
		goto yy549;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy57;
			goto yy550;
		} else {
			if (yych == 'u') goto yy549;
			goto yy57;
		}
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy585;
	if (yych == 'e') goto yy585;
	goto yy57;
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy579;
	if (yych == 'e') goto yy579;
	goto yy57;
yy577:
	YYDEBUG(577, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy578:
	YYDEBUG(578, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy577;
	case 'A':
	case 'a':	goto yy574;
	case 'D':
	case 'd':	goto yy576;
	case 'F':
	case 'f':	goto yy572;
	case 'I':	goto yy475;
	case 'J':
	case 'j':	goto yy479;
	case 'M':
	case 'm':	goto yy573;
	case 'N':
	case 'n':	goto yy482;
	case 'O':
	case 'o':	goto yy481;
	case 'S':
	case 's':	goto yy575;
	case 'V':	goto yy477;
	case 'X':	goto yy478;
	default:	goto yy57;
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy580;
	if (yych != 'c') goto yy57;
yy580:
	YYDEBUG(580, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'E') goto yy581;
			if (yych != 'e') goto yy476;
		}
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy582;
	if (yych != 'm') goto yy57;
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy583;
	if (yych != 'b') goto yy57;
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy584;
	if (yych != 'e') goto yy57;
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy540;
	if (yych == 'r') goto yy540;
	goto yy57;
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy586;
	if (yych != 'p') goto yy57;
yy586:
	YYDEBUG(586, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'T') goto yy587;
			if (yych != 't') goto yy476;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'E') goto yy588;
			if (yych != 'e') goto yy476;
		}
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy589;
	if (yych != 'm') goto yy57;
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy590;
	if (yych != 'b') goto yy57;
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy591;
	if (yych != 'e') goto yy57;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy540;
	if (yych == 'r') goto yy540;
	goto yy57;
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy593;
		if (yych <= 'X') goto yy57;
		goto yy540;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy57;
		} else {
			if (yych == 'y') goto yy540;
			goto yy57;
		}
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'C') goto yy594;
			if (yych != 'c') goto yy476;
		}
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy540;
	if (yych == 'h') goto yy540;
	goto yy57;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy596;
	if (yych != 'b') goto yy57;
yy596:
	YYDEBUG(596, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			goto yy532;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'R') goto yy597;
			if (yych != 'r') goto yy476;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy598;
	if (yych != 'u') goto yy57;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy599;
	if (yych != 'a') goto yy57;
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy600;
	if (yych != 'r') goto yy57;
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy540;
	if (yych == 'y') goto yy540;
	goto yy57;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy608;
	if (yych <= '6') goto yy609;
	if (yych <= '9') goto yy610;
	goto yy57;
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(606, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(607, *YYCURSOR);
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych <= '/') goto yy491;
	if (yych <= '9') goto yy613;
	goto yy491;
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy497;
		goto yy491;
	} else {
		if (yych <= '0') goto yy613;
		if (yych <= '9') goto yy611;
		goto yy491;
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych <= '/') goto yy491;
	if (yych >= ':') goto yy491;
yy611:
	YYDEBUG(611, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy612;
	if (yych <= '9') goto yy605;
yy612:
	YYDEBUG(612, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy501;
			if (yych <= 0x1F) goto yy491;
			goto yy501;
		} else {
			if (yych == '.') goto yy497;
			if (yych <= '/') goto yy491;
			goto yy605;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy503;
			if (yych <= 'O') goto yy491;
			goto yy503;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy491;
				goto yy503;
			} else {
				if (yych == 'p') goto yy503;
				goto yy491;
			}
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy508;
			if (yych <= 0x1F) goto yy491;
			goto yy508;
		} else {
			if (yych == '.') goto yy493;
			if (yych <= '9') goto yy491;
			goto yy493;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy510;
			if (yych <= 'O') goto yy491;
			goto yy510;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy491;
				goto yy510;
			} else {
				if (yych == 'p') goto yy510;
				goto yy491;
			}
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy508;
			if (yych <= 0x1F) goto yy491;
			goto yy508;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy491;
				goto yy602;
			} else {
				if (yych <= '.') goto yy601;
				if (yych <= '9') goto yy491;
				goto yy493;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy510;
			if (yych <= 'O') goto yy491;
			goto yy510;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy491;
				goto yy510;
			} else {
				if (yych == 'p') goto yy510;
				goto yy491;
			}
		}
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy57;
		if (yych <= '-') goto yy655;
		goto yy602;
	} else {
		if (yych <= '/') goto yy57;
		if (yych <= '9') goto yy618;
		goto yy57;
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy57;
		if (yych <= '-') goto yy655;
		goto yy602;
	} else {
		if (yych <= '/') goto yy57;
		if (yych >= '3') goto yy57;
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy57;
	if (yych <= '-') goto yy655;
	if (yych <= '.') goto yy602;
	goto yy57;
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy651;
		if (yych <= 'T') goto yy57;
		goto yy650;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy57;
			goto yy651;
		} else {
			if (yych == 'u') goto yy650;
			goto yy57;
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy648;
	if (yych == 'e') goto yy648;
	goto yy57;
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy645;
	if (yych == 'a') goto yy645;
	goto yy57;
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy642;
		if (yych <= 'T') goto yy57;
		goto yy641;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy57;
			goto yy642;
		} else {
			if (yych == 'u') goto yy641;
			goto yy57;
		}
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy638;
	if (yych == 'e') goto yy638;
	goto yy57;
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy636;
	if (yych == 'c') goto yy636;
	goto yy57;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy634;
	if (yych == 'o') goto yy634;
	goto yy57;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy627;
	if (yych != 'e') goto yy57;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy628;
	if (yych != 'c') goto yy57;
yy628:
	YYDEBUG(628, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych >= '.') goto yy532;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'E') goto yy581;
			if (yych == 'e') goto yy581;
			goto yy476;
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy533;
	if (yych <= '0') goto yy630;
	if (yych <= '2') goto yy631;
	if (yych <= '3') goto yy632;
	goto yy533;
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy535;
	if (yych <= '9') goto yy633;
	goto yy535;
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy535;
	if (yych <= '9') goto yy633;
	goto yy535;
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy535;
	if (yych <= '1') goto yy633;
	if (yych <= '9') goto yy541;
	goto yy535;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy535;
	if (yych <= '9') goto yy542;
	goto yy535;
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy635;
	if (yych != 'v') goto yy57;
yy635:
	YYDEBUG(635, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'E') goto yy536;
			if (yych == 'e') goto yy536;
			goto yy476;
		}
	}
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy637;
	if (yych != 't') goto yy57;
yy637:
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'O') goto yy546;
			if (yych == 'o') goto yy546;
			goto yy476;
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy639;
	if (yych != 'p') goto yy57;
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'T') goto yy640;
			if (yych != 't') goto yy476;
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'E') goto yy588;
			if (yych == 'e') goto yy588;
			goto yy476;
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy644;
	if (yych == 'g') goto yy644;
	goto yy57;
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy643;
	if (yych != 'r') goto yy57;
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'I') goto yy552;
			if (yych == 'i') goto yy552;
			goto yy476;
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'U') goto yy554;
			if (yych == 'u') goto yy554;
			goto yy476;
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy646;
		if (yych <= 'X') goto yy57;
		goto yy647;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy57;
		} else {
			if (yych == 'y') goto yy647;
			goto yy57;
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'C') goto yy594;
			if (yych == 'c') goto yy594;
			goto yy476;
		}
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy476;
			goto yy532;
		} else {
			if (yych == ' ') goto yy532;
			goto yy476;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy629;
			goto yy532;
		} else {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy649;
	if (yych != 'b') goto yy57;
yy649:
	YYDEBUG(649, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'R') goto yy597;
			if (yych == 'r') goto yy597;
			goto yy476;
		}
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy654;
		if (yych <= 'M') goto yy57;
		goto yy653;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy57;
			goto yy654;
		} else {
			if (yych == 'n') goto yy653;
			goto yy57;
		}
	}
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy652;
	if (yych != 'n') goto yy57;
yy652:
	YYDEBUG(652, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'U') goto yy559;
			if (yych == 'u') goto yy559;
			goto yy476;
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'E') goto yy540;
			if (yych == 'e') goto yy540;
			goto yy476;
		}
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy476;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= ',') goto yy476;
			if (yych <= '-') goto yy629;
			goto yy532;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy476;
			if (yych <= '9') goto yy534;
			goto yy476;
		} else {
			if (yych <= 'Y') goto yy540;
			if (yych == 'y') goto yy540;
			goto yy476;
		}
	}
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy656;
	if (yych <= '3') goto yy658;
	if (yych <= '9') goto yy659;
	goto yy57;
yy656:
	YYDEBUG(656, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '9') goto yy665;
		if (yych >= 'n') goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
		}
	}
yy657:
	YYDEBUG(657, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy657;
			goto yy665;
		} else {
			if (yych <= '9') goto yy604;
			if (yych <= 'm') goto yy657;
			goto yy661;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '9') goto yy604;
		if (yych <= 'm') goto yy657;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy664;
	goto yy57;
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy664;
	goto yy57;
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy664;
	goto yy57;
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy57;
yy664:
	YYDEBUG(664, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy657;
yy665:
	YYDEBUG(665, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '9') goto yy605;
		if (yych <= 'm') goto yy657;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy666:
	YYDEBUG(666, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy723;
		} else {
			if (yych <= '9') goto yy669;
			if (yych >= 'n') goto yy720;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy721;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy722;
		}
	}
yy667:
	YYDEBUG(667, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy667;
			goto yy723;
		} else {
			if (yych <= '1') goto yy669;
			if (yych <= 'm') goto yy667;
			goto yy720;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy667;
			goto yy721;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy722;
			goto yy667;
		}
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy723;
		if (yych <= 'm') goto yy667;
		goto yy720;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy667;
			goto yy721;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy722;
			goto yy667;
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy718;
		if (yych <= 'T') goto yy57;
		goto yy717;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy57;
			goto yy718;
		} else {
			if (yych == 'u') goto yy717;
			goto yy57;
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy716;
	if (yych == 'e') goto yy716;
	goto yy57;
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy715;
	if (yych == 'a') goto yy715;
	goto yy57;
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy714;
		if (yych <= 'T') goto yy57;
		goto yy713;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy57;
			goto yy714;
		} else {
			if (yych == 'u') goto yy713;
			goto yy57;
		}
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy711;
	if (yych == 'e') goto yy711;
	goto yy57;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy710;
	if (yych == 'c') goto yy710;
	goto yy57;
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy709;
	if (yych == 'o') goto yy709;
	goto yy57;
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy678;
	if (yych != 'e') goto yy57;
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy679;
	if (yych != 'c') goto yy57;
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy57;
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy686;
	if (yych <= '2') goto yy687;
	goto yy57;
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy688;
	goto yy57;
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '5') goto yy57;
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '6') goto yy57;
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy693;
	if (yych <= '6') goto yy694;
	goto yy57;
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy695;
	goto yy57;
yy694:
	YYDEBUG(694, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy57;
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy696;
	if (yych != ' ') goto yy57;
yy696:
	YYDEBUG(696, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(697, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy57;
			goto yy696;
		} else {
			if (yych == ' ') goto yy696;
			goto yy57;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy57;
			goto yy699;
		} else {
			if (yych != 'G') goto yy57;
		}
	}
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy707;
	goto yy57;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy700;
	if (yych <= '2') goto yy702;
	if (yych <= '9') goto yy703;
	goto yy57;
yy700:
	YYDEBUG(700, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy701;
	if (yych <= '9') goto yy703;
	if (yych <= ':') goto yy704;
yy701:
	YYDEBUG(701, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy701;
		if (yych >= '5') goto yy705;
	} else {
		if (yych <= '9') goto yy706;
		if (yych <= ':') goto yy704;
		goto yy701;
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy701;
	if (yych <= '5') goto yy705;
	if (yych <= '9') goto yy706;
	if (yych >= ';') goto yy701;
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy701;
	if (yych <= '5') goto yy705;
	if (yych <= '9') goto yy706;
	goto yy701;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy701;
	if (yych >= ':') goto yy701;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy701;
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy57;
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy699;
	if (yych == '-') goto yy699;
	goto yy57;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy679;
	if (yych == 'v') goto yy679;
	goto yy57;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy679;
	if (yych == 't') goto yy679;
	goto yy57;
yy711:
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy712;
	if (yych != 'p') goto yy57;
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy680;
		goto yy57;
	} else {
		if (yych <= 'T') goto yy679;
		if (yych == 't') goto yy679;
		goto yy57;
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy679;
	if (yych == 'g') goto yy679;
	goto yy57;
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy679;
	if (yych == 'r') goto yy679;
	goto yy57;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy679;
		if (yych <= 'X') goto yy57;
		goto yy679;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy57;
			goto yy679;
		} else {
			if (yych == 'y') goto yy679;
			goto yy57;
		}
	}
yy716:
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy679;
	if (yych == 'b') goto yy679;
	goto yy57;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy679;
		if (yych <= 'M') goto yy57;
		goto yy679;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy57;
			goto yy679;
		} else {
			if (yych == 'n') goto yy679;
			goto yy57;
		}
	}
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy679;
	if (yych == 'n') goto yy679;
	goto yy57;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy728;
	goto yy57;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy728;
	goto yy57;
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy728;
	goto yy57;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy728;
	goto yy57;
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy667;
	if (yych >= ':') goto yy667;
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy667;
	if (yych >= ':') goto yy667;
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy667;
	if (yych >= ':') goto yy667;
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy667;
yy728:
	YYDEBUG(728, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy723;
	goto yy667;
yy729:
	YYDEBUG(729, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy731;
		goto yy578;
	} else {
		if (yych <= '-') goto yy732;
		if (yych <= '.') goto yy731;
		if (yych >= '0') goto yy578;
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case 'A':
	case 'a':	goto yy673;
	case 'D':
	case 'd':	goto yy677;
	case 'F':
	case 'f':	goto yy671;
	case 'J':
	case 'j':	goto yy670;
	case 'M':
	case 'm':	goto yy672;
	case 'N':
	case 'n':	goto yy676;
	case 'O':
	case 'o':	goto yy675;
	case 'S':
	case 's':	goto yy674;
	default:	goto yy57;
	}
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy578;
	if (yych <= '0') goto yy736;
	if (yych <= '1') goto yy737;
	if (yych <= '9') goto yy738;
	goto yy578;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy578;
	if (yych <= '0') goto yy733;
	if (yych <= '1') goto yy734;
	if (yych <= '9') goto yy735;
	goto yy578;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy57;
	if (yych <= '.') goto yy602;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy735;
	goto yy57;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy57;
	if (yych <= '.') goto yy602;
	if (yych <= '/') goto yy57;
	if (yych >= '3') goto yy57;
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy57;
	if (yych <= '.') goto yy602;
	goto yy57;
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy57;
		if (yych <= '-') goto yy602;
		goto yy739;
	} else {
		if (yych <= '/') goto yy57;
		if (yych <= '9') goto yy738;
		goto yy57;
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy57;
		if (yych <= '-') goto yy602;
		goto yy739;
	} else {
		if (yych <= '/') goto yy57;
		if (yych >= '3') goto yy57;
	}
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy57;
	if (yych <= '-') goto yy602;
	if (yych >= '/') goto yy57;
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(740, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy611;
	goto yy57;
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy785;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy783;
	goto yy61;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy751;
	case '1':	goto yy752;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy753;
	case 'A':
	case 'a':	goto yy746;
	case 'D':
	case 'd':	goto yy750;
	case 'F':
	case 'f':	goto yy744;
	case 'J':
	case 'j':	goto yy743;
	case 'M':
	case 'm':	goto yy745;
	case 'N':
	case 'n':	goto yy749;
	case 'O':
	case 'o':	goto yy748;
	case 'S':
	case 's':	goto yy747;
	default:	goto yy57;
	}
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy782;
		if (yych <= 'T') goto yy57;
		goto yy781;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy57;
			goto yy782;
		} else {
			if (yych == 'u') goto yy781;
			goto yy57;
		}
	}
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy780;
	if (yych == 'e') goto yy780;
	goto yy57;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy779;
	if (yych == 'a') goto yy779;
	goto yy57;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy778;
		if (yych <= 'T') goto yy57;
		goto yy777;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy57;
			goto yy778;
		} else {
			if (yych == 'u') goto yy777;
			goto yy57;
		}
	}
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy775;
	if (yych == 'e') goto yy775;
	goto yy57;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy774;
	if (yych == 'c') goto yy774;
	goto yy57;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy773;
	if (yych == 'o') goto yy773;
	goto yy57;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy765;
	if (yych == 'e') goto yy765;
	goto yy57;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy754;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy758;
	goto yy57;
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy754;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy758;
	goto yy57;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy57;
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy755;
	if (yych <= '3') goto yy756;
	if (yych <= '9') goto yy757;
	goto yy57;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '9') goto yy757;
		if (yych <= 'm') goto yy657;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '1') goto yy757;
		if (yych <= 'm') goto yy657;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy757:
	YYDEBUG(757, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy661;
		goto yy657;
	} else {
		if (yych <= 'r') goto yy662;
		if (yych <= 's') goto yy660;
		if (yych <= 't') goto yy663;
		goto yy657;
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy57;
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych >= '1') goto yy761;
	} else {
		if (yych <= '3') goto yy762;
		if (yych <= '9') goto yy757;
		goto yy57;
	}
	YYDEBUG(760, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '9') goto yy763;
		if (yych <= 'm') goto yy657;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy761:
	YYDEBUG(761, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '9') goto yy763;
		if (yych <= 'm') goto yy657;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy762:
	YYDEBUG(762, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '1') goto yy763;
		if (yych <= 'm') goto yy657;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy763:
	YYDEBUG(763, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy661;
	} else {
		if (yych <= 'r') goto yy662;
		if (yych <= 's') goto yy660;
		if (yych <= 't') goto yy663;
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy766;
	if (yych != 'c') goto yy57;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy57;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy768;
	if (yych <= '2') goto yy769;
	if (yych <= '3') goto yy770;
	goto yy57;
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy771;
	goto yy57;
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy771;
	goto yy57;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '2') goto yy57;
yy771:
	YYDEBUG(771, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(772, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy766;
	if (yych == 'v') goto yy766;
	goto yy57;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy766;
	if (yych == 't') goto yy766;
	goto yy57;
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy776;
	if (yych != 'p') goto yy57;
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy767;
		goto yy57;
	} else {
		if (yych <= 'T') goto yy766;
		if (yych == 't') goto yy766;
		goto yy57;
	}
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy766;
	if (yych == 'g') goto yy766;
	goto yy57;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy766;
	if (yych == 'r') goto yy766;
	goto yy57;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy766;
		if (yych <= 'X') goto yy57;
		goto yy766;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy57;
			goto yy766;
		} else {
			if (yych == 'y') goto yy766;
			goto yy57;
		}
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy766;
	if (yych == 'b') goto yy766;
	goto yy57;
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy766;
		if (yych <= 'M') goto yy57;
		goto yy766;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy57;
			goto yy766;
		} else {
			if (yych == 'n') goto yy766;
			goto yy57;
		}
	}
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy766;
	if (yych == 'n') goto yy766;
	goto yy57;
yy783:
	YYDEBUG(783, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy791;
	case '-':	goto yy788;
	case '.':	goto yy792;
	case '/':	goto yy789;
	case '0':	goto yy805;
	case '1':	goto yy806;
	case '2':	goto yy808;
	case '3':	goto yy809;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	case ':':	goto yy807;
	case 'W':	goto yy810;
	default:	goto yy784;
	}
yy784:
	YYDEBUG(784, *YYCURSOR);
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy786;
	case '1':	goto yy787;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy753;
	case 'A':
	case 'a':	goto yy746;
	case 'D':
	case 'd':	goto yy750;
	case 'F':
	case 'f':	goto yy744;
	case 'J':
	case 'j':	goto yy743;
	case 'M':
	case 'm':	goto yy745;
	case 'N':
	case 'n':	goto yy749;
	case 'O':
	case 'o':	goto yy748;
	case 'S':
	case 's':	goto yy747;
	default:	goto yy57;
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy754;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy753;
	goto yy57;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy754;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy753;
	goto yy57;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy973;
	case '1':	goto yy975;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy976;
	case 'A':
	case 'a':	goto yy967;
	case 'D':
	case 'd':	goto yy971;
	case 'F':
	case 'f':	goto yy965;
	case 'J':
	case 'j':	goto yy964;
	case 'M':
	case 'm':	goto yy966;
	case 'N':
	case 'n':	goto yy970;
	case 'O':
	case 'o':	goto yy969;
	case 'S':
	case 's':	goto yy968;
	case 'W':	goto yy972;
	default:	goto yy939;
	}
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy947;
	if (yych <= '1') goto yy948;
	if (yych <= '9') goto yy949;
	goto yy57;
yy790:
	YYDEBUG(790, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy791:
	YYDEBUG(791, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy790;
	case '-':
	case '.':	goto yy938;
	case 'A':
	case 'a':	goto yy800;
	case 'D':
	case 'd':	goto yy804;
	case 'F':
	case 'f':	goto yy798;
	case 'H':
	case 'h':	goto yy64;
	case 'I':	goto yy793;
	case 'J':
	case 'j':	goto yy797;
	case 'M':
	case 'm':	goto yy799;
	case 'N':
	case 'n':	goto yy803;
	case 'O':
	case 'o':	goto yy802;
	case 'S':
	case 's':	goto yy801;
	case 'T':
	case 't':	goto yy69;
	case 'V':	goto yy795;
	case 'W':
	case 'w':	goto yy68;
	case 'X':	goto yy796;
	case 'Y':
	case 'y':	goto yy67;
	default:	goto yy57;
	}
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy939;
	if (yych <= '0') goto yy931;
	if (yych <= '2') goto yy932;
	if (yych <= '3') goto yy933;
	goto yy939;
yy793:
	YYDEBUG(793, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy930;
	} else {
		if (yych == 'W') goto yy794;
		if (yych <= 'X') goto yy884;
	}
yy794:
	YYDEBUG(794, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy928;
	goto yy794;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy927;
	goto yy794;
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy920;
		if (yych <= 'T') goto yy57;
		goto yy919;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy57;
			goto yy920;
		} else {
			if (yych == 'u') goto yy919;
			goto yy57;
		}
	}
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy913;
			goto yy57;
		} else {
			if (yych <= 'O') goto yy99;
			if (yych <= 'Q') goto yy57;
			goto yy98;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy913;
			goto yy57;
		} else {
			if (yych <= 'o') goto yy99;
			if (yych == 'r') goto yy98;
			goto yy57;
		}
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy910;
			goto yy57;
		} else {
			if (yych <= 'I') goto yy118;
			if (yych <= 'N') goto yy57;
			goto yy117;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy910;
			goto yy57;
		} else {
			if (yych <= 'i') goto yy118;
			if (yych == 'o') goto yy117;
			goto yy57;
		}
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy904;
		if (yych <= 'T') goto yy57;
		goto yy903;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy57;
			goto yy904;
		} else {
			if (yych == 'u') goto yy903;
			goto yy57;
		}
	}
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy127;
			goto yy57;
		} else {
			if (yych <= 'E') goto yy896;
			if (yych <= 'T') goto yy57;
			goto yy126;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy127;
			goto yy57;
		} else {
			if (yych <= 'e') goto yy896;
			if (yych == 'u') goto yy126;
			goto yy57;
		}
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy891;
	if (yych == 'c') goto yy891;
	goto yy57;
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy885;
	if (yych == 'o') goto yy885;
	goto yy57;
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy114;
		if (yych <= 'D') goto yy57;
		goto yy878;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy57;
			goto yy114;
		} else {
			if (yych == 'e') goto yy878;
			goto yy57;
		}
	}
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '0') goto yy875;
	if (yych <= '9') goto yy876;
	goto yy61;
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '2') goto yy844;
	if (yych <= '9') goto yy823;
	goto yy61;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy824;
	if (yych <= '1') goto yy825;
	goto yy57;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy823;
	goto yy61;
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '5') goto yy819;
	if (yych <= '6') goto yy820;
	if (yych <= '9') goto yy55;
	goto yy61;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy57;
		if (yych <= '0') goto yy811;
		if (yych <= '4') goto yy812;
		goto yy813;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy57;
			goto yy83;
		} else {
			if (yych == 'e') goto yy83;
			goto yy57;
		}
	}
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy57;
	if (yych <= '9') goto yy814;
	goto yy57;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy814;
	goto yy57;
yy813:
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '4') goto yy57;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy816;
	if (yych <= '/') goto yy815;
	if (yych <= '7') goto yy817;
yy815:
	YYDEBUG(815, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy816:
	YYDEBUG(816, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '8') goto yy57;
yy817:
	YYDEBUG(817, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(818, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy821;
	goto yy61;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '6') goto yy821;
	if (yych <= '9') goto yy55;
	goto yy61;
yy821:
	YYDEBUG(821, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy55;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych >= ' ') goto yy61;
			} else {
				if (yych == 'D') goto yy61;
				if (yych >= 'F') goto yy61;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy61;
				if (yych >= 'M') goto yy61;
			} else {
				if (yych <= 'R') goto yy822;
				if (yych <= 'T') goto yy61;
				if (yych >= 'W') goto yy61;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy61;
				if (yych >= 'd') goto yy61;
			} else {
				if (yych == 'f') goto yy61;
				if (yych >= 'h') goto yy61;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych >= 's') goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy61;
				} else {
					if (yych == 'y') goto yy61;
				}
			}
		}
	}
yy822:
	YYDEBUG(822, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy821;
	goto yy61;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy826;
	goto yy57;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '3') goto yy57;
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy828;
	if (yych <= '2') goto yy829;
	if (yych <= '3') goto yy830;
	goto yy57;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy831;
	goto yy57;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy831;
	goto yy57;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '2') goto yy57;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy57;
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy833;
	if (yych <= '2') goto yy834;
	goto yy57;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy835;
	goto yy57;
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '5') goto yy57;
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '6') goto yy57;
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy840;
	if (yych <= '6') goto yy841;
	goto yy57;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy842;
	goto yy57;
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy57;
yy842:
	YYDEBUG(842, *YYCURSOR);
	++YYCURSOR;
yy843:
	YYDEBUG(843, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy844:
	YYDEBUG(844, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy61;
		if (yych >= '1') goto yy846;
	} else {
		if (yych <= '3') goto yy847;
		if (yych <= '9') goto yy821;
		goto yy61;
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy822;
				goto yy61;
			} else {
				if (yych <= '/') goto yy822;
				if (yych <= '9') goto yy848;
				if (yych <= 'C') goto yy822;
				goto yy61;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy822;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy822;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy822;
					if (yych <= 'T') goto yy61;
					goto yy822;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy822;
				if (yych <= 'Y') goto yy61;
				goto yy822;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy822;
				} else {
					if (yych == 'g') goto yy822;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy822;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy822;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy822;
				}
			}
		}
	}
yy846:
	YYDEBUG(846, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy822;
				goto yy61;
			} else {
				if (yych <= '/') goto yy822;
				if (yych <= '9') goto yy848;
				if (yych <= 'C') goto yy822;
				goto yy61;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy822;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy822;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy822;
					if (yych <= 'T') goto yy61;
					goto yy822;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy822;
				if (yych <= 'Y') goto yy61;
				goto yy822;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy822;
				} else {
					if (yych == 'g') goto yy822;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy822;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy822;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy822;
				}
			}
		}
	}
yy847:
	YYDEBUG(847, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy822;
				goto yy61;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy822;
				} else {
					if (yych <= '9') goto yy55;
					if (yych <= 'C') goto yy822;
					goto yy61;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy822;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy822;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy822;
					if (yych <= 'T') goto yy61;
					goto yy822;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy822;
				if (yych <= 'Y') goto yy61;
				goto yy822;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy822;
				} else {
					if (yych == 'g') goto yy822;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy822;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy822;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy822;
				}
			}
		}
	}
yy848:
	YYDEBUG(848, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy55;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy65;
				if (yych >= 'F') goto yy66;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy64;
				if (yych >= 'M') goto yy63;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy62;
				} else {
					if (yych <= 'T') goto yy850;
					if (yych >= 'W') goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy67;
				if (yych >= 'd') goto yy65;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy66;
				} else {
					if (yych == 'h') goto yy64;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy63;
				if (yych <= 'r') goto yy849;
				if (yych <= 's') goto yy62;
				goto yy851;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy68;
				} else {
					if (yych == 'y') goto yy67;
				}
			}
		}
	}
yy849:
	YYDEBUG(849, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy57;
			if (yych <= '1') goto yy865;
			goto yy866;
		} else {
			if (yych <= '9') goto yy867;
			if (yych <= 'G') goto yy57;
			goto yy70;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy71;
			goto yy57;
		} else {
			if (yych <= 'h') goto yy70;
			if (yych == 'u') goto yy71;
			goto yy57;
		}
	}
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy57;
			if (yych >= '2') goto yy853;
		} else {
			if (yych <= '9') goto yy854;
			if (yych <= 'G') goto yy57;
			goto yy70;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy71;
			goto yy57;
		} else {
			if (yych <= 'h') goto yy70;
			if (yych == 'u') goto yy71;
			goto yy57;
		}
	}
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy859;
	if (yych <= '9') goto yy854;
	goto yy57;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '4') goto yy859;
	if (yych <= '5') goto yy855;
	goto yy57;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '6') goto yy57;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy857;
	if (yych <= '6') goto yy858;
	goto yy57;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy842;
	goto yy57;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy842;
	goto yy57;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy860;
	if (yych <= '9') goto yy856;
	goto yy57;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy861;
	if (yych <= '6') goto yy862;
	if (yych <= '9') goto yy856;
	goto yy57;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy863;
	if (yych <= '6') goto yy864;
	if (yych <= '9') goto yy842;
	goto yy57;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy863;
	if (yych <= '5') goto yy857;
	if (yych <= '6') goto yy858;
	goto yy57;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy843;
	if (yych <= '9') goto yy842;
	goto yy843;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy842;
	goto yy843;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy874;
	if (yych <= '9') goto yy867;
	if (yych <= ':') goto yy868;
	goto yy57;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy57;
		if (yych <= '4') goto yy874;
		goto yy855;
	} else {
		if (yych == ':') goto yy868;
		goto yy57;
	}
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy855;
	if (yych != ':') goto yy57;
yy868:
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= '6') goto yy57;
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy872;
	if (yych <= '6') goto yy873;
	goto yy57;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy842;
	goto yy57;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy842;
	goto yy57;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy860;
	if (yych <= '9') goto yy856;
	if (yych <= ':') goto yy868;
	goto yy57;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy61;
		if (yych <= '0') goto yy877;
		goto yy846;
	} else {
		if (yych <= '3') goto yy847;
		if (yych <= '9') goto yy821;
		goto yy61;
	}
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy61;
		if (yych <= '0') goto yy845;
		goto yy846;
	} else {
		if (yych <= '3') goto yy847;
		if (yych <= '9') goto yy821;
		goto yy61;
	}
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy848;
	goto yy61;
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy879;
	if (yych != 'c') goto yy57;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy880;
	if (yych != 'e') goto yy794;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy881;
	if (yych != 'm') goto yy57;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy882;
	if (yych != 'b') goto yy57;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy883;
	if (yych != 'e') goto yy57;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy884;
	if (yych != 'r') goto yy57;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy794;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy886;
	if (yych != 'v') goto yy57;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy887;
	if (yych != 'e') goto yy794;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy888;
	if (yych != 'm') goto yy57;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy889;
	if (yych != 'b') goto yy57;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy890;
	if (yych != 'e') goto yy57;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy884;
	if (yych == 'r') goto yy884;
	goto yy57;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy892;
	if (yych != 't') goto yy57;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy893;
	if (yych != 'o') goto yy794;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy894;
	if (yych != 'b') goto yy57;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy895;
	if (yych != 'e') goto yy57;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy884;
	if (yych == 'r') goto yy884;
	goto yy57;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy129;
		if (yych <= 'O') goto yy57;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy57;
			goto yy129;
		} else {
			if (yych != 'p') goto yy57;
		}
	}
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy898;
	if (yych != 't') goto yy794;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy899;
	if (yych != 'e') goto yy794;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy900;
	if (yych != 'm') goto yy57;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy901;
	if (yych != 'b') goto yy57;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy902;
	if (yych != 'e') goto yy57;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy884;
	if (yych == 'r') goto yy884;
	goto yy57;
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy907;
	if (yych == 'g') goto yy907;
	goto yy57;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy905;
	if (yych != 'r') goto yy57;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy906;
	if (yych != 'i') goto yy794;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy884;
	if (yych == 'l') goto yy884;
	goto yy57;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy908;
	if (yych != 'u') goto yy794;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy909;
	if (yych != 's') goto yy57;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy884;
	if (yych == 't') goto yy884;
	goto yy57;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy911;
		if (yych <= 'X') goto yy57;
		goto yy884;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy57;
		} else {
			if (yych == 'y') goto yy884;
			goto yy57;
		}
	}
yy911:
	YYDEBUG(911, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy912;
	if (yych != 'c') goto yy794;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy884;
	if (yych == 'h') goto yy884;
	goto yy57;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy914;
	if (yych != 'b') goto yy57;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy915;
	if (yych != 'r') goto yy794;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy916;
	if (yych != 'u') goto yy57;
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy917;
	if (yych != 'a') goto yy57;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy918;
	if (yych != 'r') goto yy57;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy884;
	if (yych == 'y') goto yy884;
	goto yy57;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy926;
		if (yych <= 'M') goto yy57;
		goto yy925;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy57;
			goto yy926;
		} else {
			if (yych == 'n') goto yy925;
			goto yy57;
		}
	}
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy921;
	if (yych != 'n') goto yy57;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy922;
	if (yych != 'u') goto yy794;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy923;
	if (yych != 'a') goto yy57;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy924;
	if (yych != 'r') goto yy57;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy884;
	if (yych == 'y') goto yy884;
	goto yy57;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy884;
	if (yych == 'e') goto yy884;
	goto yy794;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy884;
	if (yych == 'y') goto yy884;
	goto yy794;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy884;
	goto yy794;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy794;
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy884;
	goto yy794;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy884;
	goto yy794;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy946;
	if (yych <= '9') goto yy945;
	goto yy57;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy944;
	goto yy57;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy942;
	if (yych <= '6') goto yy941;
	goto yy57;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy913;
	if (yych == 'e') goto yy913;
	goto yy57;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy910;
	if (yych == 'a') goto yy910;
	goto yy57;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy940;
	if (yych == 'e') goto yy940;
	goto yy57;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy878;
	if (yych == 'e') goto yy878;
	goto yy57;
yy938:
	YYDEBUG(938, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy939:
	YYDEBUG(939, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy938;
	case 'A':
	case 'a':	goto yy800;
	case 'D':
	case 'd':	goto yy937;
	case 'F':
	case 'f':	goto yy934;
	case 'I':	goto yy793;
	case 'J':
	case 'j':	goto yy797;
	case 'M':
	case 'm':	goto yy935;
	case 'N':
	case 'n':	goto yy803;
	case 'O':
	case 'o':	goto yy802;
	case 'S':
	case 's':	goto yy936;
	case 'V':	goto yy795;
	case 'X':	goto yy796;
	default:	goto yy57;
	}
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy897;
	if (yych == 'p') goto yy897;
	goto yy57;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '6') goto yy943;
	goto yy57;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy822;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy943;
	goto yy57;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy943;
	goto yy57;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy57;
	if (yych <= '9') goto yy943;
	goto yy57;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy57;
	if (yych <= '/') goto yy950;
	if (yych <= '9') goto yy958;
	goto yy57;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy57;
	if (yych <= '/') goto yy950;
	if (yych <= '2') goto yy958;
	goto yy57;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy57;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy951;
	if (yych <= '3') goto yy952;
	if (yych <= '9') goto yy953;
	goto yy57;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy953;
		if (yych <= 'm') goto yy455;
		goto yy955;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy455;
			goto yy956;
		} else {
			if (yych <= 's') goto yy954;
			if (yych <= 't') goto yy957;
			goto yy455;
		}
	}
yy952:
	YYDEBUG(952, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy455;
		if (yych <= '1') goto yy953;
		if (yych <= 'm') goto yy455;
		goto yy955;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy455;
			goto yy956;
		} else {
			if (yych <= 's') goto yy954;
			if (yych <= 't') goto yy957;
			goto yy455;
		}
	}
yy953:
	YYDEBUG(953, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy955;
		goto yy455;
	} else {
		if (yych <= 'r') goto yy956;
		if (yych <= 's') goto yy954;
		if (yych <= 't') goto yy957;
		goto yy455;
	}
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy454;
	goto yy57;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy454;
	goto yy57;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy454;
	goto yy57;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy454;
	goto yy57;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy57;
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych >= '1') goto yy961;
	} else {
		if (yych <= '3') goto yy962;
		if (yych <= '9') goto yy953;
		goto yy57;
	}
	YYDEBUG(960, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy963;
		if (yych <= 'm') goto yy455;
		goto yy955;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy455;
			goto yy956;
		} else {
			if (yych <= 's') goto yy954;
			if (yych <= 't') goto yy957;
			goto yy455;
		}
	}
yy961:
	YYDEBUG(961, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy963;
		if (yych <= 'm') goto yy455;
		goto yy955;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy455;
			goto yy956;
		} else {
			if (yych <= 's') goto yy954;
			if (yych <= 't') goto yy957;
			goto yy455;
		}
	}
yy962:
	YYDEBUG(962, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy455;
		if (yych <= '1') goto yy963;
		if (yych <= 'm') goto yy455;
		goto yy955;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy455;
			goto yy956;
		} else {
			if (yych <= 's') goto yy954;
			if (yych <= 't') goto yy957;
			goto yy455;
		}
	}
yy963:
	YYDEBUG(963, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy454;
		if (yych <= 'm') goto yy455;
		goto yy955;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy455;
			goto yy956;
		} else {
			if (yych <= 's') goto yy954;
			if (yych <= 't') goto yy957;
			goto yy455;
		}
	}
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1044;
		if (yych <= 'T') goto yy57;
		goto yy1043;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy57;
			goto yy1044;
		} else {
			if (yych == 'u') goto yy1043;
			goto yy57;
		}
	}
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1041;
	if (yych == 'e') goto yy1041;
	goto yy57;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1038;
	if (yych == 'a') goto yy1038;
	goto yy57;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1035;
		if (yych <= 'T') goto yy57;
		goto yy1034;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy57;
			goto yy1035;
		} else {
			if (yych == 'u') goto yy1034;
			goto yy57;
		}
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1031;
	if (yych == 'e') goto yy1031;
	goto yy57;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1029;
	if (yych == 'c') goto yy1029;
	goto yy57;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1027;
	if (yych == 'o') goto yy1027;
	goto yy57;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1025;
	if (yych == 'e') goto yy1025;
	goto yy57;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy811;
	if (yych <= '4') goto yy812;
	if (yych <= '5') goto yy813;
	goto yy57;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy977;
	if (yych <= '/') goto yy974;
	if (yych <= '9') goto yy996;
yy974:
	YYDEBUG(974, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy975:
	YYDEBUG(975, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy977;
	if (yych <= '/') goto yy974;
	if (yych <= '2') goto yy996;
	goto yy974;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy974;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy978;
	if (yych <= '3') goto yy979;
	if (yych <= '9') goto yy980;
	goto yy57;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy657;
			goto yy980;
		} else {
			if (yych == 'T') goto yy985;
			goto yy657;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy982;
			if (yych <= 'q') goto yy657;
			goto yy983;
		} else {
			if (yych <= 's') goto yy981;
			if (yych <= 't') goto yy984;
			goto yy657;
		}
	}
yy979:
	YYDEBUG(979, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy657;
		} else {
			if (yych == 'T') goto yy985;
			goto yy657;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy982;
			if (yych <= 'q') goto yy657;
			goto yy983;
		} else {
			if (yych <= 's') goto yy981;
			if (yych <= 't') goto yy984;
			goto yy657;
		}
	}
yy980:
	YYDEBUG(980, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy985;
		if (yych <= 'm') goto yy657;
		goto yy982;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy983;
		} else {
			if (yych <= 's') goto yy981;
			if (yych <= 't') goto yy984;
			goto yy657;
		}
	}
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy995;
	goto yy57;
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy995;
	goto yy57;
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy995;
	goto yy57;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy995;
	goto yy57;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy986;
	if (yych <= '2') goto yy987;
	if (yych <= '9') goto yy988;
	goto yy57;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy988;
	if (yych <= ':') goto yy989;
	goto yy57;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '4') goto yy988;
	if (yych == ':') goto yy989;
	goto yy57;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy990;
	if (yych <= '9') goto yy991;
	goto yy57;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy991;
	if (yych <= ':') goto yy992;
	goto yy57;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy993;
	if (yych <= '6') goto yy994;
	if (yych <= '9') goto yy842;
	goto yy57;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy843;
	if (yych <= '9') goto yy842;
	goto yy843;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy842;
	goto yy843;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy985;
	goto yy657;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy974;
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych >= '1') goto yy999;
	} else {
		if (yych <= '3') goto yy1000;
		if (yych <= '9') goto yy980;
		goto yy57;
	}
	YYDEBUG(998, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy657;
			goto yy1001;
		} else {
			if (yych == 'T') goto yy985;
			goto yy657;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy982;
			if (yych <= 'q') goto yy657;
			goto yy983;
		} else {
			if (yych <= 's') goto yy981;
			if (yych <= 't') goto yy984;
			goto yy657;
		}
	}
yy999:
	YYDEBUG(999, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy657;
			goto yy1001;
		} else {
			if (yych == 'T') goto yy985;
			goto yy657;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy982;
			if (yych <= 'q') goto yy657;
			goto yy983;
		} else {
			if (yych <= 's') goto yy981;
			if (yych <= 't') goto yy984;
			goto yy657;
		}
	}
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy657;
		} else {
			if (yych == 'T') goto yy985;
			goto yy657;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy982;
			if (yych <= 'q') goto yy657;
			goto yy983;
		} else {
			if (yych <= 's') goto yy981;
			if (yych <= 't') goto yy984;
			goto yy657;
		}
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1002;
		if (yych <= 'm') goto yy455;
		goto yy982;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy455;
			goto yy983;
		} else {
			if (yych <= 's') goto yy981;
			if (yych <= 't') goto yy984;
			goto yy455;
		}
	}
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy1003;
	if (yych <= '2') goto yy1004;
	if (yych <= '9') goto yy988;
	goto yy57;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1005;
	if (yych <= ':') goto yy989;
	goto yy57;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '4') goto yy1005;
	if (yych == ':') goto yy989;
	goto yy57;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1007;
	if (yych <= '9') goto yy991;
	goto yy57;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1008;
	if (yych <= ':') goto yy992;
	goto yy57;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy57;
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1010;
	if (yych <= '6') goto yy1011;
	if (yych <= '9') goto yy842;
	goto yy57;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy843;
	if (yych <= '9') goto yy1012;
	goto yy843;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy843;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy843;
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yyaccept = 23;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(1015, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy1017;
		if (yych <= ',') goto yy843;
		goto yy1017;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy843;
			goto yy1014;
		} else {
			if (yych != 'G') goto yy843;
		}
	}
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1023;
	goto yy57;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy1018;
	if (yych <= '2') goto yy1019;
	if (yych <= '9') goto yy1020;
	goto yy57;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy843;
	if (yych <= '9') goto yy1020;
	if (yych <= ':') goto yy1021;
	goto yy843;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy843;
		if (yych >= '5') goto yy1022;
	} else {
		if (yych <= '9') goto yy842;
		if (yych <= ':') goto yy1021;
		goto yy843;
	}
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy843;
	if (yych <= '5') goto yy1022;
	if (yych <= '9') goto yy842;
	if (yych >= ';') goto yy843;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy843;
	if (yych <= '5') goto yy1022;
	if (yych <= '9') goto yy842;
	goto yy843;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy843;
	if (yych <= '9') goto yy842;
	goto yy843;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy57;
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1017;
	if (yych == '-') goto yy1017;
	goto yy57;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1026;
	if (yych != 'c') goto yy57;
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'E') goto yy880;
		if (yych == 'e') goto yy880;
		goto yy794;
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1028;
	if (yych != 'v') goto yy57;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'E') goto yy887;
		if (yych == 'e') goto yy887;
		goto yy794;
	}
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1030;
	if (yych != 't') goto yy57;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'O') goto yy893;
		if (yych == 'o') goto yy893;
		goto yy794;
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1032;
	if (yych != 'p') goto yy57;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'T') goto yy1033;
		if (yych != 't') goto yy794;
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'E') goto yy899;
		if (yych == 'e') goto yy899;
		goto yy794;
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1037;
	if (yych == 'g') goto yy1037;
	goto yy57;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1036;
	if (yych != 'r') goto yy57;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'I') goto yy906;
		if (yych == 'i') goto yy906;
		goto yy794;
	}
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'U') goto yy908;
		if (yych == 'u') goto yy908;
		goto yy794;
	}
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1039;
		if (yych <= 'X') goto yy57;
		goto yy1040;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy57;
		} else {
			if (yych == 'y') goto yy1040;
			goto yy57;
		}
	}
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'C') goto yy912;
		if (yych == 'c') goto yy912;
		goto yy794;
	}
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy767;
	goto yy794;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1042;
	if (yych != 'b') goto yy57;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'R') goto yy915;
		if (yych == 'r') goto yy915;
		goto yy794;
	}
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1047;
		if (yych <= 'M') goto yy57;
		goto yy1046;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy57;
			goto yy1047;
		} else {
			if (yych == 'n') goto yy1046;
			goto yy57;
		}
	}
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1045;
	if (yych != 'n') goto yy57;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'U') goto yy922;
		if (yych == 'u') goto yy922;
		goto yy794;
	}
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'E') goto yy884;
		if (yych == 'e') goto yy884;
		goto yy794;
	}
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy767;
		goto yy794;
	} else {
		if (yych <= 'Y') goto yy884;
		if (yych == 'y') goto yy884;
		goto yy794;
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy578;
			goto yy731;
		} else {
			if (yych <= ',') goto yy578;
			if (yych <= '-') goto yy732;
			goto yy731;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy730;
			if (yych <= 'T') goto yy578;
			goto yy78;
		} else {
			if (yych == 'u') goto yy78;
			goto yy578;
		}
	}
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy129;
		if (yych <= 'O') goto yy57;
		goto yy586;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy57;
			goto yy129;
		} else {
			if (yych == 'p') goto yy586;
			goto yy57;
		}
	}
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1052;
			goto yy1054;
		} else {
			if (yych <= '-') goto yy1051;
			if (yych <= '.') goto yy731;
			if (yych <= '/') goto yy730;
			goto yy741;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy470;
			goto yy1054;
		} else {
			if (yych <= 'r') goto yy471;
			if (yych <= 's') goto yy464;
			if (yych <= 't') goto yy468;
			goto yy1054;
		}
	}
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy1055;
	case '1':	goto yy1056;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy618;
	case 'A':
	case 'a':	goto yy622;
	case 'D':
	case 'd':	goto yy626;
	case 'F':
	case 'f':	goto yy620;
	case 'J':
	case 'j':	goto yy619;
	case 'M':
	case 'm':	goto yy621;
	case 'N':
	case 'n':	goto yy625;
	case 'O':
	case 'o':	goto yy624;
	case 'S':
	case 's':	goto yy623;
	default:	goto yy578;
	}
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1054;
	if (yych <= '0') goto yy736;
	if (yych <= '1') goto yy737;
	if (yych <= '9') goto yy738;
	goto yy1054;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1053;
	case '-':
	case '.':	goto yy577;
	case 'A':
	case 'a':	goto yy574;
	case 'D':
	case 'd':	goto yy466;
	case 'F':
	case 'f':	goto yy467;
	case 'H':
	case 'h':	goto yy64;
	case 'I':	goto yy475;
	case 'J':
	case 'j':	goto yy479;
	case 'M':
	case 'm':	goto yy465;
	case 'N':
	case 'n':	goto yy482;
	case 'O':
	case 'o':	goto yy481;
	case 'S':
	case 's':	goto yy463;
	case 'T':
	case 't':	goto yy69;
	case 'V':	goto yy477;
	case 'W':
	case 'w':	goto yy68;
	case 'X':	goto yy478;
	case 'Y':
	case 'y':	goto yy67;
	default:	goto yy57;
	}
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy57;
		if (yych <= '-') goto yy655;
		goto yy602;
	} else {
		if (yych <= '/') goto yy57;
		if (yych <= '9') goto yy1057;
		goto yy57;
	}
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy57;
		if (yych <= '-') goto yy655;
		goto yy602;
	} else {
		if (yych <= '/') goto yy57;
		if (yych >= '3') goto yy57;
	}
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy57;
	if (yych <= '-') goto yy1058;
	if (yych <= '.') goto yy602;
	goto yy57;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych >= '1') goto yy1060;
	} else {
		if (yych <= '3') goto yy1061;
		if (yych <= '9') goto yy659;
		goto yy57;
	}
	YYDEBUG(1059, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '9') goto yy1062;
		if (yych <= 'm') goto yy657;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy657;
		if (yych <= '9') goto yy1062;
		if (yych <= 'm') goto yy657;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy657;
		} else {
			if (yych <= '9') goto yy604;
			if (yych <= 'm') goto yy657;
			goto yy661;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy657;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy657;
		}
	}
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy764;
		if (yych <= '9') goto yy605;
		if (yych <= 'm') goto yy764;
		goto yy661;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy764;
			goto yy662;
		} else {
			if (yych <= 's') goto yy660;
			if (yych <= 't') goto yy663;
			goto yy764;
		}
	}
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1052;
			if (yych <= ',') goto yy1054;
			goto yy1051;
		} else {
			if (yych <= '.') goto yy1064;
			if (yych <= '/') goto yy730;
			if (yych <= '5') goto yy1066;
			goto yy741;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1065;
			if (yych == 'n') goto yy470;
			goto yy1054;
		} else {
			if (yych <= 'r') goto yy471;
			if (yych <= 's') goto yy464;
			if (yych <= 't') goto yy468;
			goto yy1054;
		}
	}
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy578;
		if (yych <= '0') goto yy1088;
		goto yy1089;
	} else {
		if (yych <= '5') goto yy1090;
		if (yych <= '9') goto yy1091;
		goto yy578;
	}
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1083;
	if (yych <= '9') goto yy1084;
	goto yy57;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy785;
	if (yych <= '/') goto yy61;
	if (yych >= ':') goto yy61;
	YYDEBUG(1067, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy791;
	case '-':	goto yy788;
	case '.':	goto yy792;
	case '/':	goto yy789;
	case '0':	goto yy1069;
	case '1':	goto yy1070;
	case '2':	goto yy1071;
	case '3':	goto yy1072;
	case '4':
	case '5':	goto yy1073;
	case '6':	goto yy1074;
	case '7':
	case '8':
	case '9':	goto yy55;
	case ':':	goto yy807;
	case 'W':	goto yy810;
	default:	goto yy1068;
	}
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '0') goto yy1081;
	if (yych <= '9') goto yy1082;
	goto yy61;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '2') goto yy1080;
	if (yych <= '9') goto yy1079;
	goto yy61;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy1079;
	goto yy61;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '5') goto yy1077;
	if (yych <= '6') goto yy1078;
	if (yych <= '9') goto yy1075;
	goto yy61;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy1075;
	goto yy61;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '0') goto yy1075;
	if (yych <= '9') goto yy55;
	goto yy61;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy55;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych >= ' ') goto yy61;
			} else {
				if (yych == 'D') goto yy61;
				if (yych >= 'F') goto yy61;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy61;
				if (yych >= 'M') goto yy61;
			} else {
				if (yych <= 'R') goto yy1076;
				if (yych <= 'T') goto yy61;
				if (yych >= 'W') goto yy61;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy61;
				if (yych >= 'd') goto yy61;
			} else {
				if (yych == 'f') goto yy61;
				if (yych >= 'h') goto yy61;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych >= 's') goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy61;
				} else {
					if (yych == 'y') goto yy61;
				}
			}
		}
	}
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy1076;
				goto yy61;
			} else {
				if (yych <= '/') goto yy1076;
				if (yych <= '9') goto yy821;
				if (yych <= 'C') goto yy1076;
				goto yy61;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy1076;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1076;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy1076;
					if (yych <= 'T') goto yy61;
					goto yy1076;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1076;
				if (yych <= 'Y') goto yy61;
				goto yy1076;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy1076;
				} else {
					if (yych == 'g') goto yy1076;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy1076;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy1076;
				}
			}
		}
	}
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy1076;
				goto yy61;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1076;
					goto yy821;
				} else {
					if (yych <= '9') goto yy55;
					if (yych <= 'C') goto yy1076;
					goto yy61;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy1076;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1076;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy1076;
					if (yych <= 'T') goto yy61;
					goto yy1076;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1076;
				if (yych <= 'Y') goto yy61;
				goto yy1076;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy1076;
				} else {
					if (yych == 'g') goto yy1076;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy1076;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy1076;
				}
			}
		}
	}
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy1076;
				goto yy61;
			} else {
				if (yych <= '/') goto yy1076;
				if (yych <= '9') goto yy821;
				if (yych <= 'C') goto yy1076;
				goto yy61;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy61;
				if (yych <= 'G') goto yy1076;
				goto yy61;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1076;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy1076;
					if (yych <= 'T') goto yy61;
					goto yy1076;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1076;
				if (yych <= 'Y') goto yy61;
				goto yy1076;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy61;
					goto yy1076;
				} else {
					if (yych == 'g') goto yy1076;
					goto yy61;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy61;
				if (yych <= 'r') goto yy1076;
				goto yy61;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy1076;
				}
			}
		}
	}
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy1076;
				goto yy61;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1076;
					goto yy845;
				} else {
					if (yych <= '2') goto yy846;
					if (yych <= '3') goto yy847;
					goto yy821;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'F') goto yy61;
					goto yy1076;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy61;
					goto yy1076;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych <= 'R') goto yy1076;
					goto yy61;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy61;
				if (yych <= 'X') goto yy1076;
				goto yy61;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'f') goto yy61;
					goto yy1076;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy61;
					goto yy1076;
				} else {
					if (yych <= 'm') goto yy61;
					if (yych <= 'r') goto yy1076;
					goto yy61;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy1076;
				}
			}
		}
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy1076;
				goto yy61;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1076;
					goto yy877;
				} else {
					if (yych <= '2') goto yy846;
					if (yych <= '3') goto yy847;
					goto yy821;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'F') goto yy61;
					goto yy1076;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy61;
					goto yy1076;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych <= 'R') goto yy1076;
					goto yy61;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy61;
				if (yych <= 'X') goto yy1076;
				goto yy61;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'f') goto yy61;
					goto yy1076;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy61;
					goto yy1076;
				} else {
					if (yych <= 'm') goto yy61;
					if (yych <= 'r') goto yy1076;
					goto yy61;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy1076;
				}
			}
		}
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy61;
				if (yych <= 0x1F) goto yy1076;
				goto yy61;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1076;
					goto yy845;
				} else {
					if (yych <= '2') goto yy846;
					if (yych <= '3') goto yy847;
					goto yy821;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'F') goto yy61;
					goto yy1076;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy61;
					goto yy1076;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych <= 'R') goto yy1076;
					goto yy61;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy61;
				if (yych <= 'X') goto yy1076;
				goto yy61;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'f') goto yy61;
					goto yy1076;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy61;
					goto yy1076;
				} else {
					if (yych <= 'm') goto yy61;
					if (yych <= 'r') goto yy1076;
					goto yy61;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1076;
					goto yy61;
				} else {
					if (yych == 'y') goto yy61;
					goto yy1076;
				}
			}
		}
	}
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1085;
		goto yy491;
	} else {
		if (yych <= '9') goto yy1084;
		if (yych <= ':') goto yy1085;
		goto yy491;
	}
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1085;
	if (yych != ':') goto yy491;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1086;
	if (yych <= '6') goto yy1087;
	if (yych <= '9') goto yy496;
	goto yy57;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych <= '/') goto yy491;
	if (yych <= '9') goto yy496;
	goto yy491;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych == '0') goto yy496;
	goto yy491;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy491;
		if (yych <= '-') goto yy602;
		goto yy1092;
	} else {
		if (yych <= '/') goto yy491;
		if (yych <= '9') goto yy1091;
		if (yych <= ':') goto yy1085;
		goto yy491;
	}
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy491;
		if (yych <= '-') goto yy602;
		if (yych <= '.') goto yy1092;
		goto yy491;
	} else {
		if (yych <= '2') goto yy1091;
		if (yych <= '9') goto yy1084;
		if (yych <= ':') goto yy1085;
		goto yy491;
	}
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy491;
		if (yych <= '-') goto yy602;
		goto yy1092;
	} else {
		if (yych <= '/') goto yy491;
		if (yych <= '9') goto yy1084;
		if (yych <= ':') goto yy1085;
		goto yy491;
	}
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy491;
		if (yych <= '-') goto yy602;
	} else {
		if (yych == ':') goto yy1085;
		goto yy491;
	}
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1093;
	if (yych <= '6') goto yy1094;
	if (yych <= '9') goto yy610;
	goto yy57;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych <= '/') goto yy491;
	if (yych <= '9') goto yy1095;
	goto yy491;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy497;
		goto yy491;
	} else {
		if (yych <= '0') goto yy1095;
		if (yych <= '9') goto yy611;
		goto yy491;
	}
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy497;
	if (yych <= '/') goto yy491;
	if (yych <= '9') goto yy605;
	goto yy491;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy460;
			if (yych <= ',') goto yy462;
			goto yy1051;
		} else {
			if (yych <= '.') goto yy474;
			if (yych <= '/') goto yy472;
			if (yych <= '5') goto yy1066;
			goto yy741;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy483;
			if (yych == 'n') goto yy470;
			goto yy462;
		} else {
			if (yych <= 'r') goto yy471;
			if (yych <= 's') goto yy464;
			if (yych <= 't') goto yy468;
			goto yy462;
		}
	}
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1052;
			if (yych <= ',') goto yy1054;
			goto yy1051;
		} else {
			if (yych <= '.') goto yy1064;
			if (yych <= '/') goto yy472;
			if (yych <= '5') goto yy1066;
			goto yy741;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1065;
			if (yych == 'n') goto yy470;
			goto yy1054;
		} else {
			if (yych <= 'r') goto yy471;
			if (yych <= 's') goto yy464;
			if (yych <= 't') goto yy468;
			goto yy1054;
		}
	}
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy142;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy1099;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'U') goto yy143;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'v') goto yy1100;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'H') goto yy144;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'i') goto yy1101;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'N') goto yy145;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'o') goto yy1102;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'U') goto yy1103;
		if (yych != 'u') goto yy4;
	}
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1104;
	if (yych != 's') goto yy57;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1105;
	if (yych != ' ') goto yy57;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1105;
				if (yych <= 0x1F) goto yy57;
				goto yy1105;
			} else {
				if (yych == 'D') goto yy1110;
				if (yych <= 'E') goto yy57;
				goto yy1111;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1109;
				if (yych <= 'L') goto yy57;
				goto yy1108;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy57;
				} else {
					if (yych <= 'T') goto yy1114;
					if (yych <= 'V') goto yy57;
					goto yy1113;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1112;
				if (yych <= 'c') goto yy57;
				goto yy1110;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy57;
					goto yy1111;
				} else {
					if (yych == 'h') goto yy1109;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1108;
				if (yych <= 'r') goto yy57;
				if (yych >= 't') goto yy1114;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy57;
					goto yy1113;
				} else {
					if (yych == 'y') goto yy1112;
					goto yy57;
				}
			}
		}
	}
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1179;
			goto yy57;
		} else {
			if (yych <= 'E') goto yy1180;
			if (yych <= 'T') goto yy57;
			goto yy1178;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1179;
			goto yy57;
		} else {
			if (yych <= 'e') goto yy1180;
			if (yych == 'u') goto yy1178;
			goto yy57;
		}
	}
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy1170;
		if (yych <= 'N') goto yy57;
		goto yy1169;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy57;
			goto yy1170;
		} else {
			if (yych == 'o') goto yy1169;
			goto yy57;
		}
	}
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1167;
	if (yych == 'o') goto yy1167;
	goto yy57;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1166;
	if (yych == 'a') goto yy1166;
	goto yy57;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1151;
		if (yych <= 'Q') goto yy57;
		goto yy1150;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy57;
			goto yy1151;
		} else {
			if (yych == 'r') goto yy1150;
			goto yy57;
		}
	}
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1147;
	if (yych == 'e') goto yy1147;
	goto yy57;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1133;
	if (yych == 'e') goto yy1133;
	goto yy57;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1115;
		if (yych <= 'T') goto yy57;
		goto yy1116;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy57;
		} else {
			if (yych == 'u') goto yy1116;
			goto yy57;
		}
	}
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1128;
	if (yych == 'u') goto yy1128;
	goto yy57;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1117;
	if (yych != 'e') goto yy57;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1119;
		if (yych >= ' ') goto yy1119;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1121;
		} else {
			if (yych == 's') goto yy1121;
		}
	}
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(1120, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1119;
		if (yych <= 0x1F) goto yy57;
		goto yy1119;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy57;
			goto yy1125;
		} else {
			if (yych == 'o') goto yy1125;
			goto yy57;
		}
	}
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1122;
	if (yych != 'd') goto yy57;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1123;
	if (yych != 'a') goto yy57;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1124;
	if (yych != 'y') goto yy57;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1119;
	if (yych == ' ') goto yy1119;
	goto yy1118;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1126;
	if (yych != 'f') goto yy57;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1127, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1119;
		if (yych <= 0x1F) goto yy1118;
		goto yy1119;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1118;
		} else {
			if (yych != 'r') goto yy1118;
		}
	}
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1130;
	if (yych != 's') goto yy57;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1131;
	if (yych != 'd') goto yy57;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1132;
	if (yych != 'a') goto yy57;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1124;
	if (yych == 'y') goto yy1124;
	goto yy57;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy57;
		if (yych <= 'D') goto yy1135;
	} else {
		if (yych <= 'c') goto yy57;
		if (yych <= 'd') goto yy1135;
		if (yych >= 'f') goto yy57;
	}
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1141;
	if (yych == 'k') goto yy1141;
	goto yy57;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1119;
		if (yych <= 0x1F) goto yy1118;
		goto yy1119;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1118;
		} else {
			if (yych != 'n') goto yy1118;
		}
	}
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1137;
	if (yych != 'e') goto yy57;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1138;
	if (yych != 's') goto yy57;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1139;
	if (yych != 'd') goto yy57;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1140;
	if (yych != 'a') goto yy57;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1124;
	if (yych == 'y') goto yy1124;
	goto yy57;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1144;
		if (yych >= 'S') goto yy1143;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1144;
		} else {
			if (yych == 's') goto yy1143;
		}
	}
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1118;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1145;
	if (yych != 'a') goto yy57;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1146;
	if (yych != 'y') goto yy57;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1143;
	if (yych == 's') goto yy1143;
	goto yy1118;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1148;
	if (yych != 'a') goto yy57;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1149;
	if (yych != 'r') goto yy57;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1143;
	if (yych == 's') goto yy1143;
	goto yy1118;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1163;
	if (yych == 'i') goto yy1163;
	goto yy57;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1152;
	if (yych != 'r') goto yy57;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1153;
	if (yych != 't') goto yy57;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1155;
		if (yych <= 'M') goto yy57;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy57;
			goto yy1155;
		} else {
			if (yych != 'n') goto yy57;
		}
	}
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1160;
	if (yych == 'i') goto yy1160;
	goto yy57;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1156;
	if (yych != 'n') goto yy57;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1157;
	if (yych != 'i') goto yy57;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1158;
	if (yych != 'g') goto yy57;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1159;
	if (yych != 'h') goto yy57;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1149;
	if (yych == 't') goto yy1149;
	goto yy57;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1161;
	if (yych != 'g') goto yy57;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1162;
	if (yych != 'h') goto yy57;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1149;
	if (yych == 't') goto yy1149;
	goto yy57;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1119;
		if (yych <= 0x1F) goto yy1118;
		goto yy1119;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1118;
		} else {
			if (yych != 'd') goto yy1118;
		}
	}
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1165;
	if (yych != 'a') goto yy57;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1124;
	if (yych == 'y') goto yy1124;
	goto yy57;
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1149;
	if (yych == 'y') goto yy1149;
	goto yy57;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1168;
	if (yych != 'u') goto yy57;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1149;
	if (yych == 'r') goto yy1149;
	goto yy57;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1174;
	if (yych == 'n') goto yy1174;
	goto yy57;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1171;
	if (yych != 'n') goto yy57;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1143;
		if (yych <= 'T') goto yy1118;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1118;
			goto yy1143;
		} else {
			if (yych != 'u') goto yy1118;
		}
	}
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1173;
	if (yych != 't') goto yy57;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1149;
	if (yych == 'e') goto yy1149;
	goto yy57;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1119;
			goto yy1118;
		} else {
			if (yych <= ' ') goto yy1119;
			if (yych <= 'C') goto yy1118;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1176;
			goto yy1118;
		} else {
			if (yych <= 'd') goto yy1175;
			if (yych == 't') goto yy1176;
			goto yy1118;
		}
	}
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1177;
	if (yych == 'a') goto yy1177;
	goto yy57;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1149;
	if (yych == 'h') goto yy1149;
	goto yy57;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1124;
	if (yych == 'y') goto yy1124;
	goto yy57;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1189;
	if (yych == 'n') goto yy1189;
	goto yy57;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1184;
	if (yych == 't') goto yy1184;
	goto yy57;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1181;
	if (yych != 'c') goto yy57;
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1182;
		if (yych <= 'R') goto yy1118;
		goto yy1143;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1118;
		} else {
			if (yych == 's') goto yy1143;
			goto yy1118;
		}
	}
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1183;
	if (yych != 'n') goto yy57;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1149;
	if (yych == 'd') goto yy1149;
	goto yy57;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1119;
		if (yych <= 0x1F) goto yy1118;
		goto yy1119;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1118;
		} else {
			if (yych != 'u') goto yy1118;
		}
	}
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1186;
	if (yych != 'r') goto yy57;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1187;
	if (yych != 'd') goto yy57;
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1188;
	if (yych != 'a') goto yy57;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1124;
	if (yych == 'y') goto yy1124;
	goto yy57;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1119;
		if (yych <= 0x1F) goto yy1118;
		goto yy1119;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1118;
		} else {
			if (yych != 'd') goto yy1118;
		}
	}
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1191;
	if (yych != 'a') goto yy57;
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1124;
	if (yych == 'y') goto yy1124;
	goto yy57;
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1099;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'e') goto yy1193;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1100;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'v') goto yy1194;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1101;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'i') goto yy1195;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1102;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'o') goto yy1196;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1103;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'u') goto yy1197;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1104;
	if (yych != 's') goto yy155;
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy57;
			goto yy1105;
		} else {
			if (yych == ' ') goto yy1105;
			goto yy57;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy57;
			goto yy148;
		} else {
			if (yych == '_') goto yy148;
			goto yy57;
		}
	}
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'F') goto yy142;
			goto yy1213;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'g') goto yy1213;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy142;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy1201;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'U') goto yy143;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'v') goto yy1202;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy144;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'e') goto yy1203;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy145;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'n') goto yy1204;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'T') goto yy1205;
		if (yych != 't') goto yy4;
	}
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1206;
	if (yych != 'h') goto yy57;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1207;
	if (yych != ' ') goto yy57;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1207;
				if (yych <= 0x1F) goto yy57;
				goto yy1207;
			} else {
				if (yych == 'D') goto yy1110;
				if (yych <= 'E') goto yy57;
				goto yy1111;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1109;
				if (yych <= 'L') goto yy57;
				goto yy1108;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy57;
					goto yy1107;
				} else {
					if (yych <= 'T') goto yy1114;
					if (yych <= 'V') goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1112;
				if (yych <= 'c') goto yy57;
				goto yy1110;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy57;
					goto yy1111;
				} else {
					if (yych == 'h') goto yy1109;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1108;
				if (yych <= 'r') goto yy57;
				if (yych <= 's') goto yy1107;
				goto yy1114;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy57;
				} else {
					if (yych == 'y') goto yy1112;
					goto yy57;
				}
			}
		}
	}
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1210;
	if (yych != 'e') goto yy57;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy57;
		if (yych <= 'D') goto yy1135;
	} else {
		if (yych <= 'c') goto yy57;
		if (yych <= 'd') goto yy1135;
		if (yych >= 'f') goto yy57;
	}
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1212;
	if (yych != 'k') goto yy57;
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1144;
		if (yych <= 'R') goto yy57;
		goto yy1143;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy57;
			goto yy1144;
		} else {
			if (yych == 's') goto yy1143;
			goto yy57;
		}
	}
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'G') goto yy143;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1214;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1215;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1207;
			goto yy4;
		} else {
			if (yych <= ' ') goto yy1207;
			if (yych == ')') goto yy140;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1216;
			if (yych <= 'Z') goto yy145;
			goto yy4;
		} else {
			if (yych == 'h') goto yy1216;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1207;
		goto yy4;
	} else {
		if (yych <= ' ') goto yy1207;
		if (yych == ')') goto yy140;
		goto yy4;
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1213;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'g') goto yy1225;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1201;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'e') goto yy1219;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1202;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'v') goto yy1220;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1203;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'e') goto yy1221;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1204;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'n') goto yy1222;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1205;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 't') goto yy1223;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1206;
	if (yych != 'h') goto yy155;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy57;
			goto yy1207;
		} else {
			if (yych == ' ') goto yy1207;
			goto yy57;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy57;
			goto yy148;
		} else {
			if (yych == '_') goto yy148;
			goto yy57;
		}
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1214;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1226;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1215;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1227;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy4;
				goto yy1207;
			} else {
				if (yych == ' ') goto yy1207;
				goto yy4;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy4;
			} else {
				if (yych == '.') goto yy4;
				goto yy148;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy4;
				goto yy145;
			} else {
				if (yych <= 'H') goto yy1216;
				if (yych <= 'Z') goto yy145;
				goto yy4;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'h') goto yy1228;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1207;
			goto yy4;
		} else {
			if (yych <= ' ') goto yy1207;
			if (yych <= '(') goto yy4;
			goto yy140;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy148;
			goto yy4;
		} else {
			if (yych <= '/') goto yy148;
			if (yych == '_') goto yy148;
			goto yy4;
		}
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1245;
				goto yy142;
			} else {
				if (yych <= 'P') goto yy1247;
				if (yych <= 'U') goto yy142;
				goto yy1246;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy142;
				goto yy4;
			} else {
				if (yych == 'c') goto yy1245;
				goto yy142;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1247;
				goto yy142;
			} else {
				if (yych <= 'v') goto yy1246;
				if (yych <= 'z') goto yy142;
				goto yy4;
			}
		}
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy142;
			goto yy1240;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1240;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'W') goto yy142;
			goto yy1237;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'x') goto yy1237;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy142;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1233;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy167;
			goto yy140;
		} else {
			if (yych <= '@') goto yy167;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy167;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1234;
			if (yych <= 'z') goto yy143;
			goto yy167;
		}
	}
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1235;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'X') goto yy145;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'y') goto yy1236;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy140;
	goto yy167;
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'G') goto yy144;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'h') goto yy1239;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy4;
			goto yy1207;
		} else {
			if (yych == ' ') goto yy1207;
			goto yy4;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy145;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy167;
			goto yy140;
		} else {
			if (yych <= '@') goto yy167;
			if (yych <= 'T') goto yy143;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy167;
			goto yy143;
		} else {
			if (yych <= 'u') goto yy1241;
			if (yych <= 'z') goto yy143;
			goto yy167;
		}
	}
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1242;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'C') goto yy145;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'd') goto yy1243;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'A') goto yy1244;
		if (yych != 'a') goto yy4;
	}
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy173;
	if (yych == 'y') goto yy173;
	goto yy57;
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'N') goto yy143;
			goto yy1256;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'o') goto yy1256;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy143;
			goto yy1253;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy1253;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych != 'T') goto yy143;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 't') goto yy1248;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych != 'E') goto yy144;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy194;
				goto yy144;
			} else {
				if (yych <= 'e') goto yy1249;
				if (yych <= 'z') goto yy144;
				goto yy194;
			}
		}
	}
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'L') goto yy145;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'm') goto yy1250;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'B') goto yy1251;
		if (yych != 'b') goto yy4;
	}
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1252;
	if (yych != 'e') goto yy57;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy206;
	if (yych == 'r') goto yy206;
	goto yy57;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy144;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'n') goto yy1254;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy145;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 't') goto yy1255;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'H') goto yy1206;
		if (yych == 'h') goto yy1206;
		goto yy4;
	}
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy144;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'n') goto yy1257;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'C') goto yy145;
			goto yy1216;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'd') goto yy1216;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy140;
				goto yy4;
			} else {
				if (yych == '.') goto yy4;
				goto yy148;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy4;
				if (yych <= 'B') goto yy142;
				goto yy1245;
			} else {
				if (yych == 'P') goto yy1247;
				goto yy142;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1246;
				if (yych <= 'Z') goto yy142;
				goto yy4;
			} else {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy4;
				goto yy147;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1274;
				if (yych <= 'o') goto yy147;
				goto yy1276;
			} else {
				if (yych == 'v') goto yy1275;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1240;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 't') goto yy1269;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1237;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'x') goto yy1266;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1233;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy1262;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy167;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy167;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1234;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy167;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy167;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1263;
				if (yych <= 'z') goto yy151;
				goto yy167;
			}
		}
	}
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1235;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1264;
			if (yych <= 'z') goto yy152;
			goto yy4;
		}
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1236;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'y') goto yy1265;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy140;
		if (yych <= ',') goto yy167;
		goto yy148;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy167;
			goto yy148;
		} else {
			if (yych == '_') goto yy148;
			goto yy167;
		}
	}
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1239;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1268;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1207;
			if (yych <= 0x1F) goto yy4;
			goto yy1207;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy4;
				goto yy148;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy167;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy167;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1241;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy167;
			goto yy148;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy167;
				goto yy151;
			} else {
				if (yych <= 'u') goto yy1270;
				if (yych <= 'z') goto yy151;
				goto yy167;
			}
		}
	}
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1242;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1271;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1243;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'd') goto yy1272;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1244;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1273;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy173;
	if (yych == 'y') goto yy186;
	goto yy155;
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1256;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'o') goto yy1285;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1253;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1282;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'T') goto yy1248;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1277;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy194;
				goto yy144;
			} else {
				if (yych <= 'E') goto yy1249;
				if (yych <= 'Z') goto yy144;
				goto yy194;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy152;
			} else {
				if (yych <= 'e') goto yy1278;
				if (yych <= 'z') goto yy152;
				goto yy194;
			}
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1250;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'm') goto yy1279;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1251;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'b') goto yy1280;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1252;
	if (yych != 'e') goto yy155;
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy206;
	if (yych == 'r') goto yy377;
	goto yy155;
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1254;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'n') goto yy1283;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1255;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 't') goto yy1284;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1206;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'h') goto yy1224;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1257;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'n') goto yy1286;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1216;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'd') goto yy1228;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'B') goto yy142;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'c') goto yy1288;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'J') goto yy143;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'k') goto yy1289;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1290;
		if (yych <= '(') goto yy4;
		goto yy140;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy4;
			goto yy144;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1291;
	if (yych != 'o') goto yy57;
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1292;
	if (yych != 'f') goto yy57;
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy57;
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy1294;
	if (yych <= '2') goto yy1296;
	if (yych <= '9') goto yy1297;
	goto yy57;
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1298;
	if (yych <= '9') goto yy1297;
	goto yy1298;
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1298;
	if (yych >= '5') goto yy1298;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1297;
			goto yy1295;
		} else {
			if (yych <= ' ') goto yy1297;
			if (yych <= '@') goto yy1295;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1295;
		} else {
			if (yych <= 'a') goto yy1299;
			if (yych != 'p') goto yy1295;
		}
	}
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy57;
	} else {
		if (yych <= 'M') goto yy1301;
		if (yych == 'm') goto yy1301;
		goto yy57;
	}
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1301;
	if (yych != 'm') goto yy57;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1303;
		if (yych == '\t') goto yy1303;
		goto yy57;
	} else {
		if (yych <= ' ') goto yy1303;
		if (yych != '.') goto yy57;
	}
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1303;
		if (yych <= 0x08) goto yy57;
	} else {
		if (yych != ' ') goto yy57;
	}
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1295;
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1288;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'c') goto yy1305;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1289;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'k') goto yy1306;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1290;
			goto yy4;
		} else {
			if (yych <= ')') goto yy140;
			if (yych == '-') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy148;
			if (yych <= '@') goto yy4;
			if (yych <= 'Z') goto yy144;
			goto yy4;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy152;
			goto yy4;
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'R') goto yy142;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1308;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1309;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy4;
			goto yy1105;
		} else {
			if (yych != ' ') goto yy4;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy144;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1311;
	if (yych != 'd') goto yy1106;
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1312;
	if (yych != 'a') goto yy57;
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1313;
	if (yych != 'y') goto yy57;
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1118;
	} else {
		if (yych <= 'S') goto yy1143;
		if (yych == 's') goto yy1143;
		goto yy1118;
	}
	YYDEBUG(1314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1315;
	if (yych != 'o') goto yy57;
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1316;
	if (yych != 'f') goto yy57;
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy2;
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1308;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 's') goto yy1318;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1309;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1319;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1105;
			if (yych <= 0x1F) goto yy4;
			goto yy1310;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy4;
				goto yy148;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'A') goto yy142;
			goto yy1356;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'b') goto yy1356;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == 'F') goto yy1346;
			if (yych <= 'Q') goto yy142;
			goto yy1345;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			if (yych <= 'e') goto yy142;
			goto yy1346;
		} else {
			if (yych == 'r') goto yy1345;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'T') goto yy142;
			goto yy1342;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'u') goto yy1342;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == 'I') goto yy1325;
			if (yych <= 'N') goto yy142;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			if (yych <= 'h') goto yy142;
			goto yy1325;
		} else {
			if (yych == 'o') goto yy1324;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy143;
			goto yy1328;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1328;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy167;
			goto yy140;
		} else {
			if (yych <= '@') goto yy167;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy167;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1326;
			if (yych <= 'z') goto yy143;
			goto yy167;
		}
	}
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1327;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'X') goto yy145;
			goto yy1236;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'y') goto yy1236;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1329;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1330;
		if (yych <= '(') goto yy4;
		goto yy140;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy4;
			goto yy145;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1331;
	if (yych != 'o') goto yy57;
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1332;
	if (yych != 'f') goto yy57;
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy57;
	YYDEBUG(1333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '1') goto yy1334;
	if (yych <= '2') goto yy1335;
	if (yych <= '9') goto yy1336;
	goto yy57;
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1337;
	if (yych <= '9') goto yy1336;
	goto yy1337;
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1337;
	if (yych >= '5') goto yy1337;
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1336;
			goto yy1295;
		} else {
			if (yych <= ' ') goto yy1336;
			if (yych <= '@') goto yy1295;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1295;
		} else {
			if (yych <= 'a') goto yy1338;
			if (yych != 'p') goto yy1295;
		}
	}
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy57;
	} else {
		if (yych <= 'M') goto yy1340;
		if (yych == 'm') goto yy1340;
		goto yy57;
	}
	YYDEBUG(1339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1340;
	if (yych != 'm') goto yy57;
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1303;
		if (yych == '\t') goto yy1303;
		goto yy57;
	} else {
		if (yych <= ' ') goto yy1303;
		if (yych != '.') goto yy57;
	}
	YYDEBUG(1341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1303;
		if (yych <= 0x08) goto yy57;
		goto yy1303;
	} else {
		if (yych == ' ') goto yy1303;
		goto yy57;
	}
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1343;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1344;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'G') goto yy145;
			goto yy1216;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'h') goto yy1216;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'R') goto yy143;
			goto yy1348;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 's') goto yy1348;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1347;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'G') goto yy144;
			goto yy1239;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'h') goto yy1239;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1349;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy4;
			goto yy1207;
		} else {
			if (yych != ' ') goto yy4;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy145;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1350:
	YYDEBUG(1350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1351;
	if (yych != 'd') goto yy1208;
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1352;
	if (yych != 'a') goto yy57;
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1353;
	if (yych != 'y') goto yy57;
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1118;
	} else {
		if (yych <= 'S') goto yy1143;
		if (yych == 's') goto yy1143;
		goto yy1118;
	}
	YYDEBUG(1354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1355;
	if (yych != 'o') goto yy57;
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1316;
	if (yych == 'f') goto yy1316;
	goto yy57;
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych != 'R') goto yy143;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'r') goto yy1357;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'T') goto yy144;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'u') goto yy1358;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy145;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1359;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'R') goto yy1360;
		if (yych != 'r') goto yy4;
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy206;
	if (yych == 'y') goto yy206;
	goto yy57;
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1356;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'b') goto yy1379;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych == '-') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy148;
				goto yy4;
			} else {
				if (yych == 'F') goto yy1346;
				goto yy142;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1345;
				goto yy142;
			} else {
				if (yych == '_') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1375;
				goto yy147;
			} else {
				if (yych <= 'r') goto yy1374;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1342;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'u') goto yy1371;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych == '-') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy148;
				goto yy4;
			} else {
				if (yych == 'I') goto yy1325;
				goto yy142;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1324;
				goto yy142;
			} else {
				if (yych == '_') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1366;
				goto yy147;
			} else {
				if (yych <= 'o') goto yy1365;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1328;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1369;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy167;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy167;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1326;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy167;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy167;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1367;
				if (yych <= 'z') goto yy151;
				goto yy167;
			}
		}
	}
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1327;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1368;
			if (yych <= 'z') goto yy152;
			goto yy4;
		}
	}
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1236;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'y') goto yy1265;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1329;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1370;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1330;
			goto yy4;
		} else {
			if (yych <= ')') goto yy140;
			if (yych == '-') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy148;
			if (yych <= '@') goto yy4;
			if (yych <= 'Z') goto yy145;
			goto yy4;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy153;
			goto yy4;
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1343;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1372;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1344;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1373;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1216;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'h') goto yy1228;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1348;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 's') goto yy1377;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1347;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1376;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1239;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1268;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1349;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1378;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1207;
			if (yych <= 0x1F) goto yy4;
			goto yy1350;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy4;
				goto yy148;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'R') goto yy1357;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1380;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1358;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'u') goto yy1381;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1381:
	YYDEBUG(1381, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1359;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1382;
			if (yych <= 'z') goto yy153;
			goto yy4;
		}
	}
yy1382:
	YYDEBUG(1382, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1360;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'r') goto yy1383;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1383:
	YYDEBUG(1383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy206;
	if (yych == 'y') goto yy377;
	goto yy155;
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1386, *YYCURSOR);
	if (yych <= '/') goto yy1387;
	if (yych <= '9') goto yy1385;
yy1387:
	YYDEBUG(1387, *YYCURSOR);
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1388:
	YYDEBUG(1388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy142;
			goto yy1429;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1429;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == 'I') goto yy1421;
			if (yych <= 'T') goto yy142;
			goto yy1422;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			if (yych <= 'h') goto yy142;
			goto yy1421;
		} else {
			if (yych == 'u') goto yy1422;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1390:
	YYDEBUG(1390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == 'D') goto yy1410;
			if (yych <= 'L') goto yy142;
			goto yy1411;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			if (yych <= 'c') goto yy142;
			goto yy1410;
		} else {
			if (yych == 'm') goto yy1411;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1391:
	YYDEBUG(1391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy142;
			goto yy1406;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy1406;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1392:
	YYDEBUG(1392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy142;
			goto yy1402;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy1402;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1393:
	YYDEBUG(1393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1065;
		goto yy57;
	} else {
		if (yych <= '9') goto yy1396;
		if (yych <= ':') goto yy1065;
		goto yy57;
	}
yy1394:
	YYDEBUG(1394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1065;
		goto yy57;
	} else {
		if (yych <= '4') goto yy1396;
		if (yych == ':') goto yy1065;
		goto yy57;
	}
yy1395:
	YYDEBUG(1395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1065;
	if (yych == ':') goto yy1065;
	goto yy57;
yy1396:
	YYDEBUG(1396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1065;
		goto yy57;
	} else {
		if (yych <= '5') goto yy1397;
		if (yych == ':') goto yy1065;
		goto yy57;
	}
yy1397:
	YYDEBUG(1397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(1398, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1068;
	if (yych <= '5') goto yy1399;
	if (yych <= '6') goto yy1400;
	goto yy1068;
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1401;
	goto yy57;
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy57;
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1076;
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'K') goto yy143;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'l') goto yy1403;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'E') goto yy144;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'f') goto yy1404;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy145;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 't') goto yy1405;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'H') goto yy1206;
		if (yych == 'h') goto yy1206;
		goto yy4;
	}
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy167;
			goto yy140;
		} else {
			if (yych <= '@') goto yy167;
			if (yych <= 'R') goto yy143;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy167;
			goto yy143;
		} else {
			if (yych <= 's') goto yy1407;
			if (yych <= 'z') goto yy143;
			goto yy167;
		}
	}
yy1407:
	YYDEBUG(1407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1408;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1408:
	YYDEBUG(1408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy145;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1409;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1409:
	YYDEBUG(1409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'Y') goto yy173;
		if (yych == 'y') goto yy173;
		goto yy4;
	}
yy1410:
	YYDEBUG(1410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
		goto yy1418;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1418;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1411:
	YYDEBUG(1411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'N') goto yy143;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'o') goto yy1412;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1412:
	YYDEBUG(1412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1413;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1413:
	YYDEBUG(1413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'Q') goto yy145;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'r') goto yy1414;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1414:
	YYDEBUG(1414, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'O') goto yy1415;
		if (yych != 'o') goto yy4;
	}
yy1415:
	YYDEBUG(1415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1416;
	if (yych != 'w') goto yy57;
yy1416:
	YYDEBUG(1416, *YYCURSOR);
	++YYCURSOR;
yy1417:
	YYDEBUG(1417, *YYCURSOR);
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1418:
	YYDEBUG(1418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'X') goto yy144;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1419;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1419:
	YYDEBUG(1419, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy140;
	} else {
		if (yych <= 'Z') goto yy145;
		if (yych <= '`') goto yy1420;
		if (yych <= 'z') goto yy145;
	}
yy1420:
	YYDEBUG(1420, *YYCURSOR);
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1421:
	YYDEBUG(1421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych <= 'Q') goto yy143;
			if (yych <= 'R') goto yy1427;
			goto yy1428;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1427;
			if (yych <= 's') goto yy1428;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1422:
	YYDEBUG(1422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy167;
			goto yy140;
		} else {
			if (yych <= '@') goto yy167;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy167;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1423;
			if (yych <= 'z') goto yy143;
			goto yy167;
		}
	}
yy1423:
	YYDEBUG(1423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'R') goto yy144;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 's') goto yy1424;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1424:
	YYDEBUG(1424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'C') goto yy145;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'd') goto yy1425;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1425:
	YYDEBUG(1425, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'A') goto yy1426;
		if (yych != 'a') goto yy4;
	}
yy1426:
	YYDEBUG(1426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy173;
	if (yych == 'y') goto yy173;
	goto yy57;
yy1427:
	YYDEBUG(1427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'C') goto yy144;
			goto yy1239;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1239;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1428:
	YYDEBUG(1428, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy4;
			goto yy1105;
		} else {
			if (yych == ' ') goto yy1105;
			goto yy4;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy144;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1429:
	YYDEBUG(1429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1430;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1430:
	YYDEBUG(1430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'G') goto yy144;
			goto yy1239;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'h') goto yy1239;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1431:
	YYDEBUG(1431, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1429;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy1461;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1432:
	YYDEBUG(1432, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych == '-') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy148;
				goto yy4;
			} else {
				if (yych == 'I') goto yy1421;
				goto yy142;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1422;
				goto yy142;
			} else {
				if (yych == '_') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1453;
				goto yy147;
			} else {
				if (yych <= 'u') goto yy1454;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1433:
	YYDEBUG(1433, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych == '-') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy148;
				goto yy4;
			} else {
				if (yych == 'D') goto yy1410;
				goto yy142;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1411;
				goto yy142;
			} else {
				if (yych == '_') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1444;
				goto yy147;
			} else {
				if (yych <= 'm') goto yy1445;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1434:
	YYDEBUG(1434, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1406;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'e') goto yy1440;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1435:
	YYDEBUG(1435, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1402;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'e') goto yy1436;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1436:
	YYDEBUG(1436, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1403;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'l') goto yy1437;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1437:
	YYDEBUG(1437, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1404;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'f') goto yy1438;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1438:
	YYDEBUG(1438, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1405;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 't') goto yy1439;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1439:
	YYDEBUG(1439, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1206;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'h') goto yy1224;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1440:
	YYDEBUG(1440, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy167;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy167;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1407;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy167;
			goto yy148;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy167;
				goto yy151;
			} else {
				if (yych <= 's') goto yy1441;
				if (yych <= 'z') goto yy151;
				goto yy167;
			}
		}
	}
yy1441:
	YYDEBUG(1441, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1408;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1442;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1442:
	YYDEBUG(1442, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1409;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1443;
			if (yych <= 'z') goto yy153;
			goto yy4;
		}
	}
yy1443:
	YYDEBUG(1443, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy173;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'y') goto yy186;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1444:
	YYDEBUG(1444, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1418;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1451;
			if (yych <= 'z') goto yy151;
			goto yy4;
		}
	}
yy1445:
	YYDEBUG(1445, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1412;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'o') goto yy1446;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1446:
	YYDEBUG(1446, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1413;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1447;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1447:
	YYDEBUG(1447, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1414;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'r') goto yy1448;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1448:
	YYDEBUG(1448, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1415;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'o') goto yy1449;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1449:
	YYDEBUG(1449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1416;
	if (yych != 'w') goto yy155;
	YYDEBUG(1450, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy148;
		goto yy1417;
	} else {
		if (yych <= '/') goto yy148;
		if (yych == '_') goto yy148;
		goto yy1417;
	}
yy1451:
	YYDEBUG(1451, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1419;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1452;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1452:
	YYDEBUG(1452, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy1420;
		} else {
			if (yych == '.') goto yy1420;
			goto yy148;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1420;
			if (yych <= 'Z') goto yy145;
			goto yy1420;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy1420;
			if (yych <= 'z') goto yy153;
			goto yy1420;
		}
	}
yy1453:
	YYDEBUG(1453, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy4;
				goto yy148;
			} else {
				if (yych <= '@') goto yy4;
				if (yych <= 'Q') goto yy143;
				goto yy1427;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1428;
				goto yy143;
			} else {
				if (yych == '_') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy151;
				goto yy1459;
			} else {
				if (yych <= 's') goto yy1460;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1454:
	YYDEBUG(1454, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy167;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy167;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1423;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy167;
			goto yy148;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy167;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1455;
				if (yych <= 'z') goto yy151;
				goto yy167;
			}
		}
	}
yy1455:
	YYDEBUG(1455, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1424;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 's') goto yy1456;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1456:
	YYDEBUG(1456, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1425;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'd') goto yy1457;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1457:
	YYDEBUG(1457, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1426;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1458;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1458:
	YYDEBUG(1458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy173;
	if (yych == 'y') goto yy186;
	goto yy155;
yy1459:
	YYDEBUG(1459, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1239;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1268;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1460:
	YYDEBUG(1460, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1105;
			if (yych <= 0x1F) goto yy4;
			goto yy1105;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy4;
				goto yy148;
			} else {
				if (yych <= '`') goto yy4;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1461:
	YYDEBUG(1461, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1430;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1462;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1462:
	YYDEBUG(1462, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1239;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1268;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1463:
	YYDEBUG(1463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == 'R') goto yy1475;
			if (yych <= 'X') goto yy142;
			goto yy1476;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			if (yych <= 'q') goto yy142;
			goto yy1475;
		} else {
			if (yych == 'y') goto yy1476;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1464:
	YYDEBUG(1464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'C') goto yy142;
			goto yy1469;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1469;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1465:
	YYDEBUG(1465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy142;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1466;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1466:
	YYDEBUG(1466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy167;
			goto yy140;
		} else {
			if (yych <= '@') goto yy167;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy167;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1467;
			if (yych <= 'z') goto yy143;
			goto yy167;
		}
	}
yy1467:
	YYDEBUG(1467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy140;
		if (yych <= '@') goto yy4;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy4;
		} else {
			if (yych <= 'a') goto yy1468;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1468:
	YYDEBUG(1468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'X') goto yy145;
			goto yy1236;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'y') goto yy1236;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1469:
	YYDEBUG(1469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1470;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1470:
	YYDEBUG(1470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'H') goto yy144;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'i') goto yy1471;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1471:
	YYDEBUG(1471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'F') goto yy145;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'g') goto yy1472;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1472:
	YYDEBUG(1472, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'H') goto yy1473;
		if (yych != 'h') goto yy4;
	}
yy1473:
	YYDEBUG(1473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1474;
	if (yych != 't') goto yy57;
yy1474:
	YYDEBUG(1474, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1420;
yy1475:
	YYDEBUG(1475, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych == 'C') goto yy1477;
				goto yy143;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'c') goto yy1477;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy1476:
	YYDEBUG(1476, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy194;
			goto yy196;
		} else {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy194;
			goto yy197;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy194;
			if (yych <= '9') goto yy196;
			goto yy194;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy194;
			if (yych <= 'z') goto yy143;
			goto yy194;
		}
	}
yy1477:
	YYDEBUG(1477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'G') goto yy144;
			goto yy396;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'h') goto yy396;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1478:
	YYDEBUG(1478, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych == '-') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy148;
				goto yy4;
			} else {
				if (yych == 'R') goto yy1475;
				goto yy142;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1476;
				goto yy142;
			} else {
				if (yych == '_') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1490;
				goto yy147;
			} else {
				if (yych <= 'y') goto yy1491;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1479:
	YYDEBUG(1479, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1469;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'd') goto yy1484;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1480:
	YYDEBUG(1480, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1466;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy1481;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1481:
	YYDEBUG(1481, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy167;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy167;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1467;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy167;
			goto yy148;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy167;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1482;
				if (yych <= 'z') goto yy151;
				goto yy167;
			}
		}
	}
yy1482:
	YYDEBUG(1482, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1468;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'a') goto yy1483;
			if (yych <= 'z') goto yy152;
			goto yy4;
		}
	}
yy1483:
	YYDEBUG(1483, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1236;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'y') goto yy1265;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1484:
	YYDEBUG(1484, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1470;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1485;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1485:
	YYDEBUG(1485, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1471;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'i') goto yy1486;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1486:
	YYDEBUG(1486, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1472;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'g') goto yy1487;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1487:
	YYDEBUG(1487, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1473;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'h') goto yy1488;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1488:
	YYDEBUG(1488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1474;
	if (yych != 't') goto yy155;
	YYDEBUG(1489, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy148;
		goto yy1420;
	} else {
		if (yych <= '/') goto yy148;
		if (yych == '_') goto yy148;
		goto yy1420;
	}
yy1490:
	YYDEBUG(1490, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'C') goto yy1477;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'c') goto yy1492;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy1491:
	YYDEBUG(1491, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy196;
			if (yych <= 0x1F) goto yy194;
			goto yy196;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy194;
				goto yy140;
			} else {
				if (yych <= ',') goto yy194;
				if (yych <= '-') goto yy372;
				goto yy196;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy148;
			if (yych <= '9') goto yy196;
			if (yych <= '@') goto yy194;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy194;
				goto yy148;
			} else {
				if (yych <= '`') goto yy194;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy1492:
	YYDEBUG(1492, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy396;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy407;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1493:
	YYDEBUG(1493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy140;
			if (yych <= '@') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'O') goto yy1501;
			if (yych <= 'U') goto yy142;
			if (yych <= 'V') goto yy1502;
			goto yy1499;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			if (yych <= 'n') goto yy142;
			goto yy1501;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy142;
				goto yy1502;
			} else {
				if (yych <= 'w') goto yy1499;
				if (yych <= 'z') goto yy142;
				goto yy4;
			}
		}
	}
yy1494:
	YYDEBUG(1494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'W') goto yy142;
			goto yy1498;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'x') goto yy1498;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1495:
	YYDEBUG(1495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy142;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1496;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1496:
	YYDEBUG(1496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1497;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1497:
	YYDEBUG(1497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'G') goto yy144;
			goto yy1239;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'h') goto yy1239;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1498:
	YYDEBUG(1498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy143;
			goto yy1428;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1428;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1499:
	YYDEBUG(1499, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy140;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy1500;
		if (yych <= 'z') goto yy143;
	}
yy1500:
	YYDEBUG(1500, *YYCURSOR);
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1501:
	YYDEBUG(1501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'M') goto yy143;
			goto yy1507;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1507;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1502:
	YYDEBUG(1502, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy140;
				goto yy194;
			} else {
				if (yych <= '-') goto yy197;
				if (yych <= '.') goto yy196;
				goto yy194;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy196;
				goto yy194;
			} else {
				if (yych != 'E') goto yy143;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy1503;
				if (yych <= 'z') goto yy143;
				goto yy194;
			}
		}
	}
yy1503:
	YYDEBUG(1503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'L') goto yy144;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'm') goto yy1504;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1504:
	YYDEBUG(1504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'A') goto yy145;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'b') goto yy1505;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1505:
	YYDEBUG(1505, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'E') goto yy1506;
		if (yych != 'e') goto yy4;
	}
yy1506:
	YYDEBUG(1506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy206;
	if (yych == 'r') goto yy206;
	goto yy57;
yy1507:
	YYDEBUG(1507, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy140;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy1508;
		if (yych <= 'z') goto yy144;
	}
yy1508:
	YYDEBUG(1508, *YYCURSOR);
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1509:
	YYDEBUG(1509, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy4;
				goto yy140;
			} else {
				if (yych == '-') goto yy148;
				goto yy4;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy148;
				if (yych <= '@') goto yy4;
				goto yy142;
			} else {
				if (yych <= 'O') goto yy1501;
				if (yych <= 'U') goto yy142;
				goto yy1502;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1499;
				if (yych <= 'Z') goto yy142;
				goto yy4;
			} else {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy4;
				goto yy147;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1516;
				if (yych <= 'u') goto yy147;
				goto yy1517;
			} else {
				if (yych <= 'w') goto yy1515;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1510:
	YYDEBUG(1510, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1498;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'x') goto yy1514;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1511:
	YYDEBUG(1511, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1496;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy1512;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1512:
	YYDEBUG(1512, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1497;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1513;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1513:
	YYDEBUG(1513, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1239;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1268;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1514:
	YYDEBUG(1514, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1428;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1460;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1515:
	YYDEBUG(1515, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy1500;
		} else {
			if (yych == '.') goto yy1500;
			goto yy148;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1500;
			if (yych <= 'Z') goto yy143;
			goto yy1500;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy1500;
			if (yych <= 'z') goto yy151;
			goto yy1500;
		}
	}
yy1516:
	YYDEBUG(1516, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1507;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1522;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1517:
	YYDEBUG(1517, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy194;
				goto yy196;
			} else {
				if (yych == ' ') goto yy196;
				goto yy194;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy140;
				if (yych <= ',') goto yy194;
				goto yy372;
			} else {
				if (yych == '/') goto yy148;
				goto yy196;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy194;
				goto yy143;
			} else {
				if (yych <= 'E') goto yy1503;
				if (yych <= 'Z') goto yy143;
				goto yy194;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy148;
				if (yych <= '`') goto yy194;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1518;
				if (yych <= 'z') goto yy151;
				goto yy194;
			}
		}
	}
yy1518:
	YYDEBUG(1518, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1504;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'm') goto yy1519;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1519:
	YYDEBUG(1519, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1505;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'b') goto yy1520;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1520:
	YYDEBUG(1520, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1506;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'e') goto yy1521;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1521:
	YYDEBUG(1521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy206;
	if (yych == 'r') goto yy377;
	goto yy155;
yy1522:
	YYDEBUG(1522, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy1508;
		} else {
			if (yych == '.') goto yy1508;
			goto yy148;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1508;
			if (yych <= 'Z') goto yy144;
			goto yy1508;
		} else {
			if (yych <= '_') goto yy148;
			if (yych <= '`') goto yy1508;
			if (yych <= 'z') goto yy152;
			goto yy1508;
		}
	}
yy1523:
	YYDEBUG(1523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'R') goto yy142;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy4;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1524;
			if (yych <= 'z') goto yy142;
			goto yy4;
		}
	}
yy1524:
	YYDEBUG(1524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy4;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1525;
			if (yych <= 'z') goto yy143;
			goto yy4;
		}
	}
yy1525:
	YYDEBUG(1525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'D') goto yy144;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy4;
			goto yy144;
		} else {
			if (yych <= 'e') goto yy1526;
			if (yych <= 'z') goto yy144;
			goto yy4;
		}
	}
yy1526:
	YYDEBUG(1526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy4;
			goto yy140;
		} else {
			if (yych <= '@') goto yy4;
			if (yych <= 'Q') goto yy145;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy145;
			if (yych <= '`') goto yy4;
			goto yy145;
		} else {
			if (yych <= 'r') goto yy1527;
			if (yych <= 'z') goto yy145;
			goto yy4;
		}
	}
yy1527:
	YYDEBUG(1527, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy140;
		goto yy4;
	} else {
		if (yych <= 'D') goto yy1528;
		if (yych != 'd') goto yy4;
	}
yy1528:
	YYDEBUG(1528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1529;
	if (yych != 'a') goto yy57;
yy1529:
	YYDEBUG(1529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1530;
	if (yych != 'y') goto yy57;
yy1530:
	YYDEBUG(1530, *YYCURSOR);
	++YYCURSOR;
yy1531:
	YYDEBUG(1531, *YYCURSOR);
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1532:
	YYDEBUG(1532, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1524;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy4;
				goto yy147;
			} else {
				if (yych <= 's') goto yy1533;
				if (yych <= 'z') goto yy147;
				goto yy4;
			}
		}
	}
yy1533:
	YYDEBUG(1533, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1525;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy4;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1534;
				if (yych <= 'z') goto yy151;
				goto yy4;
			}
		}
	}
yy1534:
	YYDEBUG(1534, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1526;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy4;
				goto yy152;
			} else {
				if (yych <= 'e') goto yy1535;
				if (yych <= 'z') goto yy152;
				goto yy4;
			}
		}
	}
yy1535:
	YYDEBUG(1535, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy140;
			if (yych <= ',') goto yy4;
			goto yy148;
		} else {
			if (yych == '/') goto yy148;
			if (yych <= '@') goto yy4;
			goto yy145;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1527;
			if (yych <= 'Z') goto yy145;
			if (yych <= '^') goto yy4;
			goto yy148;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy4;
				goto yy153;
			} else {
				if (yych <= 'r') goto yy1536;
				if (yych <= 'z') goto yy153;
				goto yy4;
			}
		}
	}
yy1536:
	YYDEBUG(1536, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy140;
			goto yy4;
		} else {
			if (yych == '.') goto yy4;
			if (yych <= '/') goto yy148;
			goto yy4;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1528;
			if (yych == '_') goto yy148;
			goto yy4;
		} else {
			if (yych == 'd') goto yy1537;
			if (yych <= 'z') goto yy154;
			goto yy4;
		}
	}
yy1537:
	YYDEBUG(1537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1529;
	if (yych != 'a') goto yy155;
	YYDEBUG(1538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1530;
	if (yych != 'y') goto yy155;
	YYDEBUG(1539, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy154;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy148;
		goto yy1531;
	} else {
		if (yych <= '/') goto yy148;
		if (yych == '_') goto yy148;
		goto yy1531;
	}
}

}

#define YYMAXFILL 31

timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, "The parsed date was invalid");
	}

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->f = 0.0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->f == TIMELIB_UNSET ) time->f = 0.0;
}

timelib_time *timelib_parse_from_format(char *format, char *string, int len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;
	int allow_extra = 0;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'D': /* three letter day */
			case 'l': /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1; 
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case 'd': /* two digit day, with leading zero */
			case 'j': /* two digit day, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case 'm': /* two digit month, with leading zero */
			case 'n': /* two digit month, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': /* three letter month */
			case 'F': /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case 'Y': /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': /* two digit hour, with leading zero */
			case 'h': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': /* two digit hour, with leading zero */
			case 'H': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': /* am/pm/a.m./p.m. */
			case 'A': /* AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case 's': /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case 'u': /* up to six digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, "A six digit millisecond could not be found", string, begin);
					} else {
						s->time->f = (f / pow(10, (ptr - tptr)));
					}
				}
				break;
			case ' ': /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': /* epoch seconds */
				TIMELIB_CHECK_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->f = 0.0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				break;

			case 'e': /* timezone */
			case 'P': /* timezone */
			case 'T': /* timezone */
			case 'O': /* timezone */
				{
					int tz_not_found;
					s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': /* separation symbol */
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-' || *ptr == '(' || *ptr == ')') {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
			case '(':
			case ')':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case '|': /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case '?': /* random char */
				++ptr;
				break;

			case '\\': /* escaped char */
				++fptr;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The escaped character could not be found", string, begin);
				}
				break;

			case '*': /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case '+': /* allow extra chars in the format */
				allow_extra = 1;
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, "Trailing data", string, ptr);
		}
	}
	/* ignore trailing +'s */
	while (*fptr == '+') {
		fptr++;
	}
	if (*fptr) {
		/* Trailing | and ! specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (*fptr++) {
				case '!': /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case '|': /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;

				default:
					add_pbf_error(s, "Data missing", string, ptr);
					done = 1;
			}
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET && 
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET && 
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
