#!/bin/sh
#first version March 1998, Andrew Tridgell

SWATDIR=$1
SRCDIR=$2/
BOOKDIR=$3

echo Installing SWAT in $SWATDIR
echo Installing the Samba Web Administration Tool

# 'langs' is a list of languages of the translated htmls.
# '.' means original version of the document.
langs=". ja"

for ln in $langs; do
  langdir=$SWATDIR/$ln
  for d in $SWATDIR $langdir $langdir/help $langdir/images $langdir/include; do
    if [ ! -d $d ]; then
        mkdir $d
        if [ ! -d $d ]; then
            echo Failed to make directory $d, does $USER have privileges?
            exit 1
        fi
    fi
  done
done

for ln in $langs; do

# Install images

  for f in $SRCDIR../swat/$ln/images/*.gif; do
      FNAME=$SWATDIR/$ln/images/`basename $f`
      echo $FNAME
      cp $f $FNAME || echo Cannot install $FNAME. Does $USER have privileges?
      chmod 0644 $FNAME
  done

# Install html help

  for f in $SRCDIR../swat/$ln/help/*.html; do
      FNAME=$SWATDIR/$ln/help/`basename $f`
      echo $FNAME
      if [ "x$BOOKDIR" = "x" ]; then
        cat $f | sed 's/@BOOKDIR@.*$//' > $f.tmp
      else
        cat $f | sed 's/@BOOKDIR@//' > $f.tmp
      fi
      f=$f.tmp
      cp $f $FNAME || echo Cannot install $FNAME. Does $USER have privileges?
      rm -f $f
      chmod 0644 $FNAME
  done

# Install html documentation

  for f in $SRCDIR../docs/$ln/htmldocs/*.html; do
      FNAME=$SWATDIR/$ln/help/`basename $f`
      echo $FNAME
      cp $f $FNAME || echo Cannot install $FNAME. Does $USER have privileges?
      chmod 0644 $FNAME
  done

# Install "server-side" includes

  for f in $SRCDIR../swat/$ln/include/*.html; do
      FNAME=$SWATDIR/$ln/include/`basename $f`
      echo $FNAME
      cp $f $FNAME || echo Cannot install $FNAME. Does $USER have privileges?
      chmod 0644 $FNAME
  done
done


# Install Using Samba book

if [ "x$BOOKDIR" != "x" ]; then

langs=". ja"

for ln in $langs; do

    # Create directories

    for d in $BOOKDIR $BOOKDIR/$ln $BOOKDIR/$ln/figs $BOOKDIR/$ln/gifs; do
        if [ ! -d $d ]; then
            mkdir $d
            if [ ! -d $d ]; then
                echo Failed to make directory $d, does $USER have privileges?
                exit 1
            fi
        fi
    done

    # HTML files

    for f in $SRCDIR../docs/$ln/htmldocs/using_samba/*.html; do
        FNAME=$BOOKDIR/$ln/`basename $f`
        echo $FNAME
        cp $f $FNAME || echo Cannot install $FNAME. Does $USER have privileges?
        chmod 0644 $FNAME
    done

    # Figures

#    for f in $SRCDIR../docs/$ln/htmldocs/using_samba/figs/*.gif; do
    for f in $SRCDIR../docs/htmldocs/using_samba/figs/*.gif; do
        FNAME=$BOOKDIR/$ln/figs/`basename $f`
        echo $FNAME
        cp $f $FNAME || echo Cannot install $FNAME. Does $USER have privileges?
        chmod 0644 $FNAME
    done

    # Gifs

#    for f in $SRCDIR../docs/$ln/htmldocs/using_samba/gifs/*.gif; do
    for f in $SRCDIR../docs/htmldocs/using_samba/gifs/*.gif; do
        FNAME=$BOOKDIR/$ln/gifs/`basename $f`
        echo $FNAME
        cp $f $FNAME || echo Cannot install $FNAME. Does $USER have privileges?
        chmod 0644 $FNAME
    done
done
fi

# install txt only documents
for f in $SRCDIR../docs/ja/textdocs/*.txt; do
      FNAME=$SWATDIR/ja/help/`basename $f`.html
      echo $FNAME
      cat $SRCDIR../docs/ja/textdocs/header.html $f $SRCDIR../docs/ja/textdocs/footer.html > $FNAME || echo Cannot install $FNAME. Does $USER have privileges?
      chmod 0644 $FNAME
done


cat << EOF
======================================================================
The SWAT files have been installed. Remember to read the swat/README
for information on enabling and using SWAT
======================================================================
EOF

exit 0
