/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.atmosphere;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.atmosphere.AtmosphereEvent;
import org.apache.wicket.atmosphere.AtmosphereEventSubscriptionCollector;
import org.apache.wicket.atmosphere.AtmosphereRequestMapper;
import org.apache.wicket.atmosphere.AtmosphereWebRequest;
import org.apache.wicket.atmosphere.AtmosphereWebResponse;
import org.apache.wicket.atmosphere.EventFilter;
import org.apache.wicket.atmosphere.EventSubscription;
import org.apache.wicket.atmosphere.EventSubscriptionInvoker;
import org.apache.wicket.atmosphere.PageKey;
import org.apache.wicket.atmosphere.ResourceRegistrationListener;
import org.apache.wicket.atmosphere.SubscribeAnnotationEventSubscriptionInvoker;
import org.apache.wicket.atmosphere.config.AtmosphereParameters;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.session.ISessionStore;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus
implements ISessionStore.UnboundListener {
    private static final Logger log = LoggerFactory.getLogger(EventBus.class);
    private static final MetaDataKey<EventBus> EVENT_BUS_KEY = new MetaDataKey<EventBus>(){
        private static final long serialVersionUID = 1L;
    };
    private final WebApplication application;
    private final Multimap<PageKey, EventSubscription> subscriptions = HashMultimap.create();
    private final Map<String, PageKey> trackedPages = Maps.newHashMap();
    private final List<ResourceRegistrationListener> registrationListeners = new CopyOnWriteArrayList<ResourceRegistrationListener>();
    private final AtmosphereParameters parameters = new AtmosphereParameters();
    private Broadcaster broadcaster;
    private boolean wantAtmosphereNotifications = false;

    public static EventBus get() {
        return EventBus.get(Application.get());
    }

    public static EventBus get(Application application) {
        EventBus eventBus = (EventBus)application.getMetaData(EVENT_BUS_KEY);
        if (eventBus == null) {
            throw new WicketRuntimeException("There is no EventBus registered for the given application: " + application.getName());
        }
        return eventBus;
    }

    public static boolean isInstalled(Application application) {
        return application.getMetaData(EVENT_BUS_KEY) != null;
    }

    public EventBus(WebApplication application) {
        this(application, null);
    }

    private static Broadcaster lookupDefaultBroadcaster() {
        BroadcasterFactory factory = BroadcasterFactory.getDefault();
        if (factory == null) {
            throw new WicketRuntimeException("There is no Atmosphere BroadcasterFactory configured. Did you include the atmosphere.xml configuration file and configured AtmosphereServlet?");
        }
        Collection allBroadcasters = factory.lookupAll();
        if (allBroadcasters.isEmpty()) {
            throw new WicketRuntimeException("The Atmosphere BroadcasterFactory has no Broadcasters, something is wrong with your Atmosphere configuration.");
        }
        return (Broadcaster)allBroadcasters.iterator().next();
    }

    public EventBus(WebApplication application, Broadcaster broadcaster) {
        this.application = application;
        this.broadcaster = broadcaster;
        application.setMetaData(EVENT_BUS_KEY, (Object)this);
        application.mount((IRequestMapper)new AtmosphereRequestMapper(this.createEventSubscriptionInvoker()));
        application.getComponentPostOnBeforeRenderListeners().add((Object)this.createEventSubscriptionCollector());
        application.getSessionStore().registerUnboundListener((ISessionStore.UnboundListener)this);
        this.checkEnabledAnalytics(this.getBroadcaster().getBroadcasterConfig().getAtmosphereConfig());
    }

    private void checkEnabledAnalytics(AtmosphereConfig config) {
        int major = Version.getMajorVersion();
        int minor = Version.getMinorVersion();
        boolean analyticsAlwaysEnabled = major == 2 && minor < 3;
        boolean analyticsOption = config.getInitParameter(AtmosphereFramework.class.getName() + ".analytics", true);
        if (analyticsAlwaysEnabled || analyticsOption) {
            log.warn("Atmosphere's Google Analytics callback is enabled. Atmosphere will contact Google Analytics on startup of your application. To disable this, upgrade to Atmosphere 2.3 and disable ApplicationConfig.ANALYTICS in your web.xml");
        }
    }

    protected EventSubscriptionInvoker createEventSubscriptionInvoker() {
        return new SubscribeAnnotationEventSubscriptionInvoker();
    }

    protected IComponentOnBeforeRenderListener createEventSubscriptionCollector() {
        return new AtmosphereEventSubscriptionCollector(this);
    }

    public Broadcaster getBroadcaster() {
        return this.broadcaster != null ? this.broadcaster : EventBus.lookupDefaultBroadcaster();
    }

    public EventBus setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
        return this;
    }

    public AtmosphereParameters getParameters() {
        return this.parameters;
    }

    public synchronized void registerPage(String trackingId, Page page) {
        PageKey oldPage = this.trackedPages.remove(trackingId);
        PageKey pageKey = new PageKey(page.getPageId(), Session.get().getId());
        if (oldPage != null && !oldPage.equals(pageKey)) {
            this.subscriptions.removeAll((Object)oldPage);
            this.fireUnregistration(trackingId);
        }
        this.trackedPages.put(trackingId, pageKey);
        this.fireRegistration(trackingId, page);
        if (log.isDebugEnabled()) {
            log.debug("registered page {} for session {}", (Object)pageKey.getPageId(), (Object)pageKey.getSessionId());
        }
    }

    public synchronized void register(Page page, EventSubscription subscription) {
        PageKey pageKey;
        if (log.isDebugEnabled()) {
            log.debug("registering {} for page {} for session {}: {}{}", new Object[]{subscription.getBehaviorIndex() == null ? "component" : "behavior", page.getPageId(), Session.get().getId(), subscription.getComponentPath(), subscription.getBehaviorIndex() == null ? "" : ":" + subscription.getBehaviorIndex()});
        }
        if (!this.subscriptions.containsEntry((Object)(pageKey = new PageKey(page.getPageId(), Session.get().getId())), (Object)subscription)) {
            this.subscriptions.put((Object)pageKey, (Object)subscription);
        }
    }

    public synchronized void unregister(Page page, EventSubscription subscription) {
        if (log.isDebugEnabled()) {
            log.debug("unregistering {} for page {} for session {}: {}{}", new Object[]{subscription.getBehaviorIndex() == null ? "component" : "behavior", page.getPageId(), Session.get().getId(), subscription.getComponentPath(), subscription.getBehaviorIndex() == null ? "" : ":" + subscription.getBehaviorIndex()});
        }
        PageKey pageKey = new PageKey(page.getPageId(), Session.get().getId());
        this.subscriptions.remove((Object)pageKey, (Object)subscription);
    }

    public synchronized void unregister(PageKey pageKey) {
        if (log.isDebugEnabled()) {
            log.debug("unregistering all subscriptions for page {} for session {}", (Object)pageKey.getPageId(), (Object)pageKey.getSessionId());
        }
        this.subscriptions.removeAll((Object)pageKey);
    }

    public synchronized void unregister(Component component) {
        String componentPath = component.getPageRelativePath();
        PageKey pageKey = new PageKey(component.getPage().getPageId(), Session.get().getId());
        Collection subscriptionsForPage = this.subscriptions.get((Object)pageKey);
        Iterator it = subscriptionsForPage.iterator();
        while (it.hasNext()) {
            if (!((EventSubscription)it.next()).getComponentPath().equals(componentPath)) continue;
            it.remove();
        }
    }

    public synchronized void unregisterConnection(String trackingId) {
        PageKey pageKey = this.trackedPages.remove(trackingId);
        if (pageKey != null) {
            this.fireUnregistration(trackingId);
            if (log.isDebugEnabled()) {
                log.debug("unregistering page {} for session {}", (Object)pageKey.getPageId(), (Object)pageKey.getSessionId());
            }
        }
    }

    public void post(Object event, String resourceUuid) {
        AtmosphereResource resource = AtmosphereResourceFactory.getDefault().find(resourceUuid);
        if (resource != null) {
            this.post(event, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object event, AtmosphereResource resource) {
        ThreadContext oldContext = ThreadContext.get((boolean)false);
        try {
            this.postToSingleResource(event, resource);
        }
        finally {
            ThreadContext.restore((ThreadContext)oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object event) {
        ThreadContext oldContext = ThreadContext.get((boolean)false);
        try {
            for (AtmosphereResource resource : ImmutableList.copyOf((Collection)this.getBroadcaster().getAtmosphereResources())) {
                this.postToSingleResource(event, resource);
            }
        }
        finally {
            ThreadContext.restore((ThreadContext)oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToSingleResource(Object payload, AtmosphereResource resource) {
        Iterable subscriptionsForPage;
        PageKey key;
        AtmosphereEvent event = new AtmosphereEvent(payload, resource);
        ThreadContext.detach();
        ThreadContext.setApplication((Application)this.application);
        EventBus eventBus = this;
        synchronized (eventBus) {
            key = this.trackedPages.get(resource.uuid());
            Collection eventSubscriptions = this.subscriptions.get((Object)key);
            subscriptionsForPage = Iterables.filter((Iterable)ImmutableList.copyOf((Collection)eventSubscriptions), (Predicate)new EventFilter(event));
        }
        if (key == null) {
            this.getBroadcaster().removeAtmosphereResource(resource);
        } else {
            Iterator<EventSubscription> iterator = subscriptionsForPage.iterator();
            if (iterator.hasNext()) {
                this.post(resource, key, iterator, event);
            }
        }
    }

    private void post(AtmosphereResource resource, PageKey pageKey, Iterator<EventSubscription> subscriptionsForPage, AtmosphereEvent event) {
        AtmosphereWebResponse response;
        String filterPath = WebApplication.get().getWicketFilter().getFilterConfig().getInitParameter("filterMappingUrlPattern");
        filterPath = filterPath.substring(1, filterPath.length() - 1);
        HttpServletRequestWrapper httpRequest = new HttpServletRequestWrapper((HttpServletRequest)resource.getRequest()){

            public String getContextPath() {
                String ret = super.getContextPath();
                return ret == null ? "" : ret;
            }
        };
        AtmosphereWebRequest request = new AtmosphereWebRequest((ServletWebRequest)this.application.newWebRequest((HttpServletRequest)httpRequest, filterPath), pageKey, subscriptionsForPage, event);
        if (this.application.createRequestCycle((Request)request, (Response)(response = new AtmosphereWebResponse(resource.getResponse()))).processRequestAndDetach()) {
            this.getBroadcaster().broadcast((Object)((Object)((Object)response)).toString(), resource);
        }
    }

    public synchronized void sessionUnbound(String sessionId) {
        log.debug("Session unbound {}", (Object)sessionId);
        Iterator<Map.Entry<String, PageKey>> pageIt = this.trackedPages.entrySet().iterator();
        while (pageIt.hasNext()) {
            Map.Entry<String, PageKey> curEntry = pageIt.next();
            if (!curEntry.getValue().isForSession(sessionId)) continue;
            pageIt.remove();
            this.fireUnregistration(curEntry.getKey());
        }
        Iterator subscriptionIt = this.subscriptions.keySet().iterator();
        while (subscriptionIt.hasNext()) {
            if (!((PageKey)subscriptionIt.next()).isForSession(sessionId)) continue;
            subscriptionIt.remove();
        }
    }

    public void addRegistrationListener(ResourceRegistrationListener listener) {
        this.registrationListeners.add(listener);
    }

    public void removeRegistrationListener(ResourceRegistrationListener listener) {
        this.registrationListeners.remove(listener);
    }

    private void fireRegistration(String uuid, Page page) {
        for (ResourceRegistrationListener curListener : this.registrationListeners) {
            curListener.resourceRegistered(uuid, page);
        }
    }

    private void fireUnregistration(String uuid) {
        for (ResourceRegistrationListener curListener : this.registrationListeners) {
            curListener.resourceUnregistered(uuid);
        }
    }

    public boolean isWantAtmosphereNotifications() {
        return this.wantAtmosphereNotifications;
    }

    public EventBus setWantAtmosphereNotifications(boolean wantAtmosphereNotifications) {
        this.wantAtmosphereNotifications = wantAtmosphereNotifications;
        return this;
    }
}

