/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.atmosphere;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.atmosphere.AtmosphereBehavior;
import org.apache.wicket.atmosphere.EventBus;
import org.apache.wicket.atmosphere.EventSubscription;
import org.apache.wicket.atmosphere.Subscribe;
import org.apache.wicket.behavior.Behavior;

public class AtmosphereEventSubscriptionCollector
implements IComponentOnBeforeRenderListener {
    private Cache<Class<?>, Iterable<Method>> subscribedMethodsCache;
    private EventBus eventBus;

    public AtmosphereEventSubscriptionCollector(EventBus eventBus) {
        this.eventBus = eventBus;
        this.subscribedMethodsCache = CacheBuilder.newBuilder().build();
    }

    public void onBeforeRender(Component component) {
        for (Method curMethod : this.findSubscribedMethods(component.getClass())) {
            this.subscribeComponent(component, null, curMethod);
        }
        for (Behavior curBehavior : component.getBehaviors()) {
            for (Method curMethod : this.findSubscribedMethods(curBehavior.getClass())) {
                this.subscribeComponent(component, curBehavior, curMethod);
            }
        }
    }

    private Iterable<Method> findSubscribedMethods(final Class<?> clazz) {
        try {
            return (Iterable)this.subscribedMethodsCache.get(clazz, (Callable)new Callable<Iterable<Method>>(){

                @Override
                public Iterable<Method> call() throws Exception {
                    ImmutableList.Builder ret = ImmutableList.builder();
                    for (Method curMethod : clazz.getMethods()) {
                        if (!curMethod.isAnnotationPresent(Subscribe.class)) continue;
                        AtmosphereEventSubscriptionCollector.this.verifyMethodParameters(curMethod);
                        ret.add((Object)curMethod);
                    }
                    return ret.build();
                }
            });
        }
        catch (ExecutionException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    private void verifyMethodParameters(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 2 || !params[0].equals(AjaxRequestTarget.class)) {
            throw new WicketRuntimeException("@Subscribe can only be used on methods with 2 params, of which the first is AjaxRequestTarget. " + method + " does not conform to this signature.");
        }
    }

    private void subscribeComponent(Component component, Behavior behavior, Method method) {
        EventSubscription subscription = new EventSubscription(component, behavior, method);
        Page page = component.getPage();
        this.eventBus.register(page, subscription);
        if (page.getBehaviors(AtmosphereBehavior.class).isEmpty()) {
            page.add(new Behavior[]{new AtmosphereBehavior()});
        }
    }
}

