/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.lang.reflect.Modifier;
import org.apache.wicket.core.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.PackageName;
import org.apache.wicket.util.string.Strings;

public class PackageMapper
extends AbstractBookmarkableMapper {
    private final PackageName packageName;
    private final IPageParametersEncoder pageParametersEncoder;

    public PackageMapper(PackageName packageName) {
        this(packageName, (IPageParametersEncoder)new PageParametersEncoder());
    }

    public PackageMapper(PackageName packageName, IPageParametersEncoder pageParametersEncoder) {
        Args.notNull((Object)packageName, (String)"packageName");
        Args.notNull((Object)pageParametersEncoder, (String)"pageParametersEncoder");
        this.packageName = packageName;
        this.pageParametersEncoder = pageParametersEncoder;
    }

    @Override
    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Class<? extends IRequestablePage> pageClass = info.getPageClass();
        PackageName pageClassPackageName = PackageName.forClass(pageClass);
        if (pageClassPackageName.equals((Object)this.packageName)) {
            String fullyQualifiedClassName;
            Url url = new Url();
            String packageRelativeClassName = fullyQualifiedClassName = pageClass.getName();
            int packageNameLength = this.packageName.getName().length();
            if (packageNameLength > 0) {
                packageRelativeClassName = fullyQualifiedClassName.substring(packageNameLength + 1);
            }
            packageRelativeClassName = this.transformForUrl(packageRelativeClassName);
            url.getSegments().add(packageRelativeClassName);
            this.encodePageComponentInfo(url, info.getPageComponentInfo());
            return this.encodePageParameters(url, info.getPageParameters(), this.pageParametersEncoder);
        }
        return null;
    }

    @Override
    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        Url url = request.getUrl();
        if (url.getSegments().size() >= 1) {
            PageComponentInfo info = this.getPageComponentInfo(url);
            String name = (String)url.getSegments().get(0);
            if (Strings.isEmpty((CharSequence)name)) {
                return null;
            }
            String className = this.cleanClassName(name);
            if (!this.isValidClassName(className)) {
                return null;
            }
            className = this.transformFromUrl(className);
            String fullyQualifiedClassName = this.packageName.getName() + '.' + className;
            Class<? extends IRequestablePage> pageClass = this.getPageClass(fullyQualifiedClassName);
            if (pageClass != null && !Modifier.isAbstract(pageClass.getModifiers()) && IRequestablePage.class.isAssignableFrom(pageClass)) {
                PageParameters pageParameters = this.extractPageParameters(request, 1, this.pageParametersEncoder);
                return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
            }
        }
        return null;
    }

    private boolean isValidClassName(String className) {
        if (Strings.isEmpty((CharSequence)className)) {
            return false;
        }
        return !className.startsWith(".");
    }

    protected String transformFromUrl(String classNameAlias) {
        return classNameAlias;
    }

    protected String transformForUrl(String className) {
        return className;
    }

    @Override
    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return false;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        return 0;
    }

    @Override
    protected boolean checkPageClass(Class<? extends IRequestablePage> pageClass) {
        PackageName pageClassPackageName = PackageName.forClass(pageClass);
        return this.packageName.equals((Object)pageClassPackageName);
    }
}

