/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.jetty9;

import java.lang.reflect.Field;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;

class Jetty9UpgradeHttpRequest
extends HttpServletRequestWrapper {
    private static final Field REQ;

    Jetty9UpgradeHttpRequest(UpgradeRequest upgradeRequest) {
        super(Jetty9UpgradeHttpRequest.extractHttpRequest(upgradeRequest));
    }

    private static HttpServletRequest extractHttpRequest(UpgradeRequest upgradeRequest) {
        HttpServletRequest request;
        if (!(upgradeRequest instanceof ServletUpgradeRequest)) {
            throw new IllegalArgumentException(Jetty9UpgradeHttpRequest.class.getName() + " can work only with " + ServletUpgradeRequest.class.getName());
        }
        ServletUpgradeRequest servletWebSocketRequest = (ServletUpgradeRequest)upgradeRequest;
        try {
            request = (HttpServletRequest)REQ.get(servletWebSocketRequest);
        }
        catch (IllegalAccessException iax) {
            throw new IllegalStateException("Cannot get the HttpServletRequest after the protocol upgrade", iax);
        }
        return request;
    }

    static {
        try {
            REQ = ServletUpgradeRequest.class.getDeclaredField("req");
        }
        catch (NoSuchFieldException nsfx) {
            throw new IllegalStateException(ServletUpgradeRequest.class.getName() + " has no 'req' field!", nsfx);
        }
        REQ.setAccessible(true);
    }
}

