/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import jakarta.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.ContextLoadException;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.aot.AotContextLoader;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public abstract class AbstractGenericWebContextLoader
extends AbstractContextLoader
implements AotContextLoader {
    protected static final Log logger = LogFactory.getLog(AbstractGenericWebContextLoader.class);

    @Override
    public final ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        return this.loadContext(mergedConfig, false);
    }

    @Deprecated(since="6.2.4", forRemoval=true)
    public final GenericWebApplicationContext loadContextForAotProcessing(MergedContextConfiguration mergedConfig) throws Exception {
        return this.loadContext(mergedConfig, true);
    }

    public final GenericWebApplicationContext loadContextForAotProcessing(MergedContextConfiguration mergedConfig, RuntimeHints runtimeHints) throws Exception {
        return this.loadContext(mergedConfig, true);
    }

    public final GenericWebApplicationContext loadContextForAotRuntime(MergedContextConfiguration mergedConfig, ApplicationContextInitializer<ConfigurableApplicationContext> initializer) throws Exception {
        Assert.notNull((Object)mergedConfig, (String)"MergedContextConfiguration must not be null");
        Assert.notNull(initializer, (String)"ApplicationContextInitializer must not be null");
        if (!(mergedConfig instanceof WebMergedContextConfiguration)) {
            throw new IllegalArgumentException("Cannot load WebApplicationContext from non-web merged context configuration %s. Consider annotating your test class with @WebAppConfiguration.".formatted(mergedConfig));
        }
        WebMergedContextConfiguration webMergedConfig = (WebMergedContextConfiguration)mergedConfig;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Loading WebApplicationContext for AOT runtime for " + String.valueOf(mergedConfig)));
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading WebApplicationContext for AOT runtime for test class " + mergedConfig.getTestClass().getName()));
        }
        this.validateMergedContextConfiguration(webMergedConfig);
        GenericWebApplicationContext context = this.createContext();
        try {
            this.configureWebResources(context, webMergedConfig);
            this.prepareContext((ConfigurableApplicationContext)context, webMergedConfig);
            initializer.initialize((ConfigurableApplicationContext)context);
            this.customizeContext(context, webMergedConfig);
            context.refresh();
            return context;
        }
        catch (Exception ex) {
            throw new ContextLoadException((ApplicationContext)context, (Throwable)ex);
        }
    }

    private GenericWebApplicationContext loadContext(MergedContextConfiguration mergedConfig, boolean forAotProcessing) throws Exception {
        if (!(mergedConfig instanceof WebMergedContextConfiguration)) {
            throw new IllegalArgumentException("Cannot load WebApplicationContext from non-web merged context configuration %s. Consider annotating your test class with @WebAppConfiguration.".formatted(mergedConfig));
        }
        WebMergedContextConfiguration webMergedConfig = (WebMergedContextConfiguration)mergedConfig;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Loading WebApplicationContext %sfor %s".formatted(forAotProcessing ? "for AOT processing " : "", mergedConfig));
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading WebApplicationContext %sfor test class %s".formatted(forAotProcessing ? "for AOT processing " : "", mergedConfig.getTestClass().getName()));
        }
        this.validateMergedContextConfiguration(webMergedConfig);
        GenericWebApplicationContext context = this.createContext();
        try {
            ApplicationContext parent = mergedConfig.getParentApplicationContext();
            if (parent != null) {
                context.setParent(parent);
            }
            this.configureWebResources(context, webMergedConfig);
            this.prepareContext((ConfigurableApplicationContext)context, webMergedConfig);
            this.customizeBeanFactory(context.getDefaultListableBeanFactory(), webMergedConfig);
            this.loadBeanDefinitions(context, webMergedConfig);
            AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)context);
            this.customizeContext(context, webMergedConfig);
            if (!forAotProcessing) {
                context.refresh();
                context.registerShutdownHook();
            }
            return context;
        }
        catch (Exception ex) {
            throw new ContextLoadException((ApplicationContext)context, (Throwable)ex);
        }
    }

    protected void validateMergedContextConfiguration(WebMergedContextConfiguration mergedConfig) {
    }

    protected GenericWebApplicationContext createContext() {
        return new GenericWebApplicationContext();
    }

    protected void configureWebResources(GenericWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        ApplicationContext parent = context.getParent();
        if (!(parent instanceof WebApplicationContext)) {
            String resourceBasePath = webMergedConfig.getResourceBasePath();
            DefaultResourceLoader resourceLoader = resourceBasePath.startsWith("classpath:") ? new DefaultResourceLoader() : new FileSystemResourceLoader();
            MockServletContext servletContext = new MockServletContext(resourceBasePath, (ResourceLoader)resourceLoader);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, context);
            context.setServletContext((ServletContext)servletContext);
        } else {
            ServletContext servletContext = null;
            while (parent != null) {
                if (parent instanceof WebApplicationContext) {
                    WebApplicationContext parentWac = (WebApplicationContext)parent;
                    if (!(parent.getParent() instanceof WebApplicationContext)) {
                        servletContext = parentWac.getServletContext();
                        break;
                    }
                }
                parent = parent.getParent();
            }
            Assert.state((servletContext != null ? 1 : 0) != 0, (String)"Failed to find root WebApplicationContext in the context hierarchy");
            context.setServletContext(servletContext);
        }
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory, WebMergedContextConfiguration webMergedConfig) {
    }

    protected abstract void loadBeanDefinitions(GenericWebApplicationContext var1, WebMergedContextConfiguration var2);

    protected void customizeContext(GenericWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        super.customizeContext((ConfigurableApplicationContext)context, webMergedConfig);
    }

    @Override
    public final ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("AbstractGenericWebContextLoader does not support the loadContext(String... locations) method");
    }
}

