/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.validation.impl.model.MergedValidationModel;
import org.apache.sling.validation.model.ValidationModel;
import org.apache.sling.validation.model.spi.ValidationModelProvider;
import org.apache.sling.validation.model.spi.ValidationModelRetriever;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ValidationModelRetrieverImpl
implements ValidationModelRetriever {
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, fieldOption=FieldOption.REPLACE)
    protected volatile List<ValidationModelProvider> modelProviders;
    @Reference
    ResourceResolverFactory resourceResolverFactory;
    private static final Logger LOG = LoggerFactory.getLogger(ValidationModelRetrieverImpl.class);

    @CheckForNull
    public ValidationModel getValidationModel(@Nonnull String resourceType, String resourcePath, boolean considerResourceSuperTypeModels) {
        ValidationModel baseModel = this.getModel(resourceType, resourcePath);
        String currentResourceType = resourceType;
        if (considerResourceSuperTypeModels) {
            ArrayList<ValidationModel> modelsToMerge = new ArrayList<ValidationModel>();
            try (ResourceResolver resourceResolver = null;){
                ValidationModel modelToMerge;
                resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
                while ((currentResourceType = resourceResolver.getParentResourceType(currentResourceType)) != null) {
                    LOG.debug("Retrieving validation models for resource super type {}...", (Object)currentResourceType);
                    modelToMerge = this.getModel(currentResourceType, resourcePath);
                    if (modelToMerge == null) continue;
                    if (baseModel == null) {
                        baseModel = modelToMerge;
                        continue;
                    }
                    modelsToMerge.add(modelToMerge);
                }
                if (!modelsToMerge.isEmpty()) {
                    modelToMerge = new MergedValidationModel(baseModel, modelsToMerge.toArray(new ValidationModel[modelsToMerge.size()]));
                    return modelToMerge;
                }
            }
        }
        return baseModel;
    }

    @CheckForNull
    private ValidationModel getModel(@Nonnull String resourceType, String resourcePath) {
        PatriciaTrie<ValidationModel> modelsForResourceType = this.fillTrieForResourceType(resourceType);
        ValidationModel model = null;
        if (StringUtils.isEmpty((CharSequence)resourcePath)) {
            model = (ValidationModel)modelsForResourceType.get((Object)"");
        } else {
            SortedMap modelMap = modelsForResourceType.subMap((Object)"", (Object)(resourcePath + "/"));
            if (!modelMap.isEmpty()) {
                model = (ValidationModel)modelMap.get(modelMap.lastKey());
            }
        }
        if (model == null && !modelsForResourceType.isEmpty()) {
            LOG.warn("Although at least one model for resource type '{}' is available, none of them are allowed to be applied to path {}", (Object)resourceType, (Object)resourcePath);
        }
        return model;
    }

    @Nonnull
    private PatriciaTrie<ValidationModel> fillTrieForResourceType(@Nonnull String resourceType) {
        PatriciaTrie modelsForResourceType = new PatriciaTrie();
        for (ValidationModelProvider modelProvider : this.modelProviders) {
            LOG.debug("Retrieving validation models with resource type {} from provider {}...", (Object)resourceType, (Object)modelProvider.getClass().getName());
            List models = modelProvider.getValidationModels(resourceType);
            for (ValidationModel model : models) {
                for (String applicablePath : model.getApplicablePaths()) {
                    LOG.debug("Found validation model for resource type {} for applicable path {}", (Object)resourceType, (Object)applicablePath);
                    modelsForResourceType.put((Object)applicablePath, (Object)model);
                }
            }
            if (!models.isEmpty()) continue;
            LOG.debug("Found no validation model with resource type {} from provider {}", (Object)resourceType, (Object)modelProvider.getClass().getName());
        }
        return modelsForResourceType;
    }
}

