/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.ast.AndImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.FullTextSearchImpl;
import org.apache.jackrabbit.oak.query.ast.LiteralImpl;
import org.apache.jackrabbit.oak.query.ast.OrImpl;
import org.apache.jackrabbit.util.Text;

class SimpleExcerptProvider {
    static final String REP_EXCERPT_FN = "rep:excerpt(.)";
    static final String EXCERPT_END = "</span></div>";
    static final String EXCERPT_BEGIN = "<div><span>";
    private static final boolean CASE_SENSITIVE_HIGHLIGHT = Boolean.getBoolean("oak.query.caseSensitiveHighlight");
    private static int maxFragmentSize = 150;

    private SimpleExcerptProvider() {
    }

    static String getExcerpt(String path, String columnName, Query query, boolean highlight) {
        if (path == null) {
            return null;
        }
        Tree t = query.getTree(path);
        if (t == null || !t.exists()) {
            return null;
        }
        if ((columnName = SimpleExcerptProvider.extractExcerptProperty(columnName)) != null && columnName.contains("/")) {
            for (String p : PathUtils.elements(PathUtils.getParentPath(columnName))) {
                if (t.hasChild(p)) {
                    t = t.getChild(p);
                    continue;
                }
                return null;
            }
            columnName = PathUtils.getName(columnName);
        }
        StringBuilder text = new StringBuilder();
        String separator = "";
        for (PropertyState propertyState : t.getProperties()) {
            if (propertyState.getType().tag() != Type.STRING.tag() || columnName != null && !columnName.equalsIgnoreCase(propertyState.getName())) continue;
            text.append(separator);
            separator = " ";
            for (String v : propertyState.getValue(Type.STRINGS)) {
                text.append(v);
            }
        }
        Set<String> searchToken = SimpleExcerptProvider.extractFulltext(query);
        if (highlight && searchToken != null) {
            return SimpleExcerptProvider.highlight(text, searchToken);
        }
        return SimpleExcerptProvider.noHighlight(text);
    }

    private static String extractExcerptProperty(String column) {
        if (REP_EXCERPT_FN.equalsIgnoreCase(column)) {
            return null;
        }
        return column.substring(column.indexOf("(") + 1, column.indexOf(")"));
    }

    private static Set<String> extractFulltext(Query q) {
        if (q instanceof QueryImpl) {
            return SimpleExcerptProvider.extractFulltext(((QueryImpl)q).getConstraint());
        }
        return Set.of();
    }

    private static Set<String> extractFulltext(ConstraintImpl c) {
        FullTextSearchImpl f;
        HashSet<String> tokens = new HashSet<String>();
        if (c instanceof FullTextSearchImpl && (f = (FullTextSearchImpl)c).getFullTextSearchExpression() instanceof LiteralImpl) {
            LiteralImpl l = (LiteralImpl)f.getFullTextSearchExpression();
            tokens.add(l.getLiteralValue().getValue(Type.STRING));
        }
        if (c instanceof AndImpl) {
            for (ConstraintImpl constraint : ((AndImpl)c).getConstraints()) {
                tokens.addAll(SimpleExcerptProvider.extractFulltext(constraint));
            }
        }
        if (c instanceof OrImpl) {
            for (ConstraintImpl constraint : ((OrImpl)c).getConstraints()) {
                tokens.addAll(SimpleExcerptProvider.extractFulltext(constraint));
            }
        }
        return tokens;
    }

    private static Set<String> tokenize(Set<String> in) {
        HashSet<String> tokens = new HashSet<String>();
        for (String s : in) {
            tokens.addAll(SimpleExcerptProvider.tokenize(s));
        }
        return tokens;
    }

    private static Set<String> tokenize(String in) {
        int length;
        HashSet<String> out = new HashSet<String>();
        StringBuilder token = new StringBuilder();
        boolean quote = false;
        block4: for (int i = 0; i < in.length(); i += length) {
            int c = in.codePointAt(i);
            length = Character.charCount(c);
            switch (c) {
                case 32: {
                    if (quote) {
                        token.append(' ');
                        continue block4;
                    }
                    if (token.length() <= 0) continue block4;
                    out.add(token.toString());
                    token = new StringBuilder();
                    continue block4;
                }
                case 34: 
                case 39: {
                    if (quote) {
                        quote = false;
                        if (token.length() <= 0) continue block4;
                        out.add(token.toString());
                        token = new StringBuilder();
                        continue block4;
                    }
                    quote = true;
                    continue block4;
                }
                default: {
                    token.append(new String(Character.toChars(c)));
                }
            }
        }
        if (token.length() > 0) {
            out.add(token.toString());
        }
        return out;
    }

    private static String noHighlight(StringBuilder text) {
        if (text.length() > maxFragmentSize) {
            int lastSpace = text.lastIndexOf(" ", maxFragmentSize);
            if (lastSpace != -1) {
                text.setLength(lastSpace);
            } else {
                text.setLength(maxFragmentSize);
            }
            text.append(" ...");
        }
        StringBuilder excerpt = new StringBuilder(EXCERPT_BEGIN);
        excerpt.append(Text.encodeIllegalXMLCharacters(text.toString()));
        excerpt.append(EXCERPT_END);
        return excerpt.toString();
    }

    static String highlight(StringBuilder text, Set<String> searchToken) {
        Set<String> tokens = SimpleExcerptProvider.tokenize(searchToken);
        String escaped = Text.encodeIllegalXMLCharacters(text.toString());
        BitSet highlight = new BitSet();
        for (String token : tokens) {
            SimpleExcerptProvider.highlight(escaped, highlight, token);
        }
        StringBuilder excerpt = new StringBuilder(EXCERPT_BEGIN);
        boolean strong = false;
        for (int i = 0; i < escaped.length(); ++i) {
            if (highlight.get(i) && !strong) {
                strong = true;
                excerpt.append("<strong>");
            } else if (!highlight.get(i) && strong) {
                strong = false;
                excerpt.append("</strong>");
            }
            excerpt.append(escaped.charAt(i));
        }
        if (strong) {
            excerpt.append("</strong>");
        }
        excerpt.append(EXCERPT_END);
        return excerpt.toString();
    }

    private static void highlight(String text, BitSet highlightBits, String token) {
        boolean isLike = false;
        if (token.endsWith("*")) {
            if (token.length() == 1) {
                return;
            }
            token = token.substring(0, token.length() - 1);
            isLike = true;
        }
        int index = 0;
        while (index < text.length() && (index = SimpleExcerptProvider.indexOfSearchText(text, token, index)) >= 0) {
            boolean isEndOk;
            int endIndex = index + token.length();
            if (isLike) {
                int nextSpace;
                for (nextSpace = endIndex; nextSpace < text.length() && !SimpleExcerptProvider.isDelimeter(text.codePointAt(nextSpace)); ++nextSpace) {
                }
                endIndex = nextSpace != text.length() ? nextSpace : text.length();
            }
            boolean isStartOk = index == 0 || SimpleExcerptProvider.isDelimeter(text.codePointAt(index - 1));
            boolean bl = isEndOk = endIndex == text.length() || SimpleExcerptProvider.isDelimeter(text.codePointAt(endIndex));
            if (isStartOk && isEndOk) {
                while (index < endIndex) {
                    highlightBits.set(index++);
                }
                continue;
            }
            index = endIndex;
        }
    }

    private static int indexOfSearchText(String text, String searchStr, int fromIndex) {
        if (CASE_SENSITIVE_HIGHLIGHT) {
            return text.indexOf(searchStr, fromIndex);
        }
        return SimpleExcerptProvider.indexOfIgnoreCase(text, searchStr, fromIndex);
    }

    public static int indexOfIgnoreCase(String str, String searchStr, int startPos) {
        String quotedSearchStr = Pattern.quote(searchStr);
        Pattern pattern = Pattern.compile(quotedSearchStr, 2);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find(startPos)) {
            return matcher.start();
        }
        return -1;
    }

    static boolean isDelimeter(int codePoint) {
        return !Character.isLetterOrDigit(codePoint);
    }

    static PropertyValue getExcerpt(PropertyValue value) {
        StringBuilder excerpt = new StringBuilder(EXCERPT_BEGIN);
        for (String v : Arrays.stream(value.toString().split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList())) {
            excerpt.append(v);
        }
        excerpt.append(EXCERPT_END);
        return PropertyValues.newString(excerpt.toString());
    }
}

