/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.cxf.v3.client;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.transport.http.Address;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class MessageSenderInterceptorInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Message message = (Message)allArguments[0];
        String httpRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        MessageInfo messageInfo = (MessageInfo)message.get((Object)"org.apache.cxf.service.model.MessageInfo");
        Address address = (Address)message.get((Object)"http.connection.address");
        if (null == httpRequestMethod || null == messageInfo || null == address) {
            return;
        }
        String operationName = this.generateOperationName(messageInfo, address);
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (String)address.getURI().getAuthority());
        ContextCarrier contextCarrier = new ContextCarrier();
        ContextManager.inject((ContextCarrier)contextCarrier);
        span.setComponent((Component)ComponentsDefine.APACHE_CXF);
        Tags.HTTP.METHOD.set(span, httpRequestMethod);
        Tags.URL.set(span, this.generateRequestURL(messageInfo, address));
        SpanLayer.asRPCFramework((AbstractSpan)span);
        Map protocolHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            ArrayList<String> headerList = new ArrayList<String>(1);
            headerList.add(next.getHeadValue());
            protocolHeaders.put(next.getHeadKey(), headerList);
        }
    }

    private String generateOperationName(MessageInfo messageInfo, Address address) {
        return address.getURI().getPath() + "/" + messageInfo.getOperation().getInputName();
    }

    private String generateRequestURL(MessageInfo messageInfo, Address address) {
        return address.getString() + "/" + messageInfo.getOperation().getInputName();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

