/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.log.log4j.v1.x.log;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.util.ThrowableTransformer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.remote.LogReportServiceClient;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.apm.network.logging.v3.LogDataBody;
import org.apache.skywalking.apm.network.logging.v3.LogTags;
import org.apache.skywalking.apm.network.logging.v3.TextLog;
import org.apache.skywalking.apm.network.logging.v3.TraceContext;

public class GRPCLogAppenderInterceptor
implements InstanceMethodsAroundInterceptor {
    private LogReportServiceClient client;

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        LoggingEvent event;
        if (Objects.isNull(this.client)) {
            this.client = (LogReportServiceClient)ServiceManager.INSTANCE.findService(LogReportServiceClient.class);
            if (Objects.isNull(this.client)) {
                return;
            }
        }
        if (Objects.nonNull(event = (LoggingEvent)allArguments[0])) {
            this.client.produce(this.transform((AppenderSkeleton)objInst, event));
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    private LogData.Builder transform(AppenderSkeleton appender, LoggingEvent event) {
        LogData.Builder builder = LogData.newBuilder().setTimestamp(event.getTimeStamp()).setServiceInstance(Config.Agent.INSTANCE_NAME).setTraceContext(TraceContext.newBuilder().setTraceId(ContextManager.getGlobalTraceId()).setSpanId(ContextManager.getSpanId()).setTraceSegmentId(ContextManager.getSegmentId()).build()).setTags(LogTags.newBuilder().addData(KeyStringValuePair.newBuilder().setKey("level").setValue(event.getLevel().toString()).build()).addData(KeyStringValuePair.newBuilder().setKey("logger").setValue(event.getLoggerName()).build()).addData(KeyStringValuePair.newBuilder().setKey("thread").setValue(event.getThreadName()).build()).build()).setBody(LogDataBody.newBuilder().setType(LogDataBody.ContentCase.TEXT.name()).setText(TextLog.newBuilder().setText(this.transformLogText(appender, event)).build()).build());
        String primaryEndpointName = ContextManager.getPrimaryEndpointName();
        if (primaryEndpointName != null) {
            builder.setEndpoint(primaryEndpointName);
        }
        return -1 == ContextManager.getSpanId() ? builder : builder.setTraceContext(TraceContext.newBuilder().setTraceId(ContextManager.getGlobalTraceId()).setSpanId(ContextManager.getSpanId()).setTraceSegmentId(ContextManager.getSegmentId()).build());
    }

    private String transformLogText(AppenderSkeleton appender, LoggingEvent event) {
        if (appender.getLayout() != null) {
            return appender.getLayout().format(event);
        }
        String throwableString = Objects.isNull(event.getThrowableInformation()) ? "" : ThrowableTransformer.INSTANCE.convert2String(event.getThrowableInformation().getThrowable(), 2048);
        return event.getMessage() + "\n" + throwableString;
    }
}

