/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.meter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.toolkit.meter.BaseBuilder;
import org.apache.skywalking.apm.toolkit.meter.BaseMeter;
import org.apache.skywalking.apm.toolkit.meter.MeterId;

public class Histogram
extends BaseMeter {
    protected Histogram(MeterId meterId, List<Double> steps) {
        super(meterId);
    }

    public void addValue(double value) {
    }

    public static class Builder
    extends BaseBuilder<Builder, Histogram> {
        private double minValue = 0.0;
        private List<Double> steps;

        public Builder(String name) {
            super(name);
        }

        public Builder(MeterId meterId) {
            super(meterId);
        }

        public Builder steps(List<Double> steps) {
            this.steps = new ArrayList<Double>(steps);
            return this;
        }

        public Builder minValue(double minValue) {
            this.minValue = minValue;
            return this;
        }

        @Override
        protected MeterId.MeterType getType() {
            return MeterId.MeterType.HISTOGRAM;
        }

        @Override
        protected Histogram create() {
            if (this.steps == null || this.steps.isEmpty()) {
                throw new IllegalArgumentException("Missing steps setting");
            }
            this.steps = this.steps.stream().distinct().sorted().collect(Collectors.toList());
            if (this.steps.get(0) < this.minValue) {
                throw new IllegalArgumentException("Step[0] must be  bigger than min value");
            }
            if (this.steps.get(0) != this.minValue) {
                this.steps.add(0, this.minValue);
            }
            return new Histogram(this.meterId, this.steps);
        }
    }
}

