/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.cloud.gateway.v412x;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.function.BiFunction;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.spring.cloud.gateway.v4x.define.EnhanceObjectCache;
import org.apache.skywalking.apm.util.StringUtil;
import org.reactivestreams.Publisher;

public class HttpClientFinalizerSendV412Interceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        EnhanceObjectCache enhanceObjectCache = (EnhanceObjectCache)objInst.getSkyWalkingDynamicField();
        if (enhanceObjectCache == null) {
            return;
        }
        ContextSnapshot contextSnapshot = enhanceObjectCache.getContextSnapshot();
        if (contextSnapshot == null) {
            return;
        }
        AbstractSpan span = ContextManager.createLocalSpan((String)"SpringCloudGateway/send");
        ContextManager.continued((ContextSnapshot)contextSnapshot);
        span.setComponent((Component)ComponentsDefine.SPRING_CLOUD_GATEWAY);
        span.prepareForAsync();
        if (StringUtil.isNotEmpty((String)enhanceObjectCache.getUrl())) {
            URL url = new URL(enhanceObjectCache.getUrl());
            ContextCarrier contextCarrier = new ContextCarrier();
            AbstractSpan abstractSpan = ContextManager.createExitSpan((String)"SpringCloudGateway/sendRequest", (ContextCarrier)contextCarrier, (String)this.getPeer(url));
            Tags.URL.set(abstractSpan, enhanceObjectCache.getUrl());
            abstractSpan.prepareForAsync();
            abstractSpan.setComponent((Component)ComponentsDefine.SPRING_CLOUD_GATEWAY);
            abstractSpan.setLayer(SpanLayer.HTTP);
            ContextManager.stopSpan((AbstractSpan)abstractSpan);
            BiFunction finalSender = (BiFunction)allArguments[0];
            allArguments[0] = (request, outbound) -> {
                Publisher publisher = (Publisher)finalSender.apply(request, outbound);
                CarrierItem next = contextCarrier.items();
                while (next.hasNext()) {
                    next = next.next();
                    request.requestHeaders().remove(next.getHeadKey());
                    request.requestHeaders().set(next.getHeadKey(), (Object)next.getHeadValue());
                }
                return publisher;
            };
            enhanceObjectCache.setCacheSpan(abstractSpan);
        }
        ContextManager.stopSpan((AbstractSpan)span);
        enhanceObjectCache.setSpan1(span);
    }

    private String getPeer(URL url) {
        return url.getHost() + ":" + url.getPort();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        ((EnhancedInstance)ret).setSkyWalkingDynamicField(objInst.getSkyWalkingDynamicField());
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

