/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import com.netflix.spectator.api.Statistic;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.metrics.publish.spectator.MeasurementNode;
import org.apache.servicecomb.foundation.vertx.http.VertxServerRequestToHttpServletRequest;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerf;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroup;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroups;
import org.apache.servicecomb.metrics.core.publish.model.invocation.PerfInfo;
import org.apache.servicecomb.swagger.invocation.Response;

public final class PublishUtils {
    public static final String EMPTY_RESULT = "-";

    private PublishUtils() {
    }

    public static PerfInfo createPerfInfo(MeasurementNode stageNode) {
        PerfInfo perfInfo = new PerfInfo();
        perfInfo.setTps(stageNode.findChild(Statistic.count.name()).summary());
        perfInfo.setMsTotalTime(stageNode.findChild(Statistic.totalTime.name()).summary() * 1000.0);
        MeasurementNode maxNode = stageNode.findChild(Statistic.max.name());
        if (maxNode != null) {
            perfInfo.setMsMaxLatency(maxNode.summary() * 1000.0);
        }
        return perfInfo;
    }

    public static OperationPerf createOperationPerf(String operation, MeasurementNode statusNode) {
        OperationPerf operationPerf = new OperationPerf();
        operationPerf.setOperation(operation);
        MeasurementNode stageNode = statusNode.findChild("stage");
        stageNode.getChildren().values().forEach(mNode -> {
            PerfInfo perfInfo = PublishUtils.createPerfInfo(mNode);
            operationPerf.getStages().put(mNode.getName(), perfInfo);
        });
        MeasurementNode latencyNode = statusNode.findChild("latencyDistribution");
        if (latencyNode != null && latencyNode.getMeasurements() != null) {
            operationPerf.setLatencyDistribution((Integer[])latencyNode.getMeasurements().stream().map(m -> (int)m.value()).toArray(Integer[]::new));
        }
        return operationPerf;
    }

    public static void addOperationPerfGroups(OperationPerfGroups operationPerfGroups, String transport, String operation, MeasurementNode statusNode) {
        Map statusMap = operationPerfGroups.getGroups().computeIfAbsent(transport, tn -> new HashMap());
        OperationPerfGroup group = statusMap.computeIfAbsent(statusNode.getName(), status -> new OperationPerfGroup(transport, (String)status));
        OperationPerf operationPerf = PublishUtils.createOperationPerf(operation, statusNode);
        group.addOperationPerf(operationPerf);
    }

    public static String refactorStatus(Invocation invocation, Response response) {
        if (invocation.getRequestEx() instanceof VertxServerRequestToHttpServletRequest) {
            RoutingContext context = ((VertxServerRequestToHttpServletRequest)invocation.getRequestEx()).getContext();
            if (context == null) {
                return String.valueOf(response.getStatusCode());
            }
            HttpServerResponse contextResponse = context.response();
            if (response.getStatusCode() == 200 && contextResponse.closed() && !contextResponse.ended()) {
                return EMPTY_RESULT;
            }
        }
        return String.valueOf(response.getStatusCode());
    }
}

