/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerMeta;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoConsumerMetaRefresher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoConsumerMetaRefresher.class);
    protected final String microserviceName;
    protected final String schemaId;
    protected final Class<?> consumerIntf;
    protected SCBEngine scbEngine;
    protected PojoConsumerMeta consumerMeta;

    public PojoConsumerMetaRefresher(String microserviceName, String schemaId, Class<?> consumerIntf) {
        this.microserviceName = microserviceName;
        this.schemaId = schemaId;
        this.consumerIntf = consumerIntf;
    }

    public PojoConsumerMeta getLatestMeta() {
        this.ensureStatusUp();
        this.ensureMetaAvailable();
        return this.consumerMeta;
    }

    private void ensureStatusUp() {
        if (this.scbEngine == null) {
            if (SCBEngine.getInstance() == null) {
                String message = "The request is rejected. Cannot process the request due to SCBEngine not ready.";
                LOGGER.warn(message);
                throw new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, (Object)new CommonExceptionData(message));
            }
            this.scbEngine = SCBEngine.getInstance();
        }
        this.scbEngine.ensureStatusUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMetaAvailable() {
        if (this.isNeedRefresh()) {
            PojoConsumerMetaRefresher pojoConsumerMetaRefresher = this;
            synchronized (pojoConsumerMetaRefresher) {
                if (this.isNeedRefresh()) {
                    this.consumerMeta = this.refreshMeta();
                }
            }
        }
    }

    private boolean isNeedRefresh() {
        return this.consumerMeta == null || this.consumerMeta.isExpired();
    }

    protected PojoConsumerMeta refreshMeta() {
        MicroserviceReferenceConfig microserviceReferenceConfig = this.scbEngine.createMicroserviceReferenceConfig(this.microserviceName);
        MicroserviceMeta microserviceMeta = microserviceReferenceConfig.getLatestMicroserviceMeta();
        SchemaMeta schemaMeta = this.findSchemaMeta(microserviceMeta);
        if (schemaMeta == null) {
            throw new IllegalStateException(String.format("Schema not exist, microserviceName=%s, schemaId=%s, consumer interface=%s; new producer not running or not deployed.", this.microserviceName, this.schemaId, this.consumerIntf.getName()));
        }
        SwaggerConsumer swaggerConsumer = this.scbEngine.getSwaggerEnvironment().createConsumer(this.consumerIntf, schemaMeta.getSwagger());
        return new PojoConsumerMeta(microserviceReferenceConfig, swaggerConsumer, schemaMeta);
    }

    private SchemaMeta findSchemaMeta(MicroserviceMeta microserviceMeta) {
        if (StringUtils.isNotEmpty((CharSequence)this.schemaId)) {
            return microserviceMeta.findSchemaMeta(this.schemaId);
        }
        SchemaMeta schemaMeta = microserviceMeta.findSchemaMeta(this.consumerIntf);
        if (schemaMeta != null) {
            return schemaMeta;
        }
        return microserviceMeta.findSchemaMeta(this.consumerIntf.getName());
    }
}

