/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Stopwatch;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.FutureUtils;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyDecoder;
import org.apache.rocketmq.remoting.netty.NettyEncoder;
import org.apache.rocketmq.remoting.netty.NettyEvent;
import org.apache.rocketmq.remoting.netty.NettyEventType;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.netty.TlsHelper;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.proxy.SocksProxyConfig;

public class NettyRemotingClient
extends NettyRemotingAbstract
implements RemotingClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final AttributeKey<ChannelWrapper> CHANNEL_WRAPPER_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"channelWrapper");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private static final long MIN_CLOSE_TIMEOUT_MILLIS = 100L;
    protected final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private final Lock lockChannelTables = new ReentrantLock();
    private final Map<String, SocksProxyConfig> proxyMap = new HashMap<String, SocksProxyConfig>();
    private final ConcurrentHashMap<String, Bootstrap> bootstrapMap = new ConcurrentHashMap();
    private final ConcurrentMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap<String, ChannelWrapper>();
    private final HashedWheelTimer timer = new HashedWheelTimer(r -> new Thread(r, "ClientHouseKeepingService"));
    private final AtomicReference<List<String>> namesrvAddrList = new AtomicReference();
    private final ConcurrentMap<String, Boolean> availableNamesrvAddrMap = new ConcurrentHashMap<String, Boolean>();
    private final AtomicReference<String> namesrvAddrChoosed = new AtomicReference();
    private final AtomicInteger namesrvIndex = new AtomicInteger(NettyRemotingClient.initValueIndex());
    private final Lock namesrvChannelLock = new ReentrantLock();
    private final ExecutorService publicExecutor;
    private final ExecutorService scanExecutor;
    private ExecutorService callbackExecutor;
    private final ChannelEventListener channelEventListener;
    private EventExecutorGroup defaultEventExecutorGroup;

    public NettyRemotingClient(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, null);
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener) {
        this(nettyClientConfig, channelEventListener, null, null);
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener, EventLoopGroup eventLoopGroup, EventExecutorGroup eventExecutorGroup) {
        super(nettyClientConfig.getClientOnewaySemaphoreValue(), nettyClientConfig.getClientAsyncSemaphoreValue());
        this.nettyClientConfig = nettyClientConfig;
        this.channelEventListener = channelEventListener;
        this.loadSocksProxyJson();
        int publicThreadNums = nettyClientConfig.getClientCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, (ThreadFactory)new ThreadFactoryImpl("NettyClientPublicExecutor_"));
        this.scanExecutor = ThreadUtils.newThreadPoolExecutor((int)4, (int)10, (long)60L, (TimeUnit)TimeUnit.SECONDS, new ArrayBlockingQueue(32), (ThreadFactory)new ThreadFactoryImpl("NettyClientScan_thread_"));
        this.eventLoopGroupWorker = eventLoopGroup != null ? eventLoopGroup : new NioEventLoopGroup(1, (ThreadFactory)new ThreadFactoryImpl("NettyClientSelector_"));
        this.defaultEventExecutorGroup = eventExecutorGroup;
        if (nettyClientConfig.isUseTLS()) {
            try {
                this.sslContext = TlsHelper.buildSslContext(true);
                LOGGER.info("SSL enabled for client");
            }
            catch (IOException e) {
                LOGGER.error("Failed to create SslContext", (Throwable)e);
            }
            catch (CertificateException e) {
                LOGGER.error("Failed to create SslContext", (Throwable)e);
                throw new RuntimeException("Failed to create SslContext", e);
            }
        }
    }

    private static int initValueIndex() {
        Random r = new Random();
        return r.nextInt(999);
    }

    private void loadSocksProxyJson() {
        Map sockProxyMap = (Map)JSON.parseObject((String)this.nettyClientConfig.getSocksProxyConfig(), (TypeReference)new TypeReference<Map<String, SocksProxyConfig>>(){}, (Feature[])new Feature[0]);
        if (sockProxyMap != null) {
            this.proxyMap.putAll(sockProxyMap);
        }
    }

    @Override
    public void start() {
        if (this.defaultEventExecutorGroup == null) {
            this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), (ThreadFactory)new ThreadFactoryImpl("NettyClientWorkerThread_"));
        }
        Bootstrap handler = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyClientConfig.getConnectTimeoutMillis())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (NettyRemotingClient.this.nettyClientConfig.isUseTLS()) {
                    if (null != NettyRemotingClient.this.sslContext) {
                        pipeline.addFirst(NettyRemotingClient.this.defaultEventExecutorGroup, "sslHandler", (ChannelHandler)NettyRemotingClient.this.sslContext.newHandler(ch.alloc()));
                        LOGGER.info("Prepend SSL handler");
                    } else {
                        LOGGER.warn("Connections are insecure as SslContext is null!");
                    }
                }
                ch.pipeline().addLast(NettyRemotingClient.this.nettyClientConfig.isDisableNettyWorkerGroup() ? null : NettyRemotingClient.this.defaultEventExecutorGroup, new ChannelHandler[]{new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NettyRemotingClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnectManageHandler(), new NettyClientHandler()});
            }
        });
        if (this.nettyClientConfig.getClientSocketSndBufSize() > 0) {
            LOGGER.info("client set SO_SNDBUF to {}", (Object)this.nettyClientConfig.getClientSocketSndBufSize());
            handler.option(ChannelOption.SO_SNDBUF, (Object)this.nettyClientConfig.getClientSocketSndBufSize());
        }
        if (this.nettyClientConfig.getClientSocketRcvBufSize() > 0) {
            LOGGER.info("client set SO_RCVBUF to {}", (Object)this.nettyClientConfig.getClientSocketRcvBufSize());
            handler.option(ChannelOption.SO_RCVBUF, (Object)this.nettyClientConfig.getClientSocketRcvBufSize());
        }
        if (this.nettyClientConfig.getWriteBufferLowWaterMark() > 0 && this.nettyClientConfig.getWriteBufferHighWaterMark() > 0) {
            LOGGER.info("client set netty WRITE_BUFFER_WATER_MARK to {},{}", (Object)this.nettyClientConfig.getWriteBufferLowWaterMark(), (Object)this.nettyClientConfig.getWriteBufferHighWaterMark());
            handler.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyClientConfig.getWriteBufferLowWaterMark(), this.nettyClientConfig.getWriteBufferHighWaterMark()));
        }
        if (this.nettyClientConfig.isClientPooledByteBufAllocatorEnable()) {
            handler.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        }
        this.nettyEventExecutor.start();
        TimerTask timerTaskScanResponseTable = new TimerTask(){

            public void run(Timeout timeout) {
                try {
                    NettyRemotingClient.this.scanResponseTable();
                }
                catch (Throwable e) {
                    LOGGER.error("scanResponseTable exception", e);
                }
                finally {
                    NettyRemotingClient.this.timer.newTimeout((TimerTask)this, 1000L, TimeUnit.MILLISECONDS);
                }
            }
        };
        this.timer.newTimeout(timerTaskScanResponseTable, 3000L, TimeUnit.MILLISECONDS);
        if (this.nettyClientConfig.isScanAvailableNameSrv()) {
            final int connectTimeoutMillis = this.nettyClientConfig.getConnectTimeoutMillis();
            TimerTask timerTaskScanAvailableNameSrv = new TimerTask(){

                public void run(Timeout timeout) {
                    try {
                        NettyRemotingClient.this.scanAvailableNameSrv();
                    }
                    catch (Exception e) {
                        LOGGER.error("scanAvailableNameSrv exception", (Throwable)e);
                    }
                    finally {
                        NettyRemotingClient.this.timer.newTimeout((TimerTask)this, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
                    }
                }
            };
            this.timer.newTimeout(timerTaskScanAvailableNameSrv, 0L, TimeUnit.MILLISECONDS);
        }
    }

    private Map.Entry<String, SocksProxyConfig> getProxy(String addr) {
        if (StringUtils.isBlank((CharSequence)addr) || !addr.contains(":")) {
            return null;
        }
        String[] hostAndPort = this.getHostAndPort(addr);
        for (Map.Entry<String, SocksProxyConfig> entry : this.proxyMap.entrySet()) {
            String cidr = entry.getKey();
            if (!"0.0.0.0/0".equals(cidr) && !RemotingHelper.ipInCIDR(hostAndPort[0], cidr)) continue;
            return entry;
        }
        return null;
    }

    protected ChannelFuture doConnect(String addr) {
        String[] hostAndPort = this.getHostAndPort(addr);
        String host = hostAndPort[0];
        int port = Integer.parseInt(hostAndPort[1]);
        return this.fetchBootstrap(addr).connect(host, port);
    }

    private Bootstrap fetchBootstrap(String addr) {
        Bootstrap old;
        Map.Entry<String, SocksProxyConfig> proxyEntry = this.getProxy(addr);
        if (proxyEntry == null) {
            return this.bootstrap;
        }
        String cidr = proxyEntry.getKey();
        SocksProxyConfig socksProxyConfig = proxyEntry.getValue();
        LOGGER.info("Netty fetch bootstrap, addr: {}, cidr: {}, proxy: {}", new Object[]{addr, cidr, socksProxyConfig != null ? socksProxyConfig.getAddr() : ""});
        Bootstrap bootstrapWithProxy = this.bootstrapMap.get(cidr);
        if (bootstrapWithProxy == null && (old = this.bootstrapMap.putIfAbsent(cidr, bootstrapWithProxy = this.createBootstrap(socksProxyConfig))) != null) {
            bootstrapWithProxy = old;
        }
        return bootstrapWithProxy;
    }

    private Bootstrap createBootstrap(final SocksProxyConfig proxy) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyClientConfig.getConnectTimeoutMillis())).option(ChannelOption.SO_SNDBUF, (Object)this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, (Object)this.nettyClientConfig.getClientSocketRcvBufSize())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                if (NettyRemotingClient.this.nettyClientConfig.isUseTLS()) {
                    if (null != NettyRemotingClient.this.sslContext) {
                        pipeline.addFirst(NettyRemotingClient.this.defaultEventExecutorGroup, "sslHandler", (ChannelHandler)NettyRemotingClient.this.sslContext.newHandler(ch.alloc()));
                        LOGGER.info("Prepend SSL handler");
                    } else {
                        LOGGER.warn("Connections are insecure as SslContext is null!");
                    }
                }
                if (proxy != null) {
                    String[] hostAndPort = NettyRemotingClient.this.getHostAndPort(proxy.getAddr());
                    pipeline.addFirst(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])), proxy.getUsername(), proxy.getPassword())});
                }
                pipeline.addLast(NettyRemotingClient.this.nettyClientConfig.isDisableNettyWorkerGroup() ? null : NettyRemotingClient.this.defaultEventExecutorGroup, new ChannelHandler[]{new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NettyRemotingClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnectManageHandler(), new NettyClientHandler()});
            }
        });
        if (proxy != null) {
            bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        }
        return bootstrap;
    }

    protected String[] getHostAndPort(String address) {
        String[] stringArray;
        int split = address.lastIndexOf(":");
        if (split < 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = address;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = address.substring(0, split);
            stringArray = stringArray3;
            stringArray3[1] = address.substring(split + 1);
        }
        return stringArray;
    }

    @Override
    public void shutdown() {
        try {
            this.timer.stop();
            for (Map.Entry channel : this.channelTables.entrySet()) {
                ((ChannelWrapper)channel.getValue()).close();
            }
            this.channelTables.clear();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.nettyEventExecutor != null) {
                this.nettyEventExecutor.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            LOGGER.error("NettyRemotingClient shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                LOGGER.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
        if (this.scanExecutor != null) {
            try {
                this.scanExecutor.shutdown();
            }
            catch (Exception e) {
                LOGGER.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(String addr, Channel channel) {
        block14: {
            if (null == channel) {
                return;
            }
            String addrRemote = null == addr ? RemotingHelper.parseChannelRemoteAddr(channel) : addr;
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = (ChannelWrapper)this.channelTables.get(addrRemote);
                        LOGGER.info("closeChannel: begin close the channel[addr={}, id={}] Found: {}", new Object[]{addrRemote, channel.id(), prevCW != null});
                        if (null == prevCW) {
                            LOGGER.info("closeChannel: the channel[addr={}, id={}] has been removed from the channel table before", (Object)addrRemote, (Object)channel.id());
                            removeItemFromTable = false;
                        } else if (prevCW.isWrapperOf(channel)) {
                            LOGGER.info("closeChannel: the channel[addr={}, id={}] has been closed before, and has been created again, nothing to do.", (Object)addrRemote, (Object)channel.id());
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            ChannelWrapper channelWrapper = RemotingHelper.getAttributeValue(CHANNEL_WRAPPER_ATTRIBUTE_KEY, channel);
                            if (channelWrapper != null && channelWrapper.tryClose(channel)) {
                                this.channelTables.remove(addrRemote);
                            }
                            LOGGER.info("closeChannel: the channel[addr={}, id={}] was removed from channel table", (Object)addrRemote, (Object)channel.id());
                        }
                        RemotingHelper.closeChannel(channel);
                        break block14;
                    }
                    catch (Exception e) {
                        LOGGER.error("closeChannel: close the channel exception", (Throwable)e);
                        break block14;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                LOGGER.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel channel) {
        block13: {
            if (null == channel) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = null;
                        String addrRemote = null;
                        for (Map.Entry entry : this.channelTables.entrySet()) {
                            String key = (String)entry.getKey();
                            ChannelWrapper prev = (ChannelWrapper)entry.getValue();
                            if (!prev.isWrapperOf(channel)) continue;
                            prevCW = prev;
                            addrRemote = key;
                            break;
                        }
                        if (null == prevCW) {
                            LOGGER.info("eventCloseChannel: the channel[addr={}, id={}] has been removed from the channel table before", (Object)RemotingHelper.parseChannelRemoteAddr(channel), (Object)channel.id());
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            ChannelWrapper channelWrapper = RemotingHelper.getAttributeValue(CHANNEL_WRAPPER_ATTRIBUTE_KEY, channel);
                            if (channelWrapper != null && channelWrapper.tryClose(channel)) {
                                this.channelTables.remove(addrRemote);
                            }
                            LOGGER.info("closeChannel: the channel[addr={}, id={}] was removed from channel table", addrRemote, (Object)channel.id());
                            RemotingHelper.closeChannel(channel);
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        LOGGER.error("closeChannel: close the channel[id={}] exception", (Object)channel.id(), (Object)e);
                        break block13;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                LOGGER.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    @Override
    public void updateNameServerAddressList(List<String> addrs) {
        List<String> old = this.namesrvAddrList.get();
        boolean update = false;
        if (!addrs.isEmpty()) {
            if (null == old) {
                update = true;
            } else if (addrs.size() != old.size()) {
                update = true;
            } else {
                for (String addr : addrs) {
                    if (old.contains(addr)) continue;
                    update = true;
                    break;
                }
            }
            if (update) {
                Collections.shuffle(addrs);
                LOGGER.info("name server address updated. NEW : {} , OLD: {}", addrs, old);
                this.namesrvAddrList.set(addrs);
                String chosenNameServerAddr = this.namesrvAddrChoosed.get();
                if (chosenNameServerAddr != null && !addrs.contains(chosenNameServerAddr)) {
                    this.namesrvAddrChoosed.compareAndSet(chosenNameServerAddr, null);
                    for (String addr : this.channelTables.keySet()) {
                        ChannelWrapper channelWrapper;
                        if (!addr.contains(chosenNameServerAddr) || (channelWrapper = (ChannelWrapper)this.channelTables.get(addr)) == null) continue;
                        channelWrapper.close();
                    }
                }
            }
        }
    }

    @Override
    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        long beginStartTime = System.currentTimeMillis();
        Channel channel = this.getAndCreateChannel(addr);
        String channelRemoteAddr = RemotingHelper.parseChannelRemoteAddr(channel);
        if (channel != null && channel.isActive()) {
            long left = timeoutMillis;
            try {
                long costTime = System.currentTimeMillis() - beginStartTime;
                if ((left -= costTime) <= 0L) {
                    throw new RemotingTimeoutException("invokeSync call the addr[" + channelRemoteAddr + "] timeout");
                }
                RemotingCommand response = this.invokeSyncImpl(channel, request, left);
                this.updateChannelLastResponseTime(addr);
                return response;
            }
            catch (RemotingSendRequestException e) {
                LOGGER.warn("invokeSync: send request exception, so close the channel[addr={}, id={}]", (Object)channelRemoteAddr, (Object)channel.id());
                this.closeChannel(addr, channel);
                throw e;
            }
            catch (RemotingTimeoutException e) {
                boolean shouldClose;
                boolean bl = shouldClose = left > 100L || left > timeoutMillis / 4L;
                if (this.nettyClientConfig.isClientCloseSocketIfTimeout() && shouldClose) {
                    this.closeChannel(addr, channel);
                    LOGGER.warn("invokeSync: close socket because of timeout, {}ms, channel[addr={}, id={}]", new Object[]{timeoutMillis, channelRemoteAddr, channel.id()});
                }
                LOGGER.warn("invokeSync: wait response timeout exception, the channel[addr={}, id={}]", (Object)channelRemoteAddr, (Object)channel.id());
                throw e;
            }
        }
        this.closeChannel(addr, channel);
        throw new RemotingConnectException(channelRemoteAddr);
    }

    @Override
    public void closeChannels(List<String> addrList) {
        for (String addr : addrList) {
            ChannelWrapper cw = (ChannelWrapper)this.channelTables.get(addr);
            if (cw == null) continue;
            this.closeChannel(addr, cw.getChannel());
        }
        this.interruptPullRequests(new HashSet<String>(addrList));
    }

    private void interruptPullRequests(Set<String> brokerAddrSet) {
        for (ResponseFuture responseFuture : this.responseTable.values()) {
            String remoteAddr;
            RemotingCommand cmd = responseFuture.getRequestCommand();
            if (cmd == null || !brokerAddrSet.contains(remoteAddr = RemotingHelper.parseChannelRemoteAddr(responseFuture.getChannel())) || cmd.getCode() != 11 && cmd.getCode() != 361) continue;
            LOGGER.info("interrupt {}", (Object)cmd);
            responseFuture.interrupt();
        }
    }

    private void updateChannelLastResponseTime(String addr) {
        String address = addr;
        if (address == null) {
            address = this.namesrvAddrChoosed.get();
        }
        if (address == null) {
            LOGGER.warn("[updateChannelLastResponseTime] could not find address!!");
            return;
        }
        ChannelWrapper channelWrapper = (ChannelWrapper)this.channelTables.get(address);
        if (channelWrapper != null && channelWrapper.isOK()) {
            channelWrapper.updateLastResponseTime();
        }
    }

    private ChannelFuture getAndCreateChannelAsync(String addr) throws InterruptedException {
        if (null == addr) {
            return this.getAndCreateNameserverChannelAsync();
        }
        ChannelWrapper cw = (ChannelWrapper)this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannelFuture();
        }
        return this.createChannelAsync(addr);
    }

    private Channel getAndCreateChannel(String addr) throws InterruptedException {
        ChannelFuture channelFuture = this.getAndCreateChannelAsync(addr);
        if (channelFuture == null) {
            return null;
        }
        return channelFuture.awaitUninterruptibly().channel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChannelFuture getAndCreateNameserverChannelAsync() throws InterruptedException {
        ChannelWrapper cw;
        String addr = this.namesrvAddrChoosed.get();
        if (addr != null && (cw = (ChannelWrapper)this.channelTables.get(addr)) != null && cw.isOK()) {
            return cw.getChannelFuture();
        }
        List<String> addrList = this.namesrvAddrList.get();
        if (this.namesrvChannelLock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                ChannelWrapper cw2;
                addr = this.namesrvAddrChoosed.get();
                if (addr != null && (cw2 = (ChannelWrapper)this.channelTables.get(addr)) != null && cw2.isOK()) {
                    ChannelFuture channelFuture = cw2.getChannelFuture();
                    return channelFuture;
                }
                if (addrList == null || addrList.isEmpty()) return null;
                int index = this.namesrvIndex.incrementAndGet();
                index = Math.abs(index);
                String newAddr = addrList.get(index %= addrList.size());
                this.namesrvAddrChoosed.set(newAddr);
                LOGGER.info("new name server is chosen. OLD: {} , NEW: {}. namesrvIndex = {}", new Object[]{addr, newAddr, this.namesrvIndex});
                ChannelFuture channelFuture = this.createChannelAsync(newAddr);
                return channelFuture;
            }
            catch (Exception e) {
                LOGGER.error("getAndCreateNameserverChannel: create name server channel exception", (Throwable)e);
                return null;
            }
            finally {
                this.namesrvChannelLock.unlock();
            }
        } else {
            LOGGER.warn("getAndCreateNameserverChannel: try to lock name server, but timeout, {}ms", (Object)3000L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture createChannelAsync(String addr) throws InterruptedException {
        ChannelWrapper cw = (ChannelWrapper)this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannelFuture();
        }
        if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                cw = (ChannelWrapper)this.channelTables.get(addr);
                if (cw != null) {
                    if (cw.isOK() || !cw.getChannelFuture().isDone()) {
                        ChannelFuture channelFuture = cw.getChannelFuture();
                        return channelFuture;
                    }
                    this.channelTables.remove(addr);
                }
                ChannelFuture channelFuture = this.createChannel(addr).getChannelFuture();
                return channelFuture;
            }
            catch (Exception e) {
                LOGGER.error("createChannel: create channel exception", (Throwable)e);
            }
            finally {
                this.lockChannelTables.unlock();
            }
        } else {
            LOGGER.warn("createChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
        }
        return null;
    }

    private ChannelWrapper createChannel(String addr) {
        ChannelFuture channelFuture = this.doConnect(addr);
        LOGGER.info("createChannel: begin to connect remote host[{}] asynchronously", (Object)addr);
        ChannelWrapper cw = new ChannelWrapper(addr, channelFuture);
        this.channelTables.put(addr, cw);
        return cw;
    }

    @Override
    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        long beginStartTime = System.currentTimeMillis();
        ChannelFuture channelFuture = this.getAndCreateChannelAsync(addr);
        if (channelFuture == null) {
            invokeCallback.operationFail(new RemotingConnectException(addr));
            return;
        }
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = channelFuture.channel();
                String channelRemoteAddr = RemotingHelper.parseChannelRemoteAddr(channel);
                if (channel != null && channel.isActive()) {
                    long costTime = System.currentTimeMillis() - beginStartTime;
                    if (timeoutMillis < costTime) {
                        invokeCallback.operationFail(new RemotingTooMuchRequestException("invokeAsync call the addr[" + channelRemoteAddr + "] timeout"));
                        return;
                    }
                    this.invokeAsyncImpl(channel, request, timeoutMillis - costTime, new InvokeCallbackWrapper(invokeCallback, addr));
                } else {
                    this.closeChannel(addr, channel);
                    invokeCallback.operationFail(new RemotingConnectException(addr));
                }
            } else {
                invokeCallback.operationFail(new RemotingConnectException(addr));
            }
        });
    }

    @Override
    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        ChannelFuture channelFuture = this.getAndCreateChannelAsync(addr);
        if (channelFuture == null) {
            throw new RemotingConnectException(addr);
        }
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = channelFuture.channel();
                String channelRemoteAddr = RemotingHelper.parseChannelRemoteAddr(channel);
                if (channel != null && channel.isActive()) {
                    this.doBeforeRpcHooks(channelRemoteAddr, request);
                    this.invokeOnewayImpl(channel, request, timeoutMillis);
                } else {
                    this.closeChannel(addr, channel);
                }
            }
        });
    }

    @Override
    public CompletableFuture<RemotingCommand> invoke(String addr, RemotingCommand request, long timeoutMillis) {
        CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
        try {
            ChannelFuture channelFuture = this.getAndCreateChannelAsync(addr);
            if (channelFuture == null) {
                future.completeExceptionally(new RemotingConnectException(addr));
                return future;
            }
            channelFuture.addListener(f -> {
                if (f.isSuccess()) {
                    Channel channel = channelFuture.channel();
                    if (channel != null && channel.isActive()) {
                        ((CompletableFuture)((CompletableFuture)this.invokeImpl(channel, request, timeoutMillis).whenComplete((v, t) -> {
                            if (t == null) {
                                this.updateChannelLastResponseTime(addr);
                            }
                        })).thenApply(ResponseFuture::getResponseCommand)).whenComplete((v, t) -> {
                            if (t != null) {
                                future.completeExceptionally((Throwable)t);
                            } else {
                                future.complete((RemotingCommand)v);
                            }
                        });
                    } else {
                        this.closeChannel(addr, channel);
                        future.completeExceptionally(new RemotingConnectException(addr));
                    }
                } else {
                    future.completeExceptionally(new RemotingConnectException(addr));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    @Override
    public CompletableFuture<ResponseFuture> invokeImpl(Channel channel, RemotingCommand request, long timeoutMillis) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String channelRemoteAddr = RemotingHelper.parseChannelRemoteAddr(channel);
        this.doBeforeRpcHooks(channelRemoteAddr, request);
        return ((CompletableFuture)super.invokeImpl(channel, request, timeoutMillis).thenCompose(responseFuture -> {
            RemotingCommand response = responseFuture.getResponseCommand();
            if (response.getCode() == 1500) {
                if (this.nettyClientConfig.isEnableReconnectForGoAway()) {
                    LOGGER.info("Receive go away from channelId={}, channel={}", (Object)channel.id(), (Object)channel);
                    ChannelWrapper channelWrapper = RemotingHelper.getAttributeValue(CHANNEL_WRAPPER_ATTRIBUTE_KEY, channel);
                    if (channelWrapper != null && channelWrapper.reconnect(channel)) {
                        LOGGER.info("Receive go away from channelId={}, channel={}, recreate the channelId={}", new Object[]{channel.id(), channel, channelWrapper.getChannel().id()});
                    }
                    if (channelWrapper != null && !channelWrapper.isWrapperOf(channel)) {
                        RemotingCommand retryRequest = RemotingCommand.createRequestCommand(request.getCode(), request.readCustomHeader());
                        retryRequest.setBody(request.getBody());
                        retryRequest.setExtFields(request.getExtFields());
                        CompletableFuture<Void> future = RemotingHelper.convertChannelFutureToCompletableFuture(channelWrapper.getChannelFuture());
                        return future.thenCompose(v -> {
                            long duration = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                            stopwatch.stop();
                            return super.invokeImpl(channelWrapper.getChannel(), retryRequest, timeoutMillis - duration).thenCompose(r -> {
                                if (r.getResponseCommand().getCode() == 1500) {
                                    return FutureUtils.completeExceptionally((Throwable)new RemotingSendRequestException(channelRemoteAddr, new Throwable("Receive GO_AWAY twice in request from channelId=" + channel.id())));
                                }
                                return CompletableFuture.completedFuture(r);
                            });
                        });
                    }
                    LOGGER.warn("invokeImpl receive GO_AWAY, channelWrapper is null or channel is the same in wrapper, channelId={}", (Object)channel.id());
                }
                return FutureUtils.completeExceptionally((Throwable)new RemotingSendRequestException(channelRemoteAddr, new Throwable("Receive GO_AWAY from channelId=" + channel.id())));
            }
            return CompletableFuture.completedFuture(responseFuture);
        })).whenComplete((v, t) -> {
            if (t == null) {
                this.doAfterRpcHooks(channelRemoteAddr, request, v.getResponseCommand());
            }
        });
    }

    @Override
    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair pair = new Pair((Object)processor, (Object)executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public boolean isChannelWritable(String addr) {
        ChannelWrapper cw = (ChannelWrapper)this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.isWritable();
        }
        return true;
    }

    @Override
    public boolean isAddressReachable(String addr) {
        if (addr == null || addr.isEmpty()) {
            return false;
        }
        try {
            Channel channel = this.getAndCreateChannel(addr);
            return channel != null && channel.isActive();
        }
        catch (Exception e) {
            LOGGER.warn("Get and create channel of {} failed", (Object)addr, (Object)e);
            return false;
        }
    }

    @Override
    public List<String> getNameServerAddressList() {
        return this.namesrvAddrList.get();
    }

    @Override
    public List<String> getAvailableNameSrvList() {
        return new ArrayList<String>(this.availableNamesrvAddrMap.keySet());
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        if (this.nettyClientConfig.isDisableCallbackExecutor()) {
            return null;
        }
        return this.callbackExecutor != null ? this.callbackExecutor : this.publicExecutor;
    }

    @Override
    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
    }

    protected void scanChannelTablesOfNameServer() {
        List<String> nameServerList = this.namesrvAddrList.get();
        if (nameServerList == null) {
            LOGGER.warn("[SCAN] Addresses of name server is empty!");
            return;
        }
        for (Map.Entry entry : this.channelTables.entrySet()) {
            String addr = (String)entry.getKey();
            ChannelWrapper channelWrapper = (ChannelWrapper)entry.getValue();
            if (channelWrapper == null || System.currentTimeMillis() - channelWrapper.getLastResponseTime() <= this.nettyClientConfig.getChannelNotActiveInterval()) continue;
            LOGGER.warn("[SCAN] No response after {} from name server {}, so close it!", (Object)channelWrapper.getLastResponseTime(), (Object)addr);
            this.closeChannel(addr, channelWrapper.getChannel());
        }
    }

    private void scanAvailableNameSrv() {
        List<String> nameServerList = this.namesrvAddrList.get();
        if (nameServerList == null) {
            LOGGER.debug("scanAvailableNameSrv addresses of name server is null!");
            return;
        }
        for (String address : this.availableNamesrvAddrMap.keySet()) {
            if (nameServerList.contains(address)) continue;
            LOGGER.warn("scanAvailableNameSrv remove invalid address {}", (Object)address);
            this.availableNamesrvAddrMap.remove(address);
        }
        for (final String namesrvAddr : nameServerList) {
            this.scanExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Channel channel = NettyRemotingClient.this.getAndCreateChannel(namesrvAddr);
                        if (channel != null) {
                            NettyRemotingClient.this.availableNamesrvAddrMap.putIfAbsent(namesrvAddr, true);
                        } else {
                            Boolean value = (Boolean)NettyRemotingClient.this.availableNamesrvAddrMap.remove(namesrvAddr);
                            if (value != null) {
                                LOGGER.warn("scanAvailableNameSrv remove unconnected address {}", (Object)namesrvAddr);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("scanAvailableNameSrv get channel of {} failed, ", (Object)namesrvAddr, (Object)e);
                    }
                }
            });
        }
    }

    public class NettyConnectManageHandler
    extends ChannelDuplexHandler {
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            String local = localAddress == null ? NetworkUtil.getLocalAddress() : RemotingHelper.parseSocketAddressAddr(localAddress);
            String remote = remoteAddress == null ? "UNKNOWN" : RemotingHelper.parseSocketAddressAddr(remoteAddress);
            LOGGER.info("NETTY CLIENT PIPELINE: CONNECT  {} => {}", (Object)local, (Object)remote);
            super.connect(ctx, remoteAddress, localAddress, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remote, ctx.channel()));
            }
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            LOGGER.info("NETTY CLIENT PIPELINE: ACTIVE, {}, channelId={}", (Object)remoteAddress, (Object)ctx.channel().id());
            super.channelActive(ctx);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.ACTIVE, remoteAddress, ctx.channel()));
            }
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            LOGGER.info("NETTY CLIENT PIPELINE: DISCONNECT {}", (Object)remoteAddress);
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.disconnect(ctx, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress, ctx.channel()));
            }
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            LOGGER.info("NETTY CLIENT PIPELINE: CLOSE channel[addr={}, id={}]", (Object)remoteAddress, (Object)ctx.channel().id());
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.close(ctx, promise);
            NettyRemotingClient.this.failFast(ctx.channel());
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress, ctx.channel()));
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            LOGGER.info("NETTY CLIENT PIPELINE: channelInactive, the channel[addr={}, id={}]", (Object)remoteAddress, (Object)ctx.channel().id());
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.channelInactive(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                LOGGER.warn("NETTY CLIENT PIPELINE: IDLE exception channel[addr={}, id={}]", (Object)remoteAddress, (Object)ctx.channel().id());
                NettyRemotingClient.this.closeChannel(ctx.channel());
                if (NettyRemotingClient.this.channelEventListener != null) {
                    NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress, ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            LOGGER.warn("NETTY CLIENT PIPELINE: exceptionCaught channel[addr={}, id={}]", new Object[]{remoteAddress, ctx.channel().id(), cause});
            NettyRemotingClient.this.closeChannel(ctx.channel());
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress, ctx.channel()));
            }
        }
    }

    public class NettyClientHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettyRemotingClient.this.processMessageReceived(ctx, msg);
        }
    }

    class InvokeCallbackWrapper
    implements InvokeCallback {
        private final InvokeCallback invokeCallback;
        private final String addr;

        public InvokeCallbackWrapper(InvokeCallback invokeCallback, String addr) {
            this.invokeCallback = invokeCallback;
            this.addr = addr;
        }

        @Override
        public void operationComplete(ResponseFuture responseFuture) {
            this.invokeCallback.operationComplete(responseFuture);
        }

        @Override
        public void operationSucceed(RemotingCommand response) {
            NettyRemotingClient.this.updateChannelLastResponseTime(this.addr);
            this.invokeCallback.operationSucceed(response);
        }

        @Override
        public void operationFail(Throwable throwable) {
            this.invokeCallback.operationFail(throwable);
        }
    }

    class ChannelWrapper {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private ChannelFuture channelFuture;
        private ChannelFuture channelToClose;
        private long lastResponseTime;
        private final String channelAddress;

        public ChannelWrapper(String address, ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
            this.lastResponseTime = System.currentTimeMillis();
            this.channelAddress = address;
            RemotingHelper.setPropertyToAttr(channelFuture.channel(), CHANNEL_WRAPPER_ATTRIBUTE_KEY, this);
        }

        public boolean isOK() {
            return this.getChannel() != null && this.getChannel().isActive();
        }

        public boolean isWritable() {
            return this.getChannel().isWritable();
        }

        public boolean isWrapperOf(Channel channel) {
            return this.channelFuture.channel() != null && this.channelFuture.channel() == channel;
        }

        private Channel getChannel() {
            return this.getChannelFuture().channel();
        }

        public ChannelFuture getChannelFuture() {
            this.lock.readLock().lock();
            try {
                ChannelFuture channelFuture = this.channelFuture;
                return channelFuture;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public long getLastResponseTime() {
            return this.lastResponseTime;
        }

        public void updateLastResponseTime() {
            this.lastResponseTime = System.currentTimeMillis();
        }

        public String getChannelAddress() {
            return this.channelAddress;
        }

        public boolean reconnect(Channel channel) {
            if (!this.isWrapperOf(channel)) {
                LOGGER.warn("channelWrapper has reconnect, so do nothing, now channelId={}, input channelId={}", (Object)this.getChannel().id(), (Object)channel.id());
                return false;
            }
            if (this.lock.writeLock().tryLock()) {
                try {
                    if (this.isWrapperOf(channel)) {
                        this.channelToClose = this.channelFuture;
                        this.channelFuture = NettyRemotingClient.this.doConnect(this.channelAddress);
                        RemotingHelper.setPropertyToAttr(this.channelFuture.channel(), CHANNEL_WRAPPER_ATTRIBUTE_KEY, this);
                        boolean bl = true;
                        return bl;
                    }
                    LOGGER.warn("channelWrapper has reconnect, so do nothing, now channelId={}, input channelId={}", (Object)this.getChannel().id(), (Object)channel.id());
                }
                catch (Throwable t) {
                    LOGGER.error("ChannelWrapper {} reconnect error", (Object)this, (Object)t);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            } else {
                LOGGER.warn("channelWrapper reconnect try lock fail, now channelId={}", (Object)this.getChannel().id());
            }
            return false;
        }

        public boolean tryClose(Channel channel) {
            try {
                this.lock.readLock().lock();
                if (this.channelFuture != null && this.channelFuture.channel().equals(channel)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            return false;
        }

        public void close() {
            try {
                this.lock.writeLock().lock();
                if (this.channelFuture != null) {
                    NettyRemotingClient.this.closeChannel(this.channelFuture.channel());
                }
                if (this.channelToClose != null) {
                    NettyRemotingClient.this.closeChannel(this.channelToClose.channel());
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

