/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetUnconfirmedServiceRequestWriteGroup extends BACnetUnconfirmedServiceRequest
    implements Message {

  // Accessors for discriminator values.
  public BACnetUnconfirmedServiceChoice getServiceChoice() {
    return BACnetUnconfirmedServiceChoice.WRITE_GROUP;
  }

  // Properties.
  protected final BACnetContextTagUnsignedInteger groupNumber;
  protected final BACnetContextTagUnsignedInteger writePriority;
  protected final BACnetGroupChannelValueList changeList;
  protected final BACnetContextTagUnsignedInteger inhibitDelay;

  // Arguments.
  protected final Integer serviceRequestLength;

  public BACnetUnconfirmedServiceRequestWriteGroup(
      BACnetContextTagUnsignedInteger groupNumber,
      BACnetContextTagUnsignedInteger writePriority,
      BACnetGroupChannelValueList changeList,
      BACnetContextTagUnsignedInteger inhibitDelay,
      Integer serviceRequestLength) {
    super(serviceRequestLength);
    this.groupNumber = groupNumber;
    this.writePriority = writePriority;
    this.changeList = changeList;
    this.inhibitDelay = inhibitDelay;
    this.serviceRequestLength = serviceRequestLength;
  }

  public BACnetContextTagUnsignedInteger getGroupNumber() {
    return groupNumber;
  }

  public BACnetContextTagUnsignedInteger getWritePriority() {
    return writePriority;
  }

  public BACnetGroupChannelValueList getChangeList() {
    return changeList;
  }

  public BACnetContextTagUnsignedInteger getInhibitDelay() {
    return inhibitDelay;
  }

  @Override
  protected void serializeBACnetUnconfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetUnconfirmedServiceRequestWriteGroup");

    // Simple Field (groupNumber)
    writeSimpleField("groupNumber", groupNumber, writeComplex(writeBuffer));

    // Simple Field (writePriority)
    writeSimpleField("writePriority", writePriority, writeComplex(writeBuffer));

    // Simple Field (changeList)
    writeSimpleField("changeList", changeList, writeComplex(writeBuffer));

    // Optional Field (inhibitDelay) (Can be skipped, if the value is null)
    writeOptionalField("inhibitDelay", inhibitDelay, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetUnconfirmedServiceRequestWriteGroup");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetUnconfirmedServiceRequestWriteGroup _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (groupNumber)
    lengthInBits += groupNumber.getLengthInBits();

    // Simple field (writePriority)
    lengthInBits += writePriority.getLengthInBits();

    // Simple field (changeList)
    lengthInBits += changeList.getLengthInBits();

    // Optional Field (inhibitDelay)
    if (inhibitDelay != null) {
      lengthInBits += inhibitDelay.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetUnconfirmedServiceRequestBuilder
      staticParseBACnetUnconfirmedServiceRequestBuilder(
          ReadBuffer readBuffer, Integer serviceRequestLength) throws ParseException {
    readBuffer.pullContext("BACnetUnconfirmedServiceRequestWriteGroup");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagUnsignedInteger groupNumber =
        readSimpleField(
            "groupNumber",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagUnsignedInteger writePriority =
        readSimpleField(
            "writePriority",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (1),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetGroupChannelValueList changeList =
        readSimpleField(
            "changeList",
            readComplex(
                () -> BACnetGroupChannelValueList.staticParse(readBuffer, (short) (2)),
                readBuffer));

    BACnetContextTagUnsignedInteger inhibitDelay =
        readOptionalField(
            "inhibitDelay",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (3),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    readBuffer.closeContext("BACnetUnconfirmedServiceRequestWriteGroup");
    // Create the instance
    return new BACnetUnconfirmedServiceRequestWriteGroupBuilderImpl(
        groupNumber, writePriority, changeList, inhibitDelay, serviceRequestLength);
  }

  public static class BACnetUnconfirmedServiceRequestWriteGroupBuilderImpl
      implements BACnetUnconfirmedServiceRequest.BACnetUnconfirmedServiceRequestBuilder {
    private final BACnetContextTagUnsignedInteger groupNumber;
    private final BACnetContextTagUnsignedInteger writePriority;
    private final BACnetGroupChannelValueList changeList;
    private final BACnetContextTagUnsignedInteger inhibitDelay;
    private final Integer serviceRequestLength;

    public BACnetUnconfirmedServiceRequestWriteGroupBuilderImpl(
        BACnetContextTagUnsignedInteger groupNumber,
        BACnetContextTagUnsignedInteger writePriority,
        BACnetGroupChannelValueList changeList,
        BACnetContextTagUnsignedInteger inhibitDelay,
        Integer serviceRequestLength) {
      this.groupNumber = groupNumber;
      this.writePriority = writePriority;
      this.changeList = changeList;
      this.inhibitDelay = inhibitDelay;
      this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetUnconfirmedServiceRequestWriteGroup build(Integer serviceRequestLength) {

      BACnetUnconfirmedServiceRequestWriteGroup bACnetUnconfirmedServiceRequestWriteGroup =
          new BACnetUnconfirmedServiceRequestWriteGroup(
              groupNumber, writePriority, changeList, inhibitDelay, serviceRequestLength);
      return bACnetUnconfirmedServiceRequestWriteGroup;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetUnconfirmedServiceRequestWriteGroup)) {
      return false;
    }
    BACnetUnconfirmedServiceRequestWriteGroup that = (BACnetUnconfirmedServiceRequestWriteGroup) o;
    return (getGroupNumber() == that.getGroupNumber())
        && (getWritePriority() == that.getWritePriority())
        && (getChangeList() == that.getChangeList())
        && (getInhibitDelay() == that.getInhibitDelay())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getGroupNumber(), getWritePriority(), getChangeList(), getInhibitDelay());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
