/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7PayloadUserDataItemCpuFunctionAlarmQueryResponse is the corresponding interface of S7PayloadUserDataItemCpuFunctionAlarmQueryResponse
type S7PayloadUserDataItemCpuFunctionAlarmQueryResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	S7PayloadUserDataItem
	// GetItems returns Items (property field)
	GetItems() []byte
	// IsS7PayloadUserDataItemCpuFunctionAlarmQueryResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7PayloadUserDataItemCpuFunctionAlarmQueryResponse()
	// CreateBuilder creates a S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder
	CreateS7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder() S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder
}

// _S7PayloadUserDataItemCpuFunctionAlarmQueryResponse is the data-structure of this message
type _S7PayloadUserDataItemCpuFunctionAlarmQueryResponse struct {
	S7PayloadUserDataItemContract
	Items []byte
}

var _ S7PayloadUserDataItemCpuFunctionAlarmQueryResponse = (*_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)(nil)
var _ S7PayloadUserDataItemRequirements = (*_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)(nil)

// NewS7PayloadUserDataItemCpuFunctionAlarmQueryResponse factory function for _S7PayloadUserDataItemCpuFunctionAlarmQueryResponse
func NewS7PayloadUserDataItemCpuFunctionAlarmQueryResponse(returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16, items []byte) *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse {
	_result := &_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse{
		S7PayloadUserDataItemContract: NewS7PayloadUserDataItem(returnCode, transportSize, dataLength),
		Items:                         items,
	}
	_result.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder is a builder for S7PayloadUserDataItemCpuFunctionAlarmQueryResponse
type S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(items []byte) S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder
	// WithItems adds Items (property field)
	WithItems(...byte) S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() S7PayloadUserDataItemBuilder
	// Build builds the S7PayloadUserDataItemCpuFunctionAlarmQueryResponse or returns an error if something is wrong
	Build() (S7PayloadUserDataItemCpuFunctionAlarmQueryResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7PayloadUserDataItemCpuFunctionAlarmQueryResponse
}

// NewS7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder() creates a S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder
func NewS7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder() S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder {
	return &_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder{_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse: new(_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)}
}

type _S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder struct {
	*_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse

	parentBuilder *_S7PayloadUserDataItemBuilder

	collectedErr []error
}

var _ (S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder) = (*_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder)(nil)

func (b *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder) setParent(contract S7PayloadUserDataItemContract) {
	b.S7PayloadUserDataItemContract = contract
	contract.(*_S7PayloadUserDataItem)._SubType = b._S7PayloadUserDataItemCpuFunctionAlarmQueryResponse
}

func (b *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder) WithMandatoryFields(items []byte) S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder {
	return b.WithItems(items...)
}

func (b *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder) WithItems(items ...byte) S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder {
	b.Items = items
	return b
}

func (b *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder) Build() (S7PayloadUserDataItemCpuFunctionAlarmQueryResponse, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._S7PayloadUserDataItemCpuFunctionAlarmQueryResponse.deepCopy(), nil
}

func (b *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder) MustBuild() S7PayloadUserDataItemCpuFunctionAlarmQueryResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder) Done() S7PayloadUserDataItemBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewS7PayloadUserDataItemBuilder().(*_S7PayloadUserDataItemBuilder)
	}
	return b.parentBuilder
}

func (b *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder) buildForS7PayloadUserDataItem() (S7PayloadUserDataItem, error) {
	return b.Build()
}

func (b *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder) DeepCopy() any {
	_copy := b.CreateS7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder().(*_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateS7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder creates a S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder
func (b *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) CreateS7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder() S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder {
	if b == nil {
		return NewS7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder()
	}
	return &_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder{_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) GetCpuFunctionGroup() uint8 {
	return 0x04
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) GetCpuFunctionType() uint8 {
	return 0x08
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) GetCpuSubfunction() uint8 {
	return 0x13
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) GetParent() S7PayloadUserDataItemContract {
	return m.S7PayloadUserDataItemContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) GetItems() []byte {
	return m.Items
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastS7PayloadUserDataItemCpuFunctionAlarmQueryResponse(structType any) S7PayloadUserDataItemCpuFunctionAlarmQueryResponse {
	if casted, ok := structType.(S7PayloadUserDataItemCpuFunctionAlarmQueryResponse); ok {
		return casted
	}
	if casted, ok := structType.(*S7PayloadUserDataItemCpuFunctionAlarmQueryResponse); ok {
		return *casted
	}
	return nil
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) GetTypeName() string {
	return "S7PayloadUserDataItemCpuFunctionAlarmQueryResponse"
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).getLengthInBits(ctx))

	// Array field
	if len(m.Items) > 0 {
		lengthInBits += 8 * uint16(len(m.Items))
	}

	return lengthInBits
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_S7PayloadUserDataItem, dataLength uint16, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (__s7PayloadUserDataItemCpuFunctionAlarmQueryResponse S7PayloadUserDataItemCpuFunctionAlarmQueryResponse, err error) {
	m.S7PayloadUserDataItemContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7PayloadUserDataItemCpuFunctionAlarmQueryResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7PayloadUserDataItemCpuFunctionAlarmQueryResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	items, err := readBuffer.ReadByteArray("items", int(dataLength))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'items' field"))
	}
	m.Items = items

	if closeErr := readBuffer.CloseContext("S7PayloadUserDataItemCpuFunctionAlarmQueryResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7PayloadUserDataItemCpuFunctionAlarmQueryResponse")
	}

	return m, nil
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7PayloadUserDataItemCpuFunctionAlarmQueryResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for S7PayloadUserDataItemCpuFunctionAlarmQueryResponse")
		}

		if err := WriteByteArrayField(ctx, "items", m.GetItems(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'items' field")
		}

		if popErr := writeBuffer.PopContext("S7PayloadUserDataItemCpuFunctionAlarmQueryResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for S7PayloadUserDataItemCpuFunctionAlarmQueryResponse")
		}
		return nil
	}
	return m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) IsS7PayloadUserDataItemCpuFunctionAlarmQueryResponse() {
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) deepCopy() *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse {
	if m == nil {
		return nil
	}
	_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseCopy := &_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse{
		m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).deepCopy(),
		utils.DeepCopySlice[byte, byte](m.Items),
	}
	_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseCopy.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = m
	return _S7PayloadUserDataItemCpuFunctionAlarmQueryResponseCopy
}

func (m *_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
