/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ParameterValueBaudRateSelector is the corresponding interface of ParameterValueBaudRateSelector
type ParameterValueBaudRateSelector interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ParameterValue
	// GetValue returns Value (property field)
	GetValue() BaudRateSelector
	// GetData returns Data (property field)
	GetData() []byte
	// IsParameterValueBaudRateSelector is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsParameterValueBaudRateSelector()
	// CreateBuilder creates a ParameterValueBaudRateSelectorBuilder
	CreateParameterValueBaudRateSelectorBuilder() ParameterValueBaudRateSelectorBuilder
}

// _ParameterValueBaudRateSelector is the data-structure of this message
type _ParameterValueBaudRateSelector struct {
	ParameterValueContract
	Value BaudRateSelector
	Data  []byte
}

var _ ParameterValueBaudRateSelector = (*_ParameterValueBaudRateSelector)(nil)
var _ ParameterValueRequirements = (*_ParameterValueBaudRateSelector)(nil)

// NewParameterValueBaudRateSelector factory function for _ParameterValueBaudRateSelector
func NewParameterValueBaudRateSelector(value BaudRateSelector, data []byte, numBytes uint8) *_ParameterValueBaudRateSelector {
	_result := &_ParameterValueBaudRateSelector{
		ParameterValueContract: NewParameterValue(numBytes),
		Value:                  value,
		Data:                   data,
	}
	_result.ParameterValueContract.(*_ParameterValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ParameterValueBaudRateSelectorBuilder is a builder for ParameterValueBaudRateSelector
type ParameterValueBaudRateSelectorBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value BaudRateSelector, data []byte) ParameterValueBaudRateSelectorBuilder
	// WithValue adds Value (property field)
	WithValue(BaudRateSelector) ParameterValueBaudRateSelectorBuilder
	// WithData adds Data (property field)
	WithData(...byte) ParameterValueBaudRateSelectorBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ParameterValueBuilder
	// Build builds the ParameterValueBaudRateSelector or returns an error if something is wrong
	Build() (ParameterValueBaudRateSelector, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ParameterValueBaudRateSelector
}

// NewParameterValueBaudRateSelectorBuilder() creates a ParameterValueBaudRateSelectorBuilder
func NewParameterValueBaudRateSelectorBuilder() ParameterValueBaudRateSelectorBuilder {
	return &_ParameterValueBaudRateSelectorBuilder{_ParameterValueBaudRateSelector: new(_ParameterValueBaudRateSelector)}
}

type _ParameterValueBaudRateSelectorBuilder struct {
	*_ParameterValueBaudRateSelector

	parentBuilder *_ParameterValueBuilder

	collectedErr []error
}

var _ (ParameterValueBaudRateSelectorBuilder) = (*_ParameterValueBaudRateSelectorBuilder)(nil)

func (b *_ParameterValueBaudRateSelectorBuilder) setParent(contract ParameterValueContract) {
	b.ParameterValueContract = contract
	contract.(*_ParameterValue)._SubType = b._ParameterValueBaudRateSelector
}

func (b *_ParameterValueBaudRateSelectorBuilder) WithMandatoryFields(value BaudRateSelector, data []byte) ParameterValueBaudRateSelectorBuilder {
	return b.WithValue(value).WithData(data...)
}

func (b *_ParameterValueBaudRateSelectorBuilder) WithValue(value BaudRateSelector) ParameterValueBaudRateSelectorBuilder {
	b.Value = value
	return b
}

func (b *_ParameterValueBaudRateSelectorBuilder) WithData(data ...byte) ParameterValueBaudRateSelectorBuilder {
	b.Data = data
	return b
}

func (b *_ParameterValueBaudRateSelectorBuilder) Build() (ParameterValueBaudRateSelector, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ParameterValueBaudRateSelector.deepCopy(), nil
}

func (b *_ParameterValueBaudRateSelectorBuilder) MustBuild() ParameterValueBaudRateSelector {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ParameterValueBaudRateSelectorBuilder) Done() ParameterValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewParameterValueBuilder().(*_ParameterValueBuilder)
	}
	return b.parentBuilder
}

func (b *_ParameterValueBaudRateSelectorBuilder) buildForParameterValue() (ParameterValue, error) {
	return b.Build()
}

func (b *_ParameterValueBaudRateSelectorBuilder) DeepCopy() any {
	_copy := b.CreateParameterValueBaudRateSelectorBuilder().(*_ParameterValueBaudRateSelectorBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateParameterValueBaudRateSelectorBuilder creates a ParameterValueBaudRateSelectorBuilder
func (b *_ParameterValueBaudRateSelector) CreateParameterValueBaudRateSelectorBuilder() ParameterValueBaudRateSelectorBuilder {
	if b == nil {
		return NewParameterValueBaudRateSelectorBuilder()
	}
	return &_ParameterValueBaudRateSelectorBuilder{_ParameterValueBaudRateSelector: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ParameterValueBaudRateSelector) GetParameterType() ParameterType {
	return ParameterType_BAUD_RATE_SELECTOR
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ParameterValueBaudRateSelector) GetParent() ParameterValueContract {
	return m.ParameterValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ParameterValueBaudRateSelector) GetValue() BaudRateSelector {
	return m.Value
}

func (m *_ParameterValueBaudRateSelector) GetData() []byte {
	return m.Data
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastParameterValueBaudRateSelector(structType any) ParameterValueBaudRateSelector {
	if casted, ok := structType.(ParameterValueBaudRateSelector); ok {
		return casted
	}
	if casted, ok := structType.(*ParameterValueBaudRateSelector); ok {
		return *casted
	}
	return nil
}

func (m *_ParameterValueBaudRateSelector) GetTypeName() string {
	return "ParameterValueBaudRateSelector"
}

func (m *_ParameterValueBaudRateSelector) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ParameterValueContract.(*_ParameterValue).getLengthInBits(ctx))

	// Simple field (value)
	lengthInBits += 8

	// Array field
	if len(m.Data) > 0 {
		lengthInBits += 8 * uint16(len(m.Data))
	}

	return lengthInBits
}

func (m *_ParameterValueBaudRateSelector) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ParameterValueBaudRateSelector) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ParameterValue, parameterType ParameterType, numBytes uint8) (__parameterValueBaudRateSelector ParameterValueBaudRateSelector, err error) {
	m.ParameterValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ParameterValueBaudRateSelector"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ParameterValueBaudRateSelector")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((numBytes) >= (1))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "BaudRateSelector has exactly one byte"})
	}

	value, err := ReadEnumField[BaudRateSelector](ctx, "value", "BaudRateSelector", ReadEnum(BaudRateSelectorByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	data, err := readBuffer.ReadByteArray("data", int(int32(numBytes)-int32(int32(1))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'data' field"))
	}
	m.Data = data

	if closeErr := readBuffer.CloseContext("ParameterValueBaudRateSelector"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ParameterValueBaudRateSelector")
	}

	return m, nil
}

func (m *_ParameterValueBaudRateSelector) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ParameterValueBaudRateSelector) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ParameterValueBaudRateSelector"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ParameterValueBaudRateSelector")
		}

		if err := WriteSimpleEnumField[BaudRateSelector](ctx, "value", "BaudRateSelector", m.GetValue(), WriteEnum[BaudRateSelector, uint8](BaudRateSelector.GetValue, BaudRateSelector.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if err := WriteByteArrayField(ctx, "data", m.GetData(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'data' field")
		}

		if popErr := writeBuffer.PopContext("ParameterValueBaudRateSelector"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ParameterValueBaudRateSelector")
		}
		return nil
	}
	return m.ParameterValueContract.(*_ParameterValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ParameterValueBaudRateSelector) IsParameterValueBaudRateSelector() {}

func (m *_ParameterValueBaudRateSelector) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ParameterValueBaudRateSelector) deepCopy() *_ParameterValueBaudRateSelector {
	if m == nil {
		return nil
	}
	_ParameterValueBaudRateSelectorCopy := &_ParameterValueBaudRateSelector{
		m.ParameterValueContract.(*_ParameterValue).deepCopy(),
		m.Value,
		utils.DeepCopySlice[byte, byte](m.Data),
	}
	_ParameterValueBaudRateSelectorCopy.ParameterValueContract.(*_ParameterValue)._SubType = m
	return _ParameterValueBaudRateSelectorCopy
}

func (m *_ParameterValueBaudRateSelector) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
