/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataThreatLevel is the corresponding interface of BACnetConstructedDataThreatLevel
type BACnetConstructedDataThreatLevel interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetThreatLevel returns ThreatLevel (property field)
	GetThreatLevel() BACnetAccessThreatLevel
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetAccessThreatLevel
	// IsBACnetConstructedDataThreatLevel is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataThreatLevel()
	// CreateBuilder creates a BACnetConstructedDataThreatLevelBuilder
	CreateBACnetConstructedDataThreatLevelBuilder() BACnetConstructedDataThreatLevelBuilder
}

// _BACnetConstructedDataThreatLevel is the data-structure of this message
type _BACnetConstructedDataThreatLevel struct {
	BACnetConstructedDataContract
	ThreatLevel BACnetAccessThreatLevel
}

var _ BACnetConstructedDataThreatLevel = (*_BACnetConstructedDataThreatLevel)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataThreatLevel)(nil)

// NewBACnetConstructedDataThreatLevel factory function for _BACnetConstructedDataThreatLevel
func NewBACnetConstructedDataThreatLevel(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, threatLevel BACnetAccessThreatLevel, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataThreatLevel {
	if threatLevel == nil {
		panic("threatLevel of type BACnetAccessThreatLevel for BACnetConstructedDataThreatLevel must not be nil")
	}
	_result := &_BACnetConstructedDataThreatLevel{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ThreatLevel:                   threatLevel,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataThreatLevelBuilder is a builder for BACnetConstructedDataThreatLevel
type BACnetConstructedDataThreatLevelBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(threatLevel BACnetAccessThreatLevel) BACnetConstructedDataThreatLevelBuilder
	// WithThreatLevel adds ThreatLevel (property field)
	WithThreatLevel(BACnetAccessThreatLevel) BACnetConstructedDataThreatLevelBuilder
	// WithThreatLevelBuilder adds ThreatLevel (property field) which is build by the builder
	WithThreatLevelBuilder(func(BACnetAccessThreatLevelBuilder) BACnetAccessThreatLevelBuilder) BACnetConstructedDataThreatLevelBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataThreatLevel or returns an error if something is wrong
	Build() (BACnetConstructedDataThreatLevel, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataThreatLevel
}

// NewBACnetConstructedDataThreatLevelBuilder() creates a BACnetConstructedDataThreatLevelBuilder
func NewBACnetConstructedDataThreatLevelBuilder() BACnetConstructedDataThreatLevelBuilder {
	return &_BACnetConstructedDataThreatLevelBuilder{_BACnetConstructedDataThreatLevel: new(_BACnetConstructedDataThreatLevel)}
}

type _BACnetConstructedDataThreatLevelBuilder struct {
	*_BACnetConstructedDataThreatLevel

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataThreatLevelBuilder) = (*_BACnetConstructedDataThreatLevelBuilder)(nil)

func (b *_BACnetConstructedDataThreatLevelBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataThreatLevel
}

func (b *_BACnetConstructedDataThreatLevelBuilder) WithMandatoryFields(threatLevel BACnetAccessThreatLevel) BACnetConstructedDataThreatLevelBuilder {
	return b.WithThreatLevel(threatLevel)
}

func (b *_BACnetConstructedDataThreatLevelBuilder) WithThreatLevel(threatLevel BACnetAccessThreatLevel) BACnetConstructedDataThreatLevelBuilder {
	b.ThreatLevel = threatLevel
	return b
}

func (b *_BACnetConstructedDataThreatLevelBuilder) WithThreatLevelBuilder(builderSupplier func(BACnetAccessThreatLevelBuilder) BACnetAccessThreatLevelBuilder) BACnetConstructedDataThreatLevelBuilder {
	builder := builderSupplier(b.ThreatLevel.CreateBACnetAccessThreatLevelBuilder())
	var err error
	b.ThreatLevel, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetAccessThreatLevelBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataThreatLevelBuilder) Build() (BACnetConstructedDataThreatLevel, error) {
	if b.ThreatLevel == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'threatLevel' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataThreatLevel.deepCopy(), nil
}

func (b *_BACnetConstructedDataThreatLevelBuilder) MustBuild() BACnetConstructedDataThreatLevel {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataThreatLevelBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataThreatLevelBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataThreatLevelBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataThreatLevelBuilder().(*_BACnetConstructedDataThreatLevelBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataThreatLevelBuilder creates a BACnetConstructedDataThreatLevelBuilder
func (b *_BACnetConstructedDataThreatLevel) CreateBACnetConstructedDataThreatLevelBuilder() BACnetConstructedDataThreatLevelBuilder {
	if b == nil {
		return NewBACnetConstructedDataThreatLevelBuilder()
	}
	return &_BACnetConstructedDataThreatLevelBuilder{_BACnetConstructedDataThreatLevel: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataThreatLevel) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataThreatLevel) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_THREAT_LEVEL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataThreatLevel) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataThreatLevel) GetThreatLevel() BACnetAccessThreatLevel {
	return m.ThreatLevel
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataThreatLevel) GetActualValue() BACnetAccessThreatLevel {
	ctx := context.Background()
	_ = ctx
	return CastBACnetAccessThreatLevel(m.GetThreatLevel())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataThreatLevel(structType any) BACnetConstructedDataThreatLevel {
	if casted, ok := structType.(BACnetConstructedDataThreatLevel); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataThreatLevel); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataThreatLevel) GetTypeName() string {
	return "BACnetConstructedDataThreatLevel"
}

func (m *_BACnetConstructedDataThreatLevel) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (threatLevel)
	lengthInBits += m.ThreatLevel.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataThreatLevel) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataThreatLevel) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataThreatLevel BACnetConstructedDataThreatLevel, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataThreatLevel"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataThreatLevel")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	threatLevel, err := ReadSimpleField[BACnetAccessThreatLevel](ctx, "threatLevel", ReadComplex[BACnetAccessThreatLevel](BACnetAccessThreatLevelParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'threatLevel' field"))
	}
	m.ThreatLevel = threatLevel

	actualValue, err := ReadVirtualField[BACnetAccessThreatLevel](ctx, "actualValue", (*BACnetAccessThreatLevel)(nil), threatLevel)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataThreatLevel"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataThreatLevel")
	}

	return m, nil
}

func (m *_BACnetConstructedDataThreatLevel) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataThreatLevel) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataThreatLevel"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataThreatLevel")
		}

		if err := WriteSimpleField[BACnetAccessThreatLevel](ctx, "threatLevel", m.GetThreatLevel(), WriteComplex[BACnetAccessThreatLevel](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'threatLevel' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataThreatLevel"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataThreatLevel")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataThreatLevel) IsBACnetConstructedDataThreatLevel() {}

func (m *_BACnetConstructedDataThreatLevel) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataThreatLevel) deepCopy() *_BACnetConstructedDataThreatLevel {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataThreatLevelCopy := &_BACnetConstructedDataThreatLevel{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetAccessThreatLevel](m.ThreatLevel),
	}
	_BACnetConstructedDataThreatLevelCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataThreatLevelCopy
}

func (m *_BACnetConstructedDataThreatLevel) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
