/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.cloud.oracle;

import java.util.List;
import org.netbeans.modules.cloud.oracle.items.OCIItem;

/**
 *
 * @author Jan Horvath
 */
public interface ChildrenProvider<T extends OCIItem, U extends OCIItem> {

    public List<U> apply(T t);
    
    /**
     * Session / profile-aware child factory. Accepts the active session (profile) as a parameter to
     * find child items. 
     * @param <T>
     * @param <U> 
     */
    public interface SessionAware<T extends OCIItem, U extends OCIItem> extends ChildrenProvider<T, U> {
        public default List<U> apply(T t) {
            return apply(t, OCIManager.getDefault().getActiveProfile(t));
        }
        
        /**
         * Finds children of item t. Use `session' to initialize BMC clients that communicate
         * with OCI.
         * @param t parent item
         * @param session authenticator factory
         * @return list of children.
         */
        public List<U> apply(T t, OCISessionInitiator session);
    }
}
