/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Interpolation1D;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class LinearInterpolator1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = -5025693608589996896L;
    private final double[] values;
    private final MathTransform1D inverse;

    private LinearInterpolator1D(double[] dArray) {
        this.values = dArray;
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (d <= (d = dArray[i])) continue;
            this.inverse = null;
            return;
        }
        this.inverse = new Inverse(this);
    }

    private static MathTransform1D create(double[] dArray) {
        boolean bl;
        double d;
        int n = dArray.length - 1;
        double d2 = dArray[0];
        double d3 = (dArray[n] - d2) / (double)n;
        double d4 = Math.abs(d3);
        int n2 = 0;
        do {
            if (++n2 < n) continue;
            return LinearTransform1D.create(d3, d2);
        } while (Numerics.epsilonEqual(d = dArray[n2], d2 + d3 * (double)n2, Math.max(Math.abs(d), d4) * 1.0E-13));
        boolean bl2 = bl = d3 < 0.0;
        if (bl) {
            for (n2 = 0; n2 <= n; ++n2) {
                dArray[n2] = -dArray[n2];
            }
        }
        AbstractMathTransform abstractMathTransform = new LinearInterpolator1D(dArray);
        if (bl) {
            abstractMathTransform = new ConcatenatedTransformDirect1D((MathTransform1D)abstractMathTransform, LinearTransform1D.NEGATE);
        }
        return abstractMathTransform;
    }

    static MathTransform1D create(double[] dArray, double[] dArray2) {
        int n;
        if (dArray == null) {
            if (dArray2 == null) {
                return IdentityTransform1D.INSTANCE;
            }
            n = dArray2.length;
        } else {
            n = dArray.length;
            if (dArray2 != null && dArray2.length != n) {
                throw new IllegalArgumentException(Errors.format((short)77));
            }
        }
        switch (n) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)29, dArray != null ? "preimage" : "values"));
            }
            case 1: {
                return LinearTransform1D.constant(dArray != null ? dArray[0] : Double.NaN, dArray2 != null ? dArray2[0] : Double.NaN);
            }
        }
        MathTransform1D mathTransform1D = null;
        if (dArray2 != null) {
            mathTransform1D = LinearInterpolator1D.create((double[])dArray2.clone());
        }
        if (dArray != null) {
            MathTransform1D mathTransform1D2 = mathTransform1D;
            try {
                mathTransform1D = LinearInterpolator1D.create((double[])dArray.clone()).inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new IllegalArgumentException(Resources.format((short)55, "preimage"), noninvertibleTransformException);
            }
            if (mathTransform1D2 != null) {
                mathTransform1D = MathTransforms.concatenate(mathTransform1D, mathTransform1D2);
            }
        }
        return mathTransform1D;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Interpolation1D.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup parameterValueGroup = this.getParameterDescriptors().createValue();
        parameterValueGroup.parameter("values").setValue((Object)this.values);
        return parameterValueGroup;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == (double)i) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double d;
        double d2;
        double d3 = dArray[n];
        if (d3 >= 0.0) {
            int n3 = (int)d3;
            int n4 = this.values.length - 1;
            if (n3 < n4) {
                double d4 = this.values[n3];
                double d5 = this.values[n3 + 1];
                d2 = d4 * (1.0 - (d3 -= (double)n3)) + d5 * d3;
                d = d5 - d4;
            } else {
                double d6 = this.values[n4];
                d = d6 - this.values[n4 - 1];
                d2 = (d3 - (double)n4) * d + d6;
            }
        } else {
            double d7 = this.values[0];
            d = this.values[1] - d7;
            d2 = d3 * d + d7;
        }
        if (dArray2 != null) {
            dArray2[n2] = d2;
        }
        return bl ? new Matrix1(d) : null;
    }

    @Override
    public double transform(double d) {
        if (d >= 0.0) {
            int n = (int)d;
            int n2 = this.values.length - 1;
            if (n < n2) {
                return this.values[n] * (1.0 - (d -= (double)n)) + this.values[n + 1] * d;
            }
            double d2 = this.values[n2];
            return (d - (double)n2) * (d2 - this.values[n2 - 1]) + d2;
        }
        double d3 = this.values[0];
        return d * (this.values[1] - d3) + d3;
    }

    @Override
    public double derivative(double d) {
        int n = Math.max(0, Math.min(this.values.length - 2, (int)d));
        return this.values[n + 1] - this.values[n];
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return this.inverse != null ? this.inverse : super.inverse();
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            return Arrays.equals(this.values, ((LinearInterpolator1D)object).values);
        }
        return false;
    }

    private static final class Inverse
    extends AbstractMathTransform1D.Inverse
    implements MathTransform1D,
    Serializable {
        private static final long serialVersionUID = -5112948223332095009L;
        private final LinearInterpolator1D forward;

        Inverse(LinearInterpolator1D linearInterpolator1D) {
            this.forward = linearInterpolator1D;
        }

        @Override
        public MathTransform1D inverse() {
            return this.forward;
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            double d;
            double d2;
            double d3 = dArray[n];
            double[] dArray3 = this.forward.values;
            int n3 = Arrays.binarySearch(dArray3, d3);
            if (n3 >= 0) {
                d2 = n3;
                n3 = Math.max(1, Math.min(dArray3.length - 1, n3));
                d = dArray3[n3] - dArray3[n3 - 1];
            } else if ((n3 ^= 0xFFFFFFFF) >= 1) {
                if (n3 < dArray3.length) {
                    double d4 = dArray3[n3 - 1];
                    d = dArray3[n3] - d4;
                    d2 = (d3 - d4) / d + (double)(n3 - 1);
                } else {
                    int n4 = dArray3.length - 1;
                    double d5 = dArray3[n4];
                    d = d5 - dArray3[n4 - 1];
                    d2 = (d3 - d5) / d + (double)n4;
                }
            } else {
                double d6 = dArray3[0];
                d = dArray3[1] - d6;
                d2 = (d3 - d6) / d;
            }
            if (dArray2 != null) {
                dArray2[n2] = d2;
            }
            return bl ? new Matrix1(1.0 / d) : null;
        }

        public double transform(double d) {
            double[] dArray = this.forward.values;
            int n = Arrays.binarySearch(dArray, d);
            if (n >= 0) {
                return n;
            }
            if ((n ^= 0xFFFFFFFF) >= 1) {
                if (n < dArray.length) {
                    double d2 = dArray[n - 1];
                    return (d - d2) / (dArray[n] - d2) + (double)(n - 1);
                }
                int n2 = dArray.length - 1;
                double d3 = dArray[n2];
                return (d - d3) / (d3 - dArray[n2 - 1]) + (double)n2;
            }
            double d4 = dArray[0];
            return (d - d4) / (dArray[1] - d4);
        }

        public double derivative(double d) {
            double[] dArray = this.forward.values;
            int n = Arrays.binarySearch(dArray, d);
            if (n < 0) {
                n ^= 0xFFFFFFFF;
            }
            n = Math.max(1, Math.min(dArray.length - 1, n));
            return 1.0 / (dArray[n] - dArray[n - 1]);
        }
    }
}

