/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.monitor.QueryMatch;

public class MatchingQueries<T extends QueryMatch> {
    private final Map<String, T> matches;
    private final Map<String, Exception> errors;
    private final long queryBuildTime;
    private final long searchTime;
    private final int queriesRun;

    MatchingQueries(Map<String, T> matches, Map<String, Exception> errors, long queryBuildTime, long searchTime, int queriesRun) {
        this.matches = Collections.unmodifiableMap(matches);
        this.errors = Collections.unmodifiableMap(errors);
        this.queryBuildTime = queryBuildTime;
        this.searchTime = searchTime;
        this.queriesRun = queriesRun;
    }

    public T matches(String queryId) {
        return (T)((QueryMatch)this.matches.get(queryId));
    }

    public Collection<T> getMatches() {
        return this.matches.values();
    }

    public int getMatchCount() {
        return this.matches.size();
    }

    public long getQueryBuildTime() {
        return this.queryBuildTime;
    }

    public long getSearchTime() {
        return this.searchTime;
    }

    public int getQueriesRun() {
        return this.queriesRun;
    }

    public Map<String, Exception> getErrors() {
        return this.errors;
    }
}

