/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.monitor.Monitor;
import org.apache.lucene.monitor.MonitorQuery;
import org.apache.lucene.util.NamedThreadFactory;

public class ConcurrentQueryLoader
implements Closeable {
    private final Monitor monitor;
    private final ExecutorService executor;
    private final CountDownLatch shutdownLatch;
    private final BlockingQueue<MonitorQuery> queue;
    private boolean shutdown = false;
    private List<IOException> errors = new ArrayList<IOException>();
    public static final int DEFAULT_QUEUE_SIZE = 2000;

    public ConcurrentQueryLoader(Monitor monitor) {
        this(monitor, Runtime.getRuntime().availableProcessors(), 2000);
    }

    public ConcurrentQueryLoader(Monitor monitor, int threads, int queueSize) {
        this.monitor = monitor;
        this.queue = new LinkedBlockingQueue<MonitorQuery>(queueSize);
        this.executor = Executors.newFixedThreadPool(threads, (ThreadFactory)new NamedThreadFactory("loader"));
        this.shutdownLatch = new CountDownLatch(threads);
        for (int i = 0; i < threads; ++i) {
            this.executor.submit(new Worker(queueSize / threads));
        }
    }

    public void add(MonitorQuery mq) throws InterruptedException {
        if (this.shutdown) {
            throw new IllegalStateException("ConcurrentQueryLoader has been shutdown, cannot add new queries");
        }
        this.queue.put(mq);
    }

    @Override
    public void close() throws IOException {
        this.shutdown = true;
        this.executor.shutdown();
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.errors.size() > 0) {
            IOException e = new IOException();
            this.errors.forEach(e::addSuppressed);
            throw e;
        }
    }

    private static <E> int drain(BlockingQueue<E> q, Collection<? super E> buffer, int numElements, long timeout, TimeUnit unit) throws InterruptedException {
        Objects.requireNonNull(buffer);
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        int added = 0;
        while (added < numElements) {
            if ((added += q.drainTo(buffer, numElements - added)) >= numElements) continue;
            E e = q.poll(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
            if (e == null) break;
            buffer.add(e);
            ++added;
        }
        return added;
    }

    private class Worker
    implements Runnable {
        final List<MonitorQuery> workerQueue;
        final int queueSize;
        boolean running = true;

        Worker(int queueSize) {
            this.workerQueue = new ArrayList<MonitorQuery>(queueSize);
            this.queueSize = queueSize;
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    this.workerQueue.clear();
                    ConcurrentQueryLoader.drain(ConcurrentQueryLoader.this.queue, this.workerQueue, this.queueSize, 100L, TimeUnit.MILLISECONDS);
                    if (this.workerQueue.size() == 0 && ConcurrentQueryLoader.this.shutdown) {
                        this.running = false;
                    }
                    if (this.workerQueue.size() <= 0) continue;
                    ConcurrentQueryLoader.this.monitor.register(this.workerQueue);
                }
            }
            catch (IOException e) {
                ConcurrentQueryLoader.this.errors.add(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                ConcurrentQueryLoader.this.shutdownLatch.countDown();
            }
        }
    }
}

