/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.lucene.analysis.ja.dict.ConnectionCostsBuilder;
import org.apache.lucene.analysis.ja.dict.TokenInfoDictionaryBuilder;
import org.apache.lucene.analysis.ja.dict.UnknownDictionaryBuilder;

public class DictionaryBuilder {
    private DictionaryBuilder() {
    }

    public static void build(DictionaryFormat format, Path inputDir, Path outputDir, String encoding, boolean normalizeEntry) throws IOException {
        new TokenInfoDictionaryBuilder(format, encoding, normalizeEntry).build(inputDir).write(outputDir);
        new UnknownDictionaryBuilder(encoding).build(inputDir).write(outputDir);
        ConnectionCostsBuilder.build(inputDir.resolve("matrix.def")).write(outputDir, "kuromoji_cc", 1);
    }

    public static void main(String[] args) throws IOException {
        DictionaryFormat format = DictionaryFormat.valueOf(args[0].toUpperCase(Locale.ROOT));
        String inputDirName = args[1];
        String outputDirName = args[2];
        String inputEncoding = args[3];
        boolean normalizeEntries = Boolean.parseBoolean(args[4]);
        DictionaryBuilder.build(format, Paths.get(inputDirName, new String[0]), Paths.get(outputDirName, new String[0]), inputEncoding, normalizeEntries);
    }

    public static enum DictionaryFormat {
        IPADIC,
        UNIDIC;

    }
}

