/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.util.inifile;

import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.luke.app.desktop.util.inifile.IniFile;
import org.apache.lucene.luke.app.desktop.util.inifile.IniFileReader;
import org.apache.lucene.luke.app.desktop.util.inifile.IniFileWriter;
import org.apache.lucene.luke.app.desktop.util.inifile.OptionMap;
import org.apache.lucene.luke.app.desktop.util.inifile.SimpleIniFileReader;
import org.apache.lucene.luke.app.desktop.util.inifile.SimpleIniFileWriter;

public class SimpleIniFile
implements IniFile {
    private final Map<String, OptionMap> sections = new LinkedHashMap<String, OptionMap>();
    private IniFileWriter writer = new SimpleIniFileWriter();
    private IniFileReader reader = new SimpleIniFileReader();

    @Override
    public synchronized void load(Path path) throws IOException {
        this.sections.putAll(this.reader.readSections(path));
    }

    @Override
    public synchronized void store(Path path) throws IOException {
        this.writer.writeSections(path, this.sections);
    }

    @Override
    public synchronized void put(String section, String option, Object value) {
        if (this.checkString(section) && this.checkString(option) && Objects.nonNull(value)) {
            this.sections.putIfAbsent(section, new OptionMap());
            this.sections.get(section).put(option, value instanceof String ? (String)value : String.valueOf(value));
        }
    }

    @Override
    public String getString(String section, String option) {
        OptionMap options;
        if (this.checkString(section) && this.checkString(option) && (options = this.sections.get(section)) != null) {
            return options.getAsString(option);
        }
        return null;
    }

    @Override
    public Boolean getBoolean(String section, String option) {
        OptionMap options;
        if (this.checkString(section) && this.checkString(option) && (options = this.sections.get(section)) != null) {
            return options.getAsBoolean(option);
        }
        return false;
    }

    private boolean checkString(String s) {
        return Objects.nonNull(s) && !s.isEmpty();
    }

    Map<String, OptionMap> getSections() {
        return this.sections;
    }
}

