/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.lucene.luke.app.DirectoryHandler;
import org.apache.lucene.luke.app.DirectoryObserver;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.LukeWindowOperator;
import org.apache.lucene.luke.app.desktop.components.dialog.menubar.AboutDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.menubar.CheckIndexDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.menubar.CreateIndexDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.menubar.ExportTermsDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.menubar.OpenIndexDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.menubar.OptimizeIndexDialogFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.util.Version;

public final class MenuBarProvider {
    private final Preferences prefs;
    private final ComponentOperatorRegistry operatorRegistry;
    private final DirectoryHandler directoryHandler;
    private final IndexHandler indexHandler;
    private final OpenIndexDialogFactory openIndexDialogFactory;
    private final CreateIndexDialogFactory createIndexDialogFactory;
    private final OptimizeIndexDialogFactory optimizeIndexDialogFactory;
    private final ExportTermsDialogFactory exportTermsDialogFactory;
    private final CheckIndexDialogFactory checkIndexDialogFactory;
    private final AboutDialogFactory aboutDialogFactory;
    private final JMenuItem openIndexMItem = new JMenuItem();
    private final JMenuItem reopenIndexMItem = new JMenuItem();
    private final JMenuItem createIndexMItem = new JMenuItem();
    private final JMenuItem closeIndexMItem = new JMenuItem();
    private final JMenuItem grayThemeMItem = new JMenuItem();
    private final JMenuItem classicThemeMItem = new JMenuItem();
    private final JMenuItem sandstoneThemeMItem = new JMenuItem();
    private final JMenuItem navyThemeMItem = new JMenuItem();
    private final JMenuItem exitMItem = new JMenuItem();
    private final JMenuItem optimizeIndexMItem = new JMenuItem();
    private final JMenuItem exportTermsMItem = new JMenuItem();
    private final JMenuItem checkIndexMItem = new JMenuItem();
    private final JMenuItem aboutMItem = new JMenuItem();
    private final ListenerFunctions listeners = new ListenerFunctions();

    public MenuBarProvider() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.directoryHandler = DirectoryHandler.getInstance();
        this.indexHandler = IndexHandler.getInstance();
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.openIndexDialogFactory = OpenIndexDialogFactory.getInstance();
        this.createIndexDialogFactory = CreateIndexDialogFactory.getInstance();
        this.optimizeIndexDialogFactory = OptimizeIndexDialogFactory.getInstance();
        this.exportTermsDialogFactory = ExportTermsDialogFactory.getInstance();
        this.checkIndexDialogFactory = CheckIndexDialogFactory.getInstance();
        this.aboutDialogFactory = AboutDialogFactory.getInstance();
        Observer observer = new Observer();
        this.directoryHandler.addObserver(observer);
        this.indexHandler.addObserver(observer);
    }

    public JMenuBar get() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createToolsMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu(MessageUtils.getLocalizedMessage("menu.file"));
        this.openIndexMItem.setText(MessageUtils.getLocalizedMessage("menu.item.open_index"));
        this.openIndexMItem.addActionListener(this.listeners::showOpenIndexDialog);
        fileMenu.add(this.openIndexMItem);
        this.reopenIndexMItem.setText(MessageUtils.getLocalizedMessage("menu.item.reopen_index"));
        this.reopenIndexMItem.setEnabled(false);
        this.reopenIndexMItem.addActionListener(this.listeners::reopenIndex);
        fileMenu.add(this.reopenIndexMItem);
        this.createIndexMItem.setText(MessageUtils.getLocalizedMessage("menu.item.create_index"));
        this.createIndexMItem.addActionListener(this.listeners::showCreateIndexDialog);
        fileMenu.add(this.createIndexMItem);
        this.closeIndexMItem.setText(MessageUtils.getLocalizedMessage("menu.item.close_index"));
        this.closeIndexMItem.setEnabled(false);
        this.closeIndexMItem.addActionListener(this.listeners::closeIndex);
        fileMenu.add(this.closeIndexMItem);
        fileMenu.addSeparator();
        JMenu settingsMenu = new JMenu(MessageUtils.getLocalizedMessage("menu.settings"));
        JMenu themeMenu = new JMenu(MessageUtils.getLocalizedMessage("menu.color"));
        this.grayThemeMItem.setText(MessageUtils.getLocalizedMessage("menu.item.theme_gray"));
        this.grayThemeMItem.addActionListener(this.listeners::changeThemeToGray);
        themeMenu.add(this.grayThemeMItem);
        this.classicThemeMItem.setText(MessageUtils.getLocalizedMessage("menu.item.theme_classic"));
        this.classicThemeMItem.addActionListener(this.listeners::changeThemeToClassic);
        themeMenu.add(this.classicThemeMItem);
        this.sandstoneThemeMItem.setText(MessageUtils.getLocalizedMessage("menu.item.theme_sandstone"));
        this.sandstoneThemeMItem.addActionListener(this.listeners::changeThemeToSandstone);
        themeMenu.add(this.sandstoneThemeMItem);
        this.navyThemeMItem.setText(MessageUtils.getLocalizedMessage("menu.item.theme_navy"));
        this.navyThemeMItem.addActionListener(this.listeners::changeThemeToNavy);
        themeMenu.add(this.navyThemeMItem);
        settingsMenu.add(themeMenu);
        fileMenu.add(settingsMenu);
        fileMenu.addSeparator();
        this.exitMItem.setText(MessageUtils.getLocalizedMessage("menu.item.exit"));
        this.exitMItem.addActionListener(this.listeners::exit);
        fileMenu.add(this.exitMItem);
        return fileMenu;
    }

    private JMenu createToolsMenu() {
        JMenu toolsMenu = new JMenu(MessageUtils.getLocalizedMessage("menu.tools"));
        this.optimizeIndexMItem.setText(MessageUtils.getLocalizedMessage("menu.item.optimize"));
        this.optimizeIndexMItem.setEnabled(false);
        this.optimizeIndexMItem.addActionListener(this.listeners::showOptimizeIndexDialog);
        toolsMenu.add(this.optimizeIndexMItem);
        this.checkIndexMItem.setText(MessageUtils.getLocalizedMessage("menu.item.check_index"));
        this.checkIndexMItem.setEnabled(false);
        this.checkIndexMItem.addActionListener(this.listeners::showCheckIndexDialog);
        toolsMenu.add(this.checkIndexMItem);
        this.exportTermsMItem.setText(MessageUtils.getLocalizedMessage("menu.item.export.terms"));
        this.exportTermsMItem.setEnabled(false);
        this.exportTermsMItem.addActionListener(this.listeners::showExportTermsDialog);
        toolsMenu.add(this.exportTermsMItem);
        return toolsMenu;
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu(MessageUtils.getLocalizedMessage("menu.help"));
        this.aboutMItem.setText(MessageUtils.getLocalizedMessage("menu.item.about"));
        this.aboutMItem.addActionListener(this.listeners::showAboutDialog);
        helpMenu.add(this.aboutMItem);
        return helpMenu;
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void showOpenIndexDialog(ActionEvent e) {
            new DialogOpener<OpenIndexDialogFactory>(MenuBarProvider.this.openIndexDialogFactory).open(MessageUtils.getLocalizedMessage("openindex.dialog.title"), 600, 420, factory -> {}, new String[0]);
        }

        void showCreateIndexDialog(ActionEvent e) {
            new DialogOpener<CreateIndexDialogFactory>(MenuBarProvider.this.createIndexDialogFactory).open(MessageUtils.getLocalizedMessage("createindex.dialog.title"), 600, 360, factory -> {}, new String[0]);
        }

        void reopenIndex(ActionEvent e) {
            MenuBarProvider.this.indexHandler.reOpen();
        }

        void closeIndex(ActionEvent e) {
            this.close();
        }

        void changeThemeToGray(ActionEvent e) {
            this.changeTheme(Preferences.ColorTheme.GRAY);
        }

        void changeThemeToClassic(ActionEvent e) {
            this.changeTheme(Preferences.ColorTheme.CLASSIC);
        }

        void changeThemeToSandstone(ActionEvent e) {
            this.changeTheme(Preferences.ColorTheme.SANDSTONE);
        }

        void changeThemeToNavy(ActionEvent e) {
            this.changeTheme(Preferences.ColorTheme.NAVY);
        }

        private void changeTheme(Preferences.ColorTheme theme) {
            try {
                MenuBarProvider.this.prefs.setColorTheme(theme);
                MenuBarProvider.this.operatorRegistry.get(LukeWindowOperator.class).ifPresent(operator -> operator.setColorTheme(theme));
            }
            catch (IOException e) {
                throw new LukeException("Failed to set color theme : " + theme.name(), e);
            }
        }

        void exit(ActionEvent e) {
            this.close();
            System.exit(0);
        }

        private void close() {
            MenuBarProvider.this.directoryHandler.close();
            MenuBarProvider.this.indexHandler.close();
        }

        void showOptimizeIndexDialog(ActionEvent e) {
            new DialogOpener<OptimizeIndexDialogFactory>(MenuBarProvider.this.optimizeIndexDialogFactory).open("Optimize index", 600, 600, factory -> {}, new String[0]);
        }

        void showCheckIndexDialog(ActionEvent e) {
            new DialogOpener<CheckIndexDialogFactory>(MenuBarProvider.this.checkIndexDialogFactory).open("Check index", 600, 600, factory -> {}, new String[0]);
        }

        void showAboutDialog(ActionEvent e) {
            String title = "About Luke v" + Version.LATEST.toString();
            new DialogOpener<AboutDialogFactory>(MenuBarProvider.this.aboutDialogFactory).open(title, 800, 480, factory -> {}, new String[0]);
        }

        void showExportTermsDialog(ActionEvent e) {
            new DialogOpener<ExportTermsDialogFactory>(MenuBarProvider.this.exportTermsDialogFactory).open("Export terms", 600, 450, factory -> {}, new String[0]);
        }
    }

    private class Observer
    implements IndexObserver,
    DirectoryObserver {
        private Observer() {
        }

        @Override
        public void openDirectory(LukeState state) {
            MenuBarProvider.this.reopenIndexMItem.setEnabled(false);
            MenuBarProvider.this.closeIndexMItem.setEnabled(false);
            MenuBarProvider.this.optimizeIndexMItem.setEnabled(false);
            MenuBarProvider.this.exportTermsMItem.setEnabled(false);
            MenuBarProvider.this.checkIndexMItem.setEnabled(true);
        }

        @Override
        public void closeDirectory() {
            this.close();
        }

        @Override
        public void openIndex(LukeState state) {
            MenuBarProvider.this.reopenIndexMItem.setEnabled(true);
            MenuBarProvider.this.closeIndexMItem.setEnabled(true);
            MenuBarProvider.this.exportTermsMItem.setEnabled(true);
            if (!state.readOnly() && state.hasDirectoryReader()) {
                MenuBarProvider.this.optimizeIndexMItem.setEnabled(true);
            }
            if (state.hasDirectoryReader()) {
                MenuBarProvider.this.checkIndexMItem.setEnabled(true);
            }
        }

        @Override
        public void closeIndex() {
            this.close();
        }

        private void close() {
            MenuBarProvider.this.reopenIndexMItem.setEnabled(false);
            MenuBarProvider.this.closeIndexMItem.setEnabled(false);
            MenuBarProvider.this.optimizeIndexMItem.setEnabled(false);
            MenuBarProvider.this.checkIndexMItem.setEnabled(false);
            MenuBarProvider.this.exportTermsMItem.setEnabled(false);
        }
    }
}

