/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.asserting;

import java.io.IOException;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.tests.codecs.asserting.AssertingCodec;
import org.apache.lucene.tests.index.AssertingLeafReader;
import org.apache.lucene.tests.util.TestUtil;

public final class AssertingPointsFormat
extends PointsFormat {
    private final PointsFormat in;

    public AssertingPointsFormat() {
        this(TestUtil.getDefaultCodec().pointsFormat());
    }

    public AssertingPointsFormat(PointsFormat in) {
        this.in = in;
    }

    public PointsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new AssertingPointsWriter(state, this.in.fieldsWriter(state));
    }

    public PointsReader fieldsReader(SegmentReadState state) throws IOException {
        return new AssertingPointsReader(state.segmentInfo.maxDoc(), this.in.fieldsReader(state), state.fieldInfos, false);
    }

    static class AssertingPointsWriter
    extends PointsWriter {
        private final PointsWriter in;

        AssertingPointsWriter(SegmentWriteState writeState, PointsWriter in) {
            this.in = in;
        }

        public void writeField(FieldInfo fieldInfo, PointsReader values) throws IOException {
            if (fieldInfo.getPointDimensionCount() == 0) {
                throw new IllegalArgumentException("writing field=\"" + fieldInfo.name + "\" but pointDimensionalCount is 0");
            }
            this.in.writeField(fieldInfo, values);
        }

        public void merge(MergeState mergeState) throws IOException {
            this.in.merge(mergeState);
        }

        public void finish() throws IOException {
            this.in.finish();
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }
    }

    static class AssertingPointsReader
    extends PointsReader {
        private final PointsReader in;
        private final int maxDoc;
        private final FieldInfos fis;
        private final boolean merging;
        private final Thread creationThread;

        AssertingPointsReader(int maxDoc, PointsReader in, FieldInfos fis, boolean merging) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.fis = fis;
            this.merging = merging;
            this.creationThread = Thread.currentThread();
            assert (this.toString() != null);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public PointValues getValues(String field) throws IOException {
            PointValues values;
            FieldInfo fi = this.fis.fieldInfo(field);
            assert (fi != null && fi.getPointDimensionCount() > 0);
            if (this.merging) {
                AssertingCodec.assertThread("PointsReader", this.creationThread);
            }
            if ((values = this.in.getValues(field)) == null) {
                return null;
            }
            return new AssertingLeafReader.AssertingPointValues(values, this.maxDoc);
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public PointsReader getMergeInstance() {
            return new AssertingPointsReader(this.maxDoc, this.in.getMergeInstance(), this.fis, true);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.in.toString() + ")";
        }
    }
}

