/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export default {
    message: {
        common: {
            lang: 'English',
            statisticsTime: '统计日期',
            fullScreen: '全屏',
            log: '日志',
            diagnosis: '智能诊断',
            watermaskText: '由DataWorkShop生成，仅供内部参考，严禁对外分享',
            filter: '过滤',
            saveToWidget: '保存widget到解决方案',
            script: '脚本',
            refresh: '刷新',
            download: '下载',
            submit: '确定',
            saveSuccess: '保存成功',
            detail: '详情',
            FAQ: '常见问题',
            clearCache: '清理缓存',
            logOut: '退出登录',
            action: '操作',
            path: '请选择路径',
            resultList: '结果集',
            process: '任务ID',
            ok: '确认',
            add: '新增',
            cancel: '取消',
            delete: '删除',
            failedNotice: '验证项未通过，请检查后再试！',
            logoName: 'Linkis',
            project: '工程',
            home: '首页',
            management: '管理台',
            bbs: '论坛',
            feedback: '反馈',
            exceptionTips: '后台接口异常，请联系开发处理！',
            separator: {
                comma: '逗号',
                tab: 'tab键',
                semicolon: '分号',
                space: '空格',
                vertical: '竖线',
            },
            tabs: {
                progress: '进度',
                result: '运行结果',
                log: '运行日志',
                history: '历史',
                diagnosis: '智能诊断',
            },
            notice: {
                unsave: {
                    title: '提醒',
                    desc: '您的临时脚本已修改，请注意保存！',
                },
                sendStart: {
                    title: '运行提示',
                    render: '开始执行脚本',
                },
                querySuccess: {
                    title: '执行结果提示',
                    render: '脚本执行成功，共耗时',
                },
                notice: {
                    title: '执行结果提示',
                },
                kill: {
                    title: '运行提示',
                    desc: '已经停止执行脚本',
                },
            },
            steps: {
                title: 'Job状态',
                stepsInfo: {
                    Submitted: '任务已提交',
                    Inited: '排队中',
                    Scheduled: '资源申请中',
                    Running: '脚本运行中',
                    Succeed: '成功',
                    ResultLoading: '读取结果集中',
                    Completed: '完成',
                    Failed: '执行失败',
                    Cancelled: '已取消',
                    FailedToGetResult: '获取结果集失败',
                    FailedToGetResultPath: '获取结果集路径失败',
                    FailedToGetResultList: '获取结果集列表失败',
                    FailedToGetResultFirst: '获取第一个结果集失败',
                    WaitForRetry: '等待重试',
                    FailedToApply: '申请资源失败',
                    FailedToExecute: '执行失败',
                    notResult: '未生成结果集',
                },
                hoverList: {
                    first: '1.获取结果集路径成功...',
                    second: '2.获取结果集列表成功...',
                },
            },
            resultsExport: {
                header: '结果集导出',
                formItems: {
                    name: {
                        label: '导出名称',
                        placeholder: '请输入导出名称……',
                        title: '导出后缀可在管理台-常用功能-设置-应用级-pipeline中设置！',
                    },
                    path: {
                        label: '存储路径',
                        title: '结果集导出',
                        isSheet: '是否将多个结果集导出到excel的不同sheet',
                    },
                },
                rules: {
                    name: {
                        required: '请输入名称',
                        lengthLimit: '长度在1到200个字符',
                        letterTypeLimit: '仅支持中文、大小写字母、数字和下划线',
                    },
                    path: {
                        required: '请选择导出路径！',
                    },
                },
            },
            progress: {
                title: '运行进度',
                watingList: '前面还有 {num} 个job在等待',
                columns: {
                    id: {
                        title: '名称',
                    },
                    progress: {
                        title: '进度条',
                    },
                    taskNum: {
                        title: '任务数',
                        status: {
                            running: '运行中',
                            success: '成功',
                            fail: '失败',
                            totalTasks: '总任务',
                        },
                    },
                },
            },
            execute: {
                waitingQueue: '前面还有 {num} 个job',
                error: {
                    getResultList: '获取结果集失败，请联系管理员！',
                    queryTimeout: '查询超时，请重新执行！',
                    noResultList: '脚本未生成结果集！',
                    errorLog: '获取结果集失败，请联系管理员！',
                    failed: '执行失败，请到日志中查看错误原因，或将历史中的关键信息反馈给管理员！',
                    canceled: '查询已被取消！',
                    executeTimeout:
                        '查询超时，请到日志中查看错误原因，或将历史中的关键信息反馈给管理员！',
                },
                success: {
                    getResultList: '获取结果集成功！',
                    stateEnd: '任务执行完成，正在获取结果集！',
                },
            },
            functionView: {
                formItems: {
                    name: '函数名称',
                    createUser: '创建人/部门',
                    updateTime: '修改时间',
                    useFormat: '使用格式',
                    description: '函数描述',
                },
            },
            navBar: {
                addTitle: '新建目录',
                dataStudio: {
                    outTable: '导出表',
                    importHive: '导入hive',
                    addTitle: '新建目录',
                    searchPlaceholder: '请输入文件夹或文件名搜索',
                },
                workSpace: {
                    searchPlaceholder: '请输入文件夹或文件名搜索',
                },
                database: {
                    searchPlaceholder: '请输入数据库或表名搜索',
                },
                fnSideBar: {
                    searchPlaceholder: '请输入文件夹或函数名称搜索',
                },
                hdfs: {
                    searchPlaceholder: '请输入文件夹或函数名称搜索',
                },
            },
            monacoMenu: {
                YXJB: '运行脚本',
                GSH: '格式化',
                CZ: '查找',
                TH: '替换',
                HZS: '行注释',
                ZT: '粘贴',
                HBQWJCFZWB:
                    '很抱歉，IDE未监控到复制文本，如果您是在IDE系统外执行的复制操作，请使用ctrl+v组合键进行粘贴！',
                TDZDH: '跳到指定行',
                GBYFJC: '关闭语法检查',
                DKYFJC: '打开语法检查',
                GYFSYGWYF: '该语法属于高危语法，请谨慎操作！',
            },
            resourceSimple: {
                YS: 'Scriptis',
                FL: '分类',
                ZH: 'Visualis',
                FLOW1: '实时工作流',
                FLOW2: '调度系统',
                ZWSJ: '暂无数据',
                KX: '空闲',
                FM: '繁忙',
                QD: '启动',
                LX: '按类别',
                AZT: '按状态',
                DDJK: '请等待接口返回！',
                QDYQWFJS: '启动状态引擎无法结束！',
                WXZYQ: '未选中引擎！',
                RWGLQ: '任务管理器',
                YQGLQ: '引擎管理器',
                DLGLQ: '队列管理器',
                QX: '全选',
                QXQX: '取消全选',
                SX: '刷新',
                JSRW: '结束任务',
                JSYQ: '结束引擎',
                PDZ: '排队中',
                ZYSQ: '资源申请中',
                YX: '运行',
                YQ: '引擎',
                RW: '任务',
                WZJBMC: '未知脚本名称',
                ZHJB: '知画脚本',
                GZLJB: '工作流脚本',
                YQRW: '引擎和任务',
                JSYQRW: '结束引擎和任务',
                CKJBXX: '查看脚本信息',
                FZJBXX: '复制脚本信息',
                QXZYTJL: '请选择一条记录！',
                WHQD: '任务正在初始化，暂不能进行kill，请等候任务初始化完成',
                WHQDENGINE: '未获取到engineInstance，请联系管理员查看！',
                YXTS: '运行提示',
                YJTZZXJB: '已经停止执行脚本',
                JSYQHRWCG: '结束引擎和任务成功',
                DKCG: '打开成功',
                JBFZDZTRB: '脚本信息已复制到粘贴板，请使用ctrl+v组合键粘贴！',
                XZDL: '请选择队列',
                ZYSYL: '资源使用率',
                H: '核',
                NC: '内存',
                ZYSYPHB: '资源使用排行榜',
                ZW: '暂无',
            },
            headerNavBar: {
                Workflow: '工作流开发',
                Exchangis: '数据交换组件',
                Scriptis: '数据开发组件',
                Qualitis: '数据治理组件',
                Visualis: '可视化组件',
                Schedulis: '工作流调度组件',
                LinkisConsole: 'Linkis 管理台',
            },
            userMenu: {
                title: '警告',
                content:
                    '<p>此操作将清空本地数据库缓存，这样会丢失您的脚本日志、历史和结果集等相关信息，请确认是否有未保存的脚本！</p><p>点击确认按钮继续操作？</p>',
                clearCacheSuccess: '清除本地数据缓存成功!',
                comingSoon: '尚未开源，敬请期待！',
            },
            login: {
                loginTitle: '欢迎登录Linkis系统！',
                userName: '请输入用户名',
                remember: '记住当前用户',
                login: '登录',
                passwordHint: '请输入密码！',
                loginSuccess: '登录成功',
                haveLogin: '您已经登录，请不要重复登录',
                vaildFaild: '验证未通过！',
                selectProxyTip: '用户代理未选择！',
                logoutSuccess: '您已成功退出'
            },
            dynamicForm: {
                rule: {
                    emptyKey: 'key为空',
                    lengthLimit: '长度超过128字符',
                    nameVaild: '仅支持以字母开头，且不得存在空格和中文',
                    emptyValue: 'value为空',
                },
                namePlaceholder: '请输入{title}名称',
                placeholderInput: '请输入值',
                someKey: '存在同名key',
            },
            deleteDialog: {
                waring: '警告',
                action: '是',
                isNext: '是否继续？',
                overThe: '结束该',
                engine: '引擎',
                task: '任务',
                engineAndTask: '引擎和任务',
            },
            tableRow: {
                detail: '选中行详情',
                search: '搜索……',
                columnName: '列名',
                value: '值',
                dataType: '数据类型',
            },
            toolbar: {
                replace: '请选择替换空值：',
                emptyString: '空字符串',
                analysis: '可视化',
                window: '可视化窗口',
                export: '导出',
                format: '请选择下载格式：',
                exportFormat: '导出格式：',
                coding: '请选择编码：',
                model: '请选择分析模式',
                graphAnalysis: '图表分析',
                excelAnalysis: 'Excel分析',
                lineFilter: '列筛选',
                resultGroupLineFilter: '对结果集的列进行筛选',
                resultGroup: '结果集',
                all: '是否全量',
                allDownLoad: '所有结果集',
                autoFormat: '自动格式化',
                downloadMode: '下载方式：',
                deepAnalysis: '分 析 进 阶',
                success: {
                    download: '下载成功，请到本地的download文件夹查看！',
                },
                rowToColumn: '行转列',
                rowToColumnTitle: '查看当前行详情',
                selectSeparator: '请选择自定义分隔符：',
            },
            time: {
                SEC: ' 秒',
                MIN: ' 分',
                HOUR: ' 时',
                DAY: ' 日',
                WEEK: ' 周',
                MONTH: ' 月',
                YEAR: ' 年',
                Mon: '星期一',
                Tue: '星期二',
                Wed: '星期三',
                Thu: '星期四',
                Fri: '星期五',
                Sat: '星期六',
                Sun: '星期日',
                second: '秒',
                minute: '分钟',
                hour: '小时',
                day: '天',
            },
            warning: {
                api: '接口请求中，请稍候！',
                data: '数据请求中，请稍候！',
                waiting: '请等待接口返回！',
                biLoading: '正在和Visualis系统通讯，请稍候！',
                comingSoon: '尚未开源，敬请期待！',
            },
        },
        linkis: {
            id: '序号',
            sourceInfo: '来源信息',
            refresh: '刷新',
            engineConfig: '引擎配置',
            engineNumber: '引擎数量',
            globalConfigs: '全局配置',
            applicationDesc: '应用描述',
            applicationName: '应用名称',
            applicationAndEngine: '应用及引擎管理',
            addApplicationAndEngine: '添加应用及引擎',
            editApplicationAndEngine: '编辑应用及引擎',
            failedToAddCreator: '应用添加失败',
            successfullyAddCreator: '应用添加成功',
            nonRepetitiveEngines: '请勿添加重复的引擎',
            failedToGetCategoryId: '应用id获取失败',
            successfullyAddEngine: '引擎添加成功',
            failedToAddEngine: '引擎添加失败',
            failedToUpdateCreator: '应用描述更新失败',
            successfullyUpdateCreator: '应用描述更新成功',
            failedToUpdateEngine: '引擎描述更新失败',
            successfullyUpdateEngine: '引擎描述更新成功',
            confirmToDeleteCreator: '确认删除该应用吗？',
            confirmToModifyCreator: '确认执行该操作吗？',
            globalTaskQuery: '全局任务查询',
            batchStop: '批量停止',
            confirmToStop: '确认停止',
            placeholderZip: '请输入工作空间python包路径（只支持zip）!',
            emptyString: '空字符串',
            addAppType: '新增应用类型',
            editContents: '编辑目录',
            ConfirmEdit: '完成编辑',
            serviceRegistryCenter: '服务注册中心',
            addParameterConfig: '新增参数配置',
            addEngineType: '新增引擎类型',
            editDescriptionEngineConfig: '编辑引擎配置',
            name: '名称',
            order: '顺序',
            description: '描述',
            noDescription: '暂无描述',
            addTags: '添加标签',
            labelEmptyError: '标签不能为空',
            labelNoSpecialSymbol: '不得存在空格和中文',
            labelLengthLimit: '标签内容长度不超过16',
            find: '查询',
            initiator: '创建者',
            inputOwnerHint: '请输入创建者',
            jumpPage: '请在跳转页面查看……',
            editedSuccess: '修改成功',
            errorCode: '错误码',
            errorDescription: '错误描述',
            notLog: '未获取到日志！',
            unfold: '展开',
            fold: '收起',
            addVariable: '新增变量',
            defaultValue: '默认值',
            noDefaultValue: '无默认值',
            stop: '停止',
            tip: '提示',
            serverTip: '无结果集（resultLocation:null）',
            stopEngineTip: '请问确认要停止当前引擎？',
            log: '任务日志',
            detail: '任务详情',
            result: '任务结果',
            startUp: '启动',
            tagEdit: '编辑',
            tipForKill: '将要停止此ECM实例 【{instance}】上的空闲引擎',
            killAll: '停止空闲引擎',
            allEngine: '包含多用户引擎？',
            killFinishedInfo:
                '预计停止{killEngineNum}个引擎, 将释放 ECM {cores}cores,{memory}G 资源',
            noDataTextBeforeSearch: '请输入执行代码进行查询',
            noDataTextAfterSearch: '暂无数据',
            yes: '是',
            no: '否',
            keyTip: '不能为空',
            rename: '重命名',
            resources: '资源',
            instanceNum: '实例数',
            instanceName: '实例名称',
            reset: '重置',
            clearSearch: '清空',
            showOperations: '显示操作',
            hide: '隐藏操作',
            resetAll: '全部重置',
            remove: '移除',
            submit: '确定',
            search: '搜索',
            save: '保存',
            edit: '编辑',
            cancel: '取消',
            create: '新建',
            noDataText: '暂无数据',
            noLog: '暂无运行日志',
            jobId: '任务ID',
            userName: '用户名',
            password: '密码',
            unselect: '请选择',
            noselection: '请先选择',
            searchName: '请输入用户名搜索',
            generalView: '切换普通视图',
            manageView: '切换管理员视图',
            back: '返回',
            prev: '上一步',
            complete: '完成',
            close: '关闭',
            udfName: 'UDF名称',
            udfType: 'UDF类型',
            nextPage: '下一页',
            previousPage: '上一页',
            all: '全部',
            common: '通用',
            tenant: '租户标签',
            inputTenant: '请输入租户标签',
            globalSettings: '全局配置',
            downloadLogs: '下载日志',
            downloadLogsConfirm: '确认要下载日志吗？',
            resultSet: {
                prefixText: '因为您的结果集较大，为了更好的体验，',
                linkText: '点击查看结果集',
                largeResultTips: '前端只展示5000条数据',
            },
            needPre: '需要先选择分类和输入用户名',
            warning: {
                api: '接口请求中，请稍候！',
                data: '数据请求中，请稍候！',
                waiting: '请等待接口返回！',
                biLoading: '正在和Visualis系统通讯，请稍候！',
                comingSoon: '尚未开源，敬请期待！',
            },
            resourceManagement: {
                resourceUsage: '资源使用情况',
                applicationList: '应用列表',
            },
            tableColumns: {
                instanceName: '实例名称',
                initiator: '启动者',
                engineInstance: '引擎实例',
                engineType: '引擎类型',
                serveType: '服务类型',
                appType: '应用类型',
                taskID: '任务ID',
                fileName: '来源',
                executionCode: '查询语句',
                status: '状态',
                costTime: '已耗时',
                label: '标签',
                editLabel: '编辑标签',
                engineVersion: '引擎版本',
                engineVersionCannotBeNull: '引擎版本不能为空',
                addApplicationRules: '应用名称不能有特殊符号和空格',
                usedResources: '已用资源',
                lockedResource: '上锁资源',
                maximumAvailableResources: '最大可用资源',
                minimumAvailableResources: '最小可用资源',
                startTime: '启动时间',
                executeApplicationName: '引擎',
                requestApplicationName: '应用',
                user: '用户',
                createdTime: '创建时间',
                updateTime: '更新时间',
                failedReason: '关键信息',
                control: {
                    title: '操作',
                    label: '查看'
                },
                queenRemain: '队列剩余资源',
                queueUsed: '队列已用资源',
                queueTop: '队列上限资源',
                engineRemain: '引擎剩余资源',
                engineUsed: '引擎已用资源',
                engineTop: '引擎上限资源',
                versionTips: '如果没有对应的版本，请确认是否已安装对应的版本引擎物料',
                applicationRole: '应用方'
            },
            logLoading: '日志请求中，请稍后',
            title: 'Linkis管理台',
            info: '{num} 条新消息',
            hint: '请在跳转页面查看……',
            sideNavList: {
                news: {
                    name: '最新动态',
                    children: {
                        daily: '运营日报',
                    },
                },
                function: {
                    name: '常用功能',
                    children: {
                        globalHistory: '任务概览',
                        resource: '资源管理',
                        resourceEngineConnList: '历史引擎',
                        setting: '参数配置',
                        globalVariable: '全局变量',
                        ECMManage: 'ECM管理',
                        microserviceManage: '微服务管理',
                        udfFunctionTitle: 'UDF函数',
                        udfFunctionManage: 'UDF管理',
                        functionManagement: '函数管理',
                        dataSourceManage: '数据源管理',
                        userResourceManagement: '用户资源管理',
                        tenantTagManagement: '租户标签管理',
                        ipListManagement: '白名单管理',
                        errorCode: '错误码管理',
                        gatewayAuthToken: '令牌管理',
                        rmExternalResourceProvider: '扩展资源管理',
                        configManagement: '配置项管理',
                        udfManager: '用户管理',
                        udfTree: 'UDF分类',
                        datasourceAccess: '数据源权限',
                        datasourceEnv: '数据源环境',
                        datasourceType: '数据源分类',
                        datasourceTypeKey: '数据源配置项',
                        EnginePluginManagement: '引擎物料管理',
                        basedataManagement: '基础数据管理',
                        codeQuery: '代码检索',
                        engineConfigurationTemplate: '引擎配置模板',
                        EngineConnList: '引擎列表',
                    },
                },
            },
            modal: {
                modalTitle: '提示信息',
                modalDelete: '确认是否删除[{name}]项?',
                modalDeleteRecord: '确认是否删除该记录?',
                modalDeleteTask: '确认是否停止当前选择任务?',
                modalDeleteInstance: '确认是否停止当前选择实例?',
                modalDeleteSuccess: '删除成功',
                modalDeleteFail: '删除失败',
            },
            formItems: {
                id: {
                    placeholder: '请输入ID搜索',
                },
                date: {
                    label: '起始时间',
                    placeholder: '请选择起始日期',
                },
                instance: {
                    label: '实例',
                    placeholder: '请输入实例',
                },
                creator: {
                    label: '应用',
                    placeholder: '请输入应用搜索',
                },
                engine: {
                    label: '引擎',
                },
                status: {
                    label: '状态',
                },
                appType: '应用类型',
                engineType: '引擎类型',
            },
            columns: {
                taskID: '任务ID',
                execId: '任务名',
                fileName: '脚本名称',
                executionCode: '查询语句',
                status: '状态',
                costTime: '已耗时',
                failedReason: '关键信息',
                executeApplicationName: '引擎',
                requestApplicationName: '应用',
                umUser: '创建人',
                progress: '进度',
                createdTime: '创建时间',
                updatedTime: '最后更新时间',
                control: {
                    title: '操作',
                    label: '查看',
                },
                moduleName: '模块名称',
                totalResource: '总资源',
                usedResource: '已用资源',
                initializingResource: '初始化中资源',
                memory: '内存',
                engineInstance: '引擎实例',
                applicationName: '应用名称',
                usedTime: '开始时间',
                engineStatus: '状态',
                username: '用户名',
            },
            shortcuts: {
                today: '今天',
                week: '近7天',
                month: '近30天',
            },
            statusType: {
                all: '全部',
                inited: '排队中',
                running: '运行中',
                succeed: '运行成功',
                cancelled: '取消',
                failed: '失败',
                scheduled: '资源申请中',
                timeout: '超时',
                retry: '重试',
                unknown: '未知',
            },
            countList: {
                all: '任务总数',
                succeed: '成功',
                inited: '排队中',
                running: '运行中',
                failed: '失败',
                others: '其他',
            },
            header: '资源管理器',
            tabs: {
                first: '用户会话',
                second: '用户资源',
                third: '服务器资源',
            },
            noLimit: '无限制',
            core: '核',
            row: {
                applicationName: '应用名称',
                usedTime: '开始时间',
                engineStatus: '状态',
                engineInstance: '引擎实例',
                queueName: '队列名称',
                user: '用户',
                cpu: '已用的服务器CPU资源',
                memory: '已用的服务器内存资源',
                queueCpu: '已用的Yarn队列CPU资源',
                queueMemory: '已用的Yarn队列内存资源',
            },
            setting: {
                global: '全局',
                globalSetting: '通用设置',
                hide: '隐藏',
                show: '显示',
                advancedSetting: '高级设置',
                dataDev: '数据开发',
            },
            globalVariable: '全局变量',
            rules: {
                first: {
                    required: '变量 {text} 的key为空',
                    lengthLimit: '长度应为 1 至 128 个字符',
                    letterTypeLimit: '仅支持以字母开头，且不得存在空格和中文',
                    placeholder: '请输入变量名',
                },
                second: {
                    required: '变量 {text} 的value为空',
                    lengthLimit: '长度应为 1 至 128 个字符',
                    placeholder: '请输入变量值',
                },
            },
            addArgs: '增加参数',
            emptyDataText: '暂无全局变量数据',
            sameName: '存在同名key',
            error: {
                validate: '有验证项未通过，请检查后再试！',
            },
            success: {
                update: '全局变量更新成功！',
            },
            searchAppType: '请输入应用类型',
            resetTip: '是否确认重置该资源?',
            resetAllTip:
                '是否重置全部用户资源(该操作只会清理用户资源记录，不清理已经产生的资源)',
            viewlog: '查看日志',
            datasource: {
                pleaseInput: '请输入',
                pleaseUpload: '请上传',
                datasourceSrc: '数据源',
                connectTest: '测试连接',
                sourceName: '数据源名称',
                sourceDec: '数据源描述',
                sourceType: '数据源类型',
                creator: '创建人',
                create: '新增数据源',
                exports: '批量导出数据源',
                imports: '批量导入数据源',
                overdue: '过期',
                versionList: '版本列表',
                dataSourceName: '数据源名称',
                dataSourceType: '数据源类型',
                createSystem: '创建系统',
                dataSourceEnv: '可用集群',
                status: '状态',
                permissions: '权限',
                label: '标签',
                version: '版本',
                desc: '描述',
                action: '操作',
                createUser: '创建人',
                createTime: '创建时间',
                versionDec: '版本描述',
                watch: '查看',
                rollback: '回滚',
                publish: '发布',
                initVersion: '初始化版本',
                updateVersion: '版本更新',
                published: '已发布',
                unpublish: '未发布',
                cannotPublish: '不可发布',
                used: '可用',
                commentValue: '从版本 {text} 回滚',
            },
            tenantTagManagement: {
                userName: '用户名',
                appName: '应用名',
                tenantTag: '租户标签',
                search: '搜索',
                clear: '清空',
                create: '新增',
                userCreator: '用户-应用',
                createUser: '创建人',
                createTime: '创建时间',
                desc: '业务来源',
                inputUser: '请输入用户名',
                inputApp: '请输入应用名',
                inputTenant: '请输入租户标签',
                inputDesc: '请输入业务来源',
                inputCreateUser: '请输入创建者',
                yourTagMapping: '您的标签映射',
                notEmpty: '不能为空',
                maxLen: '长度不能超过100',
                contentError: '仅限英文、数字、星号和下划线',
                contentError1: '仅限英文、数字和下划线',
                contentError2: '仅限英文、数字、下划线和横线',
                check: '检查',
                OK: '确定',
                Cancel: '取消',
                action: '操作',
                edit: '编辑',
                delete: '删除',
                userIsExisted: '用户标签已存在',
                addSuccessful: '添加成功',
                confirmDel: '确认删除',
                isConfirmDel: '确定要删除这条数据吗({name})',
            },
            ipListManagement: {
                userName: '用户名',
                appName: '应用名',
                ipList: 'IP列表',
                search: '搜索',
                clear: '清空',
                create: '新增',
                userCreator: '用户-应用',
                createUser: '创建人',
                createTime: '创建时间',
                desc: '业务来源',
                inputUser: '请输入用户名',
                inputApp: '请输入应用名',
                inputIpList: '请输入IP列表',
                inputDesc: '请输入业务来源',
                inputCreateUser: '请输入创建者',
                yourTagMapping: '您的标签映射',
                notEmpty: '不能为空',
                maxLen: '长度不能超过100',
                contentError: '仅限英文、数字、星号和下划线',
                contentError1: '仅限英文、数字和下划线',
                contentError2: '仅限英文、数字、下划线和横线',
                ipContentError: '请输入正确格式的IP地址(多个IP地址通过,分隔)',
                check: '检查',
                OK: '确定',
                Cancel: '取消',
                action: '操作',
                edit: '编辑',
                delete: '删除',
                userIsExisted: '用户标签已存在',
                addSuccessful: '添加成功',
                confirmDel: '确认删除',
                isConfirmDel: '确定要删除这条数据吗({name})',
            },
            basedataManagement: {
                add: '新增',
                remove: '删除',
                edit: '编辑',
                searchLabel: '模糊搜索:',
                searchPlaceholder: '请输入搜索内容',
                search: '搜索',
                action: '操作',
                categoryMaxLength: '分类名长度不能超过100',
                tableId: '表ID',
                applicationId: '应用ID',
                visitor: '访问者',
                field: '字段',
                accessTime: '访问时间',
                modal: {
                    confirm: '确定',
                    cancel: '取消',
                    modalTitle: '提示信息',
                    modalFormat: '确定删除 {0} 这条记录?',
                    modalDelete1: '确认是否删除[{name}]该记录?',
                    modalDelete: '确认是否删除[{name}]该记录?',
                    modalDeleteSuccess: '删除成功',
                    modalDeleteFail: '删除失败',
                    modalAddSuccess: '添加成功',
                    modalAddFail: '添加失败',
                    modalEditSuccess: '编辑成功',
                    modalEditFail: '编辑失败',
                },
                addUDFAdmin: '新增UDF管理员',
                gatewayAuthToken: {
                    tokenName: '名称',
                    legalUsers: '用户',
                    legalHosts: '主机',
                    elapseDay: '有效天数',
                    permanentlyValid: '永久有效',
                    businessOwner: '所属者',
                    createTime: '创建时间',
                    updateTime: '更新时间',
                    updateBy: '更新人',
                    searchPlaceholder: '令牌名称/用户/主机',
                    info: '有效天数: -1 表示永久',
                    legalUsersInfo:
                        '*允许所有用户；多用户使用,隔开，例如:user1,user2',
                    legalUsersValidate: {
                        empty: '请填写用户',
                        format: '格式不正确，使用*或使用,分割，例如:user1,user2',
                    },
                    legalHostsInfo:
                        '*允许所有主机；多主机使用,隔开，例如:host1,host2',
                    legalHostsInfoValidate: {
                        empty: '请填写主机',
                    },
                    elapseDayValidate: {
                        format: '格式不正确，使用*或使用,分割，例如:host1,host2',
                        empty: '请填写有效天数',
                        GT0: '有效天数必须大于0',
                    },
                },
                errorCode: {
                    errorCode: '错误代码',
                    errorDesc: '错误描述',
                    errorRegex: '错误正则',
                    searchPlaceholder: '代码/描述/正则',
                },
                rmExternalResourceProvider: {
                    resourceType: '资源类型',
                    name: '名称',
                    labels: '标签',
                    config: '配置信息',
                    searchPlaceholder: '名称/标签/配置',
                },
                udfManager: {
                    userName: '用户名',
                    searchPlaceholder: '用户名',
                    userNameValidate: {
                        size: '用户名长度不能超过20个字符',
                        empty: '请输入用户名',
                    },
                },
                udfTree: {
                    name: '名称',
                    category: '分类',
                    userName: '用户名',
                    description: '描述',
                    parent: '父级',
                    createTime: '创建时间',
                    updateTime: '更新时间',
                    searchPlaceholder: '名称/分类/描述/用户名',
                    parentInfo: '父级分类，Root为根目录',
                },
                datasourceEnv: {
                    envName: '环境名称',
                    envDesc: '环境描述',
                    name: '数据源名称',
                    datasourceType: '数据源类型',
                    keytab: 'kerboros认证',
                    parameter: '参数',
                    createTime: '创建时间',
                    createUser: '创建者',
                    updateTime: '更新时间',
                    modifyUser: '更新者',
                    searchPlaceholder: '环境名称/环境描述/参数',
                },
                engineConfigurationTemplate: {
                    engineLabelId: '引擎类型ID',
                    advanced: '是否优先',
                    defaultValue: '默认值',
                    description: '描述',
                    engineConnType: '引擎类型',
                    key: '键值',
                    level: '等级',
                    name: '名称',
                    treeName: '树名称',
                    validateRange: '验证范围',
                    validateType: '验证类型',
                    hidden: '隐藏',
                    id: 'ID',
                    engineLabelList: '引擎类型列表',
                    yes: '是',
                    no: '否',
                    delSuccess: '删除成功',
                    delFail: '删除失败',
                    edit: '编辑',
                },
                datasourceType: {
                    name: '名称',
                    description: '描述',
                    option: '选项',
                    classifier: '分类',
                    icon: '图标',
                    layers: '层级',
                    searchPlaceholder: '名称/描述/分类',
                    layersValidate: {
                        range: '最小为0',
                    },
                },
                datasourceTypeKey: {
                    key: '键名',
                    dataSourceType: '数据源类型',
                    name: '名称',
                    nameEn: '名称(英文)',
                    valueType: '值类型',
                    defaultValue: '默认值',
                    scope: '范围',
                    require: '必要字段',
                    description: '描述',
                    descriptionEn: '描述(英文)',
                    valueRegex: '值校验规则',
                    createTime: '创建时间',
                    updateTime: '更新时间',
                    searchPlaceholder: '名称',
                    searchName: '名称',
                    searchType: '类型',
                    all: '全部',
                },
            },
            EnginePluginManagement: {
                engineConnType: '引擎类型',
                engineConnVersion: '引擎版本',
                create: '新增引擎插件',
                fileName: '文件名称',
                fileSize: '文件大小',
                lastModified: '文件更新时间',
                bmlResourceId: '物料资源Id',
                bmlResourceVersion: '物料资源版本',
                lastUpdateTime: '更新时间',
                createTime: '创建时间',
                Reset: '重置',
                delete: '删除已选物料的版本',
                update: '更新引擎插件',
                updateFileOnly: '更新',
                resourceVersion: '引擎物料bml版本',
                user: '所属人',
                deleteCurrentbml: '删除',
                versionList: '版本列表',
                rollback: '回滚',
                action: '操作',
            },
            codeQuery: {
                executionCode: '执行代码',
                dateRange: '时间范围',
                placeholder: {
                    executionCode: '请输入执行代码',
                    dateRange: '时间范围',
                    status: '状态',
                },
                inputCode: '请输入执行代码',
                id: '任务ID',
                code: '代码',
                check: '查看',
                search: '搜索',
                clear: '清空',
                status: '状态',
                submitUser: '提交用户',
                createdTime: '创建时间',
                searchRange: '仅可查询T-1的历史代码',
            },
            task: {
                projectName: '项目名称',
                workflowName: '工作流名称',
                workflowIp: '工作流IP',
            },
        },
    },
};
