/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import java.util.Map;
import java.util.Objects;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.message.MailboxName;
import org.apache.james.mailbox.model.MailboxACL;

public final class ACLResponse
implements ImapResponseMessage {
    private final MailboxACL acl;
    private final MailboxName mailboxName;

    public ACLResponse(MailboxName mailboxName, MailboxACL acl) {
        this.mailboxName = mailboxName;
        this.acl = acl;
    }

    public MailboxACL getAcl() {
        return this.acl;
    }

    public MailboxName getMailboxName() {
        return this.mailboxName;
    }

    public final boolean equals(Object o) {
        if (o instanceof ACLResponse) {
            ACLResponse other = (ACLResponse)o;
            return Objects.equals(this.acl, other.acl) && Objects.equals(this.mailboxName, other.mailboxName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.acl, this.mailboxName);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("ACL").append(' ').append(this.mailboxName);
        for (Map.Entry en : this.acl.getEntries().entrySet()) {
            result.append(' ').append(((MailboxACL.EntryKey)en.getKey()).toString()).append(' ').append(((MailboxACL.Rfc4314Rights)en.getValue()).toString());
        }
        return result.toString();
    }
}

