/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.lib;

import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.SieveRepositoryManagementMBean;
import org.apache.james.sieverepository.api.exception.SieveRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SieveRepositoryManagement
extends StandardMBean
implements SieveRepositoryManagementMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SieveRepositoryManagement.class);
    private SieveRepository sieveRepository;

    public SieveRepositoryManagement() throws NotCompliantMBeanException {
        super(SieveRepositoryManagementMBean.class);
    }

    @Inject
    public void setSieveRepository(SieveRepository sieveRepository) {
        this.sieveRepository = sieveRepository;
    }

    public long getQuota() throws SieveRepositoryException {
        return this.sieveRepository.getDefaultQuota().asLong();
    }

    public void setQuota(long quota) throws SieveRepositoryException {
        this.sieveRepository.setDefaultQuota(QuotaSizeLimit.size((long)quota));
    }

    public void removeQuota() throws SieveRepositoryException {
        this.sieveRepository.removeQuota();
    }

    public long getQuota(String user) throws SieveRepositoryException {
        return this.sieveRepository.getQuota(Username.of((String)user)).asLong();
    }

    public void setQuota(String user, long quota) throws SieveRepositoryException {
        this.sieveRepository.setQuota(Username.of((String)user), QuotaSizeLimit.size((long)quota));
    }

    public void removeQuota(String user) throws SieveRepositoryException {
        this.sieveRepository.removeQuota(Username.of((String)user));
    }

    public void addActiveSieveScript(String userName, String scriptName, String script) throws SieveRepositoryException {
        Username username = Username.of((String)userName);
        this.sieveRepository.putScript(username, new ScriptName(scriptName), new ScriptContent(script));
        this.sieveRepository.setActive(username, new ScriptName(scriptName));
    }

    public void addActiveSieveScriptFromFile(String userName, String scriptName, String scriptPath) throws SieveRepositoryException {
        try (FileInputStream scriptFileAsStream = new FileInputStream(scriptPath);){
            this.addActiveSieveScript(userName, scriptName, IOUtils.toString((InputStream)scriptFileAsStream, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOGGER.error("Error while reading sieve script from file {}", (Object)scriptPath, (Object)e);
        }
    }
}

