/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class SetTTLStatement
extends Statement
implements IConfigStatement {
    protected PartialPath path;
    protected long ttl;

    public SetTTLStatement() {
        this.statementType = StatementType.TTL;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public long getTTL() {
        return this.ttl;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitSetTTL(this, context);
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return this.path != null ? Collections.singletonList(this.path) : Collections.singletonList(new PartialPath(new String[]{"root", "**"}));
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathOrPatternListPermission(userName, checkedPaths, PrivilegeType.WRITE_SCHEMA), checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }
}

