/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.AggregationDecorrelation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AssignUniqueId;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanNodeDecorrelator;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.Type;

public class TransformCorrelatedGroupedAggregationWithProjection
implements Rule<CorrelatedJoinNode> {
    private static final Capture<ProjectNode> PROJECTION = Capture.newCapture();
    private static final Capture<AggregationNode> AGGREGATION = Capture.newCapture();
    private static final Capture<PlanNode> SOURCE = Capture.newCapture();
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Patterns.CorrelatedJoin.type().equalTo(JoinNode.JoinType.INNER)).with(Pattern.nonEmpty(Patterns.CorrelatedJoin.correlation())).with(Patterns.CorrelatedJoin.filter().equalTo(BooleanLiteral.TRUE_LITERAL)).with(Patterns.CorrelatedJoin.subquery().matching(Patterns.project().capturedAs(PROJECTION).with(Patterns.source().matching(Patterns.aggregation().with(Pattern.nonEmpty(Patterns.Aggregation.groupingColumns())).matching(aggregation -> aggregation.getGroupingSetCount() == 1).with(Patterns.source().capturedAs(SOURCE)).capturedAs(AGGREGATION)))));
    private final PlannerContext plannerContext;

    public TransformCorrelatedGroupedAggregationWithProjection(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        PlanNode source = captures.get(SOURCE);
        AggregationNode distinct = null;
        PlanNodeDecorrelator decorrelator = new PlanNodeDecorrelator(this.plannerContext, context.getSymbolAllocator(), context.getLookup());
        Optional<PlanNodeDecorrelator.DecorrelatedNode> decorrelatedSource = decorrelator.decorrelateFilters(source, correlatedJoinNode.getCorrelation());
        if (!decorrelatedSource.isPresent()) {
            if (AggregationDecorrelation.isDistinctOperator(source)) {
                distinct = (AggregationNode)source;
                source = distinct.getChild();
                decorrelatedSource = decorrelator.decorrelateFilters(source, correlatedJoinNode.getCorrelation());
            }
            if (!decorrelatedSource.isPresent()) {
                return Rule.Result.empty();
            }
        }
        source = decorrelatedSource.get().getNode();
        AssignUniqueId inputWithUniqueId = new AssignUniqueId(context.getIdAllocator().genPlanNodeId(), correlatedJoinNode.getInput(), context.getSymbolAllocator().newSymbol("unique", (Type)BooleanType.getInstance()));
        JoinNode join = new JoinNode(context.getIdAllocator().genPlanNodeId(), JoinNode.JoinType.INNER, inputWithUniqueId, source, (List<JoinNode.EquiJoinClause>)ImmutableList.of(), Optional.empty(), ((PlanNode)inputWithUniqueId).getOutputSymbols(), source.getOutputSymbols(), decorrelatedSource.get().getCorrelatedPredicates(), Optional.empty());
        if (distinct != null) {
            distinct = AggregationDecorrelation.restoreDistinctAggregation(distinct, join, (List<Symbol>)ImmutableList.builder().addAll(join.getLeftOutputSymbols()).addAll(distinct.getGroupingKeys()).build());
        }
        AggregationNode groupedAggregation = captures.get(AGGREGATION);
        groupedAggregation = AggregationNode.builderFrom(groupedAggregation).setSource(distinct != null ? distinct : join).setGroupingSets(AggregationNode.singleGroupingSet((List<Symbol>)ImmutableList.builder().addAll(join.getLeftOutputSymbols()).addAll(groupedAggregation.getGroupingKeys()).build())).setPreGroupedSymbols((List<Symbol>)ImmutableList.of()).setHashSymbol(Optional.empty()).setGroupIdSymbol(Optional.empty()).build();
        HashSet<Symbol> outputSymbols = new HashSet<Symbol>(correlatedJoinNode.getOutputSymbols());
        List expectedAggregationOutputs = (List)groupedAggregation.getOutputSymbols().stream().filter(outputSymbols::contains).collect(ImmutableList.toImmutableList());
        Assignments assignments = Assignments.builder().putIdentities(expectedAggregationOutputs).putAll(captures.get(PROJECTION).getAssignments()).build();
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().genPlanNodeId(), groupedAggregation, assignments));
    }
}

