"""Unit tests for all neural networks."""

from sktime.tests.test_all_estimators import BaseFixtureGenerator, QuickTester


class NetworkFixtureGenerator(BaseFixtureGenerator):
    """Fixture generator for classifier tests.

    Fixtures parameterized
    ----------------------
    estimator_class: estimator inheriting from BaseObject
        ranges over estimator classes not excluded by EXCLUDE_ESTIMATORS, EXCLUDED_TESTS
    estimator_instance: instance of estimator inheriting from BaseObject
        ranges over estimator classes not excluded by EXCLUDE_ESTIMATORS, EXCLUDED_TESTS
        instances are generated by create_test_instance class method
    scenario: instance of TestScenario
        ranges over all scenarios returned by retrieve_scenarios
    """

    # note: this should be separate from TestAllNetworks
    #   additional fixtures, parameters, etc should be added here
    #   TestAllNetworks should contain the tests only

    estimator_type_filter = "network"


class TestAllNetworks(NetworkFixtureGenerator, QuickTester):
    """Module level tests for all sktime neural networks."""

    def test_dummy(self, estimator_instance):
        """Dummy test to act as placeholder."""
        # check if multivariate input raises error for univariate regressors
        assert 42 == 42
