/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.TrimColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;

public class LTrimColumnTransformer
extends UnaryColumnTransformer {
    private final byte[] character;

    public LTrimColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, String characterStr) {
        super(returnType, childColumnTransformer);
        this.character = characterStr.getBytes();
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBinary(new Binary(LTrimColumnTransformer.ltrim(currentValue, this.character)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBinary(new Binary(LTrimColumnTransformer.ltrim(currentValue, this.character)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    public static byte[] ltrim(byte[] source, byte[] character) {
        int start;
        if (source.length == 0 || character.length == 0) {
            return source;
        }
        for (start = 0; start < source.length && TrimColumnTransformer.isContain(character, source[start]); ++start) {
        }
        if (start >= source.length) {
            return new byte[0];
        }
        byte[] result = new byte[source.length - start];
        System.arraycopy(source, start, result, 0, source.length - start);
        return result;
    }
}

