/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class PruneCorrelatedJoinCorrelation
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin();

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        Set<Symbol> subquerySymbols = SymbolsExtractor.extractUnique(correlatedJoinNode.getSubquery(), context.getLookup());
        List newCorrelation = (List)correlatedJoinNode.getCorrelation().stream().filter(subquerySymbols::contains).collect(ImmutableList.toImmutableList());
        if (newCorrelation.size() < correlatedJoinNode.getCorrelation().size()) {
            return Rule.Result.ofPlanNode(new CorrelatedJoinNode(correlatedJoinNode.getPlanNodeId(), correlatedJoinNode.getInput(), correlatedJoinNode.getSubquery(), newCorrelation, correlatedJoinNode.getJoinType(), correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery()));
        }
        return Rule.Result.empty();
    }
}

