/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.udf.UDFType;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class UDFInformation {
    private String functionName;
    private String className;
    private UDFType udfType;
    private boolean isUsingURI;
    private String jarName;
    private String jarMD5;

    private UDFInformation() {
    }

    public UDFInformation(String functionName, String className, UDFType udfType, boolean isUsingURI, String jarName, String jarMD5) {
        this.functionName = functionName.toUpperCase();
        this.className = className;
        this.isUsingURI = isUsingURI;
        this.jarName = jarName;
        this.jarMD5 = jarMD5;
        this.udfType = udfType;
    }

    public UDFInformation(String functionName, String className, UDFType udfType) {
        this.functionName = functionName.toUpperCase();
        this.className = className;
        this.udfType = udfType;
        this.isUsingURI = false;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getClassName() {
        return this.className;
    }

    public UDFType getUdfType() {
        return this.udfType;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getJarMD5() {
        return this.jarMD5;
    }

    public boolean isUsingURI() {
        return this.isUsingURI;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName.toUpperCase();
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setUdfType(UDFType udfType) {
        this.udfType = udfType;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public void setJarMD5(String jarMD5) {
        this.jarMD5 = jarMD5;
    }

    public void setUsingURI(boolean usingURI) {
        this.isUsingURI = usingURI;
    }

    public void setAvailable(boolean available) {
        this.udfType = this.udfType.setAvailable(available);
    }

    public boolean isAvailable() {
        return this.udfType.isAvailable();
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.functionName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.className, (OutputStream)outputStream);
        this.udfType.serialize(outputStream);
        ReadWriteIOUtils.write((Boolean)this.isUsingURI, (OutputStream)outputStream);
        if (this.isUsingURI) {
            ReadWriteIOUtils.write((String)this.jarName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)this.jarMD5, (OutputStream)outputStream);
        }
    }

    public static UDFInformation deserialize(ByteBuffer byteBuffer) {
        UDFInformation udfInformation = new UDFInformation();
        udfInformation.setFunctionName(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        udfInformation.setClassName(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        udfInformation.setUdfType(UDFType.deserialize(byteBuffer));
        boolean isUsingURI = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        udfInformation.setUsingURI(isUsingURI);
        if (isUsingURI) {
            udfInformation.setJarName(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
            udfInformation.setJarMD5(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        return udfInformation;
    }

    public static UDFInformation deserialize(InputStream inputStream) throws IOException {
        return UDFInformation.deserialize(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)inputStream)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UDFInformation that = (UDFInformation)o;
        return this.udfType.equals((Object)that.udfType) && Objects.equals(this.functionName, that.functionName) && Objects.equals(this.className, that.className) && Objects.equals(this.jarName, that.jarName) && Objects.equals(this.jarMD5, that.jarMD5);
    }

    public int hashCode() {
        return Objects.hash(this.functionName);
    }
}

