/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.memory.strategy;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.resource.memory.PipeDynamicMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.strategy.DynamicMemoryAllocationStrategy;
import org.apache.tsfile.utils.Pair;

public class ThresholdAllocationStrategy
implements DynamicMemoryAllocationStrategy {
    private static final PipeConfig PIPE_CONFIG = PipeConfig.getInstance();

    @Override
    public void dynamicallyAdjustMemory(PipeDynamicMemoryBlock dynamicMemoryBlock) {
        double diff;
        double deficitRatio = this.calculateDeficitRatio(dynamicMemoryBlock);
        long oldMemoryUsageInBytes = dynamicMemoryBlock.getMemoryUsageInBytes();
        long expectedMemory = (long)((double)oldMemoryUsageInBytes / deficitRatio);
        double memoryBlockUsageRatio = dynamicMemoryBlock.getMemoryBlockUsageRatio();
        long maximumMemoryIncrease = (long)((double)dynamicMemoryBlock.getFixedMemoryCapacity() * PIPE_CONFIG.getPipeThresholdAllocationStrategyMaximumMemoryIncrementRatio());
        if (deficitRatio <= 0.0 || oldMemoryUsageInBytes == 0L || expectedMemory == 0L) {
            dynamicMemoryBlock.applyForDynamicMemory(maximumMemoryIncrease);
            double efficiencyRatio = (double)dynamicMemoryBlock.getMemoryUsageInBytes() / (double)maximumMemoryIncrease;
            dynamicMemoryBlock.updateMemoryEfficiency(efficiencyRatio, efficiencyRatio);
            return;
        }
        double lowUsageThreshold = PIPE_CONFIG.getPipeThresholdAllocationStrategyLowUsageThreshold();
        if (dynamicMemoryBlock.getFixedMemoryBlockUsageRatio() < PIPE_CONFIG.getPipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold()) {
            if (deficitRatio >= 1.0) {
                return;
            }
            long maxAvailableMemory = Math.min(expectedMemory, dynamicMemoryBlock.canAllocateMemorySize());
            long newMemoryRequest = memoryBlockUsageRatio > lowUsageThreshold ? Math.min(oldMemoryUsageInBytes + oldMemoryUsageInBytes / 2L, maxAvailableMemory) : Math.min(oldMemoryUsageInBytes * 2L, maxAvailableMemory);
            dynamicMemoryBlock.applyForDynamicMemory(newMemoryRequest);
            double efficiencyRatio = (double)dynamicMemoryBlock.getMemoryUsageInBytes() / (double)expectedMemory;
            dynamicMemoryBlock.updateMemoryEfficiency(efficiencyRatio, efficiencyRatio);
            return;
        }
        AtomicBoolean isMemoryNotEnough = new AtomicBoolean(false);
        double averageDeficitRatio = dynamicMemoryBlock.getMemoryBlocks().mapToDouble(block -> {
            double ratio = this.calculateDeficitRatio((PipeDynamicMemoryBlock)block);
            if (block.getMemoryUsageInBytes() == 0L || ratio == 0.0) {
                isMemoryNotEnough.set(true);
            }
            return ratio;
        }).average().orElse(1.0);
        double adjustmentThreshold = PIPE_CONFIG.getPipeDynamicMemoryAdjustmentThreshold();
        double d = diff = isMemoryNotEnough.get() && averageDeficitRatio > 2.0 * adjustmentThreshold ? averageDeficitRatio - deficitRatio - adjustmentThreshold : averageDeficitRatio - deficitRatio;
        if (Math.abs(diff) > PIPE_CONFIG.getPipeDynamicMemoryAdjustmentThreshold()) {
            long mem = (long)((double)dynamicMemoryBlock.getMemoryUsageInBytes() / deficitRatio * diff);
            dynamicMemoryBlock.applyForDynamicMemory(dynamicMemoryBlock.getMemoryUsageInBytes() + mem);
            if (oldMemoryUsageInBytes != dynamicMemoryBlock.getMemoryUsageInBytes()) {
                double efficiencyRatio = (double)dynamicMemoryBlock.getMemoryUsageInBytes() / (double)expectedMemory;
                dynamicMemoryBlock.updateMemoryEfficiency(efficiencyRatio, efficiencyRatio);
            }
        } else if (memoryBlockUsageRatio > lowUsageThreshold && memoryBlockUsageRatio > (double)dynamicMemoryBlock.getExpectedAverageAllocatedMemorySize()) {
            dynamicMemoryBlock.applyForDynamicMemory(oldMemoryUsageInBytes / 2L);
            dynamicMemoryBlock.updateMemoryEfficiency(deficitRatio / 2.0, deficitRatio / 2.0);
        }
    }

    private double calculateDeficitRatio(PipeDynamicMemoryBlock block) {
        Pair<Double, Double> memoryEfficiency = block.getMemoryEfficiency();
        double pipeDynamicMemoryHistoryWeight = PIPE_CONFIG.getPipeDynamicMemoryHistoryWeight();
        return (1.0 - pipeDynamicMemoryHistoryWeight) * (Double)memoryEfficiency.getRight() + pipeDynamicMemoryHistoryWeight * (Double)memoryEfficiency.getLeft();
    }
}

